%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%%  parse.pl: parsing of user's PRISM program(s).
%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%  Copyright (C) 1998
%%%    Taisuke Sato, Yoshitaka Kameya, Yasushi Hagiwara, Nobuhisa Ueda,
%%%      Dept. of Computer Science, Tokyo Institute of Technology.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%%   - parsing AND(,)/OR(;) structure
%%%   - find "calls" relationship
%%%     (ex. for clause "A:-B,C" say "A calls B" and "A calls C")

%%% parse/2: main parsing routine
%   allows file list
% | ?- parse([blood1,blood2,...]).
% parse,parse_list,parse_file modified by hagi on Feb/24/1998.
% modified for default declaration by kame on Feb/27/1998.

parse(Files,OP) :-
	( atom(Files),!,parse_file(Files,OP)
	; is_list(Files),!,parse_list(Files,OP)
	; message("{PRISM ERROR: prism(_,~w) -- ~w must be a filename or a list of filename.}",
	          [Files,Files]),!,fail ),!,
	find_prob_pred,!,
	assertz('*Sentence*'(sys,msw,[_,2,[1,0]])),!.     % default msw decl.

parse_list([File|Files],OP) :- parse_file(File,OP),!,parse_list(Files,OP).
parse_list([],_):-!.  % Bug-fixed by kame on Nov/20/1997
	
% parse for a file
%   modified by kame on Dec/14/1997.
parse_file(File,OP) :-
	nofileerrors,
	( see(File),!,
	  ( OP=verbose,!,
	    format("{Reading ~w...",[File]),ttyflush,!
	  ; true),
	  parse_sentence(File,0,NS),!,seen,!
	; ( psmfile(File,_),!,
	    message("{PRISM ERROR: Cannot open ~w.}",[File]),!,fail) 
	  ; concat_name([File,'.psm'],File1),
	    ( see(File1),!,
	      ( OP=verbose,!,
	        format("{Reading ~w...",[File1]),ttyflush,!
	      ; true),
	      parse_sentence(File1,0,NS),!,seen,!
	    ; message("{PRISM ERROR: Cannot open ~w.}",[File1]),!,fail) ),
	( OP=verbose,!,
	  message("~w sentences found.}",[NS]),!
	; true).

% parse for a sentence
% modified by hagi on Oct/1/1997
parse_sentence(File,N0,N) :- 
	read(Sentence),!,
	( Sentence = end_of_file,!,                % end with success
	  N=N0
	; unique_sentence_number(USN),!,
	  ( Sentence = target(Target,ArgN),!,      % target decl.
	    assertz('*Sentence*'(USN,target,[default,Target,ArgN]))
	  ; Sentence = target(Model,Target,ArgN),!,
	    assertz('*Sentence*'(USN,target,[Model,Target,ArgN]))
	  ; Sentence = data(Datafile),!,           % teacher data decl.
	    assertz('*Sentence*'(USN,data,[default,Datafile]))
	  ; Sentence = data(Model,Datafile),!,
	    assertz('*Sentence*'(USN,data,[Model,Datafile]))
	  ; Sentence = fixed(GPs),!,               % fixed switch decl.
	    assertz('*Sentence*'(USN,fixed,GPs))
	  ; Sentence = fixed(G_id,PbPlus),!,       % fixed switch decl.
	    assertz('*Sentence*'(USN,fixed,[G_id=PbPlus]))
	  ; Sentence = values(G_id,Values),!,      % multiple switch decl.
	    parse_msw(USN,G_id,Values)
	  ; Sentence = (Head :- Body),!,           % normal Prolog
	    parse_body(USN,Head,Body)              % (Horn clause)
	  ; Sentence = (:- Goal),!,
	    assertz('*Sentence*'(USN,query,Goal)),!,
        assertz('*Query*'(USN,Goal))           % added by kame on Nov/20/1997
	  ; parse_body(USN,Sentence,true) ),!,     % normal Prolog (unit clause)
	  N1 is N0+1,!,
	  parse_sentence(File,N1,N) ).

%%%% Parse_body:
%%%% - parse for a normal clause (body)
%%%% - assert the result
%%%% - find 'calls' relationship

parse_body(N,Head,Body) :-
	functor(Head,F,ArgN),!,
	unique_local_SN(F/ArgN,ULSN),!,  % get unique local sentence number.
	collect_pred(Body,Preds),!,
	assertz('*Sentence*'(N,normal,[F/ArgN,ULSN,Preds,Head,Body])),!.

%% collect_pred(Body,Preds):
%%   collects all predicates (comprises F,ArgN) which occur in Body.
%% <ex.>
%% collect_pred(((foo(X,Y,Z),bar(X,Y));foo(X,Y),bar(X,Y)),
%%              [(bar,2),(foo,2),(foo,3)]).
%%
%% [NOTE] The pair of last 2 args of collect_pred/3 forms 
%%        differntial list.

collect_pred(Body,Preds) :-
	collect_pred(Body,Preds0,[]),!,
	sort(Preds0,Preds),!. % delete duplicating predicates.

collect_pred(Body,Preds0,Preds1) :-
	( Body=(C,Cs),!,
	  collect_pred(C,Preds0,Preds2),!,
	  collect_pred(Cs,Preds2,Preds1)
	; Body=(D;Ds),!,
	  collect_pred(D,Preds0,Preds2),!,
	  collect_pred(Ds,Preds2,Preds1)
	; functor(Body,F,ArgN),!,
	  Preds0=[(F,ArgN)|Preds1] ),!.

%%% parse_msw/3: parses msw declaration

parse_msw(N,G_id,Values) :-
	( expand_msw_values(G_id,Values,ExValues),!
	; message("{PRISM ERROR: Msw decl. values(~w,Values) -- Values must be the list.}",[G_id]),!,fail ),!,
	length(ExValues,Size),!,
	( Size >= 2,! ; message("{PRISM ERROR: Msw decl. values(~w,Values) -- MSW must take 2 or more values.}",[G_id]),!,fail ),!,
	assertz('*Sentence*'(N,msw,[G_id,Size,ExValues])),!.

expand_msw_values(G_id,Vs,ExVs) :- expand_msw_values(G_id,Vs,ExVs,[]),!. 
    
% last 2 args play the role of differential list.
expand_msw_values(G_id,[V|Vs],ExVs0,ExVs1) :-
	expand_msw_values1(G_id,V,ExVs0,ExVs2),!,
	expand_msw_values(G_id,Vs,ExVs2,ExVs1).
expand_msw_values(_,[],ExVs,ExVs) :- !.

expand_msw_values1(G_id,V,ExVs0,ExVs1) :-
	( V = L-R,!,
	  ( integer(L),integer(R),!,
	    ( L =< R,!,expand_msw_values2(L,L,R,ExVs0,ExVs1)
	    ; message("{PRISM ERROR: Msw decl. values(~w,Values): Values contains ~w-~w -- Right-hand side must not be smaller than left-hand side.}",
	            [G_id,L,R]),!,
	    fail ),!
	  ; message("{PRISM ERROR: Msw decl. values(~w,Values): Values contains ~w-~w -- Each of arguments of '-' must be a integer.}",
                [G_id,L,R]),!,
		fail ),!
	; ExVs0=[V|ExVs1] ),!.

expand_msw_values2(C,L,R,ExVs0,ExVs1) :-
	( C=R,!,ExVs0=[R|ExVs1]
	; ExVs0=[C|ExVs2],!,
	  C1 is C+1,!,
	  expand_msw_values2(C1,L,R,ExVs2,ExVs1) ).

%%% find_prob_pred/0: finds probabilistic predicates and assertz them.
%%%   *Prob_Pred* modified by kame on Dec/14/1997
%%%                              for *expl_??* and *sample_??*
find_prob_pred :-
	assertz('*Prob_Pred*'(bsw,3,null,null)),!,
	assertz('*Prob_Pred*'(msw,3,null,null)),!,
	assertz('*Prob_Pred*'(bsw,2,null,null)),!,
	assertz('*Prob_Pred*'(msw,2,null,null)),!,
	find_prob_pred0,!.

find_prob_pred0 :-
	( setof((PF,PargN),
	        (EF,SF)^('*Prob_Pred*'(PF,PargN,EF,SF),PargN>=0),
			PPs)
	; PPs = [] ),!,
	find_prob_pred1(PPs,PPs1),!,
	'*append*'(PPs,PPs1,PPs2),!,
	sort(PPs2,PPs3),!, % delete duplicating predicate names.
	( PPs = PPs3,!
	; add_prob_pred(PPs3),!,find_prob_pred0 ).

find_prob_pred1([PP|PPs],PPs0) :-
	( setof(Q,calls(Q,PP),Qs),! ; Qs=[] ),!,
	'*append*'(Qs,PPs1,PPs0),!,
	find_prob_pred1(PPs,PPs1).
find_prob_pred1([],[]) :-!.
			 
% calls(Q,P); Q calls P. 
% [NOTE] P and Q are the form of (F,ArgN).
calls((QF,QargN),(PF,PargN)) :-
	'*Sentence*'(_,normal,[QF/QargN,_,Preds,_,_]),
	'*member*'((PF,PargN),Preds).

add_prob_pred([(PF,PargN)|PPs]) :-
	( clause('*Prob_Pred*'(PF,PargN,_,_),true),!  % already exists
	; concat_name(['*expl_',PF,'*'],EF),!,
	  concat_name(['*sample_',PF,'*'],SF),!,
	  assertz('*Prob_Pred*'(PF,PargN,EF,SF))),!,
	add_prob_pred(PPs).
add_prob_pred([]):-!.

%%% query/1: execute queries
%%%   modified by kame on Nov/20/1997 for *Query*/2.
% modified by hagi on Feb/24/1998.

query(OP) :-
        ( setof([N,Goal],retract('*Query*'(N,Goal)),NGoals),!,
          ( OP=verbose,!,
	    message('{Executing queries..}'),!
	  ; true),
          query1(NGoals),!,
	  ( OP=verbose,!,
	    message('{Queries executed.}'),!
	  ; true)
        ; true ),!.
query1([[_,Goal]|NGoals]) :-
        ( call(Goal),!
        ; message("{PRISM WARNING: Query ~w failed.}",[Goal]) ),!,
        query1(NGoals).
query1([]) :- !.
