%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%%  foreignGUI.pl: Foreign Language Interface
%%%                   provided by SICStus Prolog 3 (with GUI)
%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%  Copyright (C) 1998
%%%    Taisuke Sato, Yoshitaka Kameya, Yasushi Hagiwara, Nobuhisa Ueda,
%%%      Dept. of Computer Science, Tokyo Institute of Technology.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%% Interface predicates for random.c
foreign(set_seed,c,set_seed_by_manual(+integer)).
foreign(set_seed_time,c,set_seed_time). % using C-library time()
foreign(set_seed_time1,c,c_set_seed_time([-integer])).
foreign(show_seed,c,show_seed).
foreign(random_float,c,random_float(+float,[-float])).
	% random_float(r,R): return a random real <R> <= <r>
foreign(random_int,c,random_int(+integer,[-integer])).
	% random_int(r,I): return a random integer <I> <= <r>

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%% Interface predicates for trie.c

%%% for exportation of explanations:
foreign(prepare_trie,c,prepare_c_trie([-integer])).
foreign(cancel_trie,c,cancel_trie).   % added by kame on Dec/13/1997.
foreign(prepare_expl,c,prepare_c_expl(+integer,[-integer])).
foreign(count_expls,c,count_c_ans([-integer])).
foreign(get_trie,c,
	    export_ans_sw(+integer,+integer,+integer,+integer,[-integer])).
foreign(show_trie,c,show_trie).
foreign(freeTrie,c,init_c_trie).
foreign(initRoot,c,really_init_trie).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%% Interface predicates for em.c

%%% for exportation of EM information:
foreign(set_values,c,export_sw(+integer,+integer,[-integer])).
foreign(set_idInfo,c,export_code(+integer,+integer,+integer,[-integer])).
foreign(set_fixed,c,export_fixed_code(+integer,+integer,+float)).
foreign(set_goals,c,export_goal_patterns(+integer,[-integer])).
foreign(set_data,c,export_goal_weight(+integer,+integer)).

%%% for importation of EM information:
foreign(get_theta,c,import_pb(+integer,+integer,[-float])).
foreign(get_loglike,c,import_loglike([-float])).

%%% for control of EM routine:
% prepare_c_Pf: added by kame on Nov/20/1997.
foreign(prepare_Pf,c,prepare_c_Pf([-integer])). 
foreign(update_theta,c,update_pbs).
foreign(initTheta,c,init_pbs).
foreign(c_EM_loop,c,c_EM_loop([-integer])).
foreign(set_epsilon,c,set_c_epsilon(+float)).
foreign(get_epsilon,c,get_c_epsilon([-float])).

%%% Miscellaneous interface predicates:
foreign(freeMemory,c,init_expl_table).
foreign(initVars,c,really_init_expl_table).
foreign(show_table,c,show_table).
foreign(show_raw_table,c,show_raw_table).
foreign(show_goals,c,c_goals).
foreign(show_sw,c,c_sw).
foreign(show_sizes,c,c_sizes).
foreign(show_epsilon,c,show_epsilon).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%% Interface predicates for prob.c

foreign(initProb,c,really_init_prob).
foreign(free_Ptrie,c,init_prob_trie).
foreign(freePMemory,c,init_prob_table).
foreign(prepare_prob_trie,c,prepare_prob_trie).
% cancel_prob: added by kame on Nov/20/1997
foreign(cancelProb,c,cancel_prob).
foreign(get_Ptrie,c,
	export_prob_ans_sw(+integer,+integer,+integer,+integer,[-integer])).
foreign(show_Ptrie,c,show_prob_trie).
foreign(show_Ptable,c,show_prob_table).
foreign(set_Pvalues,c,export_prob_sw(+integer,+integer,[-integer])).
foreign(set_PidInfo,c,export_prob_code(+integer,+integer,[-integer])).
foreign(count_expls_P,c,count_prob_ans([-integer])).
foreign(set_Ptheta,c,export_pb(+integer,+integer,+float,[-integer])).
foreign(calc_prob,c,calc_Pdb([-float])).

% added by ueda on Feb/24/1998
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%% graph predicates for graph.c

foreign(graph_setwindow_em_loop,c,
        graph_setwindow_em_loop(+float,+float,+float,+integer)).
foreign(graph_line_em_loop,c,
        graph_line_em_loop(+integer,+float,+float,+float,+float)).
foreign(graph_redraw_em_loop,c,
        graph_redraw_em_loop(+integer,+float,+float,+integer)).
foreign(graph_shutwindow_em_loop,c,graph_shutwindow_em_loop).
% end of added by ueda

foreign_resource(prism,
	             % from random.o
	             [set_seed,set_seed_time,set_seed_time1,
				show_seed,random_float,random_int,
                 % from em.o
				  set_values,set_idInfo,set_fixed,set_goals,prepare_Pf,
				  initTheta,set_data,freeMemory,update_theta,
				  show_table,show_raw_table,get_theta,get_loglike,
				  c_EM_loop,show_sw,show_goals,show_sizes,set_epsilon,
				  show_epsilon,initVars,
                 % from trie.o
			      prepare_trie,cancel_trie,prepare_expl,get_trie,
				  show_trie,count_expls,freeTrie,initRoot,
                 % from prob.o
				  initProb,free_Ptrie,freePMemory,cancelProb,
				  prepare_prob_trie,get_Ptrie,show_Ptrie,show_Ptable,
				  set_Pvalues,set_PidInfo,
				  count_expls_P,set_Ptheta,calc_prob,
		 % from graph.o: added by ueda on Feb/24/1998
			  graph_setwindow_em_loop,graph_line_em_loop,
                          graph_redraw_em_loop,graph_shutwindow_em_loop]).
		 % end of added by ueda
