%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%
%%%  emGUI.pl: EM main routines with GUI.
%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%  Copyright (C) 1998
%%%    Taisuke Sato, Yoshitaka Kameya, Yasushi Hagiwara, Nobuhisa Ueda,
%%%      Dept. of Computer Science, Tokyo Institute of Technology.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

em_loop(Codes) :-
	% following 3 lines added by kame on Nov/20/1997.
	prepare_c_Pf(R),!, 
	( export_error(R),!
	; message('{PRISM INTERNAL ERROR: prepare_c_Pf failed.}'),!,fail ),!,
	init_pbs,!,import_pbs(Codes),!,print_codes(Codes),!,
	clause('*Epsilon*'(Epsilon),true),!,
%	em_loop(0,Epsilon,Codes),!.
% rewrited by ueda on Dec/26/1997
	em_loop(0,Epsilon,Codes,0,0),!.
% end of rewrited

% em_loop(M,Epsilon,Codes) :-
% rewrited by ueda on Dec/26/1997 (adding two variables min, max)
% following additions and rewritings are for showing graphs.
em_loop(M,Epsilon,Codes,Min,Max) :-
% end of rewrited
	display_em_loop(M),!,
	update_pbs,!,
	import_loglike(New_Loglike),!,
	import_pbs(Codes),!,
	( M=0,!,
	  assertz('*Log_like*'(0,New_Loglike)),!,
%	  em_loop(1,Epsilon,Codes)
% added by ueda on Feb/24/1998
	  ( clause('*Graph*'(on),true),
	    NewMax is 0.95 * New_Loglike,
	    NewMin is New_Loglike,
	    clause('*Graph_width*'(W),true),
	    ( clause('*GraphDisplay*'(on),true),!,
		  retract('*GraphDisplay*'(on)),
	      graph_shutwindow_em_loop,!
        ; true ),
	    assert('*GraphDisplay*'(on)),
		graph_setwindow_em_loop(NewMin,NewMax,Epsilon,W),!
	  ; true ),
	  em_loop(1,Epsilon,Codes,NewMin,NewMax) 
% end of added
	; Mm1 is M-1,!,
	  retract('*Log_like*'(Mm1,Old_Loglike)),!,
	  D is New_Loglike-Old_Loglike,!,
% added by ueda on Feb/24/1998
	  ( clause('*Graph*'(on),true),
	  ((Max < New_Loglike, NewMax is 0.95 * New_Loglike,
	  graph_redraw_em_loop(M,Min,NewMax,1),
	  ! );
	  NewMax is Max ),
	  graph_line_em_loop(M,D,Old_Loglike,Min,NewMax),!,
	  graph_redraw_em_loop(M,Min,NewMax,0),!; true),
% end of added
	  ( ( D < Epsilon ; New_Loglike > 0 ),!,
	    nl,!,
		assert_loglike(New_Loglike),!,   % added by kame on Feb/27/1998
		converged_em_loop(M,Codes,New_Loglike),
% added by ueda on Feb/24/1998
	    ( clause('*GraphDisplay*'(on),true),!,
		  retract('*GraphDisplay*'(on)),
		  graph_shutwindow_em_loop,! ; true) ,!
% end of added
	  ; Mp1 is M+1,!,
	    assertz('*Log_like*'(M,New_Loglike)),!,
%		em_loop(Mp1,Epsilon,Codes) )),!.
% rewrited by ueda on Dec/26/1997
		em_loop(Mp1,Epsilon,Codes,Min,NewMax) )),!.
% end of rewrited

% graph on/off switch
% added by ueda on Dec/29/1997
% message added by kame on Feb/28/1997

% graph_on  : showing graphs in learning phase
graph_on  :-
	( clause('*Graph*'(on),true),!
    ; ( retract('*Graph*'(_)),! ; true ),
	  assertz('*Graph*'(on)),!,message('{Graph ON}') ).
% graph_off : not showing graphs in learning phase
graph_off :-
	( clause('*Graph*'(off),true),!
    ; ( retract('*Graph*'(_)),! ; true ),
	  assertz('*Graph*'(off)),!,message('{Graph OFF}') ).

% graph  : show whether graph switch is on or off
graph :-
	( clause('*Graph*'(on),true),!,
	  message('A switch for showing graphs is on.')
    ; message('A switch for showing graphs is off.') ).

% graph_width(W) : set width of graphs W
graph_width(W) :-
 	Min is 100, Max is 1000,!,
	(( W < Min, message('{PRISM WARNING: Too narrow for graphs.}'))
      ; (  W > Max, message('{PRISM WARNING: Too wide for graphs.}'))
      ; (retract('*Graph_width*'(_)),false; true), assert('*Graph_width*'(W))).
% graph_erase  : erase a window for graphs
graph_erase :- retract('*GraphDisplay*'(on)), graph_shutwindow_em_loop;
	    message('{PRISM WARNING: Graph is not on display.}').
% default property
:- assert('*Graph*'(off)), assert('*GraphDisplay*'(off)), assert('*Graph_width*'(500)).
