%------------  Utilities  -------------------

append( [],B,B ).
append( [A|A1],B,[A|C] ):-
	append( A1,B,C ).

member( _,[] ):- fail.
member( Term,[Term|_] ):-!.
member( Term,[_|Other] ):-
	member( Term,Other ).

select( [],_,_ ):-fail.
select( [Term|L1],Term,L1 ):-!.
select( [Term1|L1],Term,[Term1|L2] ):-
	Term1 \== Term,!,
	select( L1,Term,L2 ).

memberVar( _,[] ) :- fail.
memberVar( Var1/Temp2,[ Var2/Temp2|_ ] ):-
	Var1 == Var2,!.
memberVar( Var1 = Var2,[ Var3 = Var4|_ ] ):-
	Var1 == Var3,
	Var2 == Var4,!.
memberVar( Var1/Temp,[ _| Other ] ):-
	memberVar( Var1/Temp,Other ).

selectVar( [],_,_ ):- fail.
selectVar( [Var2/Temp|List1],Var1/Temp,List1 ):-
	Var1 == Var2,!.
selectVar( [Var2/Temp2|List1],Var1/Temp,[Var2/Temp2|List2] ):-!,
	selectVar( List1,Var1/Temp,List2 ).

selectList( List,[],List ).
selectList( List1,[Term|Other],Result ):-
	select( List1,Term,List2 ),
	selectList( List2,Other,Result ).

nth0( 0,[Term|_],Term ):-!.
nth0( N,[_|Other],Term ):-
	N1 is N-1,
	nth0( N1,Other,Term ).

isnot_list( [] ):- !,fail.
isnot_list( [ _|_ ] ):-!,fail.
isnot_list( _ ).

isnot_null_list( [] ):-!,fail.
isnot_null_list( _ ).

trance( [],CList,CList ).
trance( [ Term | Other ],CList,Psi ):-
	var( Term ),
	append( CList,[Term],Temp ),
	trance( Other,Temp,Psi ).
trance( [ Type = Var | Other ],CList,Psi ):-
	append( CList,[[Type,Var]],Temp ),
	trance( Other,Temp,Psi ).
trance( [ Term|Other ],CList,Psi ):-
	append( CList,[Term],Temp ),
	trance( Other,Temp,Psi ).

untrance( [],CList,CList ).
untrance( [List1|Other],CList,Result ):-
	nth0( 0,List1,Term ),
	select( List1,Term,[Temp] ),
	append( CList,[ Term = Temp ],C ),
	untrance( Other,C,Result ).


%###### $BO@AhMQ%a%$%s%b%8%e!<%k(B ########

ruleBaseSystem :-
	makelower( debate1 ),
	makeclause( debate3 ),
	makeMainWindow.
ruleBaseSystem( DicFile,RuleFile ):-
	makelower( DicFile ),
	makeclause( RuleFile ),
	makeMainWindow.
rbs :- ruleBaseSystem.
rbs( DicFile,RuleFile ):- ruleBaseSystem( DicFile,RuleFile ).
