%%     unify.pl   Rbrs 1.0 
%%     Copyright (C) Katsumi Nitta   (nitta@dis.titech.ac.jp)
%%                   Taketomo Katoh  (tkatoh@ntt.dis.titech.ac.jp)
%-------------------------------------%
%   2 $B$D$N&79`$N(B unification $B$r9T$&(B   %
%   $B=R8l(B unify $B$H=R8l$N(B unification   %
%   $B$r9T$&(B unifyVerb                  %
%-------------------------------------%

unify( - A,- B,- C,CGL,RGL,CHL,RHL ):-
	var(A),var(B),!,
	canUnify( A,B,C,CGL,RGL,CHL,RHL ).
unify( - A,- B,- C,CGL,RGL,CHL,RHL ):-
	var(A),!,
	B =.. L2,
	canUnify( A,L2,C,CGL,RGL,CHL,RHL ).
unify( - A,- B,- C,CGL,RGL,CHL,RHL ):-
	var(B),!,
	A =.. L1,
	canUnify( L1,B,C,CGL,RGL,CHL,RHL ).
unify( - A,- B,- C,CGL,RGL,CHL,RHL ):-
	A =.. L1,B =.. L2,
	canUnify( L1,L2,C,CGL,RGL,CHL,RHL ).
unify( A,B,C,CGL,RGL,CHL,RHL ):-
	var(A),var(B),!,
	canUnify( A,B,C,CGL,RGL,CHL,RHL ).
unify( A,B,C,CGL,RGL,CHL,RHL ):-
	var(A),!,
	B =.. L2,
	canUnify( A,L2,C,CGL,RGL,CHL,RHL ).
unify( A,B,C,CGL,RGL,CHL,RHL ):-
	var(B),!,
	A =.. L1,
	canUnify( L1,B,C,CGL,RGL,CHL,RHL ).
unify( A,B,C,CGL,RGL,CHL,RHL ):-
	A =.. L1,B =.. L2,
	canUnify( L1,L2,C,CGL,RGL,CHL,RHL ).

canUnify( X,Y,Res,CGL,RGL,CHL,RHL ):-
	var( X ),
	var( Y ),
	getTerm( X,CGL,Term1 ),
	getTerm( Y,CHL,Term2 ),
	Term1 =.. Temp1,
	Term2 =.. Temp2,
	canUnify( Temp1,Temp2,Res,CGL,CGL2,CHL,CHL2 ),!,
	X = Y,
	selectVar( CGL2,X/_,CGL3 ),
	append( CGL3,[X/Res],RGL ),
	selectVar( CHL2,Y/_,CHL3 ),
	append( CHL3,[Y/Res],RHL ).
canUnify( X,Var2,Res,CGL,RGL,CHL,RHL ):-
	var( X ),
	getTerm( X,CGL,Term1 ),
	Term1 =.. Temp1,
	canUnify( Temp1,Var2,Res,CGL,CGL2,CHL,RHL ),!,
	selectVar( CGL2,X/_,CGL3 ),
	append( CGL3,[X/Res],RGL ).
canUnify( Var1,Y,Res,CGL,RGL,CHL,RHL ):-
	var( Y ),
	getTerm( Y,CHL,Term2 ),
	Term2 =.. Temp2,
	canUnify( Var1,Temp2,Res,CGL,RGL,CHL,CHL2 ),!,
	selectVar( CHL2,Y/_,CHL3 ),
	append( CHL3,[Y/Res],RHL ).
canUnify( ['Top'|_],[Y|L2],Temp,CGL,CGL,CHL,CHL ):-!,
	Temp =.. [Y|L2].
canUnify( [X|L1],['Top'|_],Temp,CGL,CGL,CHL,CHL ):-!,
	Temp =.. [X|L1].
canUnify( [X|L1],[X|L2],C,CGL,RGL,CHL,RHL ):-!,
	trance( L1,[],Psi1 ),
	trance( L2,[],Psi2 ),
	unify3( Psi1,Psi2,[],Result,CGL,RGL,CHL,RHL ),
	C =.. [X|Result].
canUnify( [X|L1],[Y|L2],C,CGL,RGL,CHL,RHL ):-
	getGLB( X,Y,Z ),
	Z \== 'Bottom',!,
	trance( L1,[],Psi1 ),
	trance( L2,[],Psi2 ),
	unify3( Psi1,Psi2,[],Result,CGL,RGL,CHL,RHL ),
	C =.. [Z|Result].

%--- $B=R8l$N(B Unify $BMQ$N=R8l72(B  -----%

unifyVerb( - A,- B,- C,CGL,RGL,CHL,RHL ):-
	A =.. L1,B =.. L2,
	canUnify2( L1,L2,C,CGL,RGL,CHL,RHL ).
unifyVerb( A,B,C,CGL,RGL,CHL,RHL ):-
	A =.. L1,B =.. L2,
	canUnify2( L1,L2,C,CGL,RGL,CHL,RHL ).

canUnify2( [X|L1],[X|L2],C,CGL,RGL,CHL,RHL ):-!,
	trance( L1,[],Psi1 ),
	trance( L2,[],Psi2 ),
	checkItem1( Psi1,Psi2 ),
	unify3( Psi1,Psi2,[],Result,CGL,RGL,CHL,RHL ),
	C =.. [X|Result].
canUnify2( [X|L1],[Y|L2],C,CGL,RGL,CHL,RHL ):-
	getGLB2( X,Y,Z ),
	Z \== 'Bottom',!,
	trance( L1,[],Psi1 ),
	trance( L2,[],Psi2 ),
	checkItem1( Psi1,Psi2 ),!,
	unify3( Psi1,Psi2,[],Result,CGL,RGL,CHL,RHL ),
	C =.. [Z|Result].

getGLB2( Term1,Term1,Term1 ).
getGLB2( Term1,Term2,Term2 ):-
	lower( Term1,Term2,_ ),!.
getGLB2( _,_,'Bottom' ).

checkItem1( L1,L2 ):-
	length( L1,N1 ),
	length( L2,N2 ),
	N1 = N2,!,
	checkItemList( L1,L2 ).

checkItemList( [],_ ).
checkItemList( [ Tag1|L1 ],L2 ):-
	nth0( 0,Tag1,Temp1 ),	
	member( [Temp1|_],L2 ),!,
	checkItemList( L1,L2 ).
checkItemList( _,_ ) :- fail.

%--- $B$3$3$^$G(B ------

getGLB( 'Top',Term1,Term1 ).
getGLB( Term1,'Top',Term1 ).
getGLB( Term1,Term1,Term1 ).
getGLB( Term1,Term2,Term2 ):-
	lower( Term1,Term2,_ ),!.
getGLB( Term1,Term2,Term1 ):-
	lower( Term2,Term1,_ ),!.
getGLB( Term1,Term2,Temp ):-
	lower( Term1,Temp,_ ),
	lower( Term2,Temp,_ ),!.
getGLB( _,_,'Bottom' ).

unify3( [],L2,CList,Result,CGL,CGL,CHL,CHL ):-
	untrance( L2,[],Res ),
	append( CList,Res,Result ).
unify3( [Temp],[Temp],CList,Result,CGL,RGL,CHL,RHL ):-
	isnot_list( Temp ),
	unify( Temp,Temp,Z,CGL,RGL,CHL,RHL ),!,
	append( CList,[Z],Result ).
unify3( [ L1|Other1],L2,CList,Result,CGL,RGL,CHL,RHL ):-
	check( L1,L2,L3,Temp,CGL,CGL2,CHL,CHL2 ),
	Temp \== [],!,
	untrance( [Temp],[],Res ),
	append( CList,Res,C ),
	unify3( Other1,L3,C,Result,CGL2,RGL,CHL2,RHL ).
unify3( [ L1|Other1],L2,CList,Result,CGL,RGL,CHL,RHL ):-
	check( L1,L2,_,Temp,CGL,_,CHL,_ ),
	Temp = [],!,
	untrance( [L1],[],Res ),
	append( CList,Res,C ),
	unify3( Other1,L2,C,Result,CGL,RGL,CHL,RHL ).
unify3( _,_,_,_,_,_,_,_ ):- fail.

check( [ Tag|Other ],L2,L3,Res,CGL,RGL,CHL,RHL ):-
	select( L2,[Tag|Temp],L3 ),
	check2( Other,Temp,Result,CGL,RGL,CHL,RHL ),!,
	append( [Tag],[Result],Res ).
check( [ Tag|_ ],L2,L3,_,_,_,_,_ ):-
	select( L2,[Tag|_],L3 ),!,fail.
check( _,_,_,[],_,_,_,_ ).

check2( [ Var1 ],[Var2],Var1,CGL,RGL,CHL,RHL ):-
	var( Var1 ),
	var( Var2 ),
	Var1 == Var2,!,
	getTerm( Var1,CGL,Term1 ),
	getTerm( Var2,CHL,Term2 ),
	unify( Term1,Term2,Term3,CGL,CGL2,CHL,CHL2 ),
	select( CGL2,Var1/_,CGL3 ),
	append( [Var1/Term3],CGL3,RGL ),
	select( CHL2,Var2/_,CHL3 ),
	append( [Var2/Term3],CHL3,RHL ).
check2( [ Var1 ],[Var2],Var1,CGL,RGL,CHL,RHL ):-
	var( Var1 ),
	var( Var2 ),!,
	getTerm( Var1,CGL,Term1 ),
	getTerm( Var2,CHL,Term2 ),
	unify( Term1,Term2,Term3,CGL,CGL2,CHL,CHL2 ),
	selectVar( CGL2,Var1/_,CGL3 ),
	Var1 = Var2,
	append( [Var1/Term3],CGL3,RGL ),
	selectVar( CHL2,Var2/_,CHL3 ),
	append( [Var2/Term3],CHL3,RHL ).
check2( [Var1],[Term2],Var1,CGL,RGL,CHL,RHL  ):-
	var( Var1 ),!,
	getTerm( Var1,CGL,Term1 ),
	unify( Term1,Term2,Term3,CGL,CGL2,CHL,RHL ),
	selectVar( CGL2,Var1/_,CGL3 ),
	append( [Var1/Term3],CGL3,RGL ).
%	append( [Var1/Term3],CHL2,RHL ).
check2( [Term1],[Var2],Var2,CGL,RGL,CHL,RHL  ):-
	var( Var2 ),!,
	getTerm( Var2,CHL,Term2 ),
	unify( Term1,Term2,Term3,CGL,RGL,CHL,CHL2 ),
	selectVar( CHL2,Var2/_,CHL3 ),
	append( [Var2/Term3],CHL3,RHL ).
%	append( [Var2/Term3],CGL2,RGL ).
check2( [Psi1],[Psi2],Res,CGL,RGL,CHL,RHL ):-!,
	unify( Psi1,Psi2,Res,CGL,RGL,CHL,RHL ).

getTerm( Var1,VList,Term ):-
	memberVar( ( Var1 = Var2 ),VList ),!,
	getTerm( Var2,VList,Term ).
getTerm( Var1,VList,Term ):-
	memberVar( Var1/Term ,VList ),!.
getTerm( _,_,'Top' ).


change( [ / | Other ],Psi1 ):-
	nth0( 0,Other,Term ),
	var( Term ),!,
	numbervars( Term,1,_),
	assert( var( 'Vars'(1),'X' ) ),
	nth0( 1,Other,Psi1 ).
change( List1,Psi1 ):-
	Psi1 =.. List1.
