%%     tcltkinterface.pl   Rbrs 1.0 
%%     Copyright (C) Katsumi Nitta   (nitta@dis.titech.ac.jp)
%%                   Taketomo Katoh  (tkatoh@ntt.dis.titech.ac.jp)
%---------------------------------------------------%
%            Tcl/Tk Interface $BMQ=R8l72(B              %
%---------------------------------------------------$

makeBaseInterface :-
	myArg( Start,End ),
	Start \== End,!,
	makeTclList( Start,End,[],RList ),
	makeMainWindow2( RList ).
makeBaseInterface :-
	interp( I ),
	tcl_eval( I,['errormessage'],_ ).

makeTclList( N,N,CList,CList ).
makeTclList( Start,End,CList,RList ):-
	findall( CounterID,counter( Start,CounterID ),CIDList ),
	isnot_null_list( CIDList ),!,
	arg( Start,(Arg,VList) ),
	getTopGoal( Arg,Goal ),
	changedummy( Goal,NewGoal,VList ),
	getInformation( Start,Isgattack,WhichPriority ),
	makeTclList2( CIDList,[(Start,NewGoal,Isgattack,WhichPriority)],OtherList ),
	append( CList,[OtherList],CList2 ),
	Next is Start + 1,
	makeTclList( Next,End,CList2,RList ).
makeTclList( Start,End,CList,RList ):-
	arg( Start,(Arg,VList) ),
	getTopGoal( Arg,Goal ),
	changedummy( Goal,NewGoal,VList ),
	getInformation( Start,Isgattack,WhichPriority ),
	append( CList,[[(Start,NewGoal,Isgattack,WhichPriority),[]]],CList2 ),
	Next is Start + 1,
	makeTclList( Next,End,CList2,RList ).

makeTclList2( [],CList,CList ).
makeTclList2( [CID|Other],CList,RList ):-
	makeTclList3( CID,CList2 ),
	append( CList,CList2,CList3 ),
	makeTclList2( Other,CList3,RList ).

makeTclList3( CID,CList3 ):-
	TempID is CID + 1,
	makeTclList( CID,TempID,[],CList3 ).

getTopGoal( [( _::Goal <- _ )|_ ],Goal ).
getTopGoal( [( _::Goal )|_ ],Goal ).

getInformation( ArgID,1,WhichPriority ):-
	counter( PID,ArgID ),
	g_attack( PID,ArgID ),!,
	getPriority( PID,ArgID,WhichPriority ).
getInformation( ArgID,0,WhichPriority ):-
	counter( PID,ArgID ),!,
	getPriority( PID,ArgID,WhichPriority ).
getInformation( _,0,0 ).

getPriority( PID,ArgID,0 ):-
	arg( ArgID1,PID > ArgID,_,_ ),
	arg( ArgID2,ArgID > PID,_,_ ),
	getPriority( ArgID1,ArgID2,WhichPriority ),
	WhichPriority = 0,!.
getPriority( PID,ArgID,1 ):-
	arg( ArgID1,PID > ArgID,_,_ ),
	arg( ArgID2,ArgID > PID,_,_ ),
	getPriority( ArgID1,ArgID2, 1 ),!.
getPriority( PID,ArgID,2 ):-
	arg( ArgID1,PID > ArgID,_,_ ),
	arg( ArgID2,ArgID > PID,_,_ ),
	getPriority( ArgID1,ArgID2,2 ),!.
getPriority( PID,ArgID,1 ):-
	arg( _,PID > ArgID,_,_ ),!.
getPriority( PID,ArgID,2 ):-
	arg( _,ArgID > PID,_,_ ),!.
getPriority( _,_,0 ).

makeMainWindow :-
	tk_new( [],I ),
	assert( interp( I ) ),
	tcl_eval( I,'source interface.tcl',_),
	tcl_eval( I,'toplevel .top',_ ),
	tcl_eval( I,'wm geometry .top 880x810',_ ),
	tcl_eval( I,'frame .top.goalframe',_ ),
	tcl_eval( I,'entry .top.goal -relief sunken -bd 2 -width 45 -font "-adobe-courier-bold-r-normal--12-*-*-*-*-*-*-*"',_ ),
	tcl_eval( I,'button .top.bgoal -text "run!!" -command "findarg" -font "-adobe-courier-bold-o-normal--14-140-75-75-m-90-iso8859-1"',_ ),
	tcl_eval( I,'button .top.bclear -text "clear" -command "clearentry" -font "-adobe-courier-bold-o-normal--14-140-75-75-m-90-iso8859-1"',_ ),
	tcl_eval( I,'label .top.label1 -text "  Please input Goal :  " -font "-adobe-courier-bold-o-normal--14-140-75-75-m-90-iso8859-1"',_ ),
	tcl_eval( I,'makemenu',_ ),
	tcl_eval( I,'pack .top.menuframe -side left -fill y',_),
	tcl_eval( I,'bind .top.goal <Return> {findarg}',_ ),
	tcl_eval( I,'pack .top.label1 -in .top.goalframe -side left -padx 10 -pady 15',_ ),
	tcl_eval( I,'pack .top.goal -in .top.goalframe -side left -pady 15',_ ),
	tcl_eval( I,'pack .top.bgoal -in .top.goalframe -side left -pady 15',_ ),
	tcl_eval( I,'pack .top.bclear -in .top.goalframe -side left -pady 15',_ ),
	tcl_eval( I,'pack .top.goalframe -side top -padx 2 -fill x ',_),
	tk_main_loop,
	tcl_delete( I ).

makeMainWindow_again :-
	interp( I ),
	tcl_eval( I,'source interface.tcl',_),
	tcl_eval( I,'toplevel .top',_ ),
	tcl_eval( I,'wm geometry .top 880x810',_ ),
	tcl_eval( I,'frame .top.goalframe',_ ),
	tcl_eval( I,'entry .top.goal -relief sunken -bd 2 -width 45 -font "-adobe-courier-bold-r-normal--12-*-*-*-*-*-*-*"',_ ),
	tcl_eval( I,'button .top.bgoal -text "run!!" -command "findarg" -font "-adobe-courier-bold-o-normal--14-140-75-75-m-90-iso8859-1"',_ ),
	tcl_eval( I,'button .top.bclear -text "clear" -command "clearentry" -font "-adobe-courier-bold-o-normal--14-140-75-75-m-90-iso8859-1"',_ ),
	tcl_eval( I,'label .top.label1 -text "  Please input Goal :  " -font "-adobe-courier-bold-o-normal--14-140-75-75-m-90-iso8859-1"',_ ),
	tcl_eval( I,'makemenu',_ ),
	tcl_eval( I,'pack .top.menuframe -side left -fill y',_),
	tcl_eval( I,'bind .top.goal <Return> {findarg}',_ ),
	tcl_eval( I,'pack .top.label1 -in .top.goalframe -side left -padx 10 -pady 15',_ ),
	tcl_eval( I,'pack .top.goal -in .top.goalframe -side left -pady 15',_ ),
	tcl_eval( I,'pack .top.bgoal -in .top.goalframe -side left -pady 15',_ ),
	tcl_eval( I,'pack .top.bclear -in .top.goalframe -side left -pady 15',_ ),
	tcl_eval( I,'pack .top.goalframe -side top -padx 2 -fill x ',_).

runprocess( Goal ):-
	findAllArg( Goal ),
	makeArgGraph(_),
	priorityCheck(_),
	makeBaseInterface.

makeMainWindow2( ArgList ):-
	interp( I ),
	tcl_eval( I,'canvas .top.c -xscrollcommand ".top.sbx set" -yscrollcommand ".top.sby set" -scrollregion "0 0 2000 2000" -width 2000 -height 2000',_ ),
	makeMainWindow3( I,ArgList,1,BEnd,20,20,_,20,0 ),
	assert( lastButtonNum( BEnd ) ),
	tcl_eval( I,'scrollbar .top.sbx -command ".top.c xview" -width 10 -orient horizontal',_ ),
	tcl_eval( I,'scrollbar .top.sby -command ".top.c yview" -width 10 -orient vertical',_ ),
	tcl_eval( I,'lower .top.c',_ ),
	tcl_eval( I,'pack .top.sbx -side bottom -fill x',_),
	tcl_eval( I,'pack .top.sby -side right -fill y',_),
	tcl_eval( I,'pack .top.c -fill both',_ ).


makeMainWindow3( _,[[]],N2,N2,_,N,N,_,_ ).
makeMainWindow3( _,[],N2,N2,_,N,N,_,_ ).
makeMainWindow3( I,[ ArgList1|Other ],BNum,BEnd,X1,Y1,Y,ParentY,PID ):-
	makeMainWindow4( I,ArgList1,BNum,BNext,X1,Y1,Y2,ParentY,PID ),
	Y3 is Y2 + 50,
	makeMainWindow3( I,Other,BNext,BEnd,X1,Y3,Y,ParentY,PID ).


makeMainWindow4( _,[],N2,N2,_,Y,Y,_,_ ).
makeMainWindow4( I,[ (ArgID,ArgName,Isgattack,WhichPriority)|Other ],CBNum,RBNum,X1,Y1,Y,ParentY,PID ):-
	tcl_eval( I,'source interface.tcl',_),
	write_to_chars( ArgName,ArgCharList ),
	getArgButtonColor( ArgID,Color ),
	write_to_chars( Color,ColorList ),
	tcl_eval(I,['makebutton',CBNum,chars( ArgCharList ),X1,Y1,ParentY,ArgID,chars(ColorList)],_ ),
	tcl_eval(I,['writestatus',CBNum,X1,Y1,Isgattack,WhichPriority,PID,ArgID],_),
	NBNum is CBNum + 1,
	X2 is X1 + 300,
	makeMainWindow3( I,Other,NBNum,RBNum,X2,Y1,Y,Y1,ArgID ).
makeMainWindow4( I,(ArgID,ArgName,Isgattack,WhichPriority),CBNum,RBNum,X1,Y1,Y1,ParentY,PID ):-
	tcl_eval( I,'source interface.tcl',_),
	write_to_chars( ArgName,ArgCharList ),
	arg( ArgID,( Arg,VList ) ),
	removedummy( Arg,VList,[],RArg ),
	getArgButtonColor( ArgID,Color ),
	write_to_chars( Color,ColorList ),
	tcl_eval(I,['makebutton',CBNum,chars( ArgCharList ),X1,Y1,ParentY,RArg,chars(ColorList)],_ ),
	tcl_eval(I,['writestatus',CBNum,X1,Y1,Isgattack,WhichPriority,PID,ArgID],_),
	pButtonNumList( L1 ),
	retract( pButtonNumList( L1 ) ),
	assert( pButtonNumList( [CBNum|L1] ) ),
	RBNum is CBNum + 1.

getArgButtonColor( ArgID,tomato ):-
	priority( ArgID,defeasible ),!.
getArgButtonColor( ArgID,gold2 ):-
	priority( ArgID,justify ),!.
getArgButtonColor( ArgID,0 ):-
	priority( ArgID,unknown ),!.

assertPBList( N ):-
	pButtonNumList( L1 ),
	retract( pButtonNumList( L1 ) ),
	assert( pButtonNumList( [N|L1] ) ).

makeArgWindow( ArgID ):-
	arg( ArgID,(Arg,VList ) ),
	removedummy( Arg,VList,[],RArg ),
	getTopGoal( RArg,ArgName ),
	interp( I ),
	tcl_eval( I,['maketopwindow',ArgID],_ ),
	makeArgWindowList( I,ArgID,ArgName,RArg,_,20,150,_,1,_,150 ),
	tcl_eval( I,['maketopwindow2',ArgID ],_ ).


makeArgWindowList( I,ArgID,( not ArgName ),Args,Args,X1,Y1,Y,CBNum,RBNum,Parenty ):-
	write_to_chars( (not ArgName),ArgChar ),
	tcl_eval( I,['putbutton2',ArgID,dq( chars(ArgChar) ),X1,Y1,CBNum,Parenty],_ ),
	RBNum is CBNum + 1,
	Y is Y1 + 120.
makeArgWindowList( I,ArgID,( A >> B ),Args,Args,X1,Y1,Y,CBNum,RBNum,Parenty ):-
	write_to_chars( ( A >> B ),ArgChar ),
	tcl_eval( I,['putbutton3',ArgID,dq( chars(ArgChar) ),X1,Y1,CBNum,Parenty],_ ),
	RBNum is CBNum + 1,
	Y is Y1 + 120.
makeArgWindowList( I,ArgID,( A << B ),Args,Args,X1,Y1,Y,CBNum,RBNum,Parenty ):-
	write_to_chars( ( A << B ),ArgChar ),
	tcl_eval( I,['putbutton3',ArgID,dq( chars(ArgChar) ),X1,Y1,CBNum,Parenty],_ ),
	RBNum is CBNum + 1,
	Y is Y1 + 120.
makeArgWindowList( I,ArgID,ArgName,Args,Args2,X1,Y1,Y,CBNum,RBNum,Parenty ):-
	select( Args,( RID::ArgName <- Bodys ),Args2 ),
	write_to_chars( ArgName,ArgChar ),
	tcl_eval( I,['putbutton',ArgID,dq( chars(ArgChar) ),X1,Y1,CBNum,Parenty],_ ),
	N1 is X1 +160,
	N2 is Y1 -60,
	putRule( I,RID,( RID::ArgName <- Bodys ),ArgID,N1,N2,CBNum ),
	X2 is X1 + 250,
	CBNum2 is CBNum + 1,
	makeBodyList( I,ArgID,Bodys,Args2,_,X2,Y1,Y,CBNum2,RBNum,Y1 ).

makeBodyList( I,ArgID,(B1,B2),Args,RArgs,X,Y1,Y,CBNum,RBNum,Parenty ):-
	makeBodyList( I,ArgID,B1,Args,Args2,X,Y1,Y2,CBNum,CBNum2,Parenty ),
	makeBodyList( I,ArgID,B2,Args2,RArgs,X,Y2,Y,CBNum2,RBNum,Parenty ).
makeBodyList( I,ArgID,Body,Args,RArgs,X,Y1,Y,CBNum,RBNum,Parenty ):-
	makeArgWindowList( I,ArgID,Body,Args,RArgs,X,Y1,Y,CBNum,RBNum,Parenty ).

putRule( I,Rule,Arg,ArgID,X,Y,CBNum ):-
	write_to_chars( Rule,RuleChar ),
	write_to_chars( Arg,ArgChar ),
	tcl_eval( I,['putrule',ArgID,dq(chars( RuleChar )),dq(chars(ArgChar)),X,Y,CBNum],_).

putArginWindow( _,_,[],N,N ).
putArginWindow( I,ArgID,[ (ArgName,X,Y )|Other ],CBNum,RBNum ):-
	write_to_chars( ArgName,ArgCharList ),
	tcl_eval( I,['putbutton',ArgID,dq( chars(ArgCharList) ),X,Y,CBNum],_ ),
	CBNum2 is CBNum + 1,
	putArginWindow( I,ArgID,Other,CBNum2,RBNum ).

makePArgWindow( PID,ArgID,> ):-
	findall( PArgID,arg( PArgID,(PID>ArgID),_,_ ),ArgList1 ),
	findall( PArgID2,arg( PArgID2,(ArgID>PID),_,_ ),ArgList2 ),
	findallPPArg( ArgList1,ArgList2,>,[],ArgList3 ),
	makePArgTclList( ArgList1,[],RArgList1 ),
	makePArgTclList( ArgList2,[],RArgList2 ),
	makePArgTclList( ArgList3,[],RArgList3 ),
	makePArgWindow2( >,ArgID,RArgList1,RArgList2,RArgList3 ).
makePArgWindow( PID,ArgID,< ):-
	findall( PArgID,arg( PArgID,(PID>ArgID),_,_ ),ArgList1 ),
	findall( PArgID2,arg( PArgID2,(ArgID>PID),_,_ ),ArgList2 ),
	findallPPArg( ArgList1,ArgList2,<,[],ArgList3 ),
	makePArgTclList( ArgList1,[],RArgList1 ),
	makePArgTclList( ArgList2,[],RArgList2 ),
	makePArgTclList( ArgList3,[],RArgList3 ),
	makePArgWindow2( <,ArgID,RArgList1,RArgList2,RArgList3 ).
makePArgWindow( PID,ArgID,<> ):-
	findall( PArgID,arg( PArgID,(PID>ArgID),_,_ ),ArgList1 ),
	findall( PArgID2,arg( PArgID2,(ArgID>PID),_,_ ),ArgList2 ),
	findallPPArg( ArgList1,ArgList2,>,[],ArgList3 ),
	findallPPArg( ArgList1,ArgList2,<,[],ArgList4 ),
	makePArgTclList( ArgList1,[],RArgList1 ),
	makePArgTclList( ArgList2,[],RArgList2 ),
	makePArgTclList( ArgList3,[],RArgList3 ),
	makePArgTclList( ArgList4,[],RArgList4 ),
	makePArgWindow2( <>,ArgID,RArgList1,RArgList2,RArgList3,RArgList4 ).


findallPPArg( [],_,_,CList,CList ).
findallPPArg( [ID1|Other],IDL2,>,CList,RList ):-
	findallPPArg2( ID1,IDL2,>,CList,CList2 ),
	findallPPArg( Other,IDL2,>,CList2,RList ).
findallPPArg( [ID1|Other],IDL2,<,CList,RList ):-
	findallPPArg2( ID1,IDL2,<,CList,CList2 ),
	findallPPArg( Other,IDL2,<,CList2,RList ).

findallPPArg2( _,[],_,CList,CList ).
findallPPArg2( ID1,[ID2|Other],>,CList,RList ):-
	findall( PArgID,arg( PArgID,ID1>ID2,_,_ ),IDList ),
	append( CList,IDList,CList2 ),
	findallPPArg2( ID1,Other,>,CList2,RList ).
findallPPArg2( ID1,[ID2|Other],<,CList,RList ):-
	findall( PArgID,arg( PArgID,ID1<ID2,_,_ ),IDList ),
	append( CList,IDList,CList2 ),
	findallPPArg2( ID1,Other,<,CList2,RList ).

makePArgTclList( [],CList,CList ).
makePArgTclList( [ArgID1|Other],CList,RList ):-
	End is ArgID1 +1,
	makeTclPList( ArgID1,End,[],CList2 ),
	append( CList,CList2,CList3 ),
	makePArgTclList( Other,CList3,RList ).

makeTclPList( N,N,CList,CList ).
makeTclPList( Start,End,CList,RList ):-
	findall( CounterID,counter( Start,CounterID ),CIDList ),
	isnot_null_list( CIDList ),!,
	arg( Start,_,Arg,VList ),
	getTopGoal( Arg,Goal ),
	changedummy( Goal,NewGoal,VList ),
	getInformation( Start,Isgattack,WhichPriority ),
	makeTclList2( CIDList,[(Start,NewGoal,Isgattack,WhichPriority)],OtherList ),
	append( CList,[OtherList],CList2 ),
	Next is Start + 1,
	makeTclPList( Next,End,CList2,RList ).
makeTclPList( Start,End,CList,RList ):-
	arg( Start,_,Arg,VList ),
	getTopGoal( Arg,Goal ),
	changedummy( Goal,NewGoal,VList ),
	getInformation( Start,Isgattack,WhichPriority ),
	append( CList,[[(Start,NewGoal,Isgattack,WhichPriority),[]]],CList2 ),
	Next is Start + 1,
	makeTclPList( Next,End,CList2,RList ).
makeTclPList( Start,End,CList,RList ):-
	findall( CounterID,counter( Start,CounterID ),CIDList ),
	isnot_null_list( CIDList ),!,
	arg( Start,(Arg,VList) ),
	getTopGoal( Arg,Goal ),
	changedummy( Goal,NewGoal,VList ),
	getInformation( Start,Isgattack,WhichPriority ),
	makeTclList2( CIDList,[(Start,NewGoal,Isgattack,WhichPriority)],OtherList ),
	append( CList,[OtherList],CList2 ),
	Next is Start + 1,
	makeTclPList( Next,End,CList2,RList ).
makeTclPList( Start,End,CList,RList ):-
	arg( Start,(Arg,VList) ),
	getTopGoal( Arg,Goal ),
	changedummy( Goal,NewGoal,VList ),
	getInformation( Start,Isgattack,WhichPriority ),
	append( CList,[[(Start,NewGoal,Isgattack,WhichPriority),[]]],CList2 ),
	Next is Start + 1,
	makeTclPList( Next,End,CList2,RList ).

makePArgWindow2( <>,CID,[],[],[],[] ):-
	interp( I ),
	tcl_eval( I,['printnothing',CID],_ ).
makePArgWindow2( >,CID,PAL1,[],_ ):-
	interp( I ),
	tcl_eval( I,['makepargwindow',CID],_ ),
	putPArgs3( CID,I,PAL1,1,_,0,20,_,20,0 ),
	tcl_eval( I,['makepargwindow2',CID],_ ).
makePArgWindow2( <,CID,[],PAL2,_ ):-
	interp( I ),
	tcl_eval( I,['makepargwindow',CID],_ ),
	putPArgs( CID,I,PAL2,1,_,0,20,_,20,0 ),
	tcl_eval( I,['makepargwindow2',CID],_ ).
makePArgWindow2( <>,CID,PAL1,PAL2,[],[] ):-
	interp( I ),
	tcl_eval( I,['makepargwindow',CID],_ ),
	putPArgs3( CID,I,PAL1,1,NBNum,-120,20,_,20,0 ),
	putPArgs( CID,I,PAL2,NBNum,_,120,20,_,20,0 ),
	tcl_eval( I,['makeline',CID],_ ),
	tcl_eval( I,['makepargwindow2',CID],_ ).
makePArgWindow2( >,CID,PAL1,PAL2,PAL3 ):-
	interp( I ),
	tcl_eval( I,['makepargwindow',CID],_ ),
	putPArgs3( CID,I,PAL1,1,NBNum,-120,20,LeftY,20,0 ),
	putPArgs( CID,I,PAL2,NBNum,NBNum2,120,20,RightY,20,0 ),
	putPPArgs( CID,>,I,LeftY,RightY,PAL3,NBNum2 ),
	tcl_eval( I,['makepargwindow2',CID],_ ).
makePArgWindow2( <,CID,PAL1,PAL2,PAL3 ):-
	interp( I ),
	tcl_eval( I,['makepargwindow',CID],_ ),
	putPArgs3( CID,I,PAL1,1,NBNum,-120,20,LeftY,20,0 ),
	putPArgs( CID,I,PAL2,NBNum,NBNum2,120,20,RightY,20,0 ),
	putPPArgs( CID,<,I,LeftY,RightY,PAL3,NBNum2 ),
	tcl_eval( I,['makepargwindow2',CID],_ ).
makePArgWindow2( <>,CID,PAL1,PAL2,PAL3,PAL4 ):-
	interp( I ),
	tcl_eval( I,['makepargwindow',CID],_ ),
	putPArgs3( CID,I,PAL1,1,NBNum,-120,20,LeftY,20,0 ),
	putPArgs( CID,I,PAL2,NBNum,NBNum2,120,20,RightY,20,0 ),
	putPPArgs2( CID,I,LeftY,RightY,PAL3,PAL4,NBNum2 ),
	tcl_eval( I,['makepargwindow2',CID],_ ).

putPPArgs( CID,Which,I,Left,Right,PAL,BNum ):-
	Left > Right,!,
	Y is Left +60,
	tcl_eval( I,['makepline',CID,Which,Y],_ ),
	putPArgs( CID,I,PAL,BNum,_,0,Y,_,20,0 ).
putPPArgs( CID,Which,I,Left,Right,PAL,BNum ):-
	Right > Left,!,
	Y is Right + 60,
	tcl_eval( I,['makepline',CID,Which,Y],_ ),
	putPArgs( CID,I,PAL,BNum,_,0,Y,_,20,0 ).

putPPArgs2( CID,I,Left,Right,PAL1,PAL2,BNum ):-
	Left > Right,!,
	Y is Left + 30,
	Which = <>,
	tcl_eval( I,['makepline2',CID,Which,Y],_ ),
	putPArgs3( CID,I,PAL1,BNum,BNum2,-40,Y,_,Y,0 ),
	putPArgs( CID,I,PAL2,BNum2,_,40,Y,_,Y,0 ).
putPPArgs2( CID,I,Left,Right,PAL1,PAL2,BNum ):-
	Right > Left,!,
	Y is Right + 30,
	Which = <>,
	tcl_eval( I,['makepline2',CID,Which,Y],_ ),
	putPArgs3( CID,I,PAL1,BNum,BNum2,-40,Y,_,Y,0 ),
	putPArgs( CID,I,PAL2,BNum2,_,40,Y,_,Y,0 ).

putPArgs( _,_,[[]],N2,N2,_,N,N,_,_ ).
putPArgs( _,_,[],N2,N2,_,N,N,_,_ ).
putPArgs( CID,I,[ ArgList1|Other ],BNum,BEnd,X1,Y1,Y,ParentY,PID ):-
	putPArgs2( CID,I,ArgList1,BNum,BNext,X1,Y1,Y2,ParentY,PID ),
	Y3 is Y2 + 50,
	putPArgs( CID,I,Other,BNext,BEnd,X1,Y3,Y,Y1,PID ).

putPArgs2( _,_,[],N2,N2,_,Y,Y,_,_ ).
putPArgs2( CID,I,[ (ArgID,ArgName,Isgattack,WhichPriority)|Other ],CBNum,RBNum,X1,Y1,Y,ParentY,PID ):-
	tcl_eval( I,'source interface.tcl',_),
	write_to_chars( ArgName,ArgCharList ),
	getArgButtonColor( ArgID,Color ),
	write_to_chars( Color,ColorList ),
	tcl_eval(I,['makebutton3',CID,CBNum,chars( ArgCharList ),X1,Y1,ParentY,ArgID,chars(ColorList)],_ ),
	tcl_eval(I,['writestatus3',CID,CBNum,X1,Y1,Isgattack,WhichPriority,PID,ArgID],_),
	NBNum is CBNum + 1,
	X2 is X1 + 300,
	putPArgs( CID,I,Other,NBNum,RBNum,X2,Y1,Y,Y1,ArgID ).
putPArgs2( CID,I,(ArgID,ArgName,Isgattack,WhichPriority),CBNum,RBNum,X1,Y1,Y1,ParentY,PID ):-
	tcl_eval( I,'source interface.tcl',_),
	write_to_chars( ArgName,ArgCharList ),
	arg( ArgID,( Arg,VList ) ),
	removedamy( Arg,VList,[],RArg ),
	getArgButtonColor( ArgID,Color ),
	write_to_chars( Color,ColorList ),
	tcl_eval(I,['makebutton3',CID,CBNum,chars( ArgCharList ),X1,Y1,ParentY,RArg,chars(ColorList)],_ ),
	tcl_eval(I,['writestatus3',CID,CBNum,X1,Y1,Isgattack,WhichPriority,PID,ArgID],_),
	RBNum is CBNum + 1.

putPArgs3( _,_,[[]],N2,N2,_,N,N,_,_ ).
putPArgs3( _,_,[],N2,N2,_,N,N,_,_ ).
putPArgs3( CID,I,[ ArgList1|Other ],BNum,BEnd,X1,Y1,Y,ParentY,PID ):-
	putPArgs4( CID,I,ArgList1,BNum,BNext,X1,Y1,Y2,ParentY,PID ),
	Y3 is Y2 + 50,
	putPArgs3( CID,I,Other,BNext,BEnd,X1,Y3,Y,Y1,PID ).

putPArgs4( _,_,[],N2,N2,_,Y,Y,_,_ ).
putPArgs4( CID,I,[ (ArgID,ArgName,Isgattack,WhichPriority)|Other ],CBNum,RBNum,X1,Y1,Y,ParentY,PID ):-
	tcl_eval( I,'source interface.tcl',_),
	write_to_chars( ArgName,ArgCharList ),
	getArgButtonColor( ArgID,Color ),
	write_to_chars( Color,ColorList ),
	tcl_eval(I,['makebutton2',CID,CBNum,chars( ArgCharList ),X1,Y1,ParentY,ArgID,chars(ColorList)],_ ),
	tcl_eval(I,['writestatus2',CID,CBNum,X1,Y1,Isgattack,WhichPriority,PID,ArgID],_),
	NBNum is CBNum + 1,
	X2 is X1 - 300,
	putPArgs3( CID,I,Other,NBNum,RBNum,X2,Y1,Y,Y1,ArgID ).
putPArgs4( CID,I,(ArgID,ArgName,Isgattack,WhichPriority),CBNum,RBNum,X1,Y1,Y1,ParentY,PID ):-
	tcl_eval( I,'source interface.tcl',_),
	write_to_chars( ArgName,ArgCharList ),
	arg( ArgID,( Arg,VList ) ),
	removedamy( Arg,VList,[],RArg ),
	getArgButtonColor( ArgID,Color ),
	write_to_chars( Color,ColorList ),
	tcl_eval(I,['makebutton2',CID,CBNum,chars( ArgCharList ),X1,Y1,ParentY,RArg,chars(ColorList)],_ ),
	tcl_eval(I,['writestatus2',CID,CBNum,X1,Y1,Isgattack,WhichPriority,PID,ArgID],_),
	RBNum is CBNum + 1.

makeArgWindow2( ArgID ):-
	arg( ArgID,_,Arg,VList ),!,
	removedummy( Arg,VList,[],RArg ),
	getTopGoal( RArg,ArgName ),
	interp( I ),
	tcl_eval( I,['maketopwindow',ArgID],_ ),
	makeArgWindowList( I,ArgID,ArgName,RArg,_,20,150,_,1,_,150 ),
	tcl_eval( I,['maketopwindow2',ArgID ],_ ).
makeArgWindow2( ArgID ):-
	arg( ArgID,(Arg,VList) ),!,
	removedummy( Arg,VList,[],RArg ),
	getTopGoal( RArg,ArgName ),
	interp( I ),
	tcl_eval( I,['maketopwindow',ArgID],_ ),
	makeArgWindowList( I,ArgID,ArgName,RArg,_,20,150,_,1,_,150 ),
	tcl_eval( I,['maketopwindow2',ArgID ],_ ).

showArg( ID ):-
	interp( I ),
	arg( ID,(Arg,VList) ),!,
	removedummy( Arg,VList,[],NArg ),
	tcl_eval( I,['makeText',ID],_ ),
	writeTextArg( I,NArg,ID,10,_,1,_ ).
showArg( ID ):-
	interp( I ),
	arg( ID,_,Arg,VList ),
	removedummy( Arg,VList,[],NArg ),
	tcl_eval( I,['makeText',ID],_ ),
	writeTextArg( I,NArg,ID,10,_,1,_ ).

writeTextArg( _,[],_,_,_,_,_ ).
writeTextArg( I,[( RID::Head <- Body )|Other ],ID,X1,X,Y1,Y ):-
	write_to_chars( (RID::Head <- not Body),Rule ),
	tcl_eval( I,['writetext',dq( chars(Rule) ),ID,X1,Y1],_ ),
	Y2 is Y1 + 1,
	writeTextArg2( I,Body,Other,ID,X1,X,Y2,Y ).

writeTextArg2( I,(B1,B2),Other,ID,X1,X,Y1,Y ):-
	writeTextArg2( I,B1,Other,ID,X1,_,Y1,Y2 ),
	writeTextArg2( I,B2,Other,ID,X1,X,Y2,Y ).
writeTextArg2( _,( not _ ),_,_,X,X,Y,Y ).
writeTextArg2( _,( _ >> _ ),_,_,X,X,Y,Y ).
writeTextArg2( _,( _ << _ ),_,_,X,X,Y,Y ).
writeTextArg2( I,Term,Other,ID,X1,X,Y1,Y ):-
	select( Other,( RID::Term <- Body ),Other2 ),
	X2 is X1 + 30,
	writeTextArg( I,[( RID::Term <- Body )|Other2],ID,X2,X,Y1,Y ).

showIdentify :-
	interp( I ),
	identifyList( my,List ),
	tcl_eval( I,['makeidentwindow'],_ ),
	showIdentify2( I,List,1 ).

showIdentify2( _,[],_ ).
showIdentify2( I,[A|Other],N ):-
	write_to_chars( A,A2 ),
	tcl_eval( I,['writeident',dq(chars( A2 )),N],_ ),
	N2 is N + 1,
	showIdentify2( I,Other,N2 ).

clearWindow :-
	interp( I ),
	tcl_eval( I,['clearwindow'],_ ),
	makeMainWindow_again,
	abolish( arg ),
	abolish( issue ),
	abolish( carg ),
	abolish( counter ),
	abolish( pcounter ),
	abolish( g_attack ),
	retractOther.

retractOther :-
	abolish( lastArgID ),
	assert( lastArgID(1) ),
	abolish( lastPArgID ),
	assert( lastPArgID( 1 ) ),
	assertz( counter( null,null ) ),
	assert( pcounter( null,null ) ),
	assert( g_attack( null,null ) ),
	abolish( pre_CounterList ),
	assert( pre_CounterList( [ (null,null) ] ) ),
	abolish( pre_PCounterList ),
	assert( pre_PCounterList( [ (null,null) ] ) ),
	abolish( identifyList ),
	assert( identifyList( my,[] ) ),
	assert( identifyList( other,[] ) ),
	abolish( pButtonNumList ),
	assert( pButtonNumList( [] ) ),
	abolish( myArg ),
	assert( myArg( null,null ) ),
	assert( arg( null,null,null,null ) ).

checkIC:-
	clause( ICID,fail,Body,VList ),
	myGoalList( GList ),
	checkIC2( Body,VList,GList,[],ArgIDList ),!,
	writeIC( ICID,ArgIDList ).
checkIC.

findChildArg( [ArgID1],ArgID1 ).
findChildArg( [ArgID1|Other],ChildArg ):-
	is_parent( ArgID1,Other ),!,
	findChildArg( Other,ChildArg ).
findChildArg( [ ArgID1|Other ],ChildArg ):-
	append( Other,[ArgID1],Temp ),
	findChildArg( Temp,ChildArg ).

is_parent( ArgID1,[ArgID2] ):-
	is_parent2( ArgID1,ArgID2 ).
is_parent( ArgID1,[ArgID2|Other] ):-
	is_parent2( ArgID1,ArgID2 ),
	is_parent( ArgID1,Other ).

is_parent2( ArgID1,ArgID1 ).
is_parent2( ArgID1,ArgID2 ):-
	counter( ArgID1,TempID ),
	counter( TempID,ArgID2 ),!.
is_parent2( ArgID1,ArgID2 ):-
	counter( ArgID1,TempID ),
	is_parrent2( TempID,ArgID2 ).

checkIC( Args ):-
	findall( ICID,clause( ICID,fail,_,_ ),IDList ),
	makeICList( Args,[],RICList ),
	icchecking( IDList,RICList,[],RList ),
%	write( RList ).
	isnot_null_list( RList ),!,
	makeICWindow2( RList,1,_ ).
checkIC(_):-
	interp( I ),
	tcl_eval( I,'icnothing',_ ).

icchecking( [],_,CList,CList ).
icchecking( [ID1|Other],ICList,CList,RList ):-
	clause( ID1,fail,Body,VList ),
	checkIC2( Body,VList,ICList,[],ArgIDList ),!,
	append( CList,[(ID1,ArgIDList)],CList2 ),
	icchecking( Other,ICList,CList2,RList ).

checkIC2( (A,B),VList,GList,CIDList,RIDList ):-
	checkIC2( A,VList,GList,CIDList,CIDList2 ),
	checkIC2( B,VList,GList,CIDList2,RIDList ).
checkIC2( A,VList,GList,CIDList,RIDList  ):-
	checkIC4( A,VList,GList,[],CIDList2 ),
	isnot_null_list( CIDList2 ),!,
	append( CIDList,CIDList2,RIDList ).

checkIC3( _,_,[],CIDList,CIDList ).
checkIC3( A,VList,[ GList1 | Other ],CIDList,RIDList ):-
	checkIC4( A,VList,GList1,CIDList,CIDList2 ),
	checkIC3( A,VList,Other,CIDList2,RIDList ).

checkIC4( _,_,[],CIDList,CIDList ).
checkIC4( A,VList,[ ( ArgID,Term,VList2 )| _ ],CIDList,[( ArgID,Term,VList2 )|CIDList] ):-
	unifyVerb( A,Term,_,VList,_,VList2,_ ),!.
checkIC4( A,VList,[ _|Other],CIDList,RIDList ):-
	checkIC4( A,VList,Other,CIDList,RIDList ).

makeGoalList2( N,N,CGList,CGList ).
makeGoalList2( Start,End,CGList,RGList ):-
	arg( Start,(Arg,VList) ),!,
	getGoal2( Arg,VList,Start,CGList,CGList2 ),
	Next is Start + 1,
	makeGoalList2( Next,End,CGList2,RGList ).
makeGoalList2( Start,End,CGList,RGList ):-
	arg( Start,_,Arg,VList ),!,
	getGoal2( Arg,VList,Start,CGList,CGList2 ),
	Next is Start + 1,
	makeGoalList2( Next,End,CGList2,RGList ).

getGoal2( [],_,_,CGList,CGList ).
getGoal2( [(_:: G <- _)|Terms],VList,_,CGList,RGList ):-
	existGoal2( G,VList,CGList ),!,
	getGoal2( Terms,VList,CGList,RGList ).
getGoal2( [(_:: G <- _)|Terms],VList,ID,CGList,RGList ):-!,
	append( CGList,[(ID,G,VList)],CGList2 ),
	getGoal2( Terms,VList,ID,CGList2,RGList ).
getGoal2( [(_:: G )|Terms],VList,ID,CGList,RGList ):-!,
	append( CGList,[(ID,G,VList)],CGList2 ),
	getGoal2( Terms,VList,ID,CGList2,RGList ).

existGoal2( _,_,[] ):- fail.
existGoal2( G,VList,[ (_,Goal1,VList1)|_ ] ):-
	unifyVerb( G,Goal1,_,VList,_,VList1,_ ),!.
existGoal2( G,VList,[ _|Other ] ):-
	existGoal2( G,VList,Other ).


writeIC( ICID,ArgIDList ):-
	assert( not_allowArgs( ICID,ArgIDList ) ),
	write( 'Args ' ),write( ArgIDList ),write( ' is not allow set ' ),
	write( 'for constraint ' ).

makeICList( ( A,B ),CList,RList ):-
	makeICList( A,CList,CList2 ),
	makeICList( B,CList2,RList ).
makeICList( N,CList,RList ):-
	N1 is N + 1,
	makeGoalList2( N,N1,CList,RList ).

makeICWindow( List ):-
	interp( I ),
	tcl_eval( I,'icmainwin',_ ),
	makeICWindow2( I,List,1,_ ).

makeICWindow2( [],N,N ).
makeICWindow2( [(ICID,List1)|Other],N,End ):-
	interp( I ),
	tcl_eval( I,['icmainwin',ICID],_ ),
	makeICWindow3( I,ICID,List1,N,Next ),
	makeICWindow2( Other,Next,End ).

makeICWindow3( _,_,[],N,N ).
makeICWindow3( I,ICID,[(ArgID,Where,VList)|Other],N,End ):-
	changedummy( Where,NewWhere,VList ),
	write_to_chars( NewWhere,NewWhere2 ),
	tcl_eval( I,['writeICWin',ICID,dq(chars(NewWhere2)),ArgID],_ ),
	Next is N + 1,
	makeICWindow3( I,ICID,Other,Next,End ).
