%%     priority.pl   Rbrs 1.0 
%%     Copyright (C) Katsumi Nitta   (nitta@dis.titech.ac.jp)
%%                   Taketomo Katoh  (tkatoh@ntt.dis.titech.ac.jp)

makeArgGraph( _ ):-
	myArg( ID1,ID2 ),
	makeArgGraph2( ID1,ID2 ).

makeArgGraph2( N,N ).
makeArgGraph2( Start,End ):-
	findall( ID,counter( Start,ID ),IDList ),
	makeGraphEdge( Start,IDList ),
	Next is Start +1,
	makeArgGraph2( Next,End ).

makeGraphEdge( _,[] ).
makeGraphEdge( ID1,[ID2|Other] ):-
	g_attack( ID1,ID2 ),!,
	assert( edge( ID2,ID1,parent ) ),
	End is ID2 + 1,
	makeArgGraph2( ID2,End ),
	makeGraphEdge( ID1,Other ).
makeGraphEdge( ID1,[ID2|Other] ):-
	g_attack( ID2,_ ),!,
	assert( edge( ID1,ID2,child ) ),
	End is ID2 + 1,
	makeArgGraph2( ID2,End ),
	makeGraphEdge( ID1,Other ).
makeGraphEdge( ID1,[ID2|Other] ):-
	assert( edge( ID1,ID2,child ) ),
	assert( edge( ID2,ID1,parent ) ),
	makePArgGraph( ID1,ID2 ),
	End is ID2 + 1,
	makeArgGraph2( ID2,End ),
	makeGraphEdge( ID1,Other ).

makePArgGraph( ID1,ID2 ):-
	findall( PID1,arg( PID1,ID1>ID2,_,_ ),[] ),
	findall( PID2,arg( PID2,ID2>ID1,_,_ ),[] ).
makePArgGraph( ID1,ID2 ):-
	findall( PID1,arg( PID1,ID1>ID2,_,_ ),[] ),
	findall( PID2,arg( PID2,ID2>ID1,_,_ ),List2 ),
	makePArgGraph2( List2 ),
	assertPEdge( ID1,ID2,List2,ID1,not_support ).
makePArgGraph( ID1,ID2 ):-
	findall( PID2,arg( PID2,ID2>ID1,_,_ ),[] ),
	findall( PID1,arg( PID1,ID1>ID2,_,_ ),List1 ),
	makePArgGraph2( List1 ),
	assertPEdge( ID1,ID2,List1,ID2,support ).
makePArgGraph( ID1,ID2 ):-
	findall( PID1,arg( PID1,ID1>ID2,_,_ ),List1 ),
	findall( PID2,arg( PID2,ID2>ID1,_,_ ),List2 ),
	makePArgGraph2( List1 ),
	makePArgGraph2( List2 ),
	assertPEdge( ID1,ID2,List1,ID2,support ),
	assertPEdge( ID1,ID2,List2,ID1,not_support ),
	makePPArgGraph( List1,List2 ).

makePArgGraph2( [] ).
makePArgGraph2( [ID1|Other] ):-
	End is ID1 +1,
	makeArgGraph2( ID1,End ),
	makePArgGraph2( Other ).

makePPArgGraph( [],_ ).
makePPArgGraph( [ID1|Other],List2 ):-
	makePPArgGraph2( ID1,List2 ),
	makePPArgGraph( Other,List2 ).

makePPArgGraph2( _,[] ).
makePPArgGraph2( ID1,[ID2|Other] ):-
	makePArgGraph( ID1,ID2 ),
	assert( edge( ID1,ID2 ) ),
	assert( edge( ID2,ID1 ) ),
	makePPArgGraph2( ID1,Other ).

assertPEdge( _,_,[],_,_ ).
assertPEdge( ConflictPID,ConflictCID,[ID1|Other],ID2,Tag ):-
	assert( pedge( ConflictPID,ConflictCID,ID1,ID2,Tag )),
	assertPEdge( ConflictPID,ConflictCID,Other,ID2,Tag ).

priorityCheck( _ ):-
	myArg( ID1,ID2 ),
	priorityCheck2( ID1,ID2 ).

priorityCheck2( N,N ).
priorityCheck2( Start,End ):-
	findall( ID1,edge( ID1,Start,_ ),[] ),!,
	assert( priority( Start,justify ) ),
	Next is Start + 1,
	priorityCheck2( Next,End ).
priorityCheck2( Start,End ):-
	findall( ID1,edge( ID1,Start,parent ),[] ),!,
	Next is Start +1,
	priorityCheck2( Next,End ).
priorityCheck2( Start,End ):-
	findall( ID1,edge( ID1,Start,parent ),IDL1 ),
	priorityCheck3( Start,IDL1,[],PriorityList ),
	assertPriority( Start,PriorityList ),
	Next is Start + 1,
	priorityCheck2( Next,End ).

assertPriority( Start,PriorityList ):-
	isalljustify( PriorityList ),!,
	assert( priority( Start,justify ) ).
assertPriority( Start,PriorityList ):-
	isexistdefeasible( PriorityList ),!,
	assert( priority( Start,defeasible ) ).
assertPriority( Start,_ ):- !,
	assert( priority( Start,unknown ) ).

isexistdefeasible( [] ):- fail.
isexistdefeasible( [defeasible|_] ):- !.
isexistdefeasible( [ _|Other ] ):- !,
	isexistdefeasible( Other ).

priorityCheck3( _,[],CList,CList ).
priorityCheck3( PID,[CID|Other],CList,RList ):-
	priorityCheck4( PID,CID,Priority ),
	assertPriority2( CID,Priority ),
	priorityCheck3( PID,Other,[Priority|CList],RList ).

assertPriority2( CID,Priority ):-
	priority( CID,unknown ),!,
	retract( priority( CID,unknown ) ),
	reversePriority( Priority,New ),
	assert( priority( CID,New ) ).
assertPriority2( CID,Priority ):- !,
	reversePriority( Priority,New ),
	assert( priority( CID,New ) ).

reversePriority( justify,defeasible ):-!.
reversePriority( defeasible,justify ):-!.
reversePriority( unknown,unknown ):-!.

priorityCheck4( PID,CID,Priority ):-
	Temp is CID + 1,
	priorityCheck2( CID,Temp ),
	checkPriorityArg( PID,CID,Priority ).

checkPriorityArg( PID,CID,Priority ):-
	priority( CID,justify ),!,
	checkPriorityArg1( PID,CID,Priority,justify ).
checkPriorityArg( PID,CID,Priority ):-
	priority( CID,defeasible ),!,
	checkPriorityArg1( PID,CID,Priority,defeasible ).
checkPriorityArg( PID,CID,Priority ):-
	checkPriorityArg2( PID,CID,Priority ).

checkPriorityArg1( PID,CID,Priority,CIDPriority ):-
	checkPriorityArg2( PID,CID,Pri1 ),
	bothPriorityResult( Pri1,CIDPriority,Priority ).

bothPriorityResult( justify,justify,unknown ):-!.
bothPriorityResult( _,justify,defeasible ):-!.
bothPriorityResult( defeasible,_,defeasible ):-!.
bothPriorityResult( _,defeasible,justify ):-!.

checkPriorityArg2( PID,CID,unknown ):-
	findall( ID1,pedge( PID,CID,ID1,PID,not_support ),[] ),
	findall( ID2,pedge( PID,CID,ID2,CID,support ),[] ),!.
checkPriorityArg2( PID,CID,Priority ):-
	findall( ID1,pedge( PID,CID,ID1,PID,not_support ),[] ),!,
	findall( ID2,pedge( PID,CID,ID2,CID,support ),IDL2 ),
	checkPriorityArg3( IDL2,Priority ).
checkPriorityArg2( PID,CID,Priority ):-
	findall( ID1,pedge( PID,CID,ID1,PID,not_support ),IDL1 ),
	findall( ID2,pedge( PID,CID,ID2,CID,support ),[] ),!,
	checkPriorityArg5( IDL1,Priority ).
checkPriorityArg2( PID,CID,Priority ):-
	findall( ID1,pedge( PID,CID,ID1,PID,not_support ),IDL1 ),
	findall( ID2,pedge( PID,CID,ID2,CID,support ),IDL2 ),
	checkPriorityArg6( IDL1,IDL2,Priority ).

checkPriorityArg3( IDL,Priority ):-
	checkPriorityArg4( IDL,[],PList ),
	decidePriority1( PList,Priority ).

checkPriorityArg4( [],CList,CList ).
checkPriorityArg4( [ID1|Other],CList,RList ):-
	Temp is ID1 + 1,
	priorityCheck2( ID1,Temp ),
	priority( ID1,Tag ),
	checkPriorityArg4( Other,[Tag|CList],RList ).

decidePriority1( PList,unknown ):-
	member( defeasible,PList ),!.
decidePriority1( PList,justify ):-
	isalljustify( PList ),!.
decidePriority1( _,unknown ).

isalljustify( [] ).
isalljustify( [justify|Other] ):- !,
	isalljustify( Other ).
isalljustify( _ ):- fail.

isalldefeasible( [] ).
isalldefeasible( [defeasible|Other] ):- !,
	isalldefeasible( Other ).
isalldefeasible( _ ):- fail.

checkPriorityArg5( IDL,Priority ):-
	checkPriorityArg4( IDL,[],PList ),
	decidePriority2( PList,Priority ).

decidePriority2( PList,unknown ):-
	member( defeasible,PList ),!.
decidePriority2( PList,defeasible ):-
	isalljustify( PList ),!.
decidePriority2( _,unknown ).

checkPriorityArg6( IDL1,IDL2,Priority ):-
	checkPriorityArg5( IDL1,P1 ),
	checkPriorityArg3( IDL2,P2 ),
	lastCheckPriority( IDL1,IDL2,P1,P2,Priority ).

lastCheckPriority( _,_,justify,defeasible,unknown ):- !.
lastCheckPriority( _,_,justify,_,justify ):- !.
lastCheckPriority( IDL1,IDL2,defeasible,justify,Priority ):- !,
	checkPriorityPArg( IDL2,IDL1,[],PList ),
	decidePArgPriority( PList,Priority,unknown ).
lastCheckPriority( IDL1,IDL2,defeasible,unknown,Priority ):- !,
	checkPriorityPArg( IDL2,IDL1,[],PList ),
	decidePArgPriority( PList,Priority,justify ).
lastCheckPriority( _,_,defeasible,defeasible,defeasible ):- !.
lastCheckPriority( IDL1,IDL2,unknown,justify,Priority ):- !,
	checkPriorityPArg( IDL2,IDL1,[],PList ),
	decidePArgPriority( PList,Priority,unknown ).
lastCheckPriority( IDL1,IDL2,unknown,unknown,Priority ):- !,
	checkPriorityPArg( IDL2,IDL1,[],PList ),
	decidePArgPriority( PList,Priority,unknown ).
lastCheckPriority( _,_,unknown,defeasible,defeasible ):- !.

decidePArgPriority( PList,justify,_ ):-
	isalljustify( PList ),!.
decidePArgPriority( PList,defeasible,_ ):-
	isalldefeasible( PList ),!.
decidePArgPriority( _,Default,Default ).

checkPriorityPArg( [],_,CList,CList ).
checkPriorityPArg( [ID1|Other],IDL2,CList,RList ):-
	checkPriorityPArg2( ID1,IDL2,[],Pri1 ),
	decidePArgPriority2( Pri1,Priority ),
	checkPriorityPArg( Other,IDL2,[Priority|CList],RList ).

decidePArgPriority2( Pri1,justify ):-
	isalljustify( Pri1 ),!.
decidePArgPriority2( Pri1,defeasible ):-
	isalldefeasible( Pri1 ),!.
decidePArgPriority2( _,unknown ).

checkPriorityPArg2( _,[],CList,CList ).
checkPriorityPArg2( ID1,[ID2|Other],CList,RList ):-
	checkPriorityArg2( ID1,ID2,Priority ),
	changePreviousPriority( ID1,ID2,Priority ),
	checkPriorityPArg2( ID1,Other,[Priority|CList],RList ).

changePreviousPriority( ID1,ID2,Priority ):-
	priority( ID1,justify ),
	priority( ID2,justify ),!,
	retract( priority( ID1,justify ) ),
	retract( priority( ID2,justify ) ),
	assert( priority(ID1,Priority) ),
	reversePriority( Priority,New ),
	assert( priority(ID2,New) ).
changePreviousPriority( _,_,unknown ):- !.
changePreviousPriority( ID1,ID2,Priority ):-
	priority( ID1,Pri1 ),
	priority( ID2,Pri2 ),!,
	retract( priority( ID1,Pri1 ) ),
	retract( priority( ID2,Pri2 ) ),
	assert( priority(ID1,Priority) ),
	reversePriority( Priority,New ),
	assert( priority(ID2,New) ).

	