%%     makeclause.pl   Rbrs 1.0 
%%     Copyright (C) Katsumi Nitta   (nitta@dis.titech.ac.jp)
%%                   Taketomo Katoh  (tkatoh@ntt.dis.titech.ac.jp)
%----------------  makeclause Area  -----------------%
%    r1 :: p <- q,r $BEy$N%7%9%F%`$N9=J8$N%k!<%k$r(B     %
%    clause( r1,p,(q,r),$BJQ?t%j%9%H(B ) $B$N7A<0$K(B        %
%    $BJQ49$9$k%W%m%0%i%`(B                              %
%----------------------------------------------------%

makeclause( File1 ):-
	see( File1 ),
	read( X ),
	mkdef( X ),
	seen.

makedef( File1,File2 ):-
	see( File1 ),tell( File2 ),
	read( X ),
	mkdef( X ),
	seen,told.


%   $BFI$_9~$s$@%k!<%k$,M%@h%k!<%k$+H]$+$rH=CG$7!$(B
%   $B$=$l$K$h$C$F=hM}$rJ,$1$k0Y$N=R8l(B

mkdef( end_of_file ). 
mkdef( ( RuleID:: R1 > R2 ) ):-
	comPRule( (RuleID:: R1 > R2 ) ),
	read(X),!,
	mkdef( X ).
mkdef( ( RuleID:: R1 < R2 ) ):-
	comPRule( (RuleID:: R1 < R2 ) ),
	read(X),!,
	mkdef( X ).
mkdef( ( RuleID:: R1 > R2 <- Body ) ):-
	comPRule( (RuleID:: R1 > R2 <- Body ) ),
	read(X),!,
	mkdef( X ).
mkdef( ( RuleID:: R1 < R2 <- Body ) ):-
	comPRule( (RuleID:: R1 < R2 <- Body ) ),
	read(X),!,
	mkdef( X ).
mkdef( ( RuleID:: R1 > R2 <= ) ):-
	comPRule( (RuleID:: R1 > R2 <= ) ),
	read(X),!,
	mkdef( X ).
mkdef( ( RuleID:: R1 < R2 <= ) ):-
	comPRule( (RuleID:: R1 < R2 <= ) ),
	read(X),!,
	mkdef( X ).
mkdef( ( RuleID:: R1 > R2 <= Body ) ):-
	comPRule( (RuleID:: R1 > R2 <= Body ) ),
	read(X),!,
	mkdef( X ).
mkdef( ( RuleID:: R1 < R2 <= Body ) ):-
	comPRule( (RuleID:: R1 < R2 <= Body ) ),
	read(X),!,
	mkdef( X ).
mkdef( X ):-
	changeVar( X ),
	read(Y),!,
	mkdef( Y ).

% $B$R$H$D$N%k!<%k$KBP$7$F!"$=$l$r(B getVList $B$KEO$7!"(B
% $BJQ?t%j%9%H$rF@$F!"(Bassert $B$9$k4X?t(B changeVar

changeVar( ( RID :: <- Body ) ):-!,
	changeRID( RID,NewRID,CList1 ),
	getVList( Body,CList1,RList1,Sentence),
	findsameVar( RList1,RList1,RList2 ),
	assert( clause( NewRID,fail,Sentence,RList2 ) ).
changeVar( ( RID :: Head <= Body ) ):-!,
	changeRID( RID,NewRID,CList1 ),
	getVList( (Head <= Body),CList1,RList1,Sentence),
	Sentence =.. Temp,
	nth0( 1,Temp,Goal2 ),
	nth0( 2,Temp,Body2 ),
	findsameVar( RList1,RList1,RList2 ),
	assert( clause( NewRID,Goal2,Body2,RList2 ) ).
changeVar( ( RID :: Head <= ) ):-!,
	changeRID( RID,NewRID,CList1 ),
	getVList( (Head <= ),CList1,RList1,Sentence),
	Sentence =.. Temp,
	nth0( 1,Temp,Goal2 ),
	nth0( 2,Temp,Body2 ),
	findsameVar( RList1,RList1,RList2 ),
	assert( clause( NewRID,Goal2,Body2,RList2 ) ).
changeVar( ( RID :: Goal <- Body ) ):-!,
	changeRID( RID,NewRID,CList1 ),
	getVList( (Goal <- Body),CList1,RList1,Sentence),
	Sentence =.. Temp,
	nth0( 1,Temp,Goal2 ),
	nth0( 2,Temp,Body2 ),
	findsameVar( RList1,RList1,RList2 ),
	assert( clause( NewRID,Goal2,Body2,RList2 ) ).
changeVar( (RID :: Term) ):-
	changeRID( RID,NewRID,CList1 ),
	getVList( Term,CList1,RList1,Sentence),
	findsameVar( RList1,RList1,RList2 ),
	assert( clause( NewRID,Sentence,nil,RList2 ) ).


comPRule( (PID:: Head <= Body) ):-
	changeRID( PID,NewPID,CList1 ),
	getVList( (Head <= Body),CList1,RList1,Sentence),
	findsameVar( RList1,RList1,RList2 ),
	assertPRule( NewPID,Sentence,RList2 ).
comPRule( (PID :: Term <=) ):-
	changeRID( PID,NewPID,CList1 ),
	getVList( (Term <= ),CList1,RList1,Sentence),
	Sentence =.. Temp,
	nth0( 1,Temp,Goal2 ),
	nth0( 2,Temp,Body2 ),
	findsameVar( RList1,RList1,RList2 ),
	assert( pclause( NewPID,Goal2,Body2,RList2 ) ).
comPRule( (PID:: Head <- Body) ):-
	changeRID( PID,NewPID,CList1 ),
	getVList( (Head <- Body),CList1,RList1,Sentence),
	findsameVar( RList1,RList1,RList2 ),
	assertPRule( NewPID,Sentence,RList2 ).
comPRule( (PID :: Term) ):-
	changeRID( PID,NewPID,CList1 ),
	getVList( Term,CList1,RList1,Sentence),
	findsameVar( RList1,RList1,RList2 ),
	assert( pclause( NewPID,Sentence,nil,RList2 ) ).

assertPRule( PID,( Head <- Body ),VList ):-
	assert( pclause( PID,Head,Body,VList ) ).

changeRID( Rule,NewRule,RVList ):-
	Rule =.. [ RID|Vars ],
	getNewVars( Vars,[],RVList,[],NewVars,1 ),
	NewRule =.. [RID|NewVars].

getNewVars( [],CList,CList,CNewVars,CNewVars,_ ).
getNewVars( [X|Y],CList,RList,CNewVars,RNewVars,N ):-
	var( X ),!,
	append( CList,[X/'Top'],CList2 ),
	append( CNewVars,[ 'dummy'(N)=X ],CNewVars2 ),
	N1 is N+1,
	getNewVars( Y,CList2,RList,CNewVars2,RNewVars,N1 ).
getNewVars( [X|Y],CList,RList,CNewVars,RNewVars,N ):-
	X =.. [ X1|Vars ],
	getNewVars( Vars,CList,CList2,[],NewVars,1 ),
	Sentence =.. [X1|NewVars],
	append( CNewVars,[ 'dummy'(N)=Sentence ],CNewVars2 ),
	N1 is N+1,
	getNewVars( Y,CList2,RList,CNewVars2,RNewVars,N1 ).

getVList( true,CList,CList,_ ):-!.
getVList( ( A,B ),CList,VList,(S1,S2) ):-
	getVList( A,CList,Temp1,S1 ),
	getVList( B,Temp1,VList,S2 ),!.
getVList( ( A <= B ),CList,VList, (S1<-S2) ):-
	getVList( A,CList,Temp1,S1 ),
	makeDefault( A,B,NewB ),
	getVList( NewB,Temp1,VList,S2 ),!.
getVList( ( A <= ),CList,VList, (S1<-S2) ):-
	getVList( A,CList,Temp1,S1 ),
	makeDefault( A,nil,NewB ),
	getVList( NewB,Temp1,VList,S2 ),!.
getVList( ( A <- B ),CList,VList, (S1<-S2) ):-
	getVList( A,CList,Temp1,S1 ),
	getVList( B,Temp1,VList,S2 ),!.
getVList( (not (- Term)),CList,VList,not ( -S) ):-
	Term =.. [ Term1|Tags ],
	hasTags( Tags ),
	getVList2( Tags,CList,VList,[],S2 ),
	S =.. [Term1|S2 ].
getVList( (not -( Term)),CList,VList,not ( -S) ):-
	Term =.. [ Term1|Tags ],
	getVar( Tags,[],RList,[],S2,1 ),
	append( CList,RList,VList ),
	S =.. [Term1|S2 ],!.
getVList( (not Term),CList,VList,not S ):-
	Term =.. [ Term1|Tags ],
	hasTags( Tags ),
	getVList2( Tags,CList,VList,[],S2 ),
	S =.. [Term1|S2 ].
getVList( (not Term),CList,VList,not S ):-
	Term =.. [ Term1|Tags ],
	getVar( Tags,[],RList,[],S2,1 ),
	append( CList,RList,VList ),
	S =.. [Term1|S2 ],!.
getVList( (- Term),CList,VList,- S ):-
	Term =.. [ Term1|Tags ],
	hasTags( Tags ),!,
	getVList2( Tags,CList,VList,[],S2 ),
	S =.. [Term1|S2],!.
getVList( (- Term),CList,VList,- S ):-
	Term =.. [ Term1|Tags ],
	getVar( Tags,[],RList,[],S2,1 ),
	append( CList,RList,VList ),
	S =.. [Term1|S2],!.
getVList( (A>>B),CList,CList,(A>>B) ):-!.
getVList( (A<<B),CList,CList,(A<<B) ):-!.
getVList( Term,CList,VList,S ):-
	Term =.. [ Term1|Tags ],
	hasTags( Tags ),!,
	getVList2( Tags,CList,VList,[],S2 ),
	S =.. [Term1|S2].
getVList( Term,CList,VList,S ):-
	Term =.. [Term1|List1],
	getVar( List1,[],RList,[],RS,1 ),
	append( CList,RList,VList ),
	S =.. [Term1|RS],!.

makeDefault( ( A > B ),nil,( not (A < B) ) ):-!.
makeDefault( ( A < B ),nil,( not (A > B) ) ):-!.
makeDefault( ( A1 > A2 ),B,(B,( not (A1 < A2) )) ):-!.
makeDefault( ( A1 < A2 ),B,(B,( not (A1 > A2) )) ):-!.
makeDefault( ( -A),nil,( not A ) ):-!.
makeDefault( A,nil,( not -A ) ):-!.
makeDefault( ( -A ),( B1,B2 ),( B1,NewB2 ) ):-!,
	makeDefault( ( -A ),B2,NewB2 ).
makeDefault( A,( B1,B2 ),( B1,NewB2 ) ):-!,
	makeDefault( A,B2,NewB2 ).
makeDefault( ( -A ),B,(B,( not A ) ) ):-!.
makeDefault( A,B,(B,( not -A ) ) ):-!.


hasTags( [] ):-fail.
hasTags( [ Var1 | _ ] ):-
	var( Var1 ),!,
	fail.
hasTags( [ _ = _ | _ ] ).
hasTags( [_|Other] ):-
	hasTags( Other ).

getVar( [],CList,CList,CS,CS,_ ).
getVar( [Var1|Other],CList,RList,CS,RS,N ):-
	var( Var1 ),!,
	append( CList,[Var1/'Top'],CList2 ),
	append( CS,['dummy'(N)=Var1],CS2 ),
	N1 is N+1,
	getVar( Other,CList2,RList,CS2,RS,N1 ).
getVar( [Temp|Other],CList,RList,CS,RS,N ):-
	Temp =.. List,
	length( List,Num ),
	Num \== 1,!,
	getVList( Temp,[],CS1,S1 ),
	append( CList,CS1,CList2 ),
	append( CS,['dummy'(N)=S1],CS2 ),
	N1 is N+1,
	getVar( Other,CList2,RList,CS2,RS,N1 ).
getVar( [Temp|Other],CList,RList,CS,RS,N ):-
	append( CS,['dummy'(N)=Temp],CS2 ),
	N1 is N + 1,
	getVar( Other,CList,RList,CS2,RS,N1 ).

getVList2( [],CL,CL,CS,CS ).
getVList2( [ Tag1|Other],CL1,RL1,CS,S ):-
	Tag1 =.. List1,
	nth0( 2,List1,Term1 ),
	var( Term1 ),!,
	append( CS,[ Tag1 ],CS2 ),
	append( CL1,[ Term1/'Top'],CL2 ),
	getVList2( Other,CL2,RL1,CS2,S ).
getVList2( [ Tag1|Other],CL1,RL1,CS,S ):-
	Tag1 =.. List1,
	select( List1,Var/Term,List2 ),!,
	getVList( Term,CL1,CL2,Term2 ),
	append( CL2,[Var/Term2],CL3 ),
	append( List2,[ Var ],Temp ),
	NewTag =.. Temp,
	append( CS,[NewTag],CS2 ),
	getVList2( Other,CL3,RL1,CS2,S ).
getVList2( [ Tag1|Other],CL1,RL1,CS,S ):-
	Tag1 =.. [=|[Tag2|[Term1]]],
	Term1 =.. TempList,
	length( TempList,N ),
	N \== 1,!,
	getVList( Term1,CL1,CL2,Term2 ),
	NewTag =.. [=,Tag2,Term2],
	append( CS,[ NewTag ],CS2 ),
	getVList2( Other,CL2,RL1,CS2,S ).
getVList2( [Tag|Other],CL,RL,CS,S ):- 
	append( CS,[Tag],CS2 ),
	getVList2( Other,CL,RL,CS2,S ).

findsameVar( [],CL,CL ).
findsameVar( [Var/'Top'|Other],CL,RL ):-
	memberVar( Var/_,Other ),!,
	selectVar( CL,Var/'Top',CL2 ),
	findsameVar( Other,CL2,RL ).
findsameVar( [Var/_|Other],CL,RL ):-
	memberVar( Var/'Top',Other ),!,
	selectVar( CL,Var/'Top',CL2 ),
	findsameVar( Other,CL2,RL ).
findsameVar( [Var/Term1|Other],CL,RL ):-
	memberVar( (Var=Var2),Other ),
	memberVar( Var2/Term2,Other ),!,
	selectVar( CL,Var/Term1,CL2 ),
	unify( Term1,Term2,Term3,CL2,_,CL2,RL2 ),
	selectVar( RL2,Var/_,RL3 ),
	selectVar( RL3,Var2/_,RL4 ),
	append( [Var2/Term3],RL4,RL5 ),
	findsameVar( Other,RL5,RL ).
findsameVar( [Var/Term1|Other],CL,RL ):-
	memberVar( Var/Term2,Other ),!,
	selectVar( CL,Var/Term1,CL2 ),
	unify( Term1,Term2,Term3,CL2,_,CL2,RL2 ),
	selectVar( RL2,Var/_,RL3 ),
	append( [Var/Term3],RL3,RL4 ),
	findsameVar( Other,RL4,RL ).
findsameVar( [ _|Other],CL,RL ):- findsameVar( Other,CL,RL ).


changePID( PID,NewPID,RVList ):-
	PID =.. [P|Vars],
	changePVars( Vars,[],NewVars,[],RVList,1 ),
	NewPID =.. [P|NewVars].

changePVars( [],CNewVars,CNewVars,CList,CList,_ ).
changePVars( [X|Y],CNewVars,RNewVars,CVList,RVList,N ):-
	var( X ),!,
	append( CVList,[X/'Top'],CVList2 ),
	append( CNewVars,[ 'rule'(N)=X ],CNewVars2 ),
	N1 is N+1,
	changePVars( Y,CNewVars2,RNewVars,CVList2,RVList,N1 ).
changePVars( [X|Y],CNewVars,RNewVars,CVList,RVList,N ):-
	X =.. [R|Vars],
	isVar( Vars ),!,
	getNewVars( Vars,CVList,CVList2,[],TempVars,1 ),
	X1 =.. [R|TempVars],
	append( CNewVars,['rule'(N)=X1],CNewVars2 ),
	N1 is N+1,
	changePVars( Y,CNewVars2,RNewVars,CVList2,RVList,N1 ).
changePVars( [X|Y],CNewVars,RNewVars,CVList,RVList,N ):-
	changeRID( X,NewX,CVList2 ),
	append( CVList,CVList2,CVList3 ),
	append( CNewVars,[ 'rule'(N)=NewX ],CNewVars2 ),
	N1 is N+1,
	changePVars( Y,CNewVars2,RNewVars,CVList3,RVList,N1 ).

changeHead( (R1 > R2),( 'rule'(1)=R1 > 'rule'(2)=R2 ) ):-
	var(R1),var(R2),!.
changeHead( (R1 > R2),( 'rule'(1)=NewR1 > 'rule'(2)=NewR2 ) ):-
	changePID( R1,NewR1,_ ),
	changePID( R2,NewR2,_ ).
changeHead( (R1 < R2),( 'rule'(1)=R1 < 'rule'(2)=R2 ) ):-
	var(R1),var(R2),!.
changeHead( (R1 < R2),( 'rule'(1)=NewR1 < 'rule'(2)=NewR2 ) ):-
	changePID( R1,NewR1,_ ),
	changePID( R2,NewR2,_ ).

isVar( [] ).
isVar( [X|Y] ):-
	var( X ),!,
	isVar(Y).

