%%     makeCounterArg.pl   Rbrs 1.0 
%%     Copyright (C) Katsumi Nitta   (nitta@dis.titech.ac.jp)
%%                   Taketomo Katoh  (tkatoh@ntt.dis.titech.ac.jp)
%------------------------------------------%
%    findIssue $B$G8+$D$+$C$?O@E@$KBP$7$F(B    %
%    $B3FH?O@$r@8@.$9$k=R8l(B makeCounterArg   %
%------------------------------------------%

makeCounterArg( ArgId ):-
	issue( ArgId,Issues ),
	makeCounter( ArgId,1,Issues,[],CArg ),
	assert( carg( ArgId,CArg ) ),
	lastArgID( NextID ),
	retract( lastArgID( NextID ) ),
	assertCounter( ArgId,NextID ).

makeCounter( _,_,[],C,C ).
makeCounter( ArgId,CId,[ ( RId :: Issue,VList,hasnot )|IList ],C,CArg ):-
	findall( (RL,RGL),top2( Issue,VList,RL,RGL ),Args ),
	makeCounterList( (RId::Issue),Args,C,Current ),
	N is CId +1,
	makeCounter( ArgId,N,IList,Current,CArg ).
makeCounter( ArgId,CId,[ ( RId :: Issue,VList )|IList ],C,CArg ):-
	findall( (RL,RGL),top2( Issue,VList,RL,RGL ),Args ),
	makeCounterList( (RId::Issue),Args,C,Current ),
	N is CId +1,
	makeCounter( ArgId,N,IList,Current,CArg ).

makeCounterList( _,[],CList,CList ).
makeCounterList( Issue,[Arg|Other],CList,RList ):-
	append( CList,[ [Issue,Arg] ],CList2 ),
	makeCounterList( Issue,Other,CList2,RList ).

top2( (- Goal),VList,RL,RGL ):-!,
	demo( - Goal,_,[],RL,VList,RGL ).
top2( Goal,VList,RL,RGL ):-!,
	demo( Goal,_,[],RL,VList,RGL ).

assertCounter( ArgId,CId ):- 
	carg( ArgId,Counter ),!,
	question( ArgId,CId,Counter ).

question( _,NID,[] ):- assert( lastArgID( NID ) ).
question( ArgId,CId,[[Issue,CArgs]|Other ] ):-
	getreply( ArgId,CId,NId,Issue,CArgs ),
	question( ArgId,NId,Other ).

getreply( _,CId,CId,_,[] ).
getreply( ArgId,CId,NId,_,(Counter,VList) ):-
	assert( arg( CId,(Counter,VList) ) ),
	assert( counter( ArgId,CId ) ),
	NId is CId + 1.
getreply(_,_,_,_).


