%%     makeArg.pl   Rbrs 1.0 
%%     Copyright (C) Katsumi Nitta   (nitta@dis.titech.ac.jp)
%%                   Taketomo Katoh  (tkatoh@ntt.dis.titech.ac.jp)
%-------------------------------------------%
%   $B%4!<%k$rF~NO$7$F$=$l$KBP$9$kO@>Z$r@8@.(B  %
%   $B$9$k(B makeArg                            %
%-------------------------------------------%

makeArg( Goal ):-!,
	findall( (RL,RGL),top( Goal,RL,RGL ),Args ),
	lastArgID( StartID ),
	retract( lastArgID( StartID ) ),
	assertArg( StartID,LastID,Args ),
	assert( lastArgID( LastID )).

assertArg( ArgID,ArgID,[] ):- !.
assertArg( ArgID,LastID,[ Arg1|Other ] ):-!,
	assert( arg( ArgID,Arg1 ) ),
	N is ArgID + 1,
	assertArg( N,LastID,Other ).

top( (- Goal),RL,RGL ):-
	getVList( Goal,[],CGL,Goal2 ),
	demo( (- Goal2),_,[],RL,CGL,RGL),!.
top( Goal,RL,RGL ):-
	getVList( Goal,[],CGL,Goal2 ),
	demo( Goal2,_,[],RL,CGL,RGL ).

demo( (A,B),(H1,H2),CL,RL,CGL,RGL ):-!,
	demo( A,H1,CL,Temp2,CGL,CGL2 ),
	demo( B,H2,Temp2,RL,CGL2,RGL ).
demo( (not A),(not A),CL,CL,CGL,CGL ):-!.
demo( (A>>B),(A>>B),CL,RL,CGL,RGL ):-
	clause( RID,(V1>>V2),nil,VList ),
	unifyVerb( A,V1,A2,CGL,CGL2,VList,RHL1 ),
	unifyVerb( B,V2,B2,CGL2,CGL3,RHL1,RHL2 ),
	append( CL,[ (RID::(A2 >> B2) ) ],RL ),
	append( CGL3,RHL2,RHL3 ),
	findsameVar( RHL3,RHL3,RGL ),!.
demo( (A<<B),(A<<B),CL,RL,CGL,RGL ):-
	clause( RID,(V1<<V2),nil,VList ),
	unifyVerb( A,V1,A2,CGL,CGL2,VList,RHL1 ),
	unifyVerb( B,V2,B2,CGL2,CGL3,RHL1,RHL2 ),
	append( CL,[ (RID::(A2 << B2 )) ],RL ),
	append( CGL3,RHL2,RHL3 ),
	findsameVar( RHL3,RHL3,RGL ),!.
demo( A,Z,CL,RL,CGL,RGL ):-
	clause( RID,Goal,nil,VList ),
	unifyVerb( A,Goal,Z,CGL,RGL1,VList,RHL ),
	append( CL,[ (RID::Z) ],RL ),
	append( RGL1,RHL,RGL2 ),
	findsameVar( RGL2,RGL2,RGL ).
demo( A,Z,CL,RL,CGL,RGL ):-
	clause( RID,Goal,Head,VList ),
	unifyVerb( A,Goal,Z,CGL,RGL1,VList,RHL ),
	append( RGL1,RHL,RHL2 ),
	findsameVar( RHL2,RHL2,RHL3 ),
	demo( Head,NewHead,[],RL1,RHL3,RGL ),
	append( [ (RID::Z <- NewHead) ],RL1,RL2 ),
	append( CL,RL2,RL ).

removedammy2( [],_,_,CList,CList ).
removedammy2( [( RID::Head<-Body )|Other],VList1,VList2,CList,RList ):-
	changeDammy( Head,Head2,VList1,VList2 ),
	changeDammy( Body,Body2,VList1,VList2 ),
	append( CList,[(RID::Head2<-Body2)],CList2 ),
	removedammy2( Other,VList1,VList2,CList2,RList ).
removedammy2( [( RID::Head )|Other],VList1,VList2,CList,RList ):-
	changeDammy( Head,Head2,VList1,VList2 ),
	append( CList,[(RID::Head2)],CList2 ),
	removedammy2( Other,VList1,VList2,CList2,RList ).

changeDammy( (A,B),(A1,B1),VList1,VList2 ):-
	changeDammy( A,A1,VList1,VList2 ),
	changeDammy( B,B1,VList1,VList2 ).
changeDammy( (- A),(- NewA),VList1,VList2 ):-
	changeDammy( A,NewA,VList1,VList2 ).
changeDammy( (not A),(not NewA),VList1,VList2 ):-
	changeDammy( A,NewA,VList1,VList2 ).
changeDammy( A,NewA,VList1,VList2 ):-
	var( A ),
	getValue1( A,NewA,VList1,VList2 ).
changeDammy( A,NewA,VList1,VList2 ):-
	A =.. [T|Values],
	changeDammy2( Values,Temp,VList1,VList2 ),
	NewA =.. [T|Temp].

getValue1( A,A,VList,_):-
	member( (A/'Top'),VList ),!.
getValue1( A,Term,VList,_):-
	member( (A/Term),VList ),!.
getValue1( A,NewA,VList1,VList2):-
	member( (A=Temp),VList1 ),!,
	getValue1( Temp,NewA,VList1,VList2 ).
getValue1( A,A,_,VList2):-
	member( (A/'Top'),VList2 ),!.
getValue1( A,Term,_,VList2):-
	member( (A/Term),VList2 ),!.
getValue1( A,A,_,_).

changeDammy2( [],[],_,_ ).
changeDammy2( [(dammy(_)=Psi)|Other],[NewPsi|NewOther],VList1,VList2 ):-
	changeDammy( Psi,NewPsi,VList1,VList2 ),
	changeDammy2( Other,NewOther,VList1,VList2 ).
changeDammy2( [(Tag=Psi)|Other],[(Tag=NewPsi)|NewOther],VList1,VList2 ):-
	changeDammy( Psi,NewPsi,VList1,VList2 ),
	changeDammy2( Other,NewOther,VList1,VList2 ).
changeDammy2( [Tag1|Other],[Tag1|NewOther],VList1,VList2 ):-
	changeDammy2( Other,NewOther,VList1,VList2 ).
