%%     main.pl   Rbrs 1.0 
%%     Copyright (C) Katsumi Nitta   (nitta@dis.titech.ac.jp)
%%                   Taketomo Katoh  (tkatoh@ntt.dis.titech.ac.jp)

:- op( 300,xfy,'on' ).
:- op( 500,fx,'-' ).
:- op( 501,fx,'not' ).
:- op( 502,fx,'-*' ).
:- op( 714,xfy,'=' ).
:- op( 713,xfy,'/' ).
:- op( 715,xfx,'>' ).
:- op( 715,xfx,'<' ).
:- op( 717,xfx,'<>' ).
:- op( 718,xfx,'>>' ).
:- op( 719,xfx,'<<' ).
:- op( 1010,xfy,'::' ).
:- op( 1010,fy,'::' ).
:- op( 1011,xfy,':::' ).
:- op( 1008,xfy,'<-' ).
:- op( 1008,fy,'<-' ).
:- op( 1009,xfy,'<=' ).
:- op( 1009,xf,'<=' ).
:- op( 1009,xfy,'<==' ).

:-use_module( library( tcltk ) ).
:-use_module( library( charsio ) ).

%------------  Utilities  -------------------

append( [],B,B ).
append( [A|A1],B,[A|C] ):-
	append( A1,B,C ).

member( _,[] ):- fail.
member( Term,[Term|_] ):-!.
member( Term,[_|Other] ):-
	member( Term,Other ).

select( [],_,_ ):-fail.
select( [Term|L1],Term,L1 ):-!.
select( [Term1|L1],Term,[Term1|L2] ):-
	Term1 \== Term,!,
	select( L1,Term,L2 ).

memberVar( _,[] ) :- fail.
memberVar( Var1/Temp2,[ Var2/Temp2|_ ] ):-
	Var1 == Var2,!.
memberVar( Var1 = Var2,[ Var3 = Var4|_ ] ):-
	Var1 == Var3,
	Var2 == Var4,!.
memberVar( Var1/Temp,[ _| Other ] ):-
	memberVar( Var1/Temp,Other ).

selectVar( [],_,_ ):- fail.
selectVar( [Var2/Temp|List1],Var1/Temp,List1 ):-
	Var1 == Var2,!.
selectVar( [Var2/Temp2|List1],Var1/Temp,[Var2/Temp2|List2] ):-!,
	selectVar( List1,Var1/Temp,List2 ).

selectList( List,[],List ).
selectList( List1,[Term|Other],Result ):-
	select( List1,Term,List2 ),
	selectList( List2,Other,Result ).

nth0( 0,[Term|_],Term ):-!.
nth0( N,[_|Other],Term ):-
	N1 is N-1,
	nth0( N1,Other,Term ).

isnot_list( [] ):- !,fail.
isnot_list( [ _|_ ] ):-!,fail.
isnot_list( _ ).

isnot_null_list( [] ):-!,fail.
isnot_null_list( _ ).

trance( [],CList,CList ).
trance( [ Term | Other ],CList,Psi ):-
	var( Term ),
	append( CList,[Term],Temp ),
	trance( Other,Temp,Psi ).
trance( [ Type = Var | Other ],CList,Psi ):-
	append( CList,[[Type,Var]],Temp ),
	trance( Other,Temp,Psi ).
trance( [ Term|Other ],CList,Psi ):-
	append( CList,[Term],Temp ),
	trance( Other,Temp,Psi ).

untrance( [],CList,CList ).
untrance( [List1|Other],CList,Result ):-
	nth0( 0,List1,Term ),
	select( List1,Term,[Temp] ),
	append( CList,[ Term = Temp ],C ),
	untrance( Other,C,Result ).


%###### $BO@AhMQ%a%$%s%b%8%e!<%k(B ########

ruleBaseSystem :-
	makelower( debate1 ),
	makeclause( debate3 ),
	makeMainWindow.
rbs :- ruleBaseSystem.

%:-[makelower,makeclause,unify,makeArg,findIssue,makeCounterArg,
%	compareRule,comparePRule,findAllArg,priority,tcltkinterface].
:-assert( endVarNum(0) ),
	assert( lastArgID(1) ),
	assert( lastPosedArgID(1) ),
	assertz( counter( null,null ) ),
	assert( pcounter( null,null ) ),
	assert( g_attack( null,null ) ),
	assert( posed_g_attack( null,null ) ),
	assert( pre_CounterList( [ (null,null) ] ) ),
	assert( pre_PCounterList( [ (null,null) ] ) ),
	assert( identifyList( my,[default<<specity] ) ),
	assert( identifyList( other,[default>>specity] ) ),
	assert( myArg( null,null ) ),
	assert( arg( null,null,null,null ) ),
	assert( lastPosedButtonNum(1) ),
	assert( priority( null,null ) ),
	assert( pButtonNumList( [] ) ),
	assert( pedge( null,null,null,null,null ) ).

