proc errormessage {} {
    set goal [.top.goal get]
    toplevel .error
    message .error.m -relief raised -text "$B%4!<%k(B $goal $B$K$OO@>Z$O$"$j$^$;$s(B" -font "-adobe-courier-bold-r-normal--14-*-*-*-*-*-*"
    button .error.exit -text "Exit" -command "destroy .error.m .error.exit .error" -font "-adobe-courier-bold-o-normal--14-140-75-75-m-90-iso8859-1"
    pack .error.m .error.exit -side top -padx 20 -pady 20
}

proc findarg {} {
    set goal [.top.goal get]
    prolog "runprocess($goal)"
}

proc clearentry {} {
    .top.goal delete 0 end
}

proc makemenu {} {
    frame .top.menuframe -borderwidth 5 -relief sunken
    pack .top.menuframe -side left
    button .top.showarg -text "Show Arg" -width 10 -height 2 -font "-adobe-courier-bold-o-normal--14-140-75-75-m-90-iso8859-1" -command "getargid"
    button .top.clearall -text "Clear" -width 10 -height 2 -font "-adobe-courier-bold-o-normal--14-140-75-75-m-90-iso8859-1" -command "prolog \"clearWindow\""
    button .top.showIdent -text "Show Ident" -width 10 -height 2 -font "-adobe-courier-bold-o-normal--14-140-75-75-m-90-iso8859-1" -command "prolog \"showIdentify\""
    button .top.exit1 -text "Exit" -width 10 -height 2 -font "-adobe-courier-bold-o-normal--14-140-75-75-m-90-iso8859-1" -command "destroy .top ."
    pack .top.showarg .top.clearall .top.showIdent .top.exit1 -padx 3 -side top -in .top.menuframe 
}

proc getargid {} {
    toplevel .m1
    frame .m1.input
    label .m1.label -text "Please input argument number : " -font "-adobe-courier-bold-o-normal--14-140-75-75-m-90-iso8859-1"
    entry .m1.argid -relief sunken -bd 2 -width 15 -font "-adobe-courier-mudium-r-normal--12-*-*-*-*-*-*" -textvariable id
    bind .m1.argid <Return> { getentry }
    frame .m1.buttons
    button .m1.run -text "run!!" -font "-adobe-courier-bold-o-normal--14-140-75-75-m-90-iso8859-1" -command "getentry"
    button .m1.exit -text "Exit" -font "-adobe-courier-bold-o-normal--14-140-75-75-m-90-iso8859-1" -command "destroy .m1"
    pack .m1.label .m1.argid -in .m1.input -side left
    pack .m1.run .m1.exit -in .m1.buttons -side left -expand 1
    pack .m1.input .m1.buttons -side top
}

proc getentry {} {
    set id [.m1.argid get]
    destroy .m1
    prolog "showArg($id)"
}

proc makeText {i} {
    toplevel .argtext$i
    wm geometry .argtext$i 700x300
    frame .argtext$i.f1
    frame .argtext$i.f2
    button .argtext$i.exit -text "Exit" -font "-adobe-courier-bold-o-normal--14-140-75-75-m-90-iso8859-1" -command "destroy .argtext$i"
    pack .argtext$i.exit -in .argtext$i.f2
    pack .argtext$i.f2 -side left -fill y
    pack .argtext$i.f1 -side left -fill y
}

proc writetext { rule p n i } {
    set y [expr $i * 40]
    label .argtext$p.label$i -text "$rule" -font "-adobe-courier-bold-r-normal--12-*-*-*-*-*-*"
    place .argtext$p.label$i -x $n -y $y -in .argtext$p.f1
}


proc makeidentwindow {} {
    toplevel .ident
    frame .ident.f1
    frame .ident.f2
    button .ident.exit -text "Exit" -font "-adobe-courier-bold-o-normal--14-140-75-75-m-90-iso8859-1" -command "destroy .ident"
    pack .ident.exit -in .ident.f2
    pack .ident.f2 -side left -fill y
    pack .ident.f1 -side left -fill y
}

proc writeident {term i} {
    label .ident.label$i -text $term -font "-adobe-courier-bold-o-normal--14-140-75-75-m-90-iso8859-1"
    pack .ident.label$i -side top -padx 20 -pady 10 -in .ident.f1
}

proc clearcanvus { n pblist } {
    destroy .top.c .top.sbx .top.sby
    for {set i 1} {$i < $n} {incr i} {destroy .top.b$i}
    foreach i $pblist {
	destroy .top.bp$i
    }
}

proc clearwindow {} {
    destroy .top
}

proc findIC {} {
    toplevel .ic
    frame .ic.input
    label .ic.label -text "Please input argument number : " -font "-adobe-courier-bold-o-normal--14-140-75-75-m-90-iso8859-1"
    entry .ic.argid -relief sunken -bd 2 -width 15 -font "-adobe-courier-bold-o-normal--14-140-75-75-m-90-iso8859-1" -textvariable id
    bind .ic.argid <Return> { getIC }
    frame .ic.buttons
    button .ic.run -text "run!!" -font "-adobe-courier-bold-o-normal--14-140-75-75-m-90-iso8859-1" -command "getIC"
    button .ic.exit -text "Exit" -font "-adobe-courier-bold-o-normal--14-140-75-75-m-90-iso8859-1" -command "destroy .ic "
    pack .ic.label .ic.argid -in .ic.input -side left
    pack .ic.run .ic.exit -in .ic.buttons -side left -expand 1
    pack .ic.input .ic.buttons -side top    
}

proc getIC {} {
    set ids [.ic.argid get]
    prolog "checkIC( ($ids) )"
    destroy .ic
}

proc icnothing {} {
    toplevel .ic1
    message .ic1.m -text "$B;XDj$5$l$?O@>Z4V$K0l4S@-@)Ls$NL7=b$O$"$j$^$;$s(B"
    button .ic1.b -text "OK" -font "-adobe-courier-bold-o-normal--14-140-75-75-m-90-iso8859-1" -command "destroy .ic1.b .ic1.m .ic1"
    pack .ic1.m .ic1.b -side top -padx 20 -pady 20
}

proc icmainwin { i } {
    toplevel .icwin$i
    frame .icwin$i.f1
    frame .icwin$i.f2
    label .icwin$i.label1 -text "$B0l4S@-@)Ls(B"
    button .icwin$i.rule -text $i -font "-adobe-courier-bold-o-normal--14-140-75-75-m-90-iso8859-1" -command "prolog \"seeICRule( $i )\""
    label .icwin$i.label2 -text "$B$K<!$NO@>Z$,L7=b$7$F$$$^$9!#(B"
    button .icwin$i.ok -text "OK!!" -font "-adobe-courier-bold-o-normal--14-140-75-75-m-90-iso8859-1" -command "destroy .icwin$i"
    pack .icwin$i.label1 -side left -in .icwin$i.f1
    pack .icwin$i.rule -side left -in .icwin$i.f1 -padx 5
    pack .icwin$i.label2 -side left -in .icwin$i.f1
    pack .icwin$i.f1 .icwin$i.f2 .icwin$i.ok -padx 10 -pady 20 -side top
}

proc writeICWin {i where argid} {
    button .icwin$i.b$argid -text "$where" -command "prolog \"makeArgWindow( $argid )\""
    pack .icwin$i.b$argid -side left -expand 1 -padx 15 -pady 10 -in .icwin$i.f2
}
    

proc maketopwindow {i} {
    toplevel .arg$i
    wm geometry .arg$i 910x810
    canvas .arg$i.c -xscrollcommand ".arg$i.sbx set" -yscrollcommand ".arg$i.sby set" -scrollregion "0 0 2000 2000" -width 2000 -height 2000
}

proc maketopwindow2 {i} {
    scrollbar .arg$i.sbx -command ".arg$i.c xview" -width 10 -orient horizontal
    scrollbar .arg$i.sby -command ".arg$i.c yview" -width 10 -orient vertical
    frame .arg$i.menu -borderwidth 3 -relief sunken
    button .arg$i.showarg -text "Show Arg" -command "prolog \"showArg($i)\"" -font "-adobe-courier-bold-o-normal--14-140-75-75-m-90-iso8859-1" -borderwidth 3 -width 10 -height 2
    button .arg$i.exit -text "Exit" -command "destroy .arg$i" -font "-adobe-courier-bold-o-normal--14-140-75-75-m-90-iso8859-1" -borderwidth 3 -width 10 -height 2
    pack .arg$i.showarg .arg$i.exit -in .arg$i.menu -padx 3 -pady 10 -side top
    pack .arg$i.sbx -side bottom -fill x
    pack .arg$i.sby -side right -fill y
    pack .arg$i.menu -side left -fill y
    pack .arg$i.c -side left -fill both
}

proc packframe {parent i x y} {
    place .f$i -in .f$parent -x $x -y $y
}

proc makebutton {i arg x y parenty1 argID color} {
    if { $color == "0" } {
	button .top.b$i -text $arg -width 14 -height 2 -command "prolog \"makeArgWindow($argID)\"" -font "-adobe-courier-bold-r-normal--12-*-*-*-*-*-*"
    } {
	button .top.b$i -text $arg -width 14 -height 2 -command "prolog \"makeArgWindow($argID)\"" -font "-adobe-courier-bold-r-normal--12-*-*-*-*-*-*"  -bg $color -activebackground $color
    }
    .top.c create window $x $y -window .top.b$i -anchor nw
    set parentx [expr $x -300 +128]
    set parenty [expr $parenty1 +22.5]
    set middlex [expr $x -80]
    set currenty [expr $y +22.5]
    lower .top.b$i
    if { $x > 20 } {
	.top.c create line $parentx $parenty $middlex $parenty $middlex $currenty $x $currenty -width 2 -arrow both
    } {}
}

proc writestatus {i x y gattack priority parent argid} {
    if { $x > 20 } {
	set middlex [expr $x -80]
	set currenty [expr $y +22.5]
	if { $gattack == 1 } {
	    .top.c create text [expr $middlex +40] [expr $currenty -10] -text g_attack -font "-adobe-courier-bold-o-normal--14-140-75-75-m-90-iso8859-1"
	} {
	    if { $priority == 1 } {
		button .top.bp$i -text > -font "-adobe-courier-bold-r-normal--12-*-*-*-*-*-*" -command "prolog \"makePArgWindow($parent,$argid,>)\""
		.top.c create window [expr $middlex +30] [expr $currenty -20] -window .top.bp$i 
		lower .top.bp$i
		prolog "assertPBList( $i )"
	    } {
		if { $priority == 2 } {
		    button .top.bp$i -text < -font "-adobe-courier-bold-r-normal--12-*-*-*-*-*-*" -command "prolog \"makePArgWindow($parent,$argid,<)\""
		    .top.c create window [expr $middlex +30] [expr $currenty -20] -window .top.bp$i 
		    lower .top.bp$i
		    prolog "assertPBList( $i )"
		} {
		    button .top.bp$i -text <> -font "-adobe-courier-bold-r-normal--12-*-*-*-*-*-*" -command "prolog \"makePArgWindow($parent,$argid,<>)\""
		    .top.c create window [expr $middlex +30] [expr $currenty -20] -window .top.bp$i
		    lower .top.bp$i
		    prolog "assertPBList( $i )"
		}
	    }
	}
    }
}

proc test {parent which} {
    toplevel .test
    button .test.b -text $parent$which
    pack .test.b
}

proc putbutton {id arg x y i parenty1} {
    button .arg$id.b$i -text $arg -width 17 -height 2 -font "-adobe-courier-bold-r-normal--12-*-*-*-*-*-*" -command "printarg $id $i \"$arg\""
    .arg$id.c create window $x $y -window .arg$id.b$i -anchor nw
    if { $x > 20 } {
	set parentx [expr $x -235 +140]
	set middlex [expr $x -20]
	set parenty [expr $parenty1 +22.5]
	set currenty [expr $y +22.5]
	.arg$id.c create line $parentx $parenty $middlex $parenty $middlex $currenty $x $currenty -width 2 -arrow first -arrow first
    } {}
}

proc putbutton2 {id arg x y i parenty1} {
    button .arg$id.b$i -text $arg -width 17 -height 2 -font "-adobe-courier-bold-r-normal--12-*-*-*-*-*-*" -bg LightSkyBlue -activebackground LightSkyBlue -command "printarg $id $i \"$arg\""
    .arg$id.c create window $x $y -window .arg$id.b$i -anchor nw
    if { $x > 20 } {
	set parentx [expr $x -235 +140]
	set middlex [expr $x -20]
	set parenty [expr $parenty1 +22.5]
	set currenty [expr $y +22.5]
	.arg$id.c create line $parentx $parenty $middlex $parenty $middlex $currenty $x $currenty -width 2 -arrow first -arrow first
    } {}
}

proc putbutton3 {id arg x y i parenty1} {
    button .arg$id.b$i -text $arg -width 17 -height 2 -font "-adobe-courier-bold-r-normal--12-*-*-*-*-*-*" -bg Green -activebackground Green -command "printarg $id $i \"$arg\""
    .arg$id.c create window $x $y -window .arg$id.b$i -anchor nw
    if { $x > 20 } {
	set parentx [expr $x -235 +140]
	set middlex [expr $x -20]
	set parenty [expr $parenty1 +22.5]
	set currenty [expr $y +22.5]
	.arg$id.c create line $parentx $parenty $middlex $parenty $middlex $currenty $x $currenty -width 2 -arrow first -arrow first
    } {}
}

proc putrule {id rule arg x y i} {
    button .arg$id.rb$i -text $rule -padx 10 -pady 5 -command "printrule $id $i \"$arg\"" -width 7 -font "-adobe-courier-bold-r-normal--12-*-*-*-*-*-*"
    .arg$id.c create window $x $y -window .arg$id.rb$i -anchor nw
    set currentx [expr $x + 50]
    set currenty [expr $y + 25]
    set parenty [expr $y +80]
    .arg$id.c create line $currentx $currenty $currentx $parenty -width 2 -arrow last
}

proc printarg {id i arg} {
    toplevel .term$i
    button .term$i.m -text "$arg" -command "destroy .term$i" -font "-adobe-courier-bold-r-normal--12-*-*-*-*-*-*"
    button .term$i.b -text "exit" -command "destroy .term$i"
    pack .term$i.m -padx 10 -pady 30
    pack .term$i.b -padx 30 -pady 30 -side bottom
}

proc printrule {id i arg} {
    toplevel .rule$i
    button .rule$i.m -text "$arg" -command "destroy .rule$i" -font "-adobe-courier-bold-r-normal--12-*-*-*-*-*-*"
    button .rule$i.b -text "exit" -command "destroy .rule$i"
    pack .rule$i.m -padx 10 -pady 30
    pack .rule$i.b -padx 30 -pady 30 -side bottom
}


proc makepargwindow {i} {
    toplevel .parg$i
    wm geometry .parg$i 910x810
    canvas .parg$i.c -xscrollcommand ".parg$i.sbx set" -yscrollcommand ".parg$i.sby set" -scrollregion "-1000 0 1000 2000" -width 2000 -height 2000
}

proc makepargwindow2 {i} {
    scrollbar .parg$i.sbx -command ".parg$i.c xview" -width 10 -orient horizontal
    scrollbar .parg$i.sby -command ".parg$i.c yview" -width 10 -orient vertical
    .parg$i.sbx set 0.3 0.7
    frame .parg$i.menu -borderwidth 3 -relief sunken
    button .parg$i.showarg -text "Show Arg" -command "getargid" -font "-adobe-courier-bold-o-normal--14-140-75-75-m-90-iso8859-1" -borderwidth 3 -width 10 -height 2
    button .parg$i.exit -text "Exit" -command "destroy .parg$i" -font "-adobe-courier-bold-o-normal--14-140-75-75-m-90-iso8859-1" -borderwidth 3 -width 10 -height 2
    pack .parg$i.showarg .parg$i.exit -in .parg$i.menu -padx 3 -pady 10 -side top
    pack .parg$i.sbx -side bottom -fill x
    pack .parg$i.sby -side right -fill y
    pack .parg$i.menu -side left -fill y
    pack .parg$i.c -side left -fill both
}

proc printnothing {i} {
    toplevel .pargs$i
    message .pargs$i.m -relief raised -text "$B$3$NO@>Z4V$K$OM%@h4X78$O$"$j$^$;$s(B"
    button .pargs$i.b -text "OK" -font "-adobe-courier-bold-o-normal--14-140-75-75-m-90-iso8859-1" -command "destroy .pargs$i"
    pack .pargs$i.m -padx 40 -pady 40 -ipadx 40 -ipadx 40
}

proc makebutton2 {w i arg x y parenty1 argID color} {
    if { $color == "0" } {
	button .parg$w.b$i -text $arg -width 14 -height 2 -command "prolog \"makeArgWindow2($argID)\"" -font "-adobe-courier-bold-r-normal--12-*-*-*-*-*-*"
    } {
	button .parg$w.b$i -text $arg -width 14 -height 2 -command "prolog \"makeArgWindow2($argID)\"" -font "-adobe-courier-bold-r-normal--12-*-*-*-*-*-*" -bg $color -activebackground $color
    }
    .parg$w.c create window $x $y -window .parg$w.b$i -anchor n
    set parentx [expr $x +300 -80]
    set parenty [expr $parenty1 +22.5]
    set middlex [expr $x +160]
    set currenty [expr $y +22.5]
    set currentx [expr $x + 80]
    if { $x < -120 } {
	.parg$w.c create line $parentx $parenty $middlex $parenty $middlex $currenty $currentx $currenty -width 2 -arrow both
    } {}
}

proc writestatus2 {w i x y gattack priority parent argid} {
    if { $x < -120 } {
	set middlex [expr $x +160]
	set currenty [expr $y +22.5]
	if { $gattack == 1 } {
	    .parg$w.c create text [expr $middlex +40] [expr $currenty -10] -text g_attack -font "-adobe-courier-bold-r-normal--12-*-*-*-*-*-*"
	} {
	    if { $priority == 1 } {
		button .parg$w.bp$i -text > -font "-adobe-courier-bold-r-normal--12-*-*-*-*-*-*" -command "prolog \"makePArgWindow($parent,$argid,>)\""
		.parg$w.c create window [expr $middlex -30] [expr $currenty -20] -window .parg$w.bp$i
	    } {
		if { $priority == 2 } {
		    button .parg$w.bp$i -text < -font "-adobe-courier-bold-r-normal--12-*-*-*-*-*-*" -command "prolog \"makePArgWindow($parent,$argid,<)\""
		    .parg$w.c create window [expr $middlex -30] [expr $currenty -20] -window .parg$w.bp$i
		} {
		    button .parg$w.bp$i -text <> -font "-adobe-courier-bold-r-normal--12-*-*-*-*-*-*" -command "prolog \"makePArgWindow($parent,$argid,<>)\""
		    .parg$w.c create window [expr $middlex -30] [expr $currenty -20] -window .parg$w.bp$i
		}
	    }
	}
    }
}

proc makebutton3 {w i arg x y parenty1 argID color} {
    if { $color == "0" } {
	button .parg$w.b$i -text $arg -width 14 -height 2 -command "prolog \"makeArgWindow2($argID)\"" -font "-adobe-courier-bold-r-normal--12-*-*-*-*-*-*"
    } {
	button .parg$w.b$i -text $arg -width 14 -height 2 -command "prolog \"makeArgWindow2($argID)\"" -font "-adobe-courier-bold-r-normal--12-*-*-*-*-*-*" -bg $color -activebackground $color
    }
    .parg$w.c create window $x $y -window .parg$w.b$i -anchor n
    set parentx [expr $x -300 +80]
    set parenty [expr $parenty1 +22.5]
    set middlex [expr $x -160]
    set currenty [expr $y +22.5]
    set currentx [expr $x -80]
    if { $x > 120 } {
	.parg$w.c create line $parentx $parenty $middlex $parenty $middlex $currenty $currentx $currenty -width 2
    } {}
}

proc writestatus3 {w i x y gattack priority parent argid} {
    if { $x > 120 } {
	set middlex [expr $x -160]
	set currenty [expr $y +22.5]
	if { $gattack == 1 } {
	    .parg$w.c create text [expr $middlex -40] [expr $currenty -10] -text g_attack -font "-adobe-courier-bold-r-normal--12-*-*-*-*-*-*"
	} {
	    if { $priority == 1 } {
		button .parg$w.bp$i -text > -font "-adobe-courier-bold-r-normal--12-*-*-*-*-*-*" -command "prolog \"makePArgWindow($parent,$argid,>)\""
		.parg$w.c create window [expr $middlex -30] [expr $currenty -20] -window .parg$w.bp$i
	    } {
		if { $priority == 2 } {
		    button .parg$w.bp$i -text < -font "-adobe-courier-bold-r-normal--12-*-*-*-*-*-*" -command "prolog \"makePArgWindow($parent,$argid,<)\""
		    .parg$w.c create window [expr $middlex -30] [expr $currenty -20] -window .parg$w.bp$i
		} {
		    button .parg$w.bp$i -text <> -font "-adobe-courier-bold-r-normal--12-*-*-*-*-*-*" -command "prolog \"makePArgWindow($parent,$argid,<>)\""
		    .parg$w.c create window [expr $middlex -30] [expr $currenty -20] -window .parg$w.bp$i
		}
	    }
	}
    }
}

proc makeline {i} {
    .parg$i.c create line -40 44.5 40 44.5 -width 2 -arrow both
}

proc makepline {i which y} {
    set left [expr -40]
    set right [expr 40]
    set endy [expr $y +22.5]
    .parg$i.c create line $left 44.5 $right 44.5 -width 2 -arrow both
    .parg$i.c create line 0 44.5 0 $endy -width 2 -arrow first
}

proc makeppline {i which y} {
    set left [expr -40]
    set right [expr 40]
    set endy [expr $y +22.5]
    .parg$i.c create line $left 44.5 $right 44.5 -width 2 -arrow both
    .parg$i.c create line 0 44.5 0 $endy -width 2 -arrow first
    .parg$i.c create line -40 $endy 40 $endy -width 2 -arrow both
}

