%%     findIssue.pl   Rbrs 1.0 
%%     Copyright (C) Katsumi Nitta   (nitta@dis.titech.ac.jp)
%%                   Taketomo Katoh  (tkatoh@ntt.dis.titech.ac.jp)
%-----------------------------------------------%
%    $BO@>Z$+$i$=$NH?O@E@$r8+IU$1$k$?$a$N=R8l(B     %
%                 findIssue                     %
%-----------------------------------------------%

findIssue( ArgId,GList ):-
	arg( ArgId,(Arg,VList) ),
	makeIssue( Arg,VList,GList,[],Issue_list ),
	assert( issue( ArgId,Issue_list) ).

makeIssue( [],_,_,CList,CList ).
makeIssue( [(Rid:: _ <- Body)|Terms],VList,GList,CList,IList ):-
	hasnot( Body,VList,Rid,[],Issues ),
	checkGoal( Issues,GList ),!,
	append( CList,Issues,L ),
	makeIssue2( Terms,VList,GList,L,IList ).
makeIssue( [_|Terms],VList,GList,CList,IList ):-
	makeIssue2( Terms,VList,GList,CList,IList ).


hasnot( (G1,G2),VList,Rid,C,Issue ):- !,
	hasnot( G1,VList,Rid,C,L ),
	hasnot( G2,VList,Rid,L,Issue ).
hasnot( (not G),VList,Rid,C,Issue ):- !,
	append(C,[(Rid::G,VList,hasnot)],Issue ).
hasnot( _,_,_,C,C ).

reverse( (-G),Rid,VList,[(Rid::G,VList)] ).
reverse( G,Rid,VList,[(Rid:: -G,VList)] ).

%--------------------------------------------------------------

findIssue2( ArgId,GList ):-
	arg( ArgId,_,PArg,VList ),
	makeIssue2( PArg,VList,GList,[],Issue_list ),
	assert( issue( ArgId,Issue_list) ).

makeIssue2( [],_,_,CList,CList ).
makeIssue2( [(Rid:: _ <- Body)|Terms],VList,GList,CList,IList ):-
	hasnot2( Body,VList,Rid,[],Issues ),
	checkGoal( Issues,GList ),!,
	append( CList,Issues,L ),
	makeIssue2( Terms,VList,GList,L,IList ).
makeIssue2( [_|Terms],VList,GList,CList,IList ):-
	makeIssue2( Terms,VList,GList,CList,IList ).

hasnot2( (G1,G2),VList,Rid,C,Issue ):- !,
	hasnot( G1,VList,Rid,C,L ),
	hasnot( G2,VList,Rid,L,Issue ).
hasnot2( ( not ( _ > _ ) ),_,_,Issue,Issue ).
hasnot2( ( not ( _ < _ ) ),_,_,Issue,Issue ).
hasnot2( (not G),VList,Rid,C,Issue ):- !,
	append(C,[(Rid::G,VList,hasnot)],Issue ).
hasnot2( _,_,_,C,C ).
