%%     findAllArg.pl   Rbrs 1.0 
%%     Copyright (C) Katsumi Nitta   (nitta@dis.titech.ac.jp)
%%                   Taketomo Katoh  (tkatoh@ntt.dis.titech.ac.jp)

%=============================================================%
%       $BM?$($i$l$?%4!<%k$KBP$9$kO@>Z!$H?O@!$M%@h4X78$N(B        %
%       $B?dO@Ey!$2r$NA42rC5:w$r9T$&=R8l(B findAllArg             %
%=============================================================%


findAllArg( Goal ):- !,
	lastArgID( Start ),
	makeArg( Goal ),
	lastArgID( N ),
	Start \== N,!,
	makeGoalList( Start,N,[],RGList ),
	myArg( A,B ),
	retract( myArg( A,B ) ),
	assert( myArg( Start,N  ) ),
	findAllCounter( Start,N,RGList,RGList2 ),
	lastArgID( N2 ),
	makeUserGList,
	findAllPArg( N2 ),
	lastArgID( N3 ),
	makeGoalList( N2,N3,RGList2,RGList3 ),
	compareAllPArg( N2,RGList3,RGList4 ),
	assert( goalList( RGList4 ) ),
	exist_parg,
	listing( arg ).
findAllArg( _ ).

exist_parg :-
	findall( ID,arg( ID,_,_,_ ),[null] ),!.
exist_parg :-
	retract( arg( null,null,null,null ) ).

reverseUser( my,other ).
reverseUser( other,my ).


makeGoalList( N,N,CGList,CGList ).
makeGoalList( Start,End,CGList,RGList ):-
	arg( Start,(Arg,VList) ),!,
	getGoal( Arg,VList,CGList,CGList2 ),
	Next is Start + 1,
	makeGoalList( Next,End,CGList2,RGList ).
makeGoalList( Start,End,CGList,RGList ):-
	arg( Start,_,Arg,VList ),!,
	getGoal( Arg,VList,CGList,CGList2 ),
	Next is Start + 1,
	makeGoalList( Next,End,CGList2,RGList ).

getGoal( [],_,CGList,CGList ).
getGoal( [(_:: G <- _)|Terms],VList,CGList,RGList ):-
	existGoal( G,VList,CGList ),!,
	getGoal( Terms,VList,CGList,RGList ).
getGoal( [(_:: G <- _)|Terms],VList,CGList,RGList ):-!,
	append( CGList,[(G,VList)],CGList2 ),
	getGoal( Terms,VList,CGList2,RGList ).
getGoal( [(_:: G )|Terms],VList,CGList,RGList ):-!,
	append( CGList,[(G,VList)],CGList2 ),
	getGoal( Terms,VList,CGList2,RGList ).

existGoal( _,_,[] ):- fail.
existGoal( G,VList,[ (Goal1,VList1)|_ ] ):-
	unifyVerb( G,Goal1,_,VList,_,VList1,_ ),!.
existGoal( G,VList,[ _|Other ] ):-
	existGoal( G,VList,Other ).

findAllCounter( End,End,CGList,RGList ):-
	checkmoreCounter( End,CGList,RGList ).
findAllCounter( Start,End,CGList,RGList ):-
	findIssue( Start,CGList ),
	makeCounterArg( Start ),
	Next is Start +1,
	findAllCounter( Next,End,CGList,RGList ).

checkmoreCounter( End,CGList,CGList ):-
	lastArgID( N ),
	N = End,!.
checkmoreCounter( End,CGList,RGList ):-
	lastArgID( N ),
	makeGoalList( End,N,CGList,CGList2 ),
	findAllCounter( End,N,CGList2,RGList ).

checkGoal( [],_ ).
checkGoal( [Goal1|Other],GList ):-
	checkGoal2( Goal1,GList ),
	checkGoal( Other,GList ).

checkGoal2( _,[] ).
checkGoal2( ( _::Goal1 ,VList1,hasnot),[ (Goal2,VList2)|_ ] ):-
	unifyVerb( Goal1,Goal2,_,VList1,_,VList2,_ ),!,
	fail.
checkGoal2( ( _::Goal1 ,VList1),[ (Goal2,VList2)|_ ] ):-
	unifyVerb( Goal1,Goal2,_,VList1,_,VList2,_ ),!,
	fail.
checkGoal2( Issue,[_|Other] ):-
	checkGoal2( Issue,Other ).

findAllPArg( Start ):-
	counter(_,_),!,
	findall( (Arg1,Arg2),counter( Arg1,Arg2 ),CounterList ),
	pre_CounterList( PCList ),
	retract( pre_CounterList( PCList ) ),
	selectList( CounterList,PCList,ResList ),
	findAllPArg2(Start,ResList ),
	assert( pre_CounterList( CounterList ) ).
findAllPArg( _ ).

findAllPArg2( _,[] ).
findAllPArg2( Start,[ ( Arg1,Arg2 )|CounterList ]):-
	is_gattack( Arg1,Arg2 ),!,
	write( Arg1 ),write( ' g-attack ' ),write( Arg2 ),nl,
	assert( g_attack( Arg1,Arg2 ) ),
	findAllPArg2( Start,CounterList ).
findAllPArg2( _,[ (Arg1,Arg2)|CounterList ] ):-
	compareArg(Arg1,Arg2),
	lastArgID( Next ),
	findAllPArg2( Next,CounterList ).

is_gattack( ArgID1,ArgID2 ):-
	arg( ArgID1,( Arg1,VList1 ) ),
	arg( ArgID2,( [(_::Head2<-Body2)|_],VList2 ) ),
	findG_attack( Arg1,Head2,Body2,VList1,VList2 ),!.

findG_attack( [],_,_,_,_ ).
findG_attack([(_::Head1<- Body1)|_],Head2,Body2,VList1,VList2):-
	getnot( Body1,[],NotList1 ),
	findnot( NotList1,Head2,VList1,VList2 ),
	getnot( Body2,[],NotList2 ),
	findnot( NotList2,Head1,VList2,VList1 ),!,
	fail.
findG_attack( [ _|Other ],Head2,Body2,VList1,VList2 ):-
	findG_attack( Other,Head2,Body2,VList1,VList2 ).

getnot( (Term1,Term2),CList,NotList ):-
	getnot( Term1,CList,TempList ),
	getnot( Term2,TempList,NotList ).
getnot( (- _),CList,CList ):-!.
getnot( (not Term),CList,NotList ):-!,
	append( CList,[( not Term )],NotList ).
getnot( (not ( -Term)),CList,NotList ):-!,
	append( CList,[( not (- Term) )],NotList ).
getnot( _,CList,CList ).

findnot( [],_,_,_ ):- fail.
findnot( [( not Term1 )|_],Head2,VList1,VList2 ):-
	unify( Term1,Head2,_,VList1,_,VList2,_ ),!.
findnot( [_|Other],Head2,VList1,VList2 ):-
	findnot( Other,Head2,VList1,VList2 ).

compareAllPArg( Start,GList,RGList ):-
	lastArgID( End ),
	findall( (PArg1,PArg2),pcounter(PArg1,PArg2),PCounterList ),
	pre_PCounterList( PList ),
	selectList( PCounterList,PList,PCounterList2 ),
	isnot_null_list( PCounterList2 ),!,
	makePArgCounter( Start,End,GList,_ ),
	retract( pre_PCounterList( PList ) ),
	assert( pre_PCounterList( PCounterList ) ),
	lastArgID( N1 ),
	compareAllPArg2( PCounterList2 ),
	lastArgID( N2 ),
	makeGoalList( N1,N2,GList,GList2 ),
	compareAllPArg( N1,GList2,RGList ).
compareAllPArg( Start,GList,RGList ):-!,
	lastArgID( End ),
	makePArgCounter( Start,End,GList,RGList ).

makePArgCounter( N,N,RGList,RGList ):-!.
makePArgCounter( Start,End,CGList,RGList ):-
	Start \== End ,!,
	findAllCounter2( Start,End,CGList,RGList ),
	findAllPArg( Start ).

findAllCounter2( End,End,CGList,RGList ):-
	checkmoreCounter( End,CGList,RGList ).
findAllCounter2( Start,End,CGList,RGList ):-
	findIssue2( Start,CGList ),
	makeCounterArg( Start ),
	Next is Start +1,
	findAllCounter2( Next,End,CGList,RGList ).

compareAllPArg2( [] ).
compareAllPArg2( [( PArgID1,PArgID2 )|OtherList ] ):-
	comparePArg( PArgID1,PArgID2 ),
	compareAllPArg2( OtherList ).

makeUserGList :-
	myArg( Start,End ),
	makeUserGList2( Start,End,[],MyList,[],OtherList,
	        [],MyArgIDList,[],OtherArgIDList ),
	assert( myGoalList( MyList ) ),
	assert( otherGoalList( OtherList ) ),
	assert( argIDList( my,MyArgIDList ) ),
	assert( argIDList( other,OtherArgIDList ) ).

makeUserGList2( N,N,CMList,CMList,RMList,RMList,CML,CML,COL,COL ).
makeUserGList2( Start,End,CMList,
	         [ TempCMList|RMList],COList,ROList,CML,RML,COL,ROL ):-
	makeUserGList3(Start,[],TempCMList,COList,COList2,CML,CML2,COL,COL2),
	N is Start +1,
	makeUserGList2(N,End,CMList,RMList,COList2,ROList,CML2,RML,COL2,ROL).

makeUserGList3( Start,CMList,RMList,COList,ROList,CML,RML,COL,ROL ):-
	arg( Start,( ArgList,VList ) ),
	append( CML,[Start],CML2 ),
	getGList( ArgList,VList,Start,[],TempCMList,CMList ),
	append( CMList,TempCMList,CMList2 ),
	findall( ArgID,counter( Start,ArgID ),ArgIDList ),
	makeCounterGList( ArgIDList,CMList2
			,RMList,COList,ROList,CML2,RML,COL,ROL ).

getGList( [],_,_,CList,CList,_ ).
getGList( [ (_::Head <- Body )|Other ],VList,Start,CList,RList,CMList ):-
	exist_in_GList2( Start,Head,VList,CList,CList2,CMList ),
	getnot2( Start,Body,VList,CList2,CList3,CMList ),
	getGList( Other,VList,Start,CList3,RList,CMList ).

exist_in_GList2( Start,Head,VList,CList,[( Start,Head,VList)|CList],[] ).
exist_in_GList2( _,Head,VList,CList,CList,[ ( _,Term,VList2 )|_ ] ):-
	unify( Head,Term,_,VList,_,VList2,_ ).
exist_in_GList2( Start,Head,VList,CList,RList,[ _|Other ] ):-
	exist_in_GList2( Start,Head,VList,CList,RList,Other ).

getnot2( N,(Term1,Term2),VList,CList,NotList,CMList ):-
	getnot2( N,Term1,VList,CList,TempList,CMList ),
	getnot2( N,Term2,VList,TempList,NotList,CMList ).
getnot2( _,(- _),_,CList,CList,_ ):-!.
getnot2( N,(not ( -Term)),VList,CList,NotList,CMList ):-!,
	exist_in_GList2( N,(not (- Term)),VList,CList,NotList,CMList ).
getnot2( N,(not Term),VList,CList,NotList,CMList ):-!,
	exist_in_GList2( N,(not Term),VList,CList,NotList,CMList ).
getnot2( _,_,_,CList,CList,_ ).

makeCounterGList( [],CMList,CMList,RMList,RMList,CML,CML,RML,RML ).
makeCounterGList([ ID1|Other ],CMList,RMList,COList,ROList,CML,RML,COL,ROL):-
	makeUserGList3( ID1,COList,COList2,CMList,CMList2,COL,COL2,CML,CML2 ),
	makeCounterGList(Other,CMList2,RMList,COList2,ROList,CML2,RML,COL2,ROL).

