%%     compareRule.pl   Rbrs 1.0 
%%     Copyright (C) Katsumi Nitta   (nitta@dis.titech.ac.jp)
%%                   Taketomo Katoh  (tkatoh@ntt.dis.titech.ac.jp)
%--------------------------------------------------------%
%            $BO@>ZF1;N$NHf3S$r9T$&(B compareArg             %
%--------------------------------------------------------%


compareArg( ArgID1,ArgID2 ):-
	findall( ( Res1,RList2,RVList1 ),cRule( ArgID1,ArgID2,Res1,RList2,RVList1 ),R1List ),
	findall( ( Res2,RList3,RVList2 ),cRule( ArgID2,ArgID1,Res2,RList3,RVList2 ),R2List ),
	lastArgID( N ),
	retract( lastArgID(N) ),
	assertPArg( N,End,ArgID1,R1List,ArgID2,R2List ),
	assert( lastArgID( End ) ).


cRule( ArgID1,ArgID2, > ,RList,RVList ):-
	findRuleID( ArgID1,ArgID2,Rule1,Rule2,VList1,VList2 ),
	pclause( PID,(dummy(N1)=Rule3 > dummy(N2)=Rule4),nil,BVList ),
	unify( Rule1,Rule3,NewRule1,VList1,_,BVList,Temp ),
	unify( Rule2,Rule4,NewRule2,VList2,RVList,Temp,_ ),
	append( [],[(PID::(dummy(N1)=NewRule1 > dummy(N2)=NewRule2) )],RList ).
cRule( ArgID1,ArgID2, > ,RList,RVList ):-
	findRuleID( ArgID1,ArgID2,Rule1,Rule2,VList1,VList2 ),
	pclause( PID,(dummy(N1)=Rule3 < dummy(N2)=Rule4),nil,BVList ),
	unify( Rule1,Rule4,NewRule1,VList1,_,BVList,Temp ),
	unify( Rule2,Rule3,NewRule2,VList2,RVList,Temp,_ ),
	append( [],[( PID::(dummy(N1)=NewRule1 < dummy(N2)=NewRule2))],RList ).
cRule( ArgID1,ArgID2, > ,RList,RVList ):-
	findRuleID( ArgID1,ArgID2,Rule1,Rule2,VList1,VList2 ),
	whichPrior( ArgID1,ArgID2,Which ),
	pclause( PID,(dummy(N1)=Rule3 > dummy(N2)=Rule4),Body,BVList ),
	unify( Rule1,Rule3,NewRule1,VList1,NVList1,BVList,Temp ),
	append( Temp,NVList1,Temp2 ),
	unify( Rule2,Rule4,NewRule2,VList2,_,Temp2,CVList ),
	demo2( Body,NewBody,[],CList1,CVList,RVList,Which ),
	append( [(PID::(dummy(N1)=NewRule1 > dummy(N2)=NewRule2) <- NewBody)],CList1,RList ).
cRule( ArgID1,ArgID2, > ,RList,RVList ):-
	findRuleID( ArgID1,ArgID2,Rule1,Rule2,VList1,VList2 ),
	whichPrior( ArgID1,ArgID2,Which ),
	pclause( PID,(dummy(N1)=Rule3 < dummy(N2)=Rule4),Body,BVList ),
	unify( Rule1,Rule4,NewRule1,VList1,NVList,BVList,Temp ),
	append( Temp,NVList,Temp2 ),
	unify( Rule2,Rule3,NewRule2,VList2,_,Temp2,CVList ),
	demo2( Body,NewBody,[],CList1,CVList,RVList,Which ),
	append( [( PID::(dummy(N1)=NewRule1 < dummy(N2)=NewRule2)<- NewBody)],CList1,RList ).

whichPrior( ID1,ID2,my ):-
	argIDList( my,IDList1 ),
	member( ID1,IDList1 ),
	argIDList( other,IDList2 ),
	member( ID2,IDList2 ),!.
whichPrior( ID1,ID2,other ):-
	argIDList( my,IDList1 ),
	member( ID2,IDList1 ),
	argIDList( other,IDList2 ),
	member( ID1,IDList2 ),!.

demo2( (A,B),(H1,H2),CL,RL,CGL,RGL,Which ):-!,
	demo2( A,H1,CL,Temp2,CGL,CGL2,Which ),
	demo2( B,H2,Temp2,RL,CGL2,RGL,Which ).
demo2( (not A),(not A),CL,CL,CGL,CGL,_ ):-!.
demo2( (A>>B),(A>>B),CL,CL,CGL,CGL,Which ):-
	identifyList( Which,IList ),
	checkIdentify( A,B,IList,NewIList ),!,
	retract( identifyList( Which,IList ) ),
	assert( identifyList( Which,NewIList ) ).
demo2( (A<<B),(A<<B),CL,CL,CGL,CGL,Which ):-
	identifyList( Which,IList ),
	checkIdentify( B,A,IList,NewIList ),!,
	retract( identifyList( Which,IList ) ),
	assert( identifyList( Which,NewIList ) ).
demo2( A,Z,CL,RL,CGL,RGL,_ ):-
	clause( RID,Goal,nil,VList ),
	unifyVerb( A,Goal,Z,CGL,RGL1,VList,RHL ),
	append( CL,[ (RID::Z) ],RL ),
	append( RGL1,RHL,RGL2 ),
	findsameVar( RGL2,RGL2,RGL ).
demo2( A,Z,CL,RL,CGL,RGL2,Which ):-
	clause( RID,Goal,Head,VList ),
	unifyVerb( A,Goal,Z,CGL,RGL1,VList,RHL ),
	append( RGL1,RHL,RHL2 ),
	demo2( Head,NewHead,[],RL1,RHL2,RGL,Which ),
	append( [ (RID::Z <- NewHead) ],RL1,RL2 ),
	append( CL,RL2,RL ),
	findsameVar( RGL,RGL,RGL2 ).

checkIdentify( A,B,[],[A>>B] ).
checkIdentify( A,B,[ (A<<B)|Other ],[ (A<<B)|Other ] ):-!,fail.
checkIdentify( A,B,[ (B>>A)|Other ],[ (B>>A)|Other ] ):-!,fail.
checkIdentify( A,B,[ (A>>B)|Other ],[ (A>>B)|Other ] ):-!.
checkIdentify( A,B,[ (B<<A)|Other ],[ (B<<A)|Other ] ):-!.
checkIdentify( A,B,[Term|Other],[Term|NewIList] ):-
	checkIdentify( A,B,Other,NewIList ).

findRuleID( ArgID1,ArgID2,Rule1,Rule2,VList1,VList2 ):-
	counter( ArgID1,ArgID2 ),
	arg( ArgID1,( Arg1,VList1 ) ),
	arg( ArgID2,( [( Rule2::Head2 <- _)|_],VList2 ) ),
	reverse2( Head2,NewHead2 ),
	findRuleID2( Arg1,Rule1,NewHead2,VList1,VList2 ).
findRuleID( ArgID1,ArgID2,Rule2,Rule1,VList1,VList2 ):-
	counter( ArgID2,ArgID1 ),
	arg( ArgID2,( Arg1,VList1 ) ),
	arg( ArgID1,( [( Rule2::Head2 <- _)|_],VList2 ) ),
	reverse2( Head2,NewHead2 ),
	findRuleID2( Arg1,Rule1,NewHead2,VList1,VList2 ).

findRuleID2( [( RID1::Head1 <- _ )|_],RuleID1,Head2,VList1,VList2 ):-
	unify( Head1,Head2,_,VList1,_,VList2,_),!,
	RuleID1 = RID1.
findRuleID2( [_|Other],RuleID1,Head2,VList1,VList2 ):-
	findRuleID2( Other,RuleID1,Head2,VList1,VList2 ).

reverse2( -( Head ),Head ):-!.
reverse2( Head,-(Head) ):-!.

removedummy( [],_,CList,CList ).
removedummy( [( RID::Head<-Body )|Other],VList,CList,RList ):-
	changedummy( RID,RID2,VList ),
	changedummy( Head,Head2,VList ),
	changedummy( Body,Body2,VList ),
	append( CList,[(RID2::Head2<-Body2)],CList2 ),
	removedummy( Other,VList,CList2,RList ).
removedummy( [( RID::Head )|Other],VList,CList,RList ):-
	changedummy( RID,RID2,VList ),
	changedummy( Head,Head2,VList ),
	append( CList,[(RID2::Head2)],CList2 ),
	removedummy( Other,VList,CList2,RList ).

changedummy( A,NewA,VList ):-
	var( A ),
	getValue( A,NewA,VList ).
changedummy( (A,B),(A1,B1),VList ):-
	changedummy( A,A1,VList ),
	changedummy( B,B1,VList ).
changedummy( (- A),(- NewA),VList ):-
	changedummy( A,NewA,VList ).
changedummy( (not A),(not NewA),VList ):-
	changedummy( A,NewA,VList ).
changedummy( A,NewA,VList ):-
	A =.. [T|Values],
	changedummy2( Values,Temp,VList ),
	NewA =.. [T|Temp].

getValue( A,'Top',VList):-
	memberVar( (A/'Top'),VList ),!.
getValue( A,NewTerm,VList):-
	memberVar( (A/Term),VList ),!,
	changedummy( Term,NewTerm,VList ).
getValue( A,NewA,VList):-
	memberVar( (A=Temp),VList ),!,
	getValue( Temp,NewA,VList ).
getValue( A,A,_).
	

changedummy2( [],[],_ ).
changedummy2( [(inst(_)=Psi)|Other],[NewPsi|NewOther],VList ):-
	changedummy( Psi,NewPsi,VList ),
	changedummy2( Other,NewOther,VList ).
changedummy2( [(dummy(_)=Psi)|Other],[NewPsi|NewOther],VList ):-
	changedummy( Psi,NewPsi,VList ),
	changedummy2( Other,NewOther,VList ).
changedummy2( [(Tag=Psi)|Other],[(Tag=NewPsi)|NewOther],VList ):-
	changedummy( Psi,NewPsi,VList ),
	changedummy2( Other,NewOther,VList ).
changedummy2( [Tag1|Other],[Tag1|NewOther],VList ):-
	changedummy2( Other,NewOther,VList ).

assertPArg( N,N,_,[],_,[] ).
assertPArg( N,Next,ArgID1,ArgList1,ArgID2,[] ):-
	assertPArg2( N,Next,ArgID1,ArgList1,ArgID2,[] ).
assertPArg( N,Next,ArgID1,[],ArgID2,ArgList2 ):-
	assertPArg4( ArgList2,ArgID2,ArgID1,N,Next ).
assertPArg( N,Next,ArgID1,ArgList1,ArgID2,ArgList2 ):-
	assertPArg2(N,Next,ArgID1,ArgList1,ArgID2,ArgList2 ).

assertPArg2( N,N,_,[],_,_  ).
assertPArg2( N,Next,ArgID1,[Arg1|ArgList1],ArgID2,ArgList2 ):-
	N2 is N + 1,
	assertPArg3( N,N2,N3,ArgID1,Arg1,ArgID2,ArgList2 ),
	assertPArg2( N3,Next,ArgID1,ArgList1,ArgID2,ArgList2 ).


assertPArg3( N,End,End,ArgID1,( >,Arg1,VList ),ArgID2,[] ):-
	assert( arg( N,( ArgID1 > ArgID2 ),Arg1,VList ) ),
	whichPrior( ArgID1,ArgID2,Which ),
	argIDList( Which,IDL ),
	append( IDL,[N],IDL2 ),
	retract( argIDList( Which,IDL ) ),
	assert( argIDList( Which,IDL2 ) ).
assertPArg3( N,Start,End,ArgID1,Arg1,ArgID2,[ ( >,Arg2,VList )|ArgList2] ):-
	assert( arg(Start,(ArgID2>ArgID1),Arg2,VList ) ),
	whichPrior( ArgID2,ArgID1,Which ),
	argIDList( Which,IDL ),
	append( IDL,[Start],IDL2 ),
	retract( argIDList( Which,IDL ) ),
	assert( argIDList( Which,IDL2 ) ),
	Next is Start + 1,
	assert( pcounter( N,Start ) ),
	assertPArg3( N,Next,End,ArgID1,Arg1,ArgID2,ArgList2 ).

assertPArg4( [],_,_,Start,Start ).
assertPArg4([( >,Arg,VList)|Other],ArgID1,ArgID2,Start,Next ):-
	assert( arg( Start,(ArgID1 > ArgID2),Arg,VList ) ),
	whichPrior( ArgID1,ArgID2,Which ),
	argIDList( Which,IDL ),
	append( IDL,[Start],IDL2 ),
	retract( argIDList( Which,IDL ) ),
	assert( argIDList( Which,IDL2 ) ),
	N is Start+1,
	assertPArg4( Other,ArgID1,ArgID2,N,Next ).
assertPArg4( [ ( <,Arg,VList )|Other ],ArgID1,ArgID2,Start,Next ):-
	assert( arg( Start,(ArgID1 > ArgID2),Arg,VList ) ),
	whichPrior( ArgID1,ArgID2,Which ),
	argIDList( Which,IDL ),
	append( IDL,[Start],IDL2 ),
	retract( argIDList( Which,IDL ) ),
	assert( argIDList( Which,IDL2 ) ),
	N is Start+1,
	assertPArg4( Other,N,ArgID1,ArgID2,Next ).

writePArg( [( <>,_,_ )],[( <>,_,_ )],Arg1,Arg2 ):-
	write( 'No Priority between arg' ),
	write( Arg1 ),write( ' and arg' ),write( Arg2 ),nl.
writePArg( [( >,PArg1,PVList1 )],[( <>,_,_ )],Arg1,Arg2 ):-
	removedummy( PArg1,PVList1,[],RPArg1 ),
	write( 'arg' ),write( Arg1 ),write( ' > arg' ),write( Arg2 ),
	write( ' because ' ),nl,write( '[ ' ),
	writeArg2( RPArg1 ),write( ' ] ' ),nl.
writePArg( [( <>,_,_ )],[( >,PArg2,PVList2 )],Arg1,Arg2 ):-
	removedummy( PArg2,PVList2,[],RPArg2 ),
	write( 'arg' ),write( Arg2 ),write( ' > arg' ),write( Arg1 ),
	write( ' because ' ),nl,write( '[ ' ),
	writeArg2( RPArg2 ),write( ' ] ' ),nl.
writePArg( [( >,PArg1,PVList1 )],[( >,PArg2,PVList2  )],Arg1,Arg2 ):-
	removedummy( PArg1,PVList1,[],RPArg1 ),
	removedummy( PArg2,PVList2,[],RPArg2 ),
	write( 'We can not get priority between arg' ),
	write( Arg1 ),write( ' and arg' ),write( Arg2 ),nl,
	write( ' because both arg have ' ),nl,write( '[ ' ),
	writeArg2( RPArg1 ),write( ' ] ' ),nl,write( 'and' ),nl,write( '[ ' ),
	writeArg2( RPArg2 ),write( ' ] ' ),nl.


