%%     cbr.pl   Rbrs 1.0 
%%     Copyright (C) Katsumi Nitta   (nitta@dis.titech.ac.jp)
%%                   Taketomo Katoh  (tkatoh@ntt.dis.titech.ac.jp)
%-------------------  makeCase  ---------------------%
%    r1 :: p <- q,r ̃VXe̍\̃[     %
%    case( r1,p,(q,r),ϐXg ) ̌`          %
%    ϊvO                              %
%----------------------------------------------------%

makeCase( File1 ):-
	see( File1 ),
	read( X ),
	mkcas( X ),
	seen.


mkcas( end_of_file ). 
mkcas( X ):-
	changeVarCas( X ),
	read(Y),!,
	mkcas( Y ).

% ЂƂ̃[ɑ΂āA getVList ɓnA
% ϐXg𓾂āAassert ֐ changeVarCas

changeVarCas( ( RID :: Goal <== Body ) ):-!,
	changeRID( RID,NewRID,CList1 ),
	getVList( (Goal <- Body),CList1,RList1,Sentence),
	Sentence =.. Temp,
	nth0( 1,Temp,Goal2 ),
	nth0( 2,Temp,Body2 ),
	findsameVar( RList1,RList1,RList2 ),
	assert( case( NewRID,Goal2,Body2,RList2 ) ).


changeVarCas( ( RID :: Goal <= ) ):-!,
	changeRID( RID,NewRID,CList1 ),
	getVList( (Goal <- true(dummy)),CList1,RList1,Sentence),
	Sentence =.. Temp,
	nth0( 1,Temp,Goal2 ),
	nth0( 2,Temp,Body2 ),
	findsameVar( RList1,RList1,RList2 ),
	assert( case( NewRID,Goal2,Body2,RList2 ) ).

changeVarCas( _ ).





%--------------------------------
makeCBRlower( File1 ):-
	see( File1 ),
	read( X ),
	mkCBRlower( X ),
        mkCBRlower2,
	seen.

mkCBRlower( (X < Y on V) ):- !,
	assert( lowerCBR( Y,X,V,1 ) ),
	read( Z ),
	mkCBRlower( Z ).
mkCBRlower( (X < Y) ):- !,
	assert( lowerCBR( Y,X,'Top',1 ) ),
	read( Z ),
	mkCBRlower( Z ).
mkCBRlower( _ ).

mkCBRlower2:- assert(cbrDicSw(off)), mkCBRlower3, 
              retract(cbrDicSw(X)),
              (X=on -> mkCBRlower2; true).

mkCBRlower3 :-
	lowerCBR( X,Y,V1,N1 ),
	lowerCBR( Y,Z,V2,N2 ),
        (V1=V2 -> V1=V0; 
         (lower(V1,V0,_), lower(V2,V0,_)) -> true),
	N is N1+N2,
	(lowerCBR(X,Z,V0,N)->true; 
                             (assert( lowerCBR( X,Z,V0,N ) ), 
                              retract(cbrDicSw(_)),
                              assert(cbrDicSw(on)))),
        fail.
mkCBRlower3.




%---------------

cbr(G,View, Th, Score, Arg) :- case(Id, Head, Body, Bind),
                 cbrUnify(View, G,Head,Bind,Bind2),
                 cbrVerify(View, Body, Bind2, NewBind, Tree, Score),
                 Score > Th, !,
%                 showArg2(NewBind,D), 
%                 replaceCbrArg(Head,D,NewHead),
%                 replaceCbrArg(Body,D,NewBody),
%                 replaceCbrArg(Id,D,NewId),
                 replaceCbrArg(Head,NewBind,NewHead),
                 replaceCbrArg(Body,NewBind,NewBody),
                 replaceCbrArg(Id,NewBind,NewId),
                 Arg= arg(NewId, NewHead, NewBody, Tree).

%   replaceCbrArg((B,C),D,(B4,C4)) :- !,B=.. B2, deref(B2,D,B3),
%                                  B4=.. B3, replaceCbrArg(C,D,C4).
%   replaceCbrArg(A,D,A4) :- A=..A2, deref(A2,D,A3), A4=.. A3.

   replaceCbrArg((B,C),D,(B4,C4)) :- !,B=.. B2, repCbrArg2(B2,D,B3), B4=.. B3,
                                       replaceCbrArg(C,D,C4).
   replaceCbrArg(B,D,B4) :- !,B=.. B2, repCbrArg2(B2,D,B3), B4=.. B3.

    repCbrArg2([],_,[]) :- !.
    repCbrArg2([A|B],D,[A2|B2]) :- !, repCbrArg3(A,D,A2),repCbrArg2(B,D,B2).

    repCbrArg3(A=B,D,A=C) :- !, repCbrArg4(B,D,C).
    repCbrArg3(B,D,C) :- !, repCbrArg4(B,D,C).

    repCbrArg4(B,[],C) :- !, B=C.
    repCbrArg4(B,[B/B2 |_],C) :- !, C=B2.
    repCbrArg4(B,[_|D2],C) :- !, repCbrArg4(B,D2,C).

cbrUnify(View,G,Head,Bind,NewBind) :- 
                 G=..[P|Args1], Head=..[P|Args2],
                 fillBind(Bind),
                 cbrMatch(View,Args1,Args2, Bind, NewBind).

 fillBind([]) :- !.
 fillBind([A|B]) :- !, A=X/X, fillBind(B).

 cbrMatch(_,[],_, Bind, Bind) :- !.
 cbrMatch(View,[Label=Value|Args1],Args2, Bind, NewBind) :-
                 cbrMatch2(View,Label=Value, Args2, Bind, Bind2),!,
                 cbrMatch(View,Args1,Args2, Bind2, NewBind).

 cbrMatch2(View,Label=Value,[Label=Value2 |_], Bind, Bind2) :- !,
                 cbrMatch3(View,Value,Value2, Bind, Bind2).
 cbrMatch2(View,Label=Value,[_ |Args2], Bind, Bind2) :- 
                 cbrMatch2(View,Label=Value,Args2, Bind, Bind2).

 cbrMatch3(View,Value,Value2, Bind, Bind2) :-
                 member0(Value2, Bind, V),
                 getLUB(View,V,Value,LUB), LUB \== 'Top', !, 
                 cbrReplace(Bind, Value2/V, Value2/Value, Bind2).
 cbrReplace([Value/V|Bind], Value/V, Value/V2, [Value/V2|Bind]) :- !.
 cbrReplace([B0|Bind], Value/V, Value/V2, [B0|Bind3]) :- 
                 cbrReplace(Bind, Value/V, Value/V2, Bind3).

cbrVerify(View,Bodys, Bind2, NewBind, Tree, Score) :- 
           cbrVerify2(View,Bodys, Bind2, NewBind, [],Tree,0,0,Score1,Score2),
           Score is Score1*100//Score2.
  cbrVerify2(View,(Body,Bodys),Bind,NBind, OldT,  NewT, S1,S2,NS1,NS2) :- 
                 Body=..[P1|Args1], 
                 case(ID, Fact,true(dummy(1)=dummy),[]),
%                 clause(ID, Fact,not Fact2,[]),
                 Fact=..[P2|Args2], getLUB(View,P1,P2,LUB), LUB\=='Top',!,
                 S22 is S2+1,
                 cbrBodyMatch(View,Args1,Args2, [P1/P2|Bind], Bind2, Result),
                 (Result=ok -> S11 is S1+1; S11 is S1),
                 (Result=ok -> NewT2=[ID|OldT]; NewT2=OldT),
                 cbrVerify2(View,Bodys, Bind2, NBind, NewT2, NewT,
                             S11,S22, NS1,NS2).
  cbrVerify2(View,(_,Bodys),Bind,NBind, OldT,  NewT, S1,S2,NS1,NS2) :- 
                 S22 is S2+1,
                 cbrVerify2(View,Bodys, Bind, NBind, OldT, NewT,
                             S1,S22, NS1,NS2).
  cbrVerify2(View,Body, Bind, NBind, OldT,  NewT,S1,S2,NS1,NS2) :- 
                 Body=..[P1|Args1], 
                 case(ID, Fact,true(dummy(1)=dummy),[]),
%                 clause(ID, Fact, not Fact2,[]),
                 Fact=..[P2|Args2], getLUB(View,P1,P2,LUB), LUB\=='Top',!,
                 NS2 is S2+1,
                 cbrBodyMatch(View,Args1,Args2, [P1/P2|Bind], NBind,Result),
                 (Result=ok -> NS1 is S1+1; NS1 is S1),
                 (Result=ok -> NewT=[ID|OldT]; NewT=OldT).
  cbrVerify2(_,_, Bind, Bind, OldT,  OldT,S1,S2,S1,NS2) :- 
                 NS2 is S2+1.

  cbrBodyMatch(_,[],_, Bind, Bind, ok) :- !.
  cbrBodyMatch(View,[Label=Value|Args1],Args2, Bind, NewBind,Result) :-
                 cbrBodyMatch2(View,Label=Value, Args2, Bind, Bind2),!,
                 cbrBodyMatch(View,Args1,Args2, Bind2, NewBind,Result).
  cbrBodyMatch(_,_,_, Bind, Bind,no) :- !.

  cbrBodyMatch2(View,Label=Value,[Label=Value2 |_], Bind, Bind2) :- !,
                 cbrBodyMatch3(View,Value,Value2, Bind, Bind2).
  cbrBodyMatch2(View,Label=Value,[_ |Args2], Bind, Bind2) :- 
                 cbrBodyMatch2(View,Label=Value,Args2, Bind, Bind2).
  cbrBodyMatch3(View,Value,Value2, Bind, Bind2) :-
                 member0(Value, Bind, V),
                 getLUB(View,V,Value2,LUB), LUB \== 'Top', !, 
                 cbrBodyReplace(Bind, Value/V, Value/Value2, Bind2).
  cbrBodyReplace([Value/V|Bind], Value/V, Value/V2, [Value/V2|Bind]) :- !.
  cbrBodyReplace([B0|Bind], Value/V, Value/V2, [B0|Bind2]) :- 
                 cbrBodyReplace(Bind, Value/V, Value/V2, Bind2).

                 

getLUB( _, Term,Term,Term ).
getLUB( View,Term1,Term2,Term1 ):-
	lowerCBR( Term1,Term2,View,_ ).
getLUB( View,Term1,Term2,Term2 ):-
	lowerCBR( Term2,Term1,View,_ ).
getLUB( View,Term1,Term2,Temp ):-
	lowerCBR( Temp,Term1,View,_ ),
	lowerCBR( Temp,Term2,View,_ ).
getLUB( _,Term1,Term2,Term1 ):-
	lowerCBR( Term1,Term2,'Top',_ ).
getLUB( _,Term1,Term2,Term2 ):-
	lowerCBR( Term2,Term1,'Top',_ ).
getLUB( _,Term1,Term2,Temp ):-
	lowerCBR( Temp,Term1,'Top',_ ),
	lowerCBR( Temp,Term2,'Top',_ ).
getLUB( _,_,_,'Top' ) :- !.      %%  ގ

