%  Shaky v2.0      Copyright (C) 1998, Ken Kaneiwa (kaneiwa@jaist.ac.jp) 
%  Shaky v1.0      Copyright (C) 1997, Masanori Ohmori (oomori@jaist.ac.jp) 
/* ѽҸ */
:- module(u,[]).

/* replace(L1,X,Y,L2) :- L1XY˴ΤL2 */
replace([],_,_,[]).
replace([E|L1],X,Y,[Y|L2]):-
	E==X,
	replace(L1,X,Y,L2).
replace([E1|L1],X,Y,[E2|L2]):-
	user:is_list(E1),
	replace(E1,X,Y,E2),
	replace(L1,X,Y,L2).
replace([E1|L1],X,Y,[E1|L2]):-
	replace(L1,X,Y,L2).

/* 
 assoc(+Key,+Alist,-Value) :- AlistKeyбͤValueǤ 
 argument˻Ȥ
*/
assoc(_,[],_):-!,fail.
assoc(Key,[[Key,Value]|Alist],Value).
assoc(Key,[X|Alist],Value):-
        assoc(Key,Alist,Value).

% assoc_wide(Key_list,Alist,Value_list) :- assocγĥ
assoc_wide([],_,[]).
assoc_wide([V|VL],SLb,[Sv|SL]):-
	assoc_wide1(V,SLb,Sv),
	assoc_wide(VL,SLb,SL).
assoc_wide1(_,[],_):- !,fail.
assoc_wide1(V,[X|SLb],Sv):-
	X=[W,Sv], W==V.
assoc_wide1(V,[X|SLb],Sv):-
	assoc_wide1(V,SLb,Sv).

/* delete1(L1,X,L2) :- L1XĤΤL2 */
delete1([],_,[]):-!.
delete1([X|Xs],X,Y):-delete1_s1(Xs,X,Y).
delete1([X|Xs],Z,[X|Y]):-delete1(Xs,Z,Y).
delete1_s1(Xs,_,Xs).

/* delete(+L1,+X,-L2) :- L1X򤹤٤ƽΤL2Ǥ */
delete([],_,[]):-!.
delete([X|L1],X,L2):-delete(L1,X,L2).
delete([Z|L1],X,[Z|L2]):-Z \== X,delete(L1,X,L2).

% sabun(X,Y,X-Y)
sabun([],_,[]):-!.
sabun([X1|X],Y,Z):-
	member(X1,Y),!,
	sabun(X,Y,Z).
sabun([X1|X],Y,[X1|Z]):-!,
	sabun(X,Y,Z).

% get_sl(Var_list,Sit_list,Sub_sit_list)
get_sl(Var_list,Sit_list,Sub_sit_list):-
	assoc_wide(Var_list,Sit_list,Sub_sit_list).

/* pred(Inrep, Pred):-
	फҸФ */
/*pred([_,[Pred|_]|_],Pred).*/
/*ɲ*/
pred([_,[[Pred,_]|_]|_],Pred).
/* args(Inrep, Args):-
	argumentफФ */
args([_,[_,Args|_]|_],Args).

/* capital(X) :- Xκǽ餬ʸʤ yes */
capital(X):-
	'A' @=< X,
	X @< 'a'.
/* append(LList,List) :- ꥹȤΥꥹȤĤʤ */
append([],[]).
append([E|LL],L1):-
	user:append(E,L2,L1),
	append(LL,L2).

/* sitp(+Sit):- SitϾǤ. */
sitp([X,Y]):-
	db:link(X,Y).
sitp([X,Y|Sit]):-
	db:link(X,Y),
	sit([Y|Sit]).

intersection([X|L],Res):-
	intersection([X|L],Res,X).
intersection([],R,R).
intersection([X|L],Res,Tmp):-
	intersection1(X,Tmp,Tmp1),
	intersection(L,Res,Tmp1).
intersection1([],_,[]).
intersection1([E|X],Tmp,[E|Tmp1]):-
	user:member(E,Tmp),
	intersection1(X,Tmp,Tmp1).
intersection1([_|X],Tmp,Tmp1):-
	intersection1(X,Tmp,Tmp1).

union(L,Res):-
	union(L,Res,[]).
union([],R,R).
union([X|L],Res,Tmp):-
	union1(X,Tmp,Tmp1),
	union(L,Res,Tmp1).
union1([],Tmp,Tmp).
union1([E|X],Tmp,[E|Tmp1]):-
	user:non_member(E,Tmp),
	union1(X,Tmp,Tmp1).
union1([E|X],Tmp,Tmp1):-
	union1(X,Tmp,Tmp1).

subset([],_).
subset([X|L1],L2):-
	user:member(X,L2),
	subset(L1,L2).

member(E0,[]):-!,fail.
member(E0,[E1|L]):-
	E0==E1.
member(E0,[E1|L]):-
	member(E0,L).

dual([Rel,Args,0],[Rel,Args,1]).
dual([Rel,Args,1],[Rel,Args,0]).

meet(S1,S2):-
	user:last(S1,L),
	user:nth(1,S2,F),
	db:link(L,F).
