%  Shaky v2.0      Copyright (C) 1998, Ken Kaneiwa (kaneiwa@jaist.ac.jp) 
%  Shaky v1.0      Copyright (C) 1997, Masanori Ohmori (oomori@jaist.ac.jp) 
/* Transfer Module */
:- module(tr,[]).

/* transfer(In,Ex)
	:- ɽInȳɽEx */
transfer(In,Ex):-
	var(In),atom(Ex),
	transfer_etoi(Ex,In).
transfer(In,Ex):-
	atom(In),var(Ex),
	transfer_itoe(In,Ex).

/* transfer_etoi(Ex,In)
    :- ɽ(String)ɽѴ */
transfer_etoi(X,error):-
	remove_ctl(X,[9,10,32],[]).
transfer_etoi(Ex,Inn):-
	remove_ctl(Ex,[9,10,32],String),
	morpheme_analysis(String, Res, ['%','#',:,-,=,<,>,'(',')',',','|','.','[',']']),!,
	parse0(Res, Inn).
/* transfer_etoi(Ex,In):-
	remove_ctl(Ex,[9,10,32],String),
	morpheme_analysis(String, Res, ['#',:,-,=,<,>,'(',')',',','|','.','[',']']),!,
	parse(Res, Inn),
	transfer_etoi1(Inn,In).*/

remove_cmt([],TMP,TMP).
remove_cmt([X|XX],TMP,RES):-
	X \== '%',
        user:append(TMP,[X],TMP2),
        remove_cmt(XX,TMP2,RES).
remove_cmt([X|XX],TMP,RES):-
	X == '%',
        remove_cmt0(XX,XX_RES),
        remove_cmt(XX_RES,TMP,RES).

remove_cmt0([X|XX],XX):-
	X == '%'.
remove_cmt0([X|XX],RES):-
	X \== '%',
	remove_cmt0(XX,RES).

parse0([R|RX],Inn):-
	R == '%',
        remove_cmt0(RX,RX2),
	parse(RX2, Inn).
parse0([R|RX],Inn):-
	R \== '%',
	parse([R|RX], Inn).

transfer_etoi1(error,error).
transfer_etoi1(Inn,In):-
	v_replace(Inn, In).
/* transfer_itoe(In,Ex)
    :- ɽɽѴ */
/* transfer_itoe(In,Ex):-
	v_replace(Inn,In),
	parse(X,Inn),
	transfer_itoe1(X,XX),
	u:append(XX,Ex).
*/
transfer_itoe(In,Ex):-
	parse(X,In),
	transfer_itoe1(X,XX),
	u:append(XX,Ex).

transfer_itoe1([],[]).	
transfer_itoe1([E|L],[S|R]):-
	name(E,S),
	transfer_itoe1(L,R).
/*
transfer_itoe([infon, Inf],Ex):-
	infon_itoe(Inf,Ex).
transfer_itoe([term, Term],Ex):-
	term_itoe(Term,Ex).
transfer_itoe([rule, Rule],Ex):-
	rule_itoe(Rule,Ex).

infon_itoe([Rel,Args,Pol],Ex):-
	pol_itoe(Pol,Pol_ex),
	atom_itoe(Rel,Rel_ex),
	args_itoe(Args, Args_ex),
	u:append([Pol_ex,[40],Args_ex,[41,46]],Ex).
pol_itoe(0,[45]).
pol_itoe(1,[]).
atom_itoe(Atom,Atom_ex):-
	atom(Atom),
	name(Atom,Atom_ex).

args_itoe([[Label,Val]],[Arg_ex]):-
	atom_itoe(Label,Label_ex),
	val_itoe(Val,Val_ex),
	u:append([Label_ex,[61],Val_ex],Arg_ex).
args_itoe([[Label,Val]|Args],[Arg_ex|Args_ex]):-
	atom_itoe(Label,Label_ex),
	val_itoe(Val,Val_ex),
	u:append([Label_ex,[61],Val_ex,[44]],Arg_ex),
	args_itoe(Args,Args_ex).
val_itoe(Inf,Val_ex):-
	infon_itoe(Inf,Val_ex).
val_itoe(Term,Val_ex):-
	term_itoe(Term,Val_ex).
val_itoe(Atom,Val_ex):-
	atom_itoe(Atom).
*/

/* String饳ȥ륳ɤ */
% usage : remove_ctl(Data, [10,46,32,9], New_data)
remove_ctl([],_,[]).
remove_ctl([A|X],Ctl,Y):-
	user:member(A,Ctl),
	remove_ctl(X,Ctl,Y).
remove_ctl([A|X],Ctl,[A|Y]):-
	remove_ctl(X,Ctl,Y).

/* ǲ
 usage : morpheme_analysis(String, Result, [:,-,=,<,'(',')',',',/])
*/
morpheme_analysis(Str,Result,Specials):-
	morpheme_analysis1(Str,Result,Specials,[]).
morpheme_analysis1([],[],_,_Tmp):-name('',_Tmp).
morpheme_analysis1([],[Tmp],_,_Tmp):-name(Tmp,_Tmp).
morpheme_analysis1([39|Str],[Atom|Res],Chars,[]):-
	morpheme_analysis2(Str,Str_rest,Atom_s),
	name(Atom,Atom_s),
	morpheme_analysis1(Str_rest,Res,Chars,[]).
morpheme_analysis1([39|Str],[Tmp,Atom|Res],Chars,Tmp):-
	morpheme_analysis2(Str,Str_rest,Atom_s),
	name(Atom,Atom_s),
	morpheme_analysis1(Str_rest,Res,Chars,[]).
morpheme_analysis2([39|Str],Str,[]).
morpheme_analysis2([X|Str],Rest,[X|Atom]):-
	morpheme_analysis2(Str,Rest,Atom).
morpheme_analysis1([_C|Str],[C|Res],Chars,[]):-
	name(C,[_C]),
	user:member(C,Chars),
	morpheme_analysis1(Str,Res,Chars,[]).
morpheme_analysis1([_C|Str],[A,C|Res],Chars,Tmp):-
	name(C,[_C]),
	user:member(C,Chars),
	name(A,Tmp),
	morpheme_analysis1(Str,Res,Chars,[]).
morpheme_analysis1([_C|Str],Res,Chars,Tmp):-
	user:append(Tmp,[_C],Tmp1),
	morpheme_analysis1(Str,Res,Chars,Tmp1).

/* ʸ
 parse(Src,Res) */
parse(Src,Res):-
	phrase(g:s(Res),Src).
parse(_,error).

/* ѿиִ */
/* voc_check(L,VL) :- LˤVLѿ(ʸǻϤޤatom)Ƥ */
voc_check(L,VL):-voc_check(L,VL,[]).
voc_check([],[],_).
voc_check([X|L],VVL,Tmp):-
	user:is_list(X),!,
	voc_check(X,Y,Tmp),
	user:append(Y,Tmp,Tmp1),
	user:append(Y,VL,VVL),
	voc_check(L,VL,Tmp1).
voc_check([X|L],[X|VL],Tmp):-
	X @< '[', X @>= 'A', user:non_member(X,Tmp), !,
	voc_check(L,VL,[X|Tmp]).
voc_check([X|L],VL,Tmp):-
	voc_check(L,VL,Tmp).

/* v_check(L,VL) :- LˤVLѿƤ */
v_check(L,VL):-v_check(L,VL,[]).
v_check([],[],_).
v_check([X|L],VVL,Tmp):-
	user:is_list(X),!,
	v_check(X,Y,Tmp),
	user:append(Y,Tmp,Tmp1),
	user:append(Y,VL,VVL),
	v_check(L,VL,Tmp1).
v_check([X|L],[X|VL],Tmp):-
	var(X), tr:non_member(X,Tmp), !,
	v_check(L,VL,[X|Tmp]).
v_check([X|L],VL,Tmp):-
	v_check(L,VL,Tmp).

/* v_replace(L,NL) :- LʸϤޤatomѿ֤ΤNL */
v_replace(L,NL):-
	var(NL),nonvar(L),!,
	ctov_replace(L,NL).
v_replace(L,NL):-
	nonvar(NL),var(L),!,
	vtoc_replace(NL,L).

ctov_replace(L,NL):-
	voc_check(L,VL),
	ctov_replace(L,VL,NL).
ctov_replace(L,[],L).
ctov_replace(L,[X|VL],L1):-
	u:replace(L,X,_,L2),
	ctov_replace(L2,VL,L1).

vtoc_replace(L,NL):-
	v_check(L,VL),
	vtoc_replace(L,VL,NL,65).
vtoc_replace(L,[],L,_).
vtoc_replace(L,[X|VL],L1,C):-
	name(B,[C]),
	u:replace(L,X,B,L2),
	CC is C+1,
	vtoc_replace(L2,VL,L1,CC).

non_member(_,[]).
non_member(X,[Y|L]):-
	X==Y,!,fail.
non_member(X,[_|L]):-
	non_member(X,L).
