%  Shaky v2.0      Copyright (C) 1998, Ken Kaneiwa (kaneiwa@jaist.ac.jp) 
%  Shaky v1.0      Copyright (C) 1997, Masanori Ohmori (oomori@jaist.ac.jp) 
:- module(sys,[]).

/* Ҹ줬ƥҸ줫Ƚ */
system_pred(X):-
	system_predicate(Pred),
	user:member(X,Pred).
/* ƥҸΥꥹ */
/*ɲ list*/
system_predicate([ld,load_data,load_sr_data,list,list_i,listing_sit,listing_all,listing_sr,init_db]).

/* ǡ١initialize */
init_db([]):-
	db:newdb.

/* load :- ǡɤ */
/*load_data([[file,File]]):-
	io:load_data(File).*/
load_data([[file,[0,File,[]]]]):-
	io:load_data(File).
ld([[f,[0,File,[]]]]):-
	io:load_data(File).

/* load_sr_data :- ִطɤ */
load_sr_data([[file,File]]):-
	io:load_sr_data(File).

/* listing_all :- ǡɽ */
/* listing_sit(E) :- EݡȤǡɽ */
listing_sit([[sit,E]]):-
	listing_sit1(E).
listing_sit1(E):-
	db:get_data(support_map0,E,Infs),
	listing_sit2(Infs,Infs_ex),
	io:output_data(Infs_ex).
listing_sit2([],[]).
listing_sit2([Id|Infs],[Inf_ex|Infs_ex]):-
	db:get_data(infons,Id,Inf),
	tr:transfer_itoe([infon,Inf],Inf_ex),
	listing_sit2(Infs,Infs_ex).

/* ǡ١Υǡɽ */
/*ɲ*/
list_i([]) :- 
	listing(db:sort),
	listing(db:label),
	listing(db:arg),
	listing(db:imp),
	listing(db:sit),
	listing(db:fact),
	listing(db:rules).

list([]) :- 
	bb_get(db:sort_id,Id1),
	list_sort(Id1,0),
	bb_get(db:label_id,Id11),
	list_label(Id11,0),
	bb_get(db:imp_id,Id2),
	list_imp(Id2,0),
	bb_get(db:sit_id,Id3),
	list_sit(Id3,0),
	bb_get(db:fact_id,Id4),
	list_fact(Id4,0),
	bb_get(db:r_id,Id5),
	list_rule(Id5,0).

list_sort(Id,Id).
list_sort(Id,N) :-
	db:sort([N,Sort]),
	tr:transfer_itoe([sort,Sort],O),
	print_list(O),
	NA is N+1,
	list_sort(Id,NA).

list_label(Id,Id).
list_label(Id,N) :-
	db:label([N,L]),
	tr:transfer_itoe([label,L],O),
	print_list(O),
	NA is N+1,
	list_label(Id,NA).

list_sit(Id,Id).
list_sit(Id,N) :-
	db:sit([N,Sit]),
	tr:transfer_itoe([sit,Sit],O),
	print_list(O),
	NA is N+1,
	list_sit(Id,NA).

list_imp(Id,Id).
list_imp(Id,N) :-
	db:imp([N,Imp]),
	tr:transfer_itoe([imp,Imp],O),
	print_list(O),
	NA is N+1,
	list_imp(Id,NA).

list_fact(Id,Id).
list_fact(Id,N) :-
	db:fact([N,Fact]),
	tr:transfer_itoe([fact,Fact],O),
	print_list(O),
	NA is N+1,
	list_fact(Id,NA).

list_rule(Id,Id).
list_rule(Id,N) :-
	db:rules([N,Rule]),
	tr:transfer_itoe([rule,Rule],O),
	print_list(O),
	NA is N+1,
	list_rule(Id,NA).

print_list(O):-
	name(X,O),
	print(X),
	nl.

listing_all([]) :-
	db:support_map0(L0),listing1(L0,0),
	db:support_map1(L1),listing1(L1,1),
	db:support_map2(L2),listing1(L2,2).
listing1([],_).
listing1([[E,Infs_id]|X],Type):-
	infons(Infs_id,Infs),
	listing2(E,Infs,Type),
	listing1(X,Type).
listing2(_,[],_).
listing2(E,[I|Infs],Type):-
	tr:transfer_itoe([term,[[E],I,Type]],O),
	name(X,O),print(X),nl,
	listing2(E,Infs,Type).

/* infons(եidΥꥹ,եɽΥꥹ) */
infons([],[]).
infons([I|Ids],[Inf|Infs]):-
	db:get_data(infons,I,Inf),
	infons(Ids,Infs).

/* ִطɽ */
listing_sr([]):-
	db:s_link(X),
	listing_sr1(X).
listing_sr1([]).
listing_sr1([[D,Rs]|X]):-
	listing_sr2(D,Rs),
	listing_sr1(X).
listing_sr2(_,[]).
listing_sr2(D,[R|Rs]):-
	format("~a -> ~a\n",[D,R]),
	listing_sr2(D,Rs).

output([]).
output([E|Output]):-
	print(E),
	output(Output).
