%	grammar.pl, Shaky v2.0
%	Copyright (C) 1998, Ken Kaneiwa (kaneiwa@jaist.ac.jp)
%	              1997, Masanori Ohmori (oomori@jaist.ac.jp)
%
%       A grammar for translating

:- module(g,[]).

s([rule, [SIT,RULE]]) --> sit(SIT),[':',':'],rule(RULE),['.'].
s([fact, PROP]) --> prop(PROP),['.'].
s([goal, [PROP|PROPS]]) --> prop(PROP),[','],props(PROPS),['.'].
s([infon, INF]) --> infon(INF),['.'].
s([sort, [SORT1,SORT2]]) --> sort(SORT1),['<'],sort(SORT2),['.'].
s([imp, [REL1,REL2]]) --> rel(REL1),['<'],['-'],rel(REL2),['.'].
s([sit, [[ES1],[ES2]]]) --> e_sit(ES1),['<'],['<'],e_sit(ES2),['.'].
s([label, [LVL,SORT]]) --> label(LVL),['='],sort(SORT),['.'].
prop([SIT,INF,0]) --> sit(SIT),[':'],infon(INF).
prop([SIT,INF,1]) --> sit(SIT),[':'],['='],infon(INF).
prop([SIT,INF,2]) --> sit(SIT),[':'],['>'],infon(INF).
props([PROP]) --> prop(PROP).
props([PROP|PROPS]) --> prop(PROP),[','],props(PROPS).
e_sit(ATOM) --> [ATOM],{a @=< ATOM, ATOM @< '{'}.
sit([VAR,[w]]) --> var(VAR).
sit([0,[ES]]) --> e_sit(ES).
sit([0,[ES|SIT]]) --> e_sit(ES),[','],sit([0,SIT]).
infon([REL,ARGS,0]) --> ['-'],rel(REL),['('],args(ARGS),[')'].
infon([REL,[],0]) --> ['-'],rel(REL).
infon([REL,ARGS,1]) --> rel(REL),['('],args(ARGS),[')'].
infon(VAR) --> var(VAR).
infon([REL,[],1]) --> rel(REL).
rel([ATOM,0]) --> [ATOM], {a @=< ATOM, ATOM @< '{'}.
rel([ATOM,1]) --> ['#'],[ATOM], {a @=< ATOM, ATOM @< '{'}.
sort(ATOM) --> [ATOM], {a @=< ATOM, ATOM @< '{'}.
var(VAR) --> [VAR], {'A' @=< VAR, VAR @< '['}.
args([ARG]) --> arg_s(ARG).
args([ARG|ARGS]) --> arg_s(ARG),[','], args(ARGS).
arg_s([LVL,TERM]) --> label(LVL),['='],term(TERM).
label(ATOM) --> [ATOM], {a @=< ATOM, ATOM @< '{'}.
term([0,ATOM,[]]) --> [ATOM], {a @=< ATOM, ATOM @=< '~~'}.
term([VAR,ATOM,[]]) --> var(VAR),[':'],[ATOM],{a @=< ATOM, ATOM @=< '~~'}.
term([VAR,top,[]]) --> var(VAR).
term([0,ATOM,ARGS]) --> [ATOM],['['],args(ARGS),[']'], {a @=< ATOM, ATOM @=< '~~'}.
term([VAR,ATOM,ARGS]) --> var(VAR),[':'],[ATOM],['['],args(ARGS),[']'],{a @=< ATOM, ATOM @=< '~~'}.
term([VAR,top,ARGS]) --> var(VAR),['['],args(ARGS),[']'].
rule([HEAD,BODY,[]]) --> head(HEAD),['<','-'],body(BODY).
head(PROP) --> prop(PROP).
body([PROP]) --> prop(PROP).
body([PROP|BODY]) --> prop(PROP),[','],body(BODY).

/*

s([rule, [ES,RULE]]) --> e_sit(ES),[':',':'],rule(RULE),['.'].
s([term, TERM]) --> term(TERM),['.'].
s([infon, INF]) --> infon(INF),['.'].
term([SIT,INF,0]) --> sit(SIT),[':'],infon(INF).
term([SIT,INF,1]) --> sit(SIT),[':','='],infon(INF).
term([[ES],INF,2]) --> e_sit(ES),[':','>'],infon(INF).
e_sit(ATOM) --> [ATOM],{a @=< ATOM, ATOM @< '{'}.
sit(VAR) --> var(VAR).
sit([ES]) --> e_sit(ES).
sit([ES|SIT]) --> e_sit(ES),[','],sit(SIT).
infon([REL,ARGS,0]) --> ['-'],rel(REL),['('],args(ARGS),[')'].
infon([REL,[],0]) --> ['-'],rel(REL).
infon([REL,ARGS,1]) --> rel(REL),['('],args(ARGS),[')'].
infon(VAR) --> var(VAR).
infon([REL,[],1]) --> rel(REL).
rel(ATOM) --> [ATOM], {a @=< ATOM, ATOM @< '{'}.
var(VAR) --> [VAR], {'A' @=< VAR, VAR @< '['}.
args([ARG]) --> arg_s(ARG).
args([ARG|ARGS]) --> arg_s(ARG),[','], args(ARGS).
arg_s([LVL,VAL]) --> label(LVL),['='],val(VAL).
label(ATOM) --> [ATOM], {a @=< ATOM, ATOM @< '{'}.
val(LIST) --> ['['],list(LIST),[']'].
val(ATOM) --> [ATOM], {a @=< ATOM, ATOM @=< '~~'}.
val(VAR) --> var(VAR).
val(TERM) --> term(TERM).
val(INF) --> infon(INF).
list([ATOM]) --> [ATOM].
list([ATOM|LIST]) --> [ATOM],[','],list(LIST), {a @=< ATOM, ATOM @< '{'}.
rule([HEAD,BODY,BC]) --> head(HEAD),['<','-'],body(BODY),['|'],bc(BC).
rule([HEAD,BODY,[]]) --> head(HEAD),['<','-'],body(BODY).
head(TERM) --> term(TERM).
body([TERM]) --> term(TERM).
body([TERM|BODY]) --> term(TERM),[','],body(BODY).
bc([INF]) --> infon(INF).
bc([INF|BC]) --> infon(INF),[','],bc(BC).

*/
