%  Shaky v2.0      Copyright (C) 1998, Ken Kaneiwa (kaneiwa@jaist.ac.jp) 
%  Shaky v1.0      Copyright (C) 1997, Masanori Ohmori (oomori@jaist.ac.jp) 
/* $B%G!<%?%Y!<%9!&%b%8%e!<%k(B */
:- module(db,[]).

/*
arg([0,[[hit,0],[[agt,person],[coagt,person]]]]).
arg([1,[[fly,0],[[sbj,top]]]]).
arg([2,[[fly,1],[[sbj,top]]]]).
*/


/* newdb :- $B%G!<%?%Y!<%9$N=i4|2=(B 
    as_list : $B8@L@$N%j%9%H(B
    support_map0,1,2 : $B%5%]!<%H%^%C%W(B 
       $B%?%$%W(B 0 : non persistent
       $B%?%$%W(B 1 : persistent
       $B%?%$%W(B 2 : equal
*/
newdb :-
	bb_put(i_id,0),
	bb_put(fact_id,0),
	bb_put(r_id,0),
	bb_put(sort_id,0),
	bb_put(imp_id,0),
	bb_put(sit_id,0),
	bb_put(label_id,0),
	bb_put(arg_id,0),
	newdb([links,fact,sort,imp,sit,label,arg,infons,support_map0,support_map1,support_map2,rules,domain,s_link,sr,str_order]).
newdb([]).
newdb([DB|DBL]):-
	del_db(DB),
	X=..[DB,[]], 
	asserta(X),
	newdb(DBL).

/* $B%G!<%?%Y!<%9(BDB$B$,B8:_$9$k$J$i>C$9(B. $B$J$1$l$P$J$K$b$7$J$$(B. */
del_db(DB):-
	current_predicate(DB,_),
	abolish(DB,1).
del_db(DB).

/* $B>u67$N%j%s%/(B */
% s_link([[s1,[s2,s3]],[s2,[s4]],[s3,[s4]],[s4,[s5]]]).
% domain([s1,s2,s3,s4]).

/* $B%G!<%?$r%G!<%?%Y!<%9$K%9%H%"$9$k(B */
/*store_data([term, X]):-
	store_term(X).*/
/*$BDI2C(B*/
store_data([sort, X]):-
	store_sort(X).
store_data([imp, X]):-
	store_imp(X).
store_data([sit, X]):-
	store_sit(X).
store_data([fact, X]):-
	store_fact(X).
store_data([rule, X]):-
	store_rule(X).
store_data([infon, X]):-
	store_fact([[w],X,0]).
store_data([label, X]):-
	store_label(X).
store_data([comment, X]).

/* $B>u674V4X78$r%G!<%?%Y!<%9$K%9%H%"$9$k(B */
store_sr_data([infon, [domain,[[dom,X]],1]]):-
	del_db(domain),
	asserta(domain(X)).
store_sr_data([infon, [link, [[from,X],[to,Y]],1]]):-
	update_slink(X,Y).
store_sr_data([infon, [str,[[order,X]],1]]):-
	str_order(Z),
	del_db(str_order),
	asserta(str_order(X)).
store_sr_data([infon, INF]):-
	store_term([[w],INF,0]).

/* update_slink(X,Y) :- 
    $B>u6785AG(BX$B$+$i>u6785AG(BY$B$K%j%s%/$,D%$i$l$F$$$k$3$H$r%9%H%"$9$k(B */
update_slink(X,Y):-
	s_link(L),
	update_slink(L,X,Y,LL),
	del_db(s_link),
	asserta(s_link(LL)).
update_slink([],X,Y,[[X,[Y]]]).
update_slink([[X,Lx]|L],X,Y,[[X,Lx]|L]):-
	user:member(Y,Lx).
update_slink([[X,Lx]|L],X,Y,[[X,[Y|Lx]]|L]).
update_slink([E|L],X,Y,[E|LL]):-
	update_slink(L,X,Y,LL).

/* $B@)Ls$N6/$5(B */
stronger(X,Y):-
	str_order(Str),
	user:nth(Nx,Str,X),
	user:nth(Ny,Str,Y),
	Nx < Ny.

/* store_rule(X) :- $B%k!<%k$r%G!<%?%Y!<%9$K2C$($k(B */
store_rule(Rule):-
	db:rules([_,Rule]).
store_rule(Rule):-
	\+db:rules([_,Rule]),
	new_id(r_id,Id),
	asserta(rules([Id,Rule])),
	rule_arg(Rule).

rule_arg([S,[HEAD,BODY,_]]):-
	store_arg(HEAD),
	rule_arg1(BODY).

rule_arg1([]).
rule_arg1([PROP|PROPS]):-
	store_arg(PROP),
	rule_arg1(PROPS).
	
/*store_rule([E,Rule]):-
	rules(Rules),
	new_id(r_id,Id),
	del_db(rules),
	asserta(rules([[Id,Rule]|Rules])),
	store_sr(E,Id).*/
store_sr(E,Id):-
	sr(SM),
	store_sr(SM,E,Id,SM_new),
	del_db(sr),
	asserta(sr(SM_new)).
store_sr([],E,Id,[[E,[Id]]]).
store_sr([[E,X]|SM],E,Id,[[E,[Id|X]]|SM]).
store_sr([X|SM],E,Id,[X|SM_new]):-
	store_sr(SM,E,Id,SM_new).

/* $BDI2C(B */
store_label(L):-
	db:label([_,L]).
store_label(L):-
	\+db:label([_,L]),
	new_id(label_id,Id),
	assert(label([Id,L])).

store_fact(Fact):-
	db:fact([_,Fact]).
store_fact(Fact):-
	\+db:fact([_,Fact]),
	new_id(fact_id,Id),
	assert(fact([Id,Fact])),
	store_arg(Fact).

store_arg([S,[P,T,1],_]):-
	db:arg([Id,[P,LX]]),
	store_arg1(T,P,Id,LX).
store_arg([S,[P,T,1],_]):-
	\+db:arg([_,[P,_]]),
	new_id(arg_id,Id),
	assert(arg([Id,[P,[]]])),
	store_arg1(T,P,Id,[]).

store_arg1([],P,Id,LX).
store_arg1([[LVL,_]|TX],P,Id,LX):-
	user:member([LVL,_],LX),
	store_arg1(TX,P,Id,LX).
store_arg1([[LVL,_]|TX],P,Id,LX):-
	\+user:member([LVL,_],LX),
	db:label([_,[LVL,SORT]]),
	user:append(LX,[[LVL,SORT]],E),
	retract(db:arg([Id,[P,LX]])),
	assert(db:arg([Id,[P,E]])),
	store_arg1(TX,P,Id,E).

store_sort(Sort):-
	db:sort([_,Sort]).
store_sort(Sort):-
	\+db:sort([_,Sort]),
	new_id(sort_id,Id),
	assert(sort([Id,Sort])).

store_imp(Imp):-
	db:imp([_,Imp]).
store_imp(Imp):-
	\+db:imp([_,Imp]),
	new_id(imp_id,Id),
	assert(imp([Id,Imp])).

store_sit(Sit):-
	db:sit([_,Sit]).
store_sit(Sit):-
	\+db:sit([_,Sit]),
	new_id(sit_id,Id),
	assert(sit([Id,Sit])).

/* store_term(X) :- $B9`$r%G!<%?%Y!<%9$K2C$($k(B */
store_term([Sit,Inf,St]):-
	store_infon(Inf,Id),
	store_sm(Sit,Id,St).

/* store_infon(Inf,I_id) :- infon$B$r(Binfons list$B$K2C$($F(B, id$B$rF@$k(B */
store_infon(Inf,I_id):-
	infons(Infs),
	check_member(Inf,Infs,Id),
	store_infon1(Inf,Infs,Id,I_id,New_infs),
	del_db(infons),
	asserta(infons(New_infs)).
store_infon1(Inf,Infs,-1,I_id,[[I_id,Inf]|Infs]):-
	new_id(i_id,I_id).
store_infon1(_,Infs,Id,Id,Infs).

/* store_sm(Sit,Id,Stype) :- $B>u67(BSit$B$H(Bid=Id$B$N%$%s%U%)%s$O(B
   $B%5%]!<%H4X78(BStype$B$G$"$k$3$H$r%G!<%?%Y!<%9$K2C$($k(B */
store_sm(Sit,Id,0):-
	support_map0(SM),
	store_sm0(SM,Sit,Id,SM_new),
	del_db(support_map0),
	asserta(support_map0(SM_new)).
store_sm0([],[],_,[]).
store_sm0([],Sit,Id,SM_new):-
	store_sm01(Sit,Id,SM_new).
store_sm01([],_,[]).
store_sm01([E|Sit],Id,[[E,[Id]]|SM_new]):-
	store_sm01(Sit,Id,SM_new).
store_sm0([E|SM],Sit,Id,[E_new|SM_new]):-
	store_sm0_sub(E,Sit,Id,E_new,Sit_new),
	store_sm0(SM,Sit_new,Id,SM_new).
store_sm0([E|SM],Sit,Id,[E|SM_new]):-
	store_sm0(SM,Sit,Id,SM_new).
store_sm0_sub([S,Infons],Sit,Id,[S,[Id|Infons]],Sit_new):-
	user:member(S,Sit),
	user:non_member(Id,Infons),
	user:delete(Sit,S,Sit_new).
store_sm0_sub([S,Infons],Sit,Id,[S,Infons],Sit_new):-
	user:member(S,Sit),
	user:delete(Sit,S,Sit_new).

store_sm(Sit,Id,1):-
	support_map1(SM),
	store_sm1(SM,Sit,Id,SM_new),
	del_db(support_map1),
	asserta(support_map1(SM_new)).
store_sm(Sit,Id,2):-
	support_map2(SM),
	store_sm2(SM,Sit,Id,SM_new),
	del_db(support_map2),
	asserta(support_map2(SM_new)).

/* $B%G!<%?%Y!<%9$N$N<oN`$KBP$7$F?7$7$$(Bid$B$rJV$9(B */
new_id(Type,Id):-
	bb_get(Type,Id),
	Id_next is Id + 1,
	bb_put(Type,Id_next).

/* infons$B%G!<%?%Y!<%9Cf$N=EJ#$rHr$1$k(B */
check_member(Inf,[],-1).
check_member(Inf,[[Id,Inf]|_],Id).
check_member(Inf,[[_,X]|As],Id):-
	check_member(Inf,As,Id).

/* support(E,Inf,Type) :- 
    $B>u6785AG(BE$B$O%?%$%W(BType$B$G%$%s%U%)%s(BInf$B$r%5%]!<%H$9$k(B */
support(E,Inf,0):-
	support0(E,Inf).
support(E,Inf,1):-
	support1(E,Inf).
support(E,Inf,2):-
	support2(E,Inf).

/* support0(E,Inf) :- $B>u6785AG(BE$B$,%$%s%U%)%s(BInf$B$r%5%]!<%H$7$F$$$k(B */
support0(E,Inf):-
	atom(E),
	get_data(support_map0,E,Infs),!,
	user:member(Id,Infs),
	get_data(infons,Id,Inf).
support1(S,Inf):-
	ground(S),
	get_data(support_map1,S,Infs),!,
	user:member(Id,Infs),
	get_data(infons,Id,Inf).
support1(S,Inf):-
	nonvar(Inf),
	get_data(infons,Id,Inf),!,
	get_data(support_map1,S,Infs),
	user:member(Id,Infs).
support2(S,Inf):-
	ground(S),
	get_data(support_map2,S,Infs),!,
	user:member(Id,Infs),
	get_data(infons,Id,Inf).
support2(S,Inf):-
	nonvar(Inf),
	get_data(infons,Id,Inf),!,
	get_data(support_map2,S,Infs),
	user:member(Id,Infs).

/* get_data(Map_name,Key,Result)
	:- $B%^%C%W(BMap_name$B$+$i(BKey$B$r%-!<$K$7$FCM$rF@$k(B */
get_data(Map_name,Key,Val):-
	Pred=..[Map_name,Contents],
	Pred,!,
	u:assoc(Key,Contents,Val).

/* rs(E) :- $B>u67(BE$B$O(Breasoning situation$B$G$"$k(B */
rs(E) :-
	str_order(X),
	user:member(E,X).

/* rule(Id,Rule) :- Rule$B$O%k!<%k(Bid$B$,(BId$B$N%k!<%k$G$"$k(B */
rule(Id,Rule):-
	get_data(rules,Id,Rule).

/* link(S1,S2) :- S1$B$H(BS2$B$ONY@\$7$F$$$k(B */
link(S1,S2):-
	get_data(s_link,S1,SL),
	user:member(S2,SL).
link(S,nil).

/* get_domain([First,Last,Nes],Dom):- $B;OE@(B, $B=*E@(B, $BI,?\%j%9%H$+$iC5:wHO0O$rF@$k(B */
get_domain([First,Last,Nes],Dom):-
	get_domain_f(First,Rf),
	get_domain_l(Last,Rl),
	u:intersection([Rf,Rl],Dom),
	u:subset(Nes,Dom).

get_domain_f(nil,All):-
	domain(All).
get_domain_f(First,Rf):-
	get_domain_f1([First],Rf).
get_domain_f1([X|L],[X|Res]):-
	get_data(s_link,X,S),
	u:union([S,L],Tmp),
	get_domain_f1(Tmp,Res).
get_domain_f1(R,R).

get_domain_l(nil,All):-
	domain(All).
get_domain_l(Last,Rl):-
	get_domain_l1([Last],Rl).
get_domain_l1([X|L],[X|Res]):-
	setof(Y,link(Y,X),S),
	u:union([S,L],Tmp),
	get_domain_l1(Tmp,Res).
get_domain_l1(R,R).
