#
# This procedure is based on a sample of 
#            'Practical Programming in Tcl and Tk' draft.
#                                                by Hidetoshi NAGAI
#
#        If trouble, contact with Hidetoshi NAGAI (nagai@ai.kyutech.ac.jp)
#
#            Copyright (C) 1997  Kyusyu Institute of Technology, 
#                                   Department of Artificial Intelligence
#                                                Hidetoshi NAGAI
#                                                Teigo  NAKAMURA
#                                                Hirosato NOMURA

# generate text-widget with y-scroll
#
#    param  : parent widget-path 
#    width  : text width
#    height : text height
#    wrap   : word wrap parameter 
#
#    return text-wiget path
#
proc scrolled_text {parent width height {wrap char}} {
    # Create text widget attached to a vertical scrollbar
    text $parent.text -width $width -height $height \
            -setgrid true -wrap $wrap \
            -yscrollcommand [list $parent.sy set]
    scrollbar $parent.sy -orient vertical \
            -command [list $parent.text yview]

    # Arrange everything in the parent frame
    pack $parent.sy -side right -fill y
    pack $parent.text -side left -fill both -expand true

    # end of all
    return $parent.text
}


# generate text-widget with x,y-scroll
#
#    param  : parent widget-path 
#    width  : text width
#    height : text height
#
#    return text-wiget path
#
proc double_scrolled_text {parent width height} {
    # Create text widget attached to scrollbars
    text $parent.text -width $width -height $height \
            -setgrid true -wrap none \
            -yscrollcommand [list $parent.sy set] \
            -xscrollcommand [list $parent.pad.sx set]
    scrollbar $parent.sy -orient vertical \
            -command [list $parent.text yview]

    # Create extra frame to hold pad and horizontal scrollvar
    frame $parent.pad
    scrollbar $parent.pad.sx -orient horizontal \
            -command [list $parent.text xview]

    # Create padding based on the scrollbar's width and its borders.
    set pad [expr [$parent.sy cget -width] \
            + 2 * ([$parent.sy cget -bd] \
                   + [$parent.sy cget -highlightthickness])]
    frame $parent.pad.it -width $pad -height $pad

    # Arrange everything in the parent frame
    pack $parent.pad -side bottom -fill x
    pack $parent.pad.it -side right
    pack $parent.pad.sx -side bottom -fill x
    pack $parent.sy -side right -fill y
    pack $parent.text -side left -fill both -expand true

    # end of all
    return $parent.text
}


# set DEBUG mode
if {[info exists DEBUG] == 0} {
    set DEBUG 0
}
if [regexp -nocase {^(Y|YES|1)$} $DEBUG] {
    set DEBUG 1
} else {
    set DEBUG 0
}

# test mode 
if {$DEBUG} {

    frame .f
    frame .f.single
    frame .f.double
    puts [scrolled_text .f.single 20 8]
    puts [double_scrolled_text .f.double 20 8]
    pack .f.single .f.double -side top -expand true -fill both
    pack .f -expand true -fill both

    .f.single.text insert end "This has only vertical scrollbar\n"
    .f.single.text insert end "Is it OK?\n"
    .f.single.text insert end "This is a LLLLLLLLLLLLLLLLLLLLLLLLLLOOOOOOOOOOOOOOOOOOOOOOOOOOOONNNNNNNNNNNNNNNNNNNNNNNNNNNNNGGGGGGGGGGGGGGGGGGGGGGGGGGGGG text.\n"

    .f.double.text insert end "The bottom scrollbar\n"
    .f.double.text insert end "is aligned with frames\n"

}
