#
# This procedure is a sample of 'Practical Programming in Tcl and Tk' draft.
#                                                by Hidetoshi NAGAI
#
#        If trouble, contact with Hidetoshi NAGAI (nagai@ai.kyutech.ac.jp)
#
#            Copyright (C) 1997  Kyusyu Institute of Technology, 
#                                   Department of Artificial Intelligence
#                                                Hidetoshi NAGAI
#                                                Teigo  NAKAMURA
#                                                Hirosato NOMURA

# generate listbox-widget with y-scroll
#
#    param  : parent widget-path 
#    args   : list of items
#
#    return listbox-wiget path
#
proc scrolled_listbox {parent args} {
    # Create listbox attached to scrollbars, pass thru $args
    eval {listbox $parent.list \
            -yscrollcommand [list $parent.sy set]} $args
    scrollbar $parent.sy -orient vertical \
            -command [list $parent.list yview]

    pack $parent.sy -side right -fill y
    pack $parent.list -side left -fill both -expand true

    # end of all
    return $parent.list
}


# generate listbox-widget with x,y-scroll
#
#    param  : parent widget-path 
#    args   : list of items
#
#    return listbox-wiget path
#
proc double_scrolled_listbox {parent args} {
    # Create listbox attached to scrollbars, pass thru $args
    eval {listbox $parent.list \
            -yscrollcommand [list $parent.sy set] \
            -xscrollcommand [list $parent.pad.sx set]} $args
    scrollbar $parent.sy -orient vertical \
            -command [list $parent.list yview]

    # Create extra frame to hold pad and horizontal scrollvar
    frame $parent.pad
    scrollbar $parent.pad.sx -orient horizontal \
            -command [list $parent.list xview]

    # Create padding based on the scrollbar's width and its borders.
    set pad [expr [$parent.sy cget -width] \
            + 2 * ([$parent.sy cget -bd] \
                   + [$parent.sy cget -highlightthickness])]
    frame $parent.pad.it -width $pad -height $pad

    # Arrange everything in the parent frame
    pack $parent.pad -side bottom -fill x
    pack $parent.pad.it -side right
    pack $parent.pad.sx -side bottom -fill x
    pack $parent.sy -side right -fill y
    pack $parent.list -side left -fill both -expand true

    # end of all
    return $parent.list
}


# set DEBUG mode
if {[info exists DEBUG] == 0} {
    set DEBUG 0
}
if [regexp -nocase {^(Y|YES|1)$} $DEBUG] {
    set DEBUG 1
} else {
    set DEBUG 0
}

# test mode
if {$DEBUG} {
    frame .f
    puts [double_scrolled_listbox .f -width 20 -height 5 -setgrid true]
    pack .f -expand true -fill both

    .f.list insert end "The bottom scrollbar" "is aligned with frames"
}
