#
# research.tcl  Ĵʬϻٱ
#                                                    by  ʰ 
#
#        If trouble, contact with Hidetoshi NAGAI (nagai@ai.kyutech.ac.jp)
#
#            Copyright (C) 1997  彣 󹩳 ǽ󹩳ز
#                                                     ʰ 
#                                                     ¼ 
#                                                     ¼ 

###############################################
# KensakuTitleConfigure Ĵ⡼ɥȥѹ
# ѹ 1 Ԥ 0 ֤
#
#    l    : ȥʸ label å
#    mode : ȥꤷ褦ȤĴ⡼
#
proc KensakuTitleConfigure {l mode} {
    switch $mode {
        {KWIC} {
            $l configure -text "ˣףɣ"
        }

        {Sel_Sentence} {
            $l configure -text "ʸ"
        }

        {Sel_Line} {
            $l configure -text "Ԥ"
        }

        {*} {
            $l configure -text ""
            tk_dialog .d dialog "Ĵ⡼ɤ˰۾郎ޤ" warning 0 "λ"
            return 0
        }
    }

    return 1
}


###############################################
# KensakuTargetConfigure Ĵоѹ
#
#   top         : ǽоɽƥåȥѥ
#   label_name  : ǽоݼ̾ɽ٥륦åȥѥ
#   entry_name  : ǽо̾ɽ륨ȥꥦåȥѥ
#   button_name : ǽѹܥ󥦥åȥѥ
#   target      : ĴоʸμǼ
#   target_type : ĴоʸμǼ
#                   file   -> target ̾Ȥե
#                   widget -> target ѥȤƥȥå
#                   text   -> target Τоʸ
#                   var    -> target ̾Ȥѿ
#
proc KensakuTargetConfigure \
        {top label_name entry_name button_name target target_type} {
    switch $target_type {
        {file}   {
            $label_name configure -text {оݥե}

            # ɤ߹ԲĤξϤλΤ
            if ![file readable $target] {
                tk_dialog .d dialog "եɤ߹ޤ" \
                        warning 0 "λ"
                set text {}
            } else {
                # եλ꤬ȥǥ쥯ȥ꤫ŪʤΤʤ
                # ХѥѴ
                if ![kstring match {[/~]*} $target] {
                    if {[pwd] == "/"} {
                        set target /$target
                    } else {
                        set target [pwd]/$target
                    }
                }

                # եƤɤ߹
                set fd [open $target r]
                set text [read $fd]
                close $fd
            }

            $button_name configure \
                    -command "GenBrowsWindow $top {ɽ} {$text}"

            $entry_name delete 0 end
            $entry_name insert 0 $target
        }

        {widget} {
            $label_name configure -text {оݥɥ}
            upvar #0 edfileop:filetitle:$target filetitle
            upvar #0 edfileop:toplevel:$target  widget
            $button_name configure \
                    -command "wm deiconify $widget; raise $widget"
            $entry_name delete 0 end
            $entry_name insert 0 $filetitle
        }

        {text}   {
            $label_name configure -text {оݥƥ}
            $button_name configure \
                    -command "GenBrowsWindow $top {ɽ} {$target}"
            $entry_name delete 0 end
            $entry_name insert 0 $target
        }

        {var}    {
            $label_name configure -text {оݥƥ}
            upvar $target text_var
            $button_name configure \
                    -command "GenBrowsWindow $top {ɽ} {$text_var}"
            $entry_name delete 0 end
            $entry_name insert 0 $text_var
        }
    }
}


###############################################
# KensakuWindow Ĵɽϥɥ
#
#   mode        : ¹Ĵ⡼
#   target      : ĴоʸμǼ
#   target_type : ĴоʸμǼ
#                   file   -> target ̾Ȥե
#                   widget -> target ѥȤƥȥå
#                   text   -> target Τоʸ
#                   var    -> target ̾Ȥѿ
#
proc KensakuWindow {mode target {target_type widget}} {
    
    set k .kensaku_toplevel:${mode}

    # ĴѥɥѤߤ
    if {[info commands $k] == $k} {
        # Ѥ  ⡼ɤꤷƥ쥤
        KensakuTitleConfigure $k.f.l $mode
        KensakuTargetConfigure \
                $k $k.f0.ef.l $k.f0.ef.en $k.f0.bf.ref $target $target_type
        $k.f2.exec configure -command "JIKKOU $mode $k $target $target_type"
        focus $k.f1.en
        wm deiconify $k
        raise $k
        return
    }
    

    # Ĵѥɥ򿷵
    toplevel $k
    wm title $k {Research}
    #wm withdraw $k
    
    # ȥ
    frame $k.f
    label $k.f.l 
    KensakuTitleConfigure $k.f.l $mode
    pack $k.f.l -anchor nw
    
    # оݥƥɽ
    #frame $k.f0 -relief raised -bd 2
    frame $k.f0
    frame $k.f0.ef
    label $k.f0.ef.l -width 14
    entry $k.f0.ef.en -width 45
    pack $k.f0.ef.l  -side left 
    pack $k.f0.ef.l -side left -expand off
    pack $k.f0.ef.en -side left -expand on -fill x

    frame $k.f0.bf
    button $k.f0.bf.target -text {оѹ} -command "KensakuTargetChange"
    button $k.f0.bf.ref    -text {    } -command {}
    pack $k.f0.bf.target $k.f0.bf.ref -side right
    KensakuTargetConfigure \
            $k $k.f0.ef.l $k.f0.ef.en $k.f0.bf.ref $target $target_type
    pack $k.f0.ef $k.f0.bf -side top -expand on -fill x

    
    # оɽɽ
    frame $k.f1
    label $k.f1.l -width 14 -text {Ĵɽ}
    entry $k.f1.en -width 45
    bind  $k.f1.en <Any-Return> "JIKKOU $mode $k $target $target_type" 
    pack $k.f1.l -side left -expand off
    pack $k.f1.en -side left -fill x -expand on
    focus $k.f1.en

    frame $k.f2
    button $k.f2.exec  -text {  ¹  } \
            -command "JIKKOU $mode $k $target $target_type"
    button $k.f2.clear -text { ꥢ } -command "$k.f1.en delete 0 end"
    button $k.f2.exit  -text {  λ  } -command "destroy $k"
    pack $k.f2.exit $k.f2.clear $k.f2.exec -side right
    

    # ѥå
    pack $k.f $k.f0 -side top
    pack $k.f1 $k.f2  -side top -expand on -fill x

    #wm geometry $k +200+100 
    #wm deiconify $k
    #raise $k
}



###############################################
# JIKKOU ĴؤΥ㡼
#
#    mode        : ¹Ĵ⡼
#    top         : ƥåȤΥѥ
#    target      : ĴоʸμǼ
#    target_type : ĴоʸμǼ
#                    file   -> target ̾Ȥե
#                    widget -> target ѥȤƥȥå
#                    text   -> target Τоʸ
#                    var    -> target ̾Ȥѿ
#
proc JIKKOU {mode top target target_type} {

    # ĴоݥƥȤγ
    switch $target_type {
        {file}   {
            # ɤ߹ԲĤξϤλΤ
            if ![file readable $target] {
                tk_dialog .d dialog "եɤ߹ޤ" \
                        warning 0 "λ"
                set text {}
                return
            } else {
                # եλ꤬ȥǥ쥯ȥ꤫ŪʤΤʤ
                # ХѥѴ
                if ![kstring match {[/~]*} $target] {
                    if {[pwd] == "/"} {
                        set target /$target
                    } else {
                        set target [pwd]/$target
                    }
                }

                # եƤɤ߹
                set fd [open $target r]
                set text [read $fd]
                close $fd
            }
        }

        {widget} {
            set text [$target get 1.0 {end - 1 char}] 
        }

        {text}   {
            set text $target
        }

        {var}    {
            upvar $target text_var
            set text $text_var
        }
    }

    # ʸγ
    set word [$top.f1.en get]
    if {$word == ""} {
        tk_dialog .d dialog "ʸϤƤޤ" warning 0 "λ"
        return 
    }

    switch $mode {
        {KWIC} {
            # ¹Ԥȷ̤ɽ
            GenBrowsWindow $top {ˣףɣäη} \
                    [DO_KWIC $word $text] \
                    {single}
        }

        {Sel_Sentence} {
            # ¹Ԥȷ̤ɽ
            GenBrowsWindow $top {ʸФη} \
                    [PICK_SENTENCE $word $text] \
                    {single}
        }

        {Sel_Line} {
            # ¹Ԥȷ̤ɽ
            GenBrowsWindow $top {Фη} \
                    [PICK_LINE $word $text] \
                    {double}
        }

        {*} {
            # ̽ϥɥ
            GenBrowsWindow $top {} {} {single}
            return
        }
    }
}
    

###############################################
# DO_KWIC       ˣףɣ
#
#   word : ʸ
#   text : оʸ
#
#   KWIC η̤֤ (ܤϳޥɤǤ make-kwic 򻲾)
#
proc DO_KWIC {word text} {
    if [catch "exec -keepnewline make-kwic -k $word -w 80 <<\$text" result] {
        tk_dialog .d dialog "ޥ make-kwic ¹ԤǤޤ󡣥顼åϼ̤Ǥ\n $result " warning 0 "λ"
        return {}
    }

    return $result
}


###############################################
# PICK_SENTENCE      ʸ
#
# eos_char (ǥեȤǤϡ֡) 򥭡Ȥ text ʸڤʬ
# word ˴ޤʸ̤Ȥ֤
#
proc PICK_SENTENCE {word text {eos_char {}}} {
    # ƥȤԤʧԤ˷Ҥ
    set c_text [join [split $text "\n"] {}]

    # з̤ˤƤ
    set result {}

    # Ƭ֤ޡ
    set head 0

    # eos_char 򥭡ȤڤФĤġ
    while {[set tail [kstring first $eos_char $c_text]] >= 0} {
        # ʸڤФ
        set sentence [kstring range c_text $head $tail]

        # ʸޤǤз̤ɲ
        if {[kstring first $word $sentence] >= 0} {
            append result "$sentence\n"
        }

        # оݤι
        set c_text [kstring range $c_text $first end]
    }

    # ʸ eos_char ʤν
    if {$c_text != {}} {
        # ĤäʸʸȤư
        # ʸޤǤз̤ɲ
        if {[kstring first $word $c_text] >= 0} {
            append result "$c_text\n"
        }
    }

    # ̤֤
    return $result
}


###############################################
# PICK_LINE      Ԥ
#
# text ˤơword ˴ޤԤ̤Ȥ֤
#
proc PICK_LINE {word text} {
    # ƥȤԤΥꥹȤˤޤȤ
    set line_list [split $text "\n"]

    # з̤ˤƤ
    set result {}

    # ԤȤ˸
    foreach line $line_list {
        # ʸޤǤз̤ɲ
        if {[kstring first $word $line] >= 0} {
            append result "$line\n"
        }
    }

    # ̤֤
    return $result
}


###############################################
# GenBrowsWindow ɽɥκ
# 줿ƥȥå֤̾
#
#    top   : ƤȤʤ륦åȥѥ
#    title : ɽɥΥȥʸ
#    text  : ɽʸ
#    mode  : ƥȥåȤΥ
#              single -> y Τ
#              double -> x, y ξ (wrap ʤ)
#
proc GenBrowsWindow {top title text {mode single}} {
    # Ѥߤ
    set browser $top.brows_window
    if {[info commands $browser] == $browser} {
        # Ѥ  ɽ⡼ɡɽƥȤ񤭴ƥ쥤
        TextViewMode $top.brows_window.text_frame.text $mode
        $top.brows_window.button_frame.title configure -text "   $title"
        $top.brows_window.text_frame.text delete 1.0 end
        $top.brows_window.text_frame.text insert 1.0 $text
        wm deiconify $top.brows_window
        #lower $top.brows_window $top
        raise $top.brows_window
        return $top.brows_window.text_frame.text
    }

    # 
    # ե졼ȥȥ
    toplevel $top.brows_window
    frame $top.brows_window.button_frame
    label $top.brows_window.button_frame.title -text "   $title"
    pack $top.brows_window.button_frame.title -side left

    # ƥɽ
    frame $top.brows_window.text_frame
    set t [double_scrolled_text $top.brows_window.text_frame 80 25]

    # ɽ⡼ɤ
    upvar #0 TextViewMode:$t view_mode
    set view_mode {double}
    TextViewMode $t $mode

    # ɽƥȤ
    $top.brows_window.text_frame.text delete 1.0 end
    $top.brows_window.text_frame.text insert 1.0 $text

    # ܥ
    # ɽ⡼ѹ
    menubutton $top.brows_window.button_frame.view -text { ɽ } \
            -menu $top.brows_window.button_frame.view.m -relief raised 

    menu $top.brows_window.button_frame.view.m \
            -tearoff no \
            -postcommand "
    ####################################################
    # ˥塼 postcommand γ
    ####################################################
    # ƥȥåȤΥ⡼ɳǧ
    upvar #0 TextViewMode:$t view_mode
    if {\$view_mode == {single}} {
        $top.brows_window.button_frame.view.m \
                entryconfigure {ĥΤ} -state disabled
        $top.brows_window.button_frame.view.m \
                entryconfigure {Ĳ}   -state normal
    } else {
        $top.brows_window.button_frame.view.m \
                entryconfigure {ĥΤ} -state normal
        $top.brows_window.button_frame.view.m \
                entryconfigure {Ĳ}   -state disabled
    }
    ####################################################
    # ˥塼 postcommand νλ
    ####################################################
    "

    $top.brows_window.button_frame.view.m add command \
            -label "ĥΤ" -command "TextViewMode $t {single}"
    $top.brows_window.button_frame.view.m add command \
            -label "Ĳ"   -command "TextViewMode $t {double}"

    # ¸
    button $top.brows_window.button_frame.save \
            -text { ¸ } -command "WriteTextWidgetContents $top.brows_window.text_frame.text" 

    # Ĥ
    button $top.brows_window.button_frame.close \
            -text {Ĥ} -command "destroy $top.brows_window"

    # ܥΥѥå
    pack $top.brows_window.button_frame.close \
            $top.brows_window.button_frame.save \
            $top.brows_window.button_frame.view \
            -side right

    # ΤΥѥå
    pack $top.brows_window.button_frame -side top -expand on -fill x
    pack $top.brows_window.text_frame -side top -expand on -fill both
    #lower $top.brows_window $top

    # եΥå
    focus $t

    # ƥȥå֤̾
    return $t
}
