#
#  edslfile.tcl -- ե
#                                                  by  ʰ 
#
#        If trouble, contact with Hidetoshi NAGAI (nagai@ai.kyutech.ac.jp)
#
#            Copyright (C) 1997  彣 󹩳 ǽ󹩳ز
#                                                     ʰ 
#                                                     ¼ 
#                                                     ¼ 

# ɥɽƥե򤹤
# 򤵤줿ե֤̾
#
#   w     : ɥΥȥåץ٥륦åȤΥѥ
#   title : ȥСʤɤɽʸ
#   flag  : Υե̾ɤΥե饰 ( 1:  0:ʤ )
#
proc SelectFile {w title flag} {
    global selected

    # åȤ
    toplevel $w
    wm title $w $title
    frame $w.frame
    label $w.frame.dir -text "ǥ쥯ȥꡧ"
    label $w.frame.pwd
    label $w.frame.file -text "ե̾"
    entry $w.frame.fileName -relief sunken -bd 2
    listbox $w.frame.fileList -relief sunken \
            -yscrollcommand "$w.frame.scrollbar set"
    scrollbar $w.frame.scrollbar -orient vertical -relief sunken \
            -command "$w.frame.fileList yview"
    
    button $w.select -width 10 -text "" -command "selectFile $w.frame $flag"
    button $w.cansel -width 10 -text "ä" -command {set selected {}}
    
    # åȤ
    pack $w.frame.dir -anchor w
    pack $w.frame.pwd -anchor w
    pack $w.frame.file -anchor w
    pack $w.frame.fileName -fill x 
    pack $w.frame.scrollbar -side right -fill y
    pack $w.frame.fileList -side left -fill x -expand 1
    
    pack $w.frame -side left -padx 10 -pady 10
    pack $w.select $w.cansel -padx 10 -pady 10
    
    # ꥹȥܥå򣱤ĤιܤǤʤ褦ˤ  
    #  tk_listboxSingleSelect $w.frame.fileList
    
    # åȤϢ
    # ꥹȥܥåå줿ȤνΥХ
    bind $w.frame.fileList <ButtonRelease-1> "showEntry $w.frame"  
    # ꥹȥܥå֥륯å줿ȤνΥХ
    bind $w.frame.fileList <Double-ButtonPress-1> "selectFile $w.frame $flag"
    # ȥReturnϤ줿ȤνΥХ
    bind $w.frame.fileName <Any-Return> "selectFile $w.frame $flag" 
    
    # ȥΥư褦ˤ
    bind $w.frame.fileName <Left> {
        %W select clear
        %W icursor [expr [%W index insert] -1]
        tk_entrySeeCaret %W
    }
    bind $w.frame.fileName <Right> {
        %W select clear
        %W icursor [expr [%W index insert] +1]
        tk_entrySeeCaret %W
    }
    
    # եɽ
    setFileList $w.frame 
    
    # ɥɽ֤η׻ɽ
    wm withdraw $w
    update idletasks
    set x [expr [winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \
            - [winfo vrootx [winfo parent $w]]]
    set y [expr [winfo screenheight $w]/2 - [winfo reqheight $w]/2 \
            - [winfo vrooty [winfo parent $w]]]
    wm geom $w +$x+$y
    wm deiconify $w
    
    # ֤ȥե
    set oldFocus [focus]
    grab $w
    focus $w.frame.fileName
    
    # ɥޥ͡㤫κؤб
    wm protocol $w WM_DELETE_WINDOW {set selected {}}
    
    # ե뤬򤵤ΤԤ
    tkwait variable selected
    
    # ե뤬򤵤줿顢ɥեִԤ򤷤
    # 򤵤줿ե֤̾
    destroy $w
    focus $oldFocus
    return $selected
}

# ɥɽι
# f     Ϣ륦åȤܤäƤե졼०åȤΥѥ
proc setFileList f {
    # ȥǥ쥯ȥ̾ɽ
    set pwd [pwd]
    # ѥʸʾäά
    if {[string length $pwd] > 30} {
        # ѥ "/" ʬΥƥꥹȤˤĹǧʤǸǤ
        # Ϣ뤹
        set list [split [string trim $pwd "/"] "/"]
        set len [llength $list]
        set prev ""
        for {set i $len} {1} {incr i -1} {
            # cur ˤϸߤǤޤǡprev ˤľǤޤǤϢ
            # ̤äƤ
            set elem [lindex $list [expr $i - 1]]
            set cur "$elem/$prev"
            # ߤǤޤǤϢη̤ʣ - "/.../"Ĺ
            # Ĺʤä
            if {[string length $cur] > 25} {
                # ľޤǤϢη̤ "/.../" Ϣ뤹
                # ܤǤƤˤϡ 
                # "/.../" Ϣ뤹
                if {$i == $len} {set prev $elem} 
                set pwd "/.../$prev"
                break;
            }
            set prev $cur
        }
    }
    # ٥˥ȥǥ쥯ȥΥѥɽ
    $f.pwd configure -text $pwd
    
    # եɽ
    # ȥȥꥹȥܥåƤΥꥢ
    $f.fileList delete 0 end
    $f.fileName delete 0 end
    
    # .* θ
    if [catch {set files [glob .*]}] {
        # .* ¸ߤʤ
        set files {}
    }
    
    # ¾Υեθ
    catch {set files [concat $files [lsort [glob *]]]} 
    
    # եꥹȥܥåɽ
    foreach file $files {
        # ֥ǥ쥯ȥä  "/" դ 
        if [file isdirectory $file] {set file $file/}
        $f.fileList insert end $file
    }
} 

# ꤵ줿ե򤹤
# f     Ϣ륦åȤܤäƤե졼०åȤΥѥ
# flag  Υե̾ɤΥե饰 ( 1:  0:ʤ )
proc selectFile {f flag} {
    global selected
    
    # ꤵ줿ե̾
    set name [$f.fileName get] 
    # ǥ쥯ȥǤ뤳Ȥ򼨤ˤĤ "/" Ϥ
    if {$name  != "/"} {
        set name [string trimright $name "/"]
    }
    # ꤵ줿Τǥ쥯ȥʤ
    if [file isdirectory $name] {
        #  cd ɽ򹹿
        cd $name
        setFileList $f
        return 
    }
    # ꤵ줿Τ¸Υե̾
    # Υե̾Ƥʤ
    if {[file exists $name] || $flag} {
        # ѿ selected 
        set selected $name
        return
    }
    # ꤵ줿Τ̵ʸξˤϥȥƤ򥯥ꥢ
    $f.fileName delete 0 end
}

# ꥹȥܥå򤵤Ƥܤ򥨥ȥɽ
# f     Ϣ륦åȤܤäƤե졼०åȤΥѥ
proc showEntry f {
    set index [$f.fileList curselection]
    if {$index == ""} return
    $f.fileName delete 0 end;
    $f.fileName insert 0 [$f.fileList get $index]
}
