#
# edserch.tcl -- ִ
#                                                  by  ʰ 
#
#        If trouble, contact with Hidetoshi NAGAI (nagai@ai.kyutech.ac.jp)
#
#            Copyright (C) 1997  彣 󹩳 ǽ󹩳ز
#                                                     ʰ 
#                                                     ¼ 
#                                                     ¼ 

# ѿν
#set direction "down"
#set searchCmd "searchDown"
#set replaceCmd "replaceDown"
#set selRange ""

# ֤ν
# t     ƥȥåȤΥѥ
# search ʸ 
# flag  ʸʸ̤뤫ɤΥե饰
proc searchDown {t search flag} {
    #global selRange
    #global moved
    upvar #0 edsearch:selRange:$t selRange
    upvar #0 edbind:moved:$t moved

    if {! [info exists selRange]} { set selRange "" }

    # ϰ֡ƥȤιԿμ
    scan [$t index insert] %d.%d line char
    scan [$t index end] %d numLines    
    # ʸʸζ̤򤷤ʤʤ鸡ʸʸѴ
    if !$flag {set search [kstring tolower $search]}
    # 쥯
    $t tag remove sel 1.0 end
    # ԤļФʤ鸡Ԥ
    for {set i $line} {$i <= $numLines} {incr i} {
        # ϥ֤ʬо
        if {$i == $line} {
            set string [$t get $i.$char "$i.0 lineend"]
            # ʳϣԴݤȼФ
        } else {
            set string [$t get $i.0 "$i.0 lineend"]
        }
        # ʸʸζ̤򤷤ʤʤ鸡оݤʸѴ
        if !$flag {set string [kstring tolower $string]}
        # ߤιԤ˰פʸ󤬤ʤлĤν򥹥å
        if {[set index [kstring first $search $string]] == -1} {
            continue
        }
        # פʸϰϤ򹭰ѿ
        # 쥯ꤷ򤽤ľ֤
        if {$i == $line} {incr index $char}
        set end [expr $index + [kstring length $search]]
        set selRange "$i.$index $i.$end"
        eval $t tag add sel $selRange
        $t mark set insert $i.$end  
        $t yview -pickplace insert
        set moved 1 
        return
    }
    # ǸιԤޤǸƤ⸫ĤʤϤλΤ
    tk_dialog .d Search "ʸ󤬰פޤ" {} 0 "λ"
}

# ֤ε 
# t     ƥȥåȤΥѥ
# search ʸ 
# flag  ʸʸ̤뤫ɤΥե饰
proc searchUp {t search flag} {
    #global selRange
    #global moved
    upvar #0 edsearch:selRange:$t selRange
    upvar #0 edbind:moved:$t moved

    if {! [info exists selRange]} { set selRange "" }

    # ϰ֤μ
    set range [$t tag nextrange sel 1.0]
    scan [$t index insert] %d.%d line char
    # ľ˸ǰפʸ󤬤ä
    if {$range != "" && $range == $selRange} {
        # 뤬ľˤʤ
        if [$t compare [lindex $range 1] == $line.$char] {
            # פʸƬоݤȤʤ
            scan $range %d.%d line char
        }
    } 
    # ʸʸζ̤򤷤ʤʤ鸡ʸʸѴ
    if !$flag {set search [kstring tolower $search]}
    # 쥯β
    $t tag remove sel 1.0 end
    for {set i $line} {$i > 0} {incr i -1} {
        # ϸϰ֤ʬФ
        if {$i == $line} {
            set string [$t get $i.0 $i.$char]
            # ʳϣԴݤȼФ
        } else {
            set string [$t get $i.0 "$i.0 lineend"]
        }
        # ʸʸζ̤򤷤ʤʤоݤʸѴ
        if !$flag {set string [kstring tolower $string]}
        # פʸ󤬸ĤʤлĤν򥹥å
        if {[set index [kstring last $search $string]] == -1} {
            continue
        }
        # פʸϰϤ򹭰ѿ
        # 쥯ꤷ򤽤ľ֤
        set end [expr $index + [kstring length $search]]
        set selRange "$i.$index $i.$end"
        eval $t tag add sel $selRange
        $t mark set insert $i.$end
        $t yview -pickplace insert
        set moved 1 
        # ĤǤ⸫Ĥнλ
        return
    }
    # ǸιԤޤǸƤ⸫ĤʤϤλΤ
    tk_dialog .d Search "ʸ󤬰פޤ" warning 0 "λ"
}

# serachDoun 뤤 searchUp Ĥʸִʸ
# ֤
# t     ƥȥåȤΥѥ
# replace ִʸ
proc replaceString {t replace} {
    #global selRange
    upvar #0 edsearch:selRange:$t selRange

    if {! [info exists selRange]} { set selRange "" }

    set range [$t tag nextrange sel 1.0]

    # ºݤΥ쥯ϰϤȸץ㤬¸ϰϤ
    # ʤнλ
    if {$range == "" || $range != $selRange} return
    # 뤬쥯ϰϤˤʤнλ
    if ![$t compare [lindex $selRange 1] == insert] return
    set first [lindex $selRange 0]
    set last [lindex $selRange 1]
    # ʸ֤
    $t delete $first $last
    $t insert $first $replace
    set last [$t index "$first + [kstring length $replace] c"]
    $t tag add sel $first $last
    set selRange "$first $last"
}

# ֤ƥޤǤΰִ 
# t     ƥȥåȤΥѥ
# search ʸ
# replace ִʸ
# flag  ʸʸ̤뤫ɤΥե饰
proc replaceDown {t search replace flag} {
    # ִϰ֤ȥƥȤιԿμ
    scan [$t index insert] %d.%d line char 
    scan [$t index end] %d numLines    
    # ʸʸ̤ʤʤ鸡ʸʸ
    if !$flag {
        set search [kstring tolower $search]
    }
    # ʸִʸĹƤ
    set ls [kstring length $search]
    set lr [kstring length $replace]
    set cnt 0
    for {set i $line} {$i <= $numLines} {incr i} {
        # ԼФ
        if {$i == $line} {
            set string [$t get $i.$char "$i.0 lineend"]
        } else {
            set string [$t get $i.0 "$i.0 lineend"]
        }
        # ʸʸ̤ʤʤФԤʸ
        if !$flag {
            set string [kstring tolower $string]
        }
        # פʸ󤬤ʤмιԤ˰ܤ
        if {[set index [kstring first $search $string]] == -1} {
            continue
        }
        # ǽιԤʤ饤ǥå
        if {$i == $line} {incr index $char}
        while 1 {
            # ʸ֤
            $t delete $i.[expr $index] $i.[expr $index+$ls]
            $t insert $i.[expr $index] $replace
            incr cnt
            # ԤƤʤϰϤФ
            set offset [expr $index +   $lr]
            set string [$t get $i.$offset "$i.0 lineend"]
            # ʸʸ̤ʤʤФϰϤʸ
            if !$flag {
                set string [kstring tolower $string]
            }
            # פʸ󤬤ʤмιԤ˰ܤ
            if {[set index [kstring first $search $string]]  == -1} {
                break
            }
            # ǥå
            incr index $offset 
        }
    }
    # ֤Ŀ𤹤
    tk_dialog .d Replace [format "%d Ĥʸ֤ޤ" $cnt] \
            warning 0 "λ"
}

# ֤ƥƬޤǤΰִ 
# t     ƥȥåȤΥѥ
# search ʸ
# replace ִʸ
# flag  ʸʸ̤뤫ɤΥե饰
proc replaceUp {t search replace flag} {
    #global selRange
    upvar #0 edsearch:selRange:$t selRange

    if {! [info exists selRange]} { set selRange "" }

    # ִϰ֤ȥƥȤιԿμ
    set range [$t tag nextrange sel 1.0]
    if {$range != "" && $range == $selRange} {
        scan [lindex $range 0] %d.%d line char
    } else {
        scan [$t index insert] %d.%d line char
    }
    # ʸʸ̤ʤʤ鸡ʸʸ
    if !$flag {
        set search [kstring tolower $search]
    }
    # ʸִʸĹƤ
    set ls [kstring length $search]
    set lr [kstring length $replace]
    set cnt 0
    for {set i $line} {$i > 0} {incr i -1} {
        # ԼФ
        if {$i == $line} {
            set string [$t get $i.0 $i.$char]
        } else {
            set string [$t get $i.0 "$i.0 lineend"]
        }
        # ʸʸ̤ʤʤФԤʸ
        if !$flag {
            set string [kstring tolower $string]
        }
        # פʸ󤬤ʤмιԤ˰ܤ
        if {[set index [kstring last $search $string]] == -1} {
            continue
        }
        while 1 {
            # ʸ֤
            $t delete $i.$index $i.[expr $index+$ls]
            $t insert $i.$index $replace
            incr cnt
            # ԤƤʤϰϤФ
            set string [$t get $i.0 $i.$index]
            # ʸʸ̤ʤʤФϰϤʸ
            if !$flag {
                set string [kstring tolower $string]
            }
            # פʸ󤬤ʤмιԤ˰ܤ
            if {[set index [kstring last $search $string]]  == -1} {
                break
            }
        }
    }
    # ֤Ŀ𤹤
    tk_dialog .d Replace [format "%d Ĥʸ֤ޤ" $cnt] \
            warning 0 "λ"
}

# ɥɽִǽ椹
# parent : ƥåȤΥѥ
# title  : ȥʸ
# t      : ƥȥåȤΥѥ
# flag   : ⡼ɤִ⡼ɤΥե饰 ( 0:  1:ִ )
proc SearchString {parent title t flag} {
    #global selRange
    #global searchString
    upvar #0 edfileop:fileName:$t fileName
    upvar #0 edsearch:selRange:$t selRange
    upvar #0 edsearch:searchString:$t searchString
    global edsearch:toplevel:$t
    global edsearch:check:$t
    global edsearch:direction:$t
    global edsearch:searchCmd:$t 
    global edsearch:replaceCmd:$t
    global edsearch:searchflag:$t

    if {! [info exists selRange]} { set selRange "" }
    if {! [info exists searchString]} { set searchString "" }

    # åȤ
    toplevel $parent.search_frame
    wm title $parent.search_frame $title
    frame $parent.search_frame.require
    set edsearch:toplevel:$t   $parent.search_frame
    set edsearch:searchflag:$t $flag

    frame $parent.search_frame.require.target
    label $parent.search_frame.require.target.label \
            -width 16 -text {оݥƥȡ}
    label $parent.search_frame.require.target.name -text $fileName

    frame $parent.search_frame.require.search
    label $parent.search_frame.require.search.label -width 16

    #entry $parent.search_frame.require.search.entry \
            -width 20 -bd 2 -relief sunken \
            -textvariable searchString
    entry $parent.search_frame.require.search.entry \
            -width 24 -bd 2 -relief sunken \
            -textvariable edsearch:searchString:$t

    frame $parent.search_frame.require.control
    frame $parent.search_frame.require.control.mode
    frame $parent.search_frame.require.control.button

    #checkbutton $parent.search_frame.require.case -relief flat \
            -text "ʸʸ̤" -variable check
    frame $parent.search_frame.require.control.mode.check \
            -relief groove -borderwidth 2
    checkbutton $parent.search_frame.require.control.mode.check.case \
            -relief flat -text "ʸʸ̤" \
            -variable edsearch:check:$t
    set edsearch:check:$t 1

    #radiobutton $parent.search_frame.require.up -relief flat \
            -text "ظä" -variable direction
    #radiobutton $parent.search_frame.require.down -relief flat \
            -text "ظä" -variable direction 
    frame $parent.search_frame.require.control.mode.up_down \
            -relief groove -borderwidth 2
    radiobutton $parent.search_frame.require.control.mode.up_down.up \
            -relief flat -text {ظä} \
            -value {up} -variable edsearch:direction:$t
    radiobutton $parent.search_frame.require.control.mode.up_down.down \
            -relief flat -text {ظä} \
            -value {down} -variable edsearch:direction:$t
    trace variable edsearch:direction:$t w {ChangeCmd}
    set edsearch:direction:$t {down}

    #button $parent.search_frame.next -width 14 -text "򸡺" -command \
            "\$searchCmd $t \$searchString \$check" 
    button $parent.search_frame.next \
            -width 14 -text "򸡺" -command \
            "\${edsearch:searchCmd:$t} $t \${edsearch:searchString:$t} \${edsearch:check:$t}" 

    #button $parent.search_frame.quit \
            -width 14 -text "λ" -command "destroy $parent.search_frame"
    button $parent.search_frame.quit \
            -width 14 -text "λ" -command \
            "trace vdelete edsearch:direction:$t w {ChangeCmd}; destroy $parent.search_frame"

    if $flag {
        frame $parent.search_frame.require.replace 
        label $parent.search_frame.require.replace.label \
                -width 16 -text "ִʸ"
        #entry $parent.search_frame.require.replace.entry \
                -width 20 -bd 2 -relief sunken \
                -textvariable replaceString
        #button $parent.search_frame.replace \
                -width 14 -text "֤" -command \
                "replaceString $t  \$replaceString; \$searchCmd $t \$searchString \$check"
        #button $parent.search_frame.all \
                -width 14 -text "֤" -command \
                "\$replaceCmd $t \$searchString \$replaceString \$check"
        entry $parent.search_frame.require.replace.entry \
                -width 24 -bd 2 -relief sunken \
                -textvariable edsearch:replaceString:$t
        button $parent.search_frame.replace \
                -width 14 -text "֤" -command \
                "replaceString $t  \${edsearch:replaceString:$t}; \${edsearch:searchCmd:$t} $t \${edsearch:searchString:$t} \${edsearch:check:$t}"
        button $parent.search_frame.all \
                -width 14 -text "֤" -command \
                "\${edsearch:replaceCmd:$t} $t \${edsearch:searchString:$t} \${edsearch:replaceString:$t} \${edsearch:check:$t}"
    }
    
    # åȤ  
    pack $parent.search_frame.require.target.label \
            $parent.search_frame.require.target.name -side left
    pack $parent.search_frame.require.target \
            -side top -anchor w -padx 15 -pady 7

    pack $parent.search_frame.require.search.label \
            $parent.search_frame.require.search.entry -side left
    pack $parent.search_frame.require.search \
            -side top -fill y -anchor w -padx 15 -pady 5

    pack $parent.search_frame.require.control.mode.up_down.up \
            -side top -anchor w -ipadx 0 -ipady 0 -padx 0 -pady 0
    pack $parent.search_frame.require.control.mode.up_down.down \
            -side top -anchor w -ipadx 0 -ipady 0 -padx 0 -pady 0

    pack $parent.search_frame.require.control.mode.check.case \
            -side top -anchor w -ipadx 0 -ipady 0 -padx 0 -pady 0

    pack $parent.search_frame.require.control.mode.check \
            $parent.search_frame.require.control.mode.up_down \
            -side top -fill x -pady 2

    pack $parent.search_frame.next \
            -in $parent.search_frame.require.control.button \
            -side top -padx 5 -pady 0
    pack $parent.search_frame.quit \
            -in $parent.search_frame.require.control.button \
            -side top -padx 5 -pady 0

    pack $parent.search_frame.require.control.mode \
            -side left -fill y -padx 5 -pady 5
    pack $parent.search_frame.require.control.button \
            -side right -fill y -padx 5 -pady 5

    if $flag {
        pack $parent.search_frame.require.replace.label \
                $parent.search_frame.require.replace.entry -side left
        pack $parent.search_frame.require.replace \
                -after $parent.search_frame.require.search \
                -anchor w -fill x -padx 15 -pady 5
        pack $parent.search_frame.replace $parent.search_frame.all \
                -after $parent.search_frame.next -padx 5 -pady 0
    }
    
    pack $parent.search_frame.require.control -anchor w -padx 5 -pady 5
    pack $parent.search_frame.require.control -fill both

    pack $parent.search_frame.require -side left -anchor n -padx 5 -pady 5


    # ʸѥȥդ٥λ
    if $flag {
        $parent.search_frame.require.search.label \
                configure -text "ִʸ"
    } else {
        $parent.search_frame.require.search.label \
                configure -text "ʸ"
    } 
    
    # ȥ Return Ϥ줿Ȥν
    bind $parent.search_frame.require.search.entry \
            <Any-Return> "$parent.search_frame.next invoke"
    if $flag {
        bind $parent.search_frame.require.replace.entry \
                <Any-Return> "$parent.search_frame.next invoke"
    }
    
    # 쥯β
    $t tag remove sel 1.0 end
    set selRange {}
    
    # ʸϤƤ뤫ǧ
    #checkSearch $parent.search_frame $flag dummy dummy dummy
    checkSearch edsearch:searchString:$t {} w
    # searchString 뤿Ӥ checkSerach ƤӽФ
    #trace variable searchString w "checkSearch $parent.search_frame $flag"
    trace variable searchString w "checkSearch"
    
    # ե  
    set oldFocus [focus]
    #focus $parent.search_frame
    focus $parent.search_frame.require.search.entry
    
    # ɥޤԤ
    tkwait window $parent.search_frame
    
    # searchString Υȥ졼
    #trace vdelete searchString w "checkSearch $parent.search_frame $flag"
    trace vdelete searchString w "checkSearch"
    
    # ե򸵤ΥåȤִԤ
    focus $oldFocus
}

# ʸϤƤ뤫ǧ
# trace ޥɤˤä searchString 뤿Ӥ˸ƤӽФ
# name1 name2 op : ȥ졼ѥ᡼
proc checkSearch {name1 name2 op} {
    #global searchString

    regexp {[^:]*$} $name1 t

    upvar #0 edsearch:toplevel:$t     w
    upvar #0 edsearch:searchString:$t searchString
    upvar #0 edsearch:searchflag:$t   flag
    
    if {! [info exists w]} { set w "" }
    if {! [info exists searchString]} { set searchString "" }
    if {! [info exists flag]} { set flag 0 }
    
    if {$searchString == ""} {
        $w.next configure -state disabled
        if $flag {
            $w.replace configure -state disabled
            $w.all configure -state disabled
        }
    } else { 
        $w.next configure -state normal
        if $flag {
            $w.replace configure -state normal
            $w.all configure -state normal
        }
    }
}

# ִץ촹
# trace ޥɤˤä 饸ܥϢưƤ direction 
# 뤿Ӥ˸ƤӽФ
# name1 name2 op : ȥ졼ѥ᡼
proc ChangeCmd {name1 name2 op} {
    #global direction searchCmd replaceCmd

    regexp {[^:]*$} $name1 t

    upvar #0 edsearch:direction:$t direction
    upvar #0 edsearch:searchCmd:$t searchCmd
    upvar #0 edsearch:replaceCmd:$t replaceCmd
    
    if {! [info exists direction]} {
        set direction  "down"
        set searchCmd  "searchDown"
        set replaceCmd "replaceDown"
    }

    if {$direction == "up"} {
        set searchCmd  "searchUp"
        set replaceCmd "replaceUp"
    } else {
        set searchCmd  "searchDown"
        set replaceCmd "replaceDown"
    }
}

# direction 줿 ChangeCmd ƤӽФ
#trace variable direction w {ChangeCmd}
