#
# edbind.tcl -- ƥȥåȤεǽ
#                                                   by  ʰ 
#
#        If trouble, contact with Hidetoshi NAGAI (nagai@ai.kyutech.ac.jp)
#
#            Copyright (C) 1997  彣 󹩳 ǽ󹩳ز
#                                                     ʰ 
#                                                     ¼ 
#                                                     ¼ 

# ѿν
#set moved 0
#set comeback ""
#set edbind:cut_buffer "" ; # ƥȥåȴ֤Ƕͭ륫åȥХåե

# ǤդΥǥå˰ư
# t     ư륫뤬ƥȥåȤΥѥ
# index ΰư
# flag  쥯ϰϤѹ뤫ɤ򼨤ե饰
proc SetCursor {t index flag} {
    #global moved
    upvar #0 edbind:moved:$t moved

    # ե饰ʥ쥯ϰϤѹؼ줿ˤʤ 
    if $flag {
        # 쥯¸ߤʤХΰ֤ anchor 򥻥åȤ
        if {[$t tag nextrange sel 1.0 end] == ""} {
            $t mark set anchor insert
        } 
        # 쥯ϰϤǧ
        if [$t compare $index < anchor] {
            set first $index
            set last anchor
        } else {
            set first anchor
            set last $index
        }
        # ϰϤˤ륻쥯
        $t tag remove sel 1.0 $first
        # ϰϤ򥻥쥯Ͽ
        $t tag add sel $first $last
        # ϰϤˤ륻쥯
        $t tag remove sel $last end
        # ե饰ʤ
    } else {
        # 쥯򤹤٤Ʋ
        $t tag remove sel 1.0 end
    }
    # ư
    $t mark set insert $index
    # ɽϰϤĴ
    $t yview -pickplace insert
    # GetLineIndex Ȥ빭ѿΥå
    if {! [info exists moved]} { set moved 0 }
    if {$moved == -1} {
        set moved 0
    } elseif {$moved == 0} {
        set moved 1
    }
}

# ιԴְưκݤ˰ưΥǥå
#
#  t : 뤬ƥȥåȤΥѥ
#  n : ưιԤŪ
#
proc GetLineIndex {t n} {
    #global moved
    #global comeback
    upvar #0 edbind:moved:$t moved
    upvar #0 edbind:comeback:$t comeback

    # ߤΥ֤Υǥå
    set i [$t index insert]
    scan $i "%d.%d" line char
    # ưιԤμ
    set line [expr $line + $n]
    # ԴְưʳΥưäƤ
    if {! [info exists moved]} { set moved 0 }
    if $moved {
        # ߤΥब٤֤ˤʤ
        set comeback $char
    }
    # ưΥǥå
    if {! [info exists comeback]} { set comeback 0 }
    set new [$t index $line.$comeback]
    # ưΥǥåƥȤϰϤˤʤ
    if {[$t compare $new > end] || [$t compare $new < 1.0]} {
        # ֤߰ΥǥåưȤƻȤ
        set new $i
    }
    # ưιԤûä
    if {[$t compare $new > "$line.0 lineend"]} {
        # ΥǥåưȤƻȤ
        set new [$t index "$line.0 lineend"]
    }
    # ΰưäɤ򼨤ե饰
    set moved -1

    return $new
}


# 쥯ϰϤˤʸХåե˥ԡ
# t     ƥȥåȤΥѥ
proc CopyString {t} {
    global edbind:cut_buffer

    set indeces [$t tag nextrange sel 1.0]
    if {$indeces == ""} return
    set edbind:cut_buffer [eval $t get $indeces]
}

# 쥯ϰϤʸХåե˥ԡ쥯
# t     ƥȥåȤΥѥ
proc CutString t {
    global edbind:cut_buffer

    set indeces [$t tag nextrange sel 1.0]
    if {$indeces == ""} {
        return
    }
    set edbind:cut_buffer [eval $t get $indeces]
    eval $t delete $indeces
}

# Хåեˤʸ򥫡֤
# t     ƥȥåȤΥѥ
proc PasteString t {
    global edbind:cut_buffer

    if {! [info exists edbind:cut_buffer]} { set edbind:cut_buffer "" }
    $t insert insert ${edbind:cut_buffer}
}

# ƥȥåȤԽǽζ
# t     ХɤƥȥåȤΥѥ
proc PowerUpText t {
    # Хɥꥹ
    #bindtags $t "$t Text . all"

    # Delete ǥΰ֤ʸ褦ѹ
    # ɸǤϥΣʸ
    bind $t <Delete> {
        %W delete insert
        %W yview -pickplace insert
    }

    # 쥯ꤵƤȤ Return ϤƤ
    # 쥯Ƥõ˲Ԥˤ롥
    bind Text <Any-Return> {
        selection clear %W
        %W insert insert "\n"
        break
    }

    # <ButtonPress-1> ˥ХɤԤᡢ
    # 饹ΥХɤ򥦥åȤ˰ܤ
    bind $t <ButtonPress-1> [bind Text <ButtonPress-1>]
    # ΰưäե饰򥻥åȤ
    bind $t <ButtonPress-1> {+set moved 1}

    # Ϥˤ륫ΰư  
#    bind $t <Left> {
#       SetCursor %W [%W index {insert - 1 chars}] 0
#    }
#    bind $t <Right> {
#       SetCursor %W [%W index {insert + 1 chars}] 0
#    }
#    bind $t <Up> {
#       SetCursor %W [GetLineIndex %W -1] 0
#    }
#    bind $t <Down> {
#       SetCursor %W [GetLineIndex %W 1] 0
#    }
    bind $t <Home> {
        SetCursor %W [%W index {insert linestart}] 0
    }
    bind $t <End> {
        SetCursor %W [%W index {insert lineend}] 0
    }
    bind $t <Control-Home> {
        SetCursor %W 1.0 0
    }
    bind $t <Control-End> {
        SetCursor %W end 0
    }

    # Ϥˤ륫ΰưȥ쥯ѹ
#    bind $t <Shift-Left> {
#       SetCursor %W [%W index {insert - 1 chars}] 1
#    }
#    bind $t <Shift-Right> {
#       SetCursor %W [%W index {insert + 1 chars}] 1
#    }
#    bind $t <Shift-Up> {
#       SetCursor %W [GetLineIndex %W -1] 1
#    }
#    bind $t <Shift-Down> {
#       SetCursor %W [GetLineIndex %W 1] 1
#    }
    bind $t <Shift-Home> {
        SetCursor %W [%W index {insert linestart}] 1
    }
    bind $t <Shift-End> {
        SetCursor %W [%W index {insert lineend}] 1
    }
    bind $t <Shift-Control-Home> {
        SetCursor %W 1.0 1
    }
    bind $t <Shift-Control-End> {
        SetCursor %W end 1
    }

    # ХåեȤäåȡڡ
    bind $t <Control-c> {
        CopyString %W
    }
    bind $t <Control-w> {
        CutString %W
    }
    bind $t <Control-y> {
        PasteString %W
    }

    # Ctrl-k ǤХåեȤ褦
    bind $t <Control-k> "
        $t tag del sel
        $t tag add sel insert {insert lineend}
        CopyString %W
    "
}


####################################################
# Խǽƥȥåȥե졼
####################################################
# 줿ƥȥå֤̾
#
# parent : ƥȥåȤޤƥå
#
proc EdText {parent} {
    global EdText_widgets

    # ե졼
    frame $parent.text_frame -bg lemonchiffon

    # СդƥȥåȤ
    double_scrolled_text $parent.text_frame 80 25
    upvar #0 TextViewMode:$parent.text_frame.text view_mode
    set view_mode {double}

    # ȥåץ٥¸
    upvar #0 edfileop:toplevel:$parent.text_frame.text top
    if {$parent == {}} {
        set top {.}
    } else {
        set top $parent
    }

    # ꥹȤؤɲ
    lappend EdText_widgets $parent.text_frame.text

    # ɥޥ͡㤫κؤб
    wm protocol . WM_DELETE_WINDOW {ExitApp $parent.text_frame.text}

    # ƥȥåȤԽǽζ
    PowerUpText $parent.text_frame.text

    # եν
    CreateNew $parent.text_frame.text

    # ƥȥå֤̾
    return $parent.text_frame.text
}


####################################################
# ƥȥåȤɽ⡼ѹ
#
# ⡼ѹ򤹤ƥȥåȤ
# double_scrolled_text Ǻ줿ƥȥåȤǤʤФʤʤ
#
#  text : ƥȥå
#  mode : ⡼ɤ
#           single -> ĥΤ
#           double -> Ĳ
# 
proc TextViewMode {text mode} {
    upvar #0 TextViewMode:$text orig_mode

    # ѹ꤫
    if {$orig_mode == $mode} {
        # ѹʤ
        return
    }

    # ѹ
    set orig_mode $mode

    # Сޤե졼०å̾γ
    regsub {text$} $text {pad} h_scroll_pad

    # ĥСå̾γ
    regsub {text$} $text {sy}  v_scroll

    # ⡼ɤѹ
    if {$mode == {single}} {
        # ĥ⡼ɤѹ
        $text configure -wrap {char} ; # wrap mode 

        # Сɽѹ
        pack forget $h_scroll_pad

    } else {
        # Ĳ⡼ɤѹ
        $text configure -wrap {none} ; # wrap mode 

        # Сɽѹ
        pack $h_scroll_pad -side bottom -fill x -before $v_scroll

    }
}
