#
# jsax η̤ɽ뤿Υץ
#                                               by  ʰ 
#
#        If trouble, contact with Hidetoshi NAGAI (nagai@ai.kyutech.ac.jp)
#
#            Copyright (C) 1997  彣 󹩳 ǽ󹩳ز
#                                                     ʰ 
#                                                     ¼ 
#                                                     ¼ 

# Ϸ̤뤿ΥХѿ
if {[info exists JSAX_RESULT_LIST] == 0} {
    set JSAX_RESULT_LIST {}
}


# Ϸ̤ơ֥ (JSAX_RESULT_TABLE) ˳Ǽץ
proc jsax_result_list_to_table {} {
    global SELECTED_RESULT_NUMBER
    global JSAX_RESULT_LIST
    global JSAX_RESULT_TABLE

    # ¤ʬɽ
    append f_struct_regexp \
            {^F-struct:([^} "\n" {]+)} "\n" \
            {[^} "\n" {]+} "\n" \
            {(.+)$}

    # ϷɽΥꥢ
    set JSAX_RESULT_TABLE(ready) 0 ; \
            # ѿ 0 ǤȤϲϷɽͭǡʤ \
            #  1 ΤȤ JSAX ľܽϤȤƤΥǡݻ \
            # -1 ΤȤ;ʬʥǡݻƤ
    
    set JSAX_RESULT_TABLE(ambiguity) 0
    set JSAX_RESULT_TABLE(morph) "\n"  ; # ԤΥߡ
    append JSAX_RESULT_TABLE(morph) {ϼ}
    set JSAX_RESULT_TABLE(morph_time) {}
    set JSAX_RESULT_TABLE(morph_list) {}
    set JSAX_RESULT_TABLE(f_struct:lst:0) {ϼ}
    set JSAX_RESULT_TABLE(f_struct:tbl:0) {ϼ}
    set JSAX_RESULT_TABLE(syntactic_tree:0) {ϼ}
    set JSAX_RESULT_TABLE(start_sym_param:0) {ϼ}
    set JSAX_RESULT_TABLE(syntactic_time) {}

    # Ϸ̤θ
    if {$JSAX_RESULT_LIST == {}} return

    # Ϸ̤ʬ
    set cnt -1
    foreach item $JSAX_RESULT_LIST {
        # ʤ齪λ
        if {$item == {}} break

        # ֹ
        incr cnt

        # ǲϷ(Ѥ)
        if {$cnt == 0} {
            # ԤΤξϲϼ
            if {[lindex [split $item "\n"] 1] == {}} {
                # ǲϼ
                set cnt 0
                break
            }
            set JSAX_RESULT_TABLE(morph) $item
            continue
        }

        # ǲϻ
        if {$cnt == 1} {
            set JSAX_RESULT_TABLE(morph_time) $item
            if {[regexp {^ǲϻ} $item] == 0} {
                # ǲϼ
                set cnt 0
                break
            }
            continue
        }

        # ǥꥹ
        if {$cnt == 2 && ![regexp $f_struct_regexp $item match lst tbl]} {
            set JSAX_RESULT_TABLE(morph_list) $item
            continue
        }

        # ¤
        if [regexp $f_struct_regexp $item match lst tbl] {
            set num [incr JSAX_RESULT_TABLE(ambiguity)]
            set JSAX_RESULT_TABLE(f_struct:lst:$num) $lst
            set JSAX_RESULT_TABLE(f_struct:tbl:$num) $tbl
            continue
        }

        # ʸϷ or ϵѥ᡼
        if {$cnt < 3 * $JSAX_RESULT_TABLE(ambiguity) + 3} {
            set num [expr $cnt - $JSAX_RESULT_TABLE(ambiguity) - 1]
            if {$num % 2 == 0} {
                set JSAX_RESULT_TABLE(syntactic_tree:[expr int($num/2)]) $item
            } else {
                set JSAX_RESULT_TABLE(start_sym_param:[expr int($num/2)]) $item
            }
            continue
        }

        # ʸϼ¹Ի
        if {$cnt == 3 * $JSAX_RESULT_TABLE(ambiguity) + 3} {
            set JSAX_RESULT_TABLE(syntactic_time) $item
            continue
        }
    }

    # ܿγǧ
    if {$cnt < 3} {
        # ǲϼ
        set JSAX_RESULT_TABLE(morph) "\n"  ; # ԤΥߡ
        append JSAX_RESULT_TABLE(morph) {ϼ}

    } elseif {$cnt <= 4} {
        # ʸϼ
        set JSAX_RESULT_TABLE(ambiguity) 0
        set JSAX_RESULT_TABLE(syntactic_time) \
                $JSAX_RESULT_TABLE(f_struct:lst:0)
        set JSAX_RESULT_TABLE(f_struct:lst:0) {ϼ}
        set JSAX_RESULT_TABLE(f_struct:tbl:0) {ϼ}
        set JSAX_RESULT_TABLE(syntactic_tree:0) {ϼ}
        set JSAX_RESULT_TABLE(start_sym_param:0) {ϼ}

    } elseif {$cnt > 3 * $JSAX_RESULT_TABLE(ambiguity) + 3} {
        # ϰ۾
        set JSAX_RESULT_TABLE(ambiguity) 0
        set JSAX_RESULT_TABLE(f_struct:lst:0) {ϰ۾}
        set JSAX_RESULT_TABLE(f_struct:tbl:0) {ϰ۾}
        set JSAX_RESULT_TABLE(syntactic_tree:0) {ϰ۾}
        set JSAX_RESULT_TABLE(start_sym_param:0) {ϰ۾}

    }

    # ֹ
    if {$JSAX_RESULT_TABLE(ambiguity) == 0} {
        set OLD_SELECTED_RESULT_NUMBER 0
        set SELECTED_RESULT_NUMBER $OLD_SELECTED_RESULT_NUMBER
    } else {
        set OLD_SELECTED_RESULT_NUMBER 1
        set SELECTED_RESULT_NUMBER $OLD_SELECTED_RESULT_NUMBER
    }

    # ơ֥ؤ괰λ
    set JSAX_RESULT_TABLE(ready) 1
}


# ơ֥˳Ǽ줿Ϸ̤Ϥץ (ƥ)
proc print_jsax_result_table {} {
    global JSAX_RESULT_TABLE

    puts "=============================================================="
    puts $JSAX_RESULT_TABLE(morph)
    puts "--------------------------------------------------------------"
    puts $JSAX_RESULT_TABLE(morph_list)
    puts "--------------------------------------------------------------"
    puts $JSAX_RESULT_TABLE(morph_time)
    puts "=============================================================="
    puts "ʸۣ : $JSAX_RESULT_TABLE(ambiguity)"
    puts "=============================================================="
    for {set cnt 1} {$cnt <= $JSAX_RESULT_TABLE(ambiguity)} {incr cnt} {
        puts $JSAX_RESULT_TABLE(f_struct:lst:$cnt)
        puts "--------------------------------------------------------------"
        puts $JSAX_RESULT_TABLE(f_struct:tbl:$cnt)
        puts "--------------------------------------------------------------"
        puts $JSAX_RESULT_TABLE(syntactic_tree:$cnt)
        puts "=============================================================="
    }
    puts $JSAX_RESULT_TABLE(syntactic_time)
    puts "=============================================================="
}


# Υꥢ(ǧդ)
#   txt : jsax ΥɽƤƥȥå
proc jsax_log_clear {txt} {
    if {[$txt get 1.0 {end - 1 char}] == {}} {
        set result 0
    } else {
        set result \
                [tk_dialog .d dialog "򤹤٤ƾõƤ⤫ޤޤ󤫡" \
                warning 1 "Ϥ" ""]
    }
    if {$result == 0} {
        $txt delete 1.0 end
    }
}


# ɽ widget 
# 줿ƥȥå֤̾
#
#   parent : ƥå
#
proc generate_jsax_log_widget {parent} {
    # ¸ߥå
    set top $parent.jsax_log
    if {[info commands $top] == "$top"} {
        # ¸ߤ  ƥȤ򥯥ꥢ
        $parent.jsax_log.text_frame.text delete 1.0 end
        return $parent.jsax_log.text_frame.text
    }

    # ȥåץ٥
    toplevel $parent.jsax_log

    # ƥȥե졼
    frame $parent.jsax_log.text_frame
    set t [scrolled_text $parent.jsax_log.text_frame 80 25]

    # ܥե졼
    frame $parent.jsax_log.button_frame
    button $parent.jsax_log.button_frame.iconify \
            -text {} -command "wm iconify $parent.jsax_log" 

    button $parent.jsax_log.button_frame.clear \
            -text { ꥢ } -command "jsax_log_clear $t"

    button $parent.jsax_log.button_frame.save \
            -text {  ¸ } -command "WriteTextWidgetContents $t" 

    # ѥå
    pack $parent.jsax_log.button_frame.save \
            $parent.jsax_log.button_frame.clear \
            $parent.jsax_log.button_frame.iconify \
            -side right -ipadx 0 -ipady 0 -padx 0 -pady 0
    pack $parent.jsax_log.button_frame \
            -side top -expand on -fill x -ipadx 0 -ipady 0  -padx 0 -pady 0
    pack $parent.jsax_log.text_frame -side top -expand on -fill both

    # λ
    return $t
}


# Ϸɽ widget 
#   parent : ƥå
proc generate_jsax_result_widget {parent} {
    global TEXT_WIDGET_DEFAULT_WIDTH
    global TEXT_WIDGET_DEFAULT_HEIGHT
    global JSAX_RESULT_TABLE
    global MORPH_RESULT_WIDGET
    global F_STRUCT_WIDGET
    global SYNTACTIC_TREE_WIDGET
    global SELECTED_RESULT_NUMBER
    global OLD_SELECTED_RESULT_NUMBER
    global TOTAL_AMBIGUITY_LABEL
    global JSAX_DISP_MORPH
    global JSAX_DISP_SYNTAX
    global JSAX_DISP_F_STRUCT

    # ƥȥåȤΥǥեȥ
    set TEXT_WIDGET_DEFAULT_WIDTH   60
    set TEXT_WIDGET_DEFAULT_HEIGHT  10

    # ǲϷ̥ե졼
#    frame $parent.morph -borderwidth 4 -relief groove
    toplevel $parent.morph
    label $parent.morph.title -text {ǲϷ}
    frame $parent.morph.f
    set MORPH_RESULT_WIDGET \
            [double_scrolled_text $parent.morph.f \
                    $TEXT_WIDGET_DEFAULT_WIDTH $TEXT_WIDGET_DEFAULT_HEIGHT ]
    pack $parent.morph.title -side top -anchor center -expand false
    pack $MORPH_RESULT_WIDGET -side bottom -expand true -fill both
    if {$JSAX_DISP_MORPH == 1} {
        pack $parent.morph.f -expand true -fill both
    } else {
        wm withdraw $parent.morph
    }
    update

    # ʸϷ̥ե졼
#    frame $parent.syntactic -borderwidth 4 -relief groove
    toplevel $parent.syntactic
    label $parent.syntactic.title -text {ʸϷ}

    # ʸϷɽȥѥͥ
    frame $parent.syntactic.control -borderwidth 2 -relief groove
#    button $parent.syntactic.control.pre_result \
#           -text {} -command {incr SELECTED_RESULT_NUMBER -1}
#    button $parent.syntactic.control.next_result \
#           -text {} -command {incr SELECTED_RESULT_NUMBER 1}
    button $parent.syntactic.control.pre_result -text {} \
            -command {incr SELECTED_RESULT_NUMBER -1 ; redraw_jsax_result}
    button $parent.syntactic.control.next_result -text {} \
            -command {incr SELECTED_RESULT_NUMBER 1 ; redraw_jsax_result}
    frame $parent.syntactic.control.f
    label $parent.syntactic.control.f.title -text {ɽ:}
    entry  $parent.syntactic.control.f.selected \
            -textvariable SELECTED_RESULT_NUMBER \
            -justify right -width 6
    set TOTAL_AMBIGUITY_LABEL \
            [label $parent.syntactic.control.f.ambiguity \
                          -text "/$JSAX_RESULT_TABLE(ambiguity)"]
    pack $parent.syntactic.control.pre_result \
            -side left -expand false -anchor w
    pack $parent.syntactic.control.f.title \
            -side left -expand true -anchor e
    pack $parent.syntactic.control.f.selected \
            -side left -expand false -anchor e
    pack $parent.syntactic.control.f.ambiguity \
            -side left -expand true -anchor w
    pack $parent.syntactic.control.f \
            -side left -expand true -anchor center
    pack $parent.syntactic.control.next_result \
            -side right -expand false -anchor e

    # ¤ɽե졼
    frame $parent.syntactic.f_struct
    label $parent.syntactic.f_struct.title -text {¤ɽ}
    frame $parent.syntactic.f_struct.f
    set F_STRUCT_WIDGET \
            [double_scrolled_text $parent.syntactic.f_struct.f \
                    $TEXT_WIDGET_DEFAULT_WIDTH $TEXT_WIDGET_DEFAULT_HEIGHT ]
    pack $parent.syntactic.f_struct.title \
            -side top -anchor center -expand false
    pack $F_STRUCT_WIDGET -side bottom -expand true -fill both
    pack $parent.syntactic.f_struct.f -expand true -fill both

    # ʸɽե졼
    frame $parent.syntactic.syntactic_tree
    label $parent.syntactic.syntactic_tree.title -text {ʸɽ}
    frame $parent.syntactic.syntactic_tree.f
    set SYNTACTIC_TREE_WIDGET \
            [double_scrolled_text $parent.syntactic.syntactic_tree.f \
                    $TEXT_WIDGET_DEFAULT_WIDTH $TEXT_WIDGET_DEFAULT_HEIGHT ]
    pack $parent.syntactic.syntactic_tree.title \
            -side top -anchor center -expand false
    pack $SYNTACTIC_TREE_WIDGET -side bottom -expand true -fill both
    pack $parent.syntactic.syntactic_tree.f -expand true -fill both

    # ʸϷ̥ե졼Υѥå
    if {$JSAX_DISP_SYNTAX == 1 || $JSAX_DISP_F_STRUCT == 1} {
        pack $parent.syntactic.title -side top -anchor center -expand false
        pack $parent.syntactic.control -side top -expand false -fill x
        if {$JSAX_DISP_F_STRUCT == 1} {
            pack $parent.syntactic.f_struct -side top -expand true -fill both
        }
        if {$JSAX_DISP_SYNTAX == 1} {
            pack $parent.syntactic.syntactic_tree -side top \
                    -expand true -fill both
        }
    } else {
        wm withdraw $parent.syntactic
    }

    update

    # Υե졼Υѥå
#    pack $parent.morph -side top -expand true -fill both
#    pack $parent.syntactic -side top -expand true -fill both

    # ֹ
    if {$JSAX_RESULT_TABLE(ambiguity) == 0} {
        set OLD_SELECTED_RESULT_NUMBER 0
        set SELECTED_RESULT_NUMBER $OLD_SELECTED_RESULT_NUMBER
    } else {
        set OLD_SELECTED_RESULT_NUMBER 1
        set SELECTED_RESULT_NUMBER $OLD_SELECTED_RESULT_NUMBER
    }

    # Х
    # trace variable SELECTED_RESULT_NUMBER w redraw_jsax_result
    bind $parent.syntactic.control.f.selected <Any-Return> {redraw_jsax_result}
}


# Ϸɽ widget ѹ
#   parent : ƥå
proc redraw_jsax_result_widget {{parent {}}} {
    global JSAX_DISP_MORPH
    global JSAX_DISP_SYNTAX
    global JSAX_DISP_F_STRUCT
    global JSAX_RESULT_CONVERT_MODE
    global OLD_JSAX_RESULT_CONVERT_MODE

    # Ʊߡ⡼ɤ
    if {$JSAX_RESULT_CONVERT_MODE != $OLD_JSAX_RESULT_CONVERT_MODE} {
        # ۤʤ  
        redraw_jsax_result
    }

    # ǲϷ̥ե졼बǤ˺Ƥ뤫
    set widget $parent.morph.f 
    if {[info commands $widget] == $widget} {
        if {$JSAX_DISP_MORPH == 1} {
            wm deiconify $parent.morph
            pack $parent.morph.f -expand true -fill both
        } else {
            wm withdraw $parent.morph
            pack forget $parent.morph.f
        }
    }

    # ʸϷ̥ե졼बǤ˺Ƥ뤫
    set widget $parent.syntactic.title
    if {[info commands $widget] == $widget} {
        if {$JSAX_DISP_SYNTAX == 1 || $JSAX_DISP_F_STRUCT == 1} {
            wm deiconify $parent.syntactic
            pack $parent.syntactic.title -side top -anchor center -expand false
            pack $parent.syntactic.control -side top -expand false -fill x
            if {$JSAX_DISP_F_STRUCT == 1} {
                pack $parent.syntactic.f_struct \
                        -side top -expand true -fill both
            } else {
                pack forget $parent.syntactic.f_struct
            }
            if {$JSAX_DISP_SYNTAX == 1} {
                pack $parent.syntactic.syntactic_tree \
                        -side top -expand true -fill both
            } else {
                pack forget $parent.syntactic.syntactic_tree
            }
        } else {
            wm withdraw $parent.syntactic
            pack forget $parent.syntactic.title
            pack forget $parent.syntactic.control
            pack forget $parent.syntactic.f_struct
            pack forget $parent.syntactic.syntactic_tree
        }
    }
}


# ƥȥåȤؤβϷ̤ν
proc display_jsax_result {} {
    global TEXT_WIDGET_DEFAULT_WIDTH
    global TEXT_WIDGET_DEFAULT_HEIGHT
    global JSAX_RESULT_CONVERT_MODE
    global OLD_JSAX_RESULT_CONVERT_MODE
    global JSAX_RESULT_TABLE
    global MORPH_RESULT_WIDGET
    global F_STRUCT_WIDGET
    global SYNTACTIC_TREE_WIDGET
    global SELECTED_RESULT_NUMBER
    global OLD_SELECTED_RESULT_NUMBER
    global TOTAL_AMBIGUITY_LABEL

    # ̥Сȥ⡼
    if {![info exists JSAX_RESULT_CONVERT_MODE]} {
        set JSAX_RESULT_CONVERT_MODE 1
        set OLD_JSAX_RESULT_CONVERT_MODE 1
    }

    # ۣ椵
    $TOTAL_AMBIGUITY_LABEL configure -text "/$JSAX_RESULT_TABLE(ambiguity)"

    # ǲϷ̤ν
    $MORPH_RESULT_WIDGET delete 0.0 end ; # ꥢ
    $MORPH_RESULT_WIDGET insert end $JSAX_RESULT_TABLE(morph)
    if {$JSAX_RESULT_TABLE(ready) >= 0 && $JSAX_RESULT_CONVERT_MODE == 1} {
        # ʸƬޡȤƤΥܤκ
        $MORPH_RESULT_WIDGET delete 1.0 "1.end + 1 chars"
    }
    $MORPH_RESULT_WIDGET delete "end - 1 chars" ; # ;ʬʶԤκ

    # ʸϷ̤ν
    # ¤ν
    $F_STRUCT_WIDGET delete 0.0 end ; # ꥢ
    $F_STRUCT_WIDGET insert end \
            $JSAX_RESULT_TABLE(f_struct:tbl:$SELECTED_RESULT_NUMBER)
    $F_STRUCT_WIDGET delete "end - 1 chars"; # ;ʬʶԤκ

    # ڹ¤ν
    $SYNTACTIC_TREE_WIDGET delete 0.0 end ; # ꥢ
    if {$JSAX_RESULT_TABLE(ready) >= 0 && $JSAX_RESULT_CONVERT_MODE == 1} {
        # ʸƬޡȤƤΥܤκ
        set tree [remove_tag_from_tree \
                $JSAX_RESULT_TABLE(syntactic_tree:$SELECTED_RESULT_NUMBER)]
    } else {
        set tree $JSAX_RESULT_TABLE(syntactic_tree:$SELECTED_RESULT_NUMBER)
    }
    $SYNTACTIC_TREE_WIDGET insert end $tree
    $SYNTACTIC_TREE_WIDGET delete "end - 1 chars"; # ;ʬʶԤκ
}


# ڹ¤ʸƬޡȤƤΥܤκ
# ʸƬޡȤƤΥڹ¤ƥȤ֤
#
#   tree_with_head_tag : ʸƬޡȤƤΥޤڹ¤ƥ
#
proc remove_tag_from_tree {tree_with_head_tag} {
    # ñ̤ʬ
    set lines [split $tree_with_head_tag "\n"]

    # ʬκӹƬǽγ
    set tree_tmp {}
    set trim_str {                                    }
    set cnt 0
    foreach line $lines {
        incr cnt

        # Ƭ 2 Ԥ  ˡΧʸ  ʤΤ̵
        #                 |   
        if {$cnt < 3} continue

        # 3 ܤˤϥиΤǡ----------- ʬִ
        if {$cnt == 3} {
            # ޥåʬγȡؤִ
            regexp {^ *-+} $line match
            regsub -all {.} $match { } replace
            regsub {^ *-+} $line $replace new_line

            # Ƭ 2 Ԥ  ˡΧʸ  
            #                 |   
            set ll $new_line
            regsub -all {.} $ll { } lx
            set leader [string range $lx 0 \
                    [expr ([string length $lx] \
                          + [string length $replace]) / 2 - 4]]
            lappend tree_tmp "${leader}ˡΧʸ"
            lappend tree_tmp "${leader}   |"

            # 3 ܤ
            lappend tree_tmp "${new_line}"

            continue
        }

        # 4 ܰʹ
        # ޥåʬγȡؤִ
        if {[regexp {^ *[^ ]+ } $line match] == 0} {
            # ޥåʤС񤭴
            continue
        }
        regsub -all {.} $match { } replace
        regsub {^ *[^ ]+ } $line $replace new_line

        # ǽƬ̤γ
        regexp {^ *} $new_line match
        if {[string length $trim_str] > [string length $match]} {
            set trim_str $match
        }

        # Ԥ
        lappend tree_tmp "${new_line}"
    }

    # ڤν
    set tree {}
    foreach line $tree_tmp {
        regsub "^$trim_str" $line {} trim_line
        append tree "$trim_line\n"
    }

    # λ
    return $tree
}


# trace ѥߡץ
proc null_operation {name1 name2 op} {
    return
}

# Ϸ̸ɽԤץ
proc redraw_jsax_result {} {
    global SELECTED_RESULT_NUMBER
    global OLD_SELECTED_RESULT_NUMBER
    global JSAX_RESULT_CONVERT_MODE
    global OLD_JSAX_RESULT_CONVERT_MODE
    global JSAX_RESULT_TABLE

    # Ʊֹ椫
    if {$SELECTED_RESULT_NUMBER == $OLD_SELECTED_RESULT_NUMBER} {
        # Ʊߡ⡼ɤ
        if {$JSAX_RESULT_CONVERT_MODE == $OLD_JSAX_RESULT_CONVERT_MODE} {
            # Ʊ  ⤷ʤǤΤޤ
            return
        }
    }

    # ͭʸ䤬¸ߤ뤫
    if {$JSAX_RESULT_TABLE(ambiguity) == 0} {
        # ʤ  ѹԲǽ
        set OLD_SELECTED_RESULT_NUMBER 0
        set SELECTED_RESULT_NUMBER $OLD_SELECTED_RESULT_NUMBER
        return
    }

    # 󥸥ȥå
    if {$SELECTED_RESULT_NUMBER < 1} {
        # 
        set SELECTED_RESULT_NUMBER $OLD_SELECTED_RESULT_NUMBER
        return
    } elseif {$SELECTED_RESULT_NUMBER > $JSAX_RESULT_TABLE(ambiguity)} {
        # 礭
        set SELECTED_RESULT_NUMBER $OLD_SELECTED_RESULT_NUMBER
        return
    }

    # ɽ
    display_jsax_result    
    set OLD_SELECTED_RESULT_NUMBER $SELECTED_RESULT_NUMBER
    set OLD_JSAX_RESULT_CONVERT_MODE $JSAX_RESULT_CONVERT_MODE
}


##########################################################################
# Ϸ̾ (JSAX_RESULT_TABLE ˤƤ) 
# ե˽Ϥ
#
#   output_result_num_list : ϤֹΥꥹ (ʤ顤)
#   mode : 1 ʤ顤ˡΧʸ¸ǥǤβϤˤơ
#          ¤ϥߥΤΡ֥פɽ
#
proc write_jsax_result {{output_result_num_list {}}} {
    global JSAX_RESULT_TABLE

    global JSAX_SAVE_FILENAME
    global JSAX_SAVE_OVERWRITE_MODE

    global JSAX_RESULT_CONVERT_MODE
    global OLD_JSAX_RESULT_CONVERT_MODE

    global JSAX_SAVE_ALL_MODE
    global JSAX_SAVE_SENTENCE
    global JSAX_SAVE_MORPH
    global JSAX_SAVE_MORPH_TIME
    global JSAX_SAVE_MORPH_LIST
    global JSAX_SAVE_F_STRUCT_LIST
    global JSAX_SAVE_F_STRUCT
    global JSAX_SAVE_SYNTAX
    global JSAX_SAVE_START_SYM_PARAM
    global JSAX_SAVE_SYNTAX_TIME

    global JSAX_SAVE_SENTENCE_READY
    global JSAX_SAVE_MORPH_READY
    global JSAX_SAVE_MORPH_TIME_READY
    global JSAX_SAVE_MORPH_LIST_READY
    global JSAX_SAVE_F_STRUCT_LIST_READY
    global JSAX_SAVE_F_STRUCT_READY
    global JSAX_SAVE_SYNTAX_READY
    global JSAX_SAVE_START_SYM_PARAM_READY
    global JSAX_SAVE_SYNTAX_TIME_READY

    # ̥Сȥ⡼
    if {![info exists JSAX_RESULT_CONVERT_MODE]} {
        set JSAX_RESULT_CONVERT_MODE 1
        set OLD_JSAX_RESULT_CONVERT_MODE 1
    }

    # ϵϽϤʤ
    set JSAX_SAVE_START_SYM_PARAM 0

    # ơ֥˾֤åȤƤ뤫
    if {![info exists JSAX_RESULT_TABLE(ready)]} {
        tk_dialog .d dialog \
                "Ϸ̤ޤߤƤʤᡢ¸Ǥޤ󡣲Ϥμ¹ԤˤäơϷ̤ߤ¸ԤäƤ" \
                warning 0 "λ"
        return
    } elseif {$JSAX_RESULT_TABLE(ready) == 0} {
        tk_dialog .d dialog \
                "ͭʲϷ̤ߤƤʤᡢ¸Ǥޤ󡣲Ϥμ¹ԤʤɤˤäơͭʲϷ̤ߤ¸ԤäƤ" \
                warning 0 "λ"
        return
    }

    # ¸Ƥ̵ͭγǧ
    if { $JSAX_SAVE_ALL_MODE != {all} \
            && $JSAX_SAVE_SENTENCE == 0 \
            && $JSAX_SAVE_MORPH == 0 \
            && $JSAX_SAVE_MORPH_TIME == 0 \
            && $JSAX_SAVE_MORPH_LIST == 0 \
            && $JSAX_SAVE_F_STRUCT_LIST == 0 \
            && $JSAX_SAVE_F_STRUCT == 0 \
            && $JSAX_SAVE_SYNTAX == 0 \
            && $JSAX_SAVE_START_SYM_PARAM == 0 \
            && $JSAX_SAVE_SYNTAX_TIME == 0 } {
        tk_dialog .d dialog \
                "¸褦˻ꤵ줿ޤ󡣾ʤȤĤξ¸褦˻ꤷ¸¹ԤƤ" \
                warning 0 "λ"
        return
    }

    # ¸ե̾Υå
    if {![info exists JSAX_SAVE_FILENAME]} {
        set JSAX_SAVE_FILENAME {}
        set JSAX_SAVE_OVERWRITE_MODE {w}
    }
    if {$JSAX_SAVE_FILENAME == {}} {
        # ե顼򳫤ե̾׵᤹
        if {[set file [SelectFile .selfile "Save File" 1]] == ""} {
            tk_dialog .d dialog "ե뤬򤵤ޤǤ" \
                    warning 0 "λ"
            return 0
        }

        # ¸Υեʤ񤭤뤫ǧ
        set overwrite 0
        if [file exists $file] {
            set overwrite [tk_dialog .d dialog "ե뤬¸ߤƤޤ
            񤭤ޤ" \
                    warning 1 "Ϥ" "" "¸եɲ"]
            if {$overwrite == 1} {return 0}
        }

        # ե뤬¸ߤ뤬񤭹ԲĤξˤϤλΤ
        if {[file exist $file] && ![file writable $file]} {
            tk_dialog .d dialog "ե˽񤭹ޤ" warning 0 "λ"
            return 0
        }

        # եλ꤬ȥǥ쥯ȥ꤫ŪʤΤʤ
        # ХѥѴ
        if ![kstring match {[/~]*} $file] {
            if {[pwd] == "/"} {
                set file /$file
            } else {
                set file [pwd]/$file
            }
        }

        # ե̾񤭹ߥ⡼ɤꤹ
        set JSAX_SAVE_FILENAME $file
        if {$overwrite == 0} {
            # 񤭥⡼
            set JSAX_SAVE_OVERWRITE_MODE {w}
        } else {
            # ɵ⡼
            set JSAX_SAVE_OVERWRITE_MODE {a}
        }
    }

    # եΥץ
    set fd [open $JSAX_SAVE_FILENAME $JSAX_SAVE_OVERWRITE_MODE]

    # إåν
    puts $fd {<Ϸ>}

    # оʸ
    if {$JSAX_SAVE_ALL_MODE == {all} || $JSAX_SAVE_SENTENCE == 1} {
        if {$JSAX_RESULT_TABLE(ready) == -1 \
                && $JSAX_SAVE_SENTENCE_READY == 0} {
            tk_dialog .d dialog \
                    "оʸ¸褦˻ꤵƤޤɽΥեξˤͭʥǡޤޤƤޤ󡣤äơξϽϤޤ" \
                    warning 0 "λ"
        } else {
            puts $fd {<оʸ>}
            puts $fd $JSAX_RESULT_TABLE(sentence)
            puts $fd {</оʸ>}
        }
    }

    # ǲϷ
    if {$JSAX_SAVE_ALL_MODE == {all} \
            || $JSAX_SAVE_MORPH == 1 \
            || $JSAX_SAVE_MORPH_TIME == 1 \
            || $JSAX_SAVE_MORPH_LIST == 1} {
        # إå
        puts $fd {<ǲϷ>}

        if {$JSAX_SAVE_ALL_MODE == {all} || $JSAX_SAVE_MORPH == 1} {
            if {$JSAX_RESULT_TABLE(ready) == -1 \
                    && $JSAX_SAVE_MORPH_READY == 0} {
                tk_dialog .d dialog \
                        "ǹ¤(Ѥ)¸褦˻ꤵƤޤɽΥեξˤͭʥǡޤޤƤޤ󡣤äơξϽϤޤ" \
                warning 0 "λ"
            } else {
                if {$JSAX_RESULT_CONVERT_MODE == 1} {
                    # ʸƬΥΤϤ
                    set data [lreplace \
                            [split $JSAX_RESULT_TABLE(morph) "\n"] 0 0]
                } else {
                    # Τޤ޽Ϥ
                    set data [split $JSAX_RESULT_TABLE(morph) "\n"]
                }
                puts $fd {<Ѥ߷ǹ¤>}
                puts $fd [join $data "\n"]
                puts $fd {</Ѥ߷ǹ¤>}
            }
        }

        if {$JSAX_SAVE_ALL_MODE == {all} || $JSAX_SAVE_MORPH_LIST == 1} {
            if {$JSAX_RESULT_TABLE(ready) == -1 \
                    && $JSAX_SAVE_MORPH_LIST_READY == 0} {
                tk_dialog .d dialog \
                        "ǹ¤(ꥹɽ)¸褦˻ꤵƤޤɽΥեξˤͭʥǡޤޤƤޤ󡣤äơξϽϤޤ" \
                warning 0 "λ"
            } else {
                puts $fd {<ꥹɽǹ¤>}
                puts $fd $JSAX_RESULT_TABLE(morph_list)
                puts $fd {</ꥹɽǹ¤>}
            }
        }

        if {$JSAX_SAVE_ALL_MODE == {all} || $JSAX_SAVE_MORPH_TIME == 1} {
            if {$JSAX_RESULT_TABLE(ready) == -1 \
                    && $JSAX_SAVE_MORPH_TIME_READY == 0} {
                tk_dialog .d dialog \
                        "ǲϻ־¸褦˻ꤵƤޤɽΥեξˤͭʥǡޤޤƤޤ󡣤äơξϽϤޤ" \
                warning 0 "λ"
            } else {
                puts $fd {<ǲϻ>}
                puts $fd $JSAX_RESULT_TABLE(morph_time)
                puts $fd {</ǲϻ>}
            }
        }

        # եå
        puts $fd {</ǲϷ>}
    }

    # ʸϷ
    if {$JSAX_SAVE_ALL_MODE == {all} \
            || $JSAX_SAVE_SYNTAX == 1 \
            || $JSAX_SAVE_START_SYM_PARAM == 1 \
            || $JSAX_SAVE_F_STRUCT == 1 \
            || $JSAX_SAVE_F_STRUCT_LIST == 1 \
            || $JSAX_SAVE_SYNTAX_TIME == 1 } {
        # إå
        puts $fd {<ʸϷ>}

        # Ʋν
        set mark 0
        for {set cnt 1} \
                {$cnt <= $JSAX_RESULT_TABLE(ambiguity) \
                && ( $output_result_num_list == {} \
                || [lsearch $output_result_num_list  $cnt] >= 0 ) } \
                {incr cnt} {

            # إå
            puts $fd {<ʸϷ>}

            if {$JSAX_SAVE_ALL_MODE == {all} || $JSAX_SAVE_SYNTAX == 1} {
                if {$JSAX_RESULT_TABLE(ready) == -1 \
                        && $JSAX_SAVE_SYNTAX_READY == 0} {
                    if {$mark == 0} {
                        tk_dialog .d dialog \
                                "ʸڤ¸褦˻ꤵƤޤɽΥեξˤͭʥǡޤޤƤޤ󡣤äơξϽϤޤ" \
                                warning 0 "λ"
                    }
                } else {
                    puts $fd {<ʸ>}
                    if {$JSAX_RESULT_CONVERT_MODE == 1} {
                        # ʸƬΥΤϤ
                        puts $fd [remove_tag_from_tree \
                                $JSAX_RESULT_TABLE(syntactic_tree:$cnt)]
                    } else {
                        # Τޤ޽Ϥ
                        puts $fd $JSAX_RESULT_TABLE(syntactic_tree:$cnt)
                    }
                    puts $fd {</ʸ>}
                }
            }

            ##############################
            if 0 {
            if {$JSAX_SAVE_ALL_MODE == {all} \
                    || $JSAX_SAVE_START_SYM_PARAM == 1} {
                if {$JSAX_RESULT_TABLE(ready) == -1 \
                        && $JSAX_SAVE_START_SYM_PARAM_READY == 0} {
                    if {$mark == 0} {
                        tk_dialog .d dialog \
                                "ϵ¸褦˻ꤵƤޤɽΥեξˤͭʥǡޤޤƤޤ󡣤äơξϽϤޤ" \
                                warning 0 "λ"
                    }
                } else {
                    puts $fd {<ϵ>}
                    puts $fd $JSAX_RESULT_TABLE(start_sym_param:$cnt)
                    puts $fd {</ϵ>}
                }
            }
            }
            ##############################

            if {$JSAX_SAVE_ALL_MODE == {all} || $JSAX_SAVE_F_STRUCT == 1} {
                if {$JSAX_RESULT_TABLE(ready) == -1 \
                        && $JSAX_SAVE_F_STRUCT_READY == 0} {
                    if {$mark == 0} {
                        tk_dialog .d dialog \
                                "¤(Ѥ)¸褦˻ꤵƤޤɽΥեξˤͭʥǡޤޤƤޤ󡣤äơξϽϤޤ" \
                                warning 0 "λ"
                    }
                } else {
                    puts $fd {<Ѥ¤>}
                    puts $fd $JSAX_RESULT_TABLE(f_struct:tbl:$cnt)
                    puts $fd {</Ѥ¤>}
                }
            }

            if {$JSAX_SAVE_ALL_MODE == {all} \
                    || $JSAX_SAVE_F_STRUCT_LIST == 1} {
                if {$JSAX_RESULT_TABLE(ready) == -1 \
                        && $JSAX_SAVE_F_STRUCT_LIST_READY == 0} {
                    if {$mark == 0} {
                        tk_dialog .d dialog \
                                "¤(ꥹɽ)¸褦˻ꤵƤޤɽΥեξˤͭʥǡޤޤƤޤ󡣤äơξϽϤޤ" \
                                warning 0 "λ"
                    }
                } else {
                    puts $fd {<ꥹɽ¤>}
                    puts $fd $JSAX_RESULT_TABLE(f_struct:lst:$cnt)
                    puts $fd {</ꥹɽ¤>}
                }
            }

            # եå
            puts $fd {</ʸϷ>}
            set mark 1
        }

        if {$JSAX_SAVE_ALL_MODE == {all} || $JSAX_SAVE_SYNTAX_TIME == 1} {
            if {$JSAX_RESULT_TABLE(ready) == -1 \
                    && $JSAX_SAVE_SYNTAX_TIME_READY == 0} {
                if {$mark == 0} {
                    tk_dialog .d dialog \
                            "ʸϻ־¸褦˻ꤵƤޤɽΥեξˤͭʥǡޤޤƤޤ󡣤äơξϽϤޤ" \
                            warning 0 "λ"
                }
            } else {
                puts $fd {<ʸϻ>}
                puts $fd $JSAX_RESULT_TABLE(syntactic_time)
                puts $fd {</ʸϻ>}
            }
        }

        # եå
        puts $fd {</ʸϷ>}
    }

    # եåν
    puts $fd {</Ϸ>}

    # եĤ
    close $fd
}

# Ϸ̽Ϥץ
#
#    select    : ϤϤ ( all: )
#    newfile   : ե꤫     ( new:ե )
#    overwrite : 񤭤ɵ       ( w:  a:ɵ )
#
proc cntl_write_jsax_result {select newfile overwrite} {
    global SELECTED_RESULT_NUMBER
    global JSAX_SAVE_FILENAME
    global JSAX_SAVE_OVERWRITE_MODE

    if {![info exists SELECTED_RESULT_NUMBER]} {
        tk_dialog .d dialog "Ϸ̤ɽƤޤ" warning 0 "λ"
        return
    }

    if {![info exists JSAX_SAVE_FILENAME]} {
        set JSAX_SAVE_FILENAME {}
    }
    if {$newfile == {new}} {
        set JSAX_SAVE_FILENAME {}
    } elseif {$JSAX_SAVE_FILENAME {}} {
        set ans [tk_dialog .d dialog \
                "եؤ¸ϤޤԤƤޤ󡣿եꤷޤ" \
                warning 1 "ꤷƾ" "ꤷɵ" ""]
        switch $ans {
            {0} {set overwrite {w}}
            {1} {set overwrite {a}}
            {2} {return}
        }
    }

    set JSAX_SAVE_OVERWRITE_MODE $overwrite

    if {$select == {all}} {
        write_jsax_result
    } else {
        write_jsax_result $SELECTED_RESULT_NUMBER
    }
}
