/* PARCAR/KP Parallel Abductive Reasoning System on KILC+PVM */
/* Copyright (C) 1997    Shohey Kato                         */

#define ON  1
#define OFF 0

#define TRUE    1
#define FALSE   0

#define PACKETSIZE 4096
#define MAINBUFSIZE 128000
#define LINEBUFSIZE 128

#define INITIAL_VAL_OF_K 10
#define BASEVAL_OF_K	100	
#define REV_CONTROL 	0.75

#define MAXHOST	1024


typedef struct imbuffer  /* Ǽ빽¤ */
{
    struct imbuffer *next;
    int cost;           /* Υ */
    char *clause;        /*  */
}
IMBUF;

typedef struct pacar_host /* СޥΥۥȤΥǡ*/
{
    char name[64];
    int tid;            /* task id */
    double rev;         /* Load average */
    int cpu_pow;        /* CPU pow */
    int k;              /* γ٥ѥ᡼ */
    double rate;        /* k / sun_of_k */
}HOSTDATA;

typedef struct c2k_packets_buf
{
    struct c2k_packets_buf	*next;
    int	dist_subgoals;
    double rate;
    double rate_sum;	/* sum of rete */
    int hostnum;        /* number of host in virtual machine */
    int tid;            /* tid */
    char packet[MAINBUFSIZE]; /* packet */
    /* packet="number ?:(atom infinity)||(number ??):(subgoal):..:(subgoal);"
     		      ^K			 ^a minimum cost of answers */
}C2K_PACKETS;


extern int dist_count;
extern int check_phase;/* check_phase==OFF:progress phase
			  check_phase==ON :confirmation phase */

extern IMBUF *imbuftop_ans,*imbuftop_sb;
extern int subgoal_count;
extern int answer_count;
void free_imbuf();
void add_answer();
IMBUF *get_answer();
void show_answer();
void add_subgoal();
IMBUF *get_subgoal();
void show_subgoal();

int ck_cost();
char *del_endmark();
void add2buf();
char *ans_ck();
char *cut_cost();
void dist_count_set();
char *make_packet();

/* multibuf.c */
C2K_PACKETS     *c2kpackets_top;
void init_packets_buf();
void clear_packets();
void append_K2packet();
void append_answercost2packet();
void make_packets();
void show_packets();

typedef struct output
{
    float cost;
    char body[64000];
    char used[64000];
}
output;

char *get_a_word(char *,char *);
char *decode_func(char *,char *);
char *decode_list(char *,char *);
char* decode_term(char *,char *);
output *cut_sg_and_used(char *);
char* decode_term(char *,char *);
void ppterm(int,char *);
float print_terms(int,float,output *);

