/*     parcar.c                 */
/*     Υȥåץ٥       */

#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include "pvm3.h"
#include "parcar.h"
#include "../userdef.h"

/* subgoal < hosts ΤȤ᤬ʤ host ˤ atom [] */

int ck_startup=ON;

char fact[MAINBUFSIZE],hypo[MAINBUFSIZE],
    contra[MAINBUFSIZE],ques[MAINBUFSIZE];

int  msg_count=-1;

void init_val()
{
    imbuftop_ans=(IMBUF *)NULL;
    imbuftop_sb=(IMBUF *)NULL;
    subgoal_count=0;
    answer_count=0;
}

void msg_send(C2K_PACKETS *dm_buf)
{
    pvm_initsend(PvmDataDefault);
    pvm_pkstr(dm_buf->packet);
    pvm_send(dm_buf->tid, 1);
}

void send_initial_data(int tid)
{
    pvm_initsend(PvmDataDefault);
    pvm_pkstr(fact);
    pvm_send(tid, 1);
    pvm_initsend(PvmDataDefault);
    pvm_pkstr(hypo);
    pvm_send(tid, 1);
    pvm_initsend(PvmDataDefault);
    pvm_pkstr(contra);
    pvm_send(tid, 1);
}

void load_KB(char *filename)
{
    char *dm_sb;
    int i;
    
    FILE *fp;

    if((i=strcmp(filename,"-"))==0) fp=stdin;
    else if(NULL==(fp = fopen(filename,"r"))){
        fprintf(stderr,"%s: No such file or directory.\n",filename);
        exit(1);
    }
    fgets(fact,MAINBUFSIZE,fp);
    fgets(hypo,MAINBUFSIZE,fp);
    fgets(contra,MAINBUFSIZE,fp);
    fgets(ques,MAINBUFSIZE,fp);

    if (i!=0) fclose(fp);
    
    dm_sb = (char *)malloc(strlen(ques)+1);
    strcpy(dm_sb,del_endmark(ques));
    add_subgoal(ck_cost(ques),dm_sb);
    fprintf(stderr,"The observation:\n");
    print_terms(7,0.0,cut_sg_and_used(ques));
}


void start_pvm(int host_count,HOSTDATA *serv_data,char * slave)
{
    int i,numt;
    
#ifdef DEBUG
    fprintf(stderr,"I'm t%x\n", pvm_mytid());
#endif
    for(i=0;i<host_count;i++){
        numt=pvm_spawn(slave,
                       (char**)0, 1,serv_data[i].name, 1, &(serv_data[i].tid));
        if(numt==1){
            fprintf(stderr,"%-8s spawn OK, Its TID is t%x.\n",
                    serv_data[i].name,serv_data[i].tid);
        
            send_initial_data(serv_data[i].tid);
        } else {
            fprintf(stderr,"%s spawn Fail.\n", serv_data[i].name);
            switch(numt){
                case PvmBadParam:
                    fprintf(stderr,"Invaild argument\n");
                    break;
                case PvmNoHost:
                    fprintf(stderr,"no sush host in virtal machine.\n
                                    Please chech your configuration file.\n");
                    break;
                case PvmNoFile:
                    fprintf(stderr,"slave program does not found\n");
                    break;
                case PvmNoMem:
                    fprintf(stderr,"Unable to allocate buffer\n");
                    break;
                case PvmSysErr:
                    fprintf(stderr,"No response from pvmd\n");
                    break;
                case PvmOutOfRes:
                    fprintf(stderr,"Out of Resouce\n");
                    break;
                default:
                    fprintf(stderr,"Unkown Error\n");
                    break;
            }
            fprintf(stderr,"system going down.\n");
            exit(1);
        }
    }
    fprintf(stderr,"Virtual Machine started successfully.\n");
    fprintf(stderr,"Cell name       : ");
    for(i=0;i<host_count;i++)
        fprintf(stderr,"%9s",serv_data[i].name);
    fprintf(stderr,"\n");
}

void init_hostdata(int host_count,HOSTDATA *data)
{
    int i;
    for(i=0;i<host_count;i++){
	data[i].k = INITIAL_VAL_OF_K;
    }
}

int load_file(char *data_file,HOSTDATA *serv_data)
{
    int i,j=0,host_count=0;
    /* int words_count=0,spc_readingp=FALSE; */
    char linebuf[1024],word_buf[256];
    
    FILE *fp;
    i=0; j=0;
    if((fp=fopen(data_file,"r"))==NULL){
        fprintf(stderr,"Fatal: cannot open %s.\n",data_file);
        exit(1);
    }

    while(fgets(linebuf,1024,fp)!=NULL){
        i=0; j=0;
        
        if((linebuf[0]=='#')||(linebuf[0]=='\n')) continue;
        
        while(1){
            word_buf[j]=linebuf[i];
            if((linebuf[i]==' ') || (linebuf[i]=='\t')
               || (linebuf[i]=='\0') || (linebuf[i]=='\n')){
                word_buf[j]='\0';
                strcpy(serv_data[host_count++].name,word_buf);
                break;
            }
            j++;i++;
        } 
    }

    fclose(fp);
    
    strcpy(serv_data[host_count].name,"");
    serv_data[host_count].cpu_pow = 0;
    serv_data[host_count].k = 0;

    fprintf(stderr,"Cell count : %d\n",host_count);

#ifdef DEBUG
    for(i=0;i<=host_count;i++)
	fprintf(stderr,"name:%s,cpu_pow:%d k:%d\n",
                serv_data[i].name,serv_data[i].cpu_pow,serv_data[i].k);
#endif
    return(host_count);
}

void set_K(int host_count,HOSTDATA *data)
{
    int i;
    double sum,rev_min=100.00;

    for(i=0,sum=0;i<host_count;i++)
	if(rev_min>data[i].rev)
	    rev_min=data[i].rev;

    for(i=0;i<host_count;i++)
	data[i].k =(int)(
	    BASEVAL_OF_K*((rev_min + REV_CONTROL)/(data[i].rev + REV_CONTROL))
	    );    
}

void set_rate_of_K(int host_count,HOSTDATA *data)
{
    int i;
    double sum;

    for(i=0,sum=0;i<host_count;i++)
	sum += (double)data[i].k;
    
    for(i=0;i<host_count;i++){
	data[i].rate = (double)((double)data[i].k/sum);
    }
}

void reason(struct timeval *tval,int host_count,HOSTDATA *serv_data)
{
    int i,cc[MAXHOST];
    char unpack_buf[MAINBUFSIZE];
    C2K_PACKETS *dm_buf;
    
    init_packets_buf(host_count);
    init_hostdata(host_count,serv_data);
    
    while(check_phase==OFF){

	dm_buf = c2kpackets_top;
	
	if(answer_count!=0){
	    check_phase=ON;
            fprintf(stderr,"@@@@@@ Switch to Confirmation phase @@@@@@\n");
	    gettimeofday(&tval[2],(struct timezone *)NULL);
	}
	
	make_packets(c2kpackets_top,serv_data);
#ifdef DEBUG
	show_packets(c2kpackets_top);
#endif 

	for(i=0;dm_buf != (C2K_PACKETS *)NULL;dm_buf = dm_buf->next,i++)
	    msg_send(dm_buf);
	
	for(i=0;i<host_count;i++){
	    
	    cc[i] = pvm_recv(serv_data[i].tid, -1);
	    pvm_bufinfo(cc[i], (int*)0, (int*)0, &(serv_data[i].tid));
	    pvm_upkstr(unpack_buf);
	    ans_ck(unpack_buf,&serv_data[i]);
#ifdef DEBUG
            fprintf(stderr,"%.55s\n",unpack_buf);
#endif
	}

	set_K(host_count,serv_data);
	set_rate_of_K(host_count,serv_data);
	
        if(ck_startup==ON){
            fprintf(stderr,"Load average    : ");
            for(i=0;i<host_count;i++)
                    fprintf(stderr,"%9.2f",serv_data[i].rev);
            fprintf(stderr,"\n");
            ck_startup=OFF;
        }
    }
    gettimeofday(&tval[3],(struct timezone *)NULL);
}

void print_time(char *datafilename,int host_count,struct timeval *tval)
{
    double t0,t1,t2,t3;
    t0 = tval[0].tv_sec + 0.000001*tval[0].tv_usec;
    t1 = tval[1].tv_sec + 0.000001*tval[1].tv_usec;
    t2 = tval[2].tv_sec + 0.000001*tval[2].tv_usec;
    t3 = tval[3].tv_sec + 0.000001*tval[3].tv_usec;
    
    show_answer(imbuftop_ans);
    if(strcmp(datafilename,"-")!=0)
        fprintf(stdout,"\nData file : %s\n",datafilename);
    else fprintf(stdout,"\nData file : stdin\n");
    fprintf(stdout,"Cells     : %d\n",host_count);
    fprintf(stdout," Starting up: %8.5f sec\n",t1-t0);
    fprintf(stdout," Reasoning  : %8.5f sec\n",t3-t1);
    fprintf(stdout,"    progress phase     : %8.5f sec\n",t2-t1);
    fprintf(stdout,"    confirmation phase : %8.5f sec\n",t3-t2);
    fprintf(stdout," Total      : %8.5f sec\n",t3-t0);
}

void kill_servs(HOSTDATA *serv_data)
{
    int i;

    for(i=0;(strcmp(serv_data[i].name,"")!=0);i++){
	pvm_kill(serv_data[i].tid);
    }
}
    
int main(int argc,char *argv[])
{
    int i,host_count=0;

    HOSTDATA serv_data[MAXHOST];
    struct timeval tval[4];
    char slave[128],vmhost[128];
    FILE *fp;

    /*	tval[0]:a program start
	tval[1]:a reasoning start
	tval[2]:a program end
	tval[1] - tval[0]:startingup time
	tval[2] - tval[1]:progress time
	tval[3] - tval[2]:confirmation time
	tval[3] - tval[1]:reasoning time
	tval[3] - tval[0]:real running time
	*/
    strcpy(vmhost,HOSTSDATAFILE);
    strcpy(slave,DEFAULT_SLAVE);
    
    /* parsing command line */
    for(i=1;i<argc;i++){
        if(strcmp(argv[i],"-f")==0){
            strcpy(vmhost,argv[++i]);
        } else if(strcmp(argv[i],"-s")==0){
            strcpy(slave,argv[++i]);
            if(NULL==(fp=fopen(slave,"r"))){
                fprintf(stderr,
                        "Fatal: cannot find slave program '%s'.\n",slave);
                exit(1);
            }
            fclose(fp);
        } else if(argc!=2 && argc!=4 && argc!=6){
            fprintf(stderr,
                    "Usage: %s [-f host] [-s Slave] KnowledgeBase\n",argv[0]);
            exit(1);
        }
    }

    gettimeofday(&tval[0],(struct timezone *)NULL);

    /* initialization */
    init_val();
    host_count=load_file(vmhost,serv_data);
    load_KB(argv[i-1]);
    /* start virtual machine */
    start_pvm(host_count,serv_data,slave);

    /* reasoning */
    gettimeofday(&tval[1],(struct timezone *)NULL);
    reason(tval,host_count,serv_data); /* reason(-,+,+,+) */
    print_time(argv[argc-1],host_count,tval);
    kill_servs(serv_data);
    
    pvm_exit();
    exit(0);
}

