/* PARCAR/KP Parallel Abductive Reasoning System on KILC+PVM */
/* Copyright (C) 1997    Shohey Kato                         */

/* output.c */
/* translation of encoded data and outputting readable data */
/* (with inaccurate support for a clause with variables) */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "parcar.h"

char *get_a_word(char *str,char *ch)
{
    char *save;

    save=ch;
    while(str){
        *ch++=*str++;
        if(*str==' '){
            str++;
            break;
        }
    }
    
    *ch='\0';
        
     return str;
}

char *decode_func(char *in,char *func)
{
    char word[64000];
    char *tmp,*tmp2;
    int arity,i;

    tmp=in;
    tmp2=get_a_word(tmp,word);
    arity=(int)atoi(word);
    word[0]='\0';
    tmp=get_a_word(tmp2,word);
    strcat(func,word);
    strcat(func,"(");
    for(i=1;i<=arity;i++){
        word[0]='\0';
        tmp2=decode_term(tmp,word);
        
        strcat(func,word);
        if(i<arity)
            strcat(func,",");
        tmp=tmp2;
    }
    return(tmp2);
}


char *decode_list(char *in,char *list)
{
    char word[64000];
    char *tmp,*tmp2;
    int arity,i;

    tmp=in;
    tmp2=get_a_word(tmp,word);
    arity=(int)atoi(word);
    strcat(list,"[");
    word[0]='\0';
    for(i=1;i<=arity;i++){
        word[0]='\0';
       tmp=decode_term(tmp2,word);
        
       strcat(list,word);
       if(i<arity)
           strcat(list,",");
       tmp2=tmp;
    }
    return(tmp);
}

    
char* decode_term(char *string,char *decode)
{
    char *tmp,*tmp2;
    char word[64000];
    
    tmp=string;
    tmp2=get_a_word(tmp,word);
    if(strcmp(word,"atom")==0){
        word[0]='\0';
        tmp=get_a_word(tmp2,word);
        strcat(decode,word);
    }
    if(strcmp(word,"number")==0){
        word[0]='\0';
        tmp=get_a_word(tmp2,word);
        strcat(decode,word);
    }
    if(strcmp(word,"func")==0){
        word[0]='\0';
        tmp=decode_func(tmp2,word);
        strcat(decode,word);
        strcat(decode,")");
    }
    if(strcmp(word,"list")==0){
        word[0]='\0';
        tmp=decode_list(tmp2,word);
        strcat(decode,word);
        strcat(decode,"]");
    }
    return(tmp);
}

output *cut_sg_and_used(char *clause)
{
    int i;
    char *tmp,*tmp2;
    char cost[16];
    char *junk=(char *)malloc(sizeof(char)*64000);
    
    output *out=(output *)malloc(sizeof(output));

    cost[0]='\0';
    tmp=clause;
    for(i=0;i<11;i++) tmp++; /* skip 'func 6 cls ' */
    tmp2=decode_term(tmp,cost);
    out->cost=((float)atoi(cost))/1000.0;
    
    tmp=decode_term(tmp2,junk);
    tmp2=decode_term(tmp,out->body);
    decode_term(tmp2,out->used);
    free(junk);
    return out;
}

void ppterm(int tag,char *terms)
{
    int pp=0;
    int i=0;

    while(terms[i]!=']'){
        fprintf(stderr,"%c",terms[i]);
        if(terms[i++]==',') pp++;
        if(pp>tag){
            fprintf(stderr,"\n     ");
            pp=0;
        }
    }
}

           
float print_terms(int tag,float old,output *out)
{
    char *junk;

#ifdef DEBUG
    if(1){
#else
    if(old==0.0 || old == out->cost){
#endif
        junk=out->used;
        if(strcmp(out->used,"[]")==0)
            fprintf(stderr," ,\n");
        else {
            fprintf(stderr," ");
            ppterm(tag,++junk);
            fprintf(stderr,",\n");
        }
    
        junk=out->body;
        if(strcmp(out->body,"[]")==0)    
            fprintf(stderr,"   .\n");
        else {
            fprintf(stderr,"   ");
            ppterm(tag,++junk);
            fprintf(stderr,".\n");
        }    
        fprintf(stderr,"its cost = %f.\n",out->cost);
        return(out->cost);
    } else return(1000.0);
}
    
