/* PARCAR/KP Parallel Abductive Reasoning System on KILC+PVM */
/* Copyright (C) 1997    Shohey Kato                         */

/* multibuf.c */
/* constructing packets to send to slave proccesors */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "parcar.h"

extern int ck_startup;

void init_packets_buf(int hosts)
/* hostsĤΥХåեallocate */
{
    int i;
    C2K_PACKETS *dm_buf;

    if(hosts < 1){
	fprintf(stderr,"ERROR:init_packets_buf:invalid variable %d\n",hosts);
	exit(1);
    }
    
    dm_buf = (C2K_PACKETS *)malloc(sizeof(C2K_PACKETS));
    dm_buf->dist_subgoals=0;
    dm_buf->packet[0] = '\0';
    
    c2kpackets_top = dm_buf;

    for(i=1;i < hosts;i++){
	dm_buf->next = (C2K_PACKETS *)malloc(sizeof(C2K_PACKETS));
	dm_buf = dm_buf->next;
	dm_buf->dist_subgoals=0;
	dm_buf->packet[0] = '\0';
    }

    dm_buf->next = (C2K_PACKETS *)NULL;
}

void clear_packets(C2K_PACKETS *top)
/* clear C2K_PACKETS.packet */
{
    C2K_PACKETS *dm_buf;
    
    dm_buf = top;

    for(;dm_buf != (C2K_PACKETS *)NULL;dm_buf = dm_buf->next){
	dm_buf->dist_subgoals=0;
	dm_buf->packet[0]='\0';
    }
}

void append_K2packet(C2K_PACKETS *p,int k)
{
    char numbuf[10];

    sprintf(numbuf,"%d",k);
    
#ifdef NO_REV_CONTROL
    strcat(p->packet,"number 100");
#else    
    strcat(p->packet,"number ");
    strcat(p->packet,numbuf);
#endif
}


void append_answercost2packet(C2K_PACKETS *p)
{
    if(check_phase==OFF)
	strcat(p->packet,":atom infinity");
    else{
#ifdef DEBUG
	fprintf(stderr,"switched\n");
#endif
	strcat(p->packet,":");
	strcat(p->packet,cut_cost(imbuftop_ans->clause));	
    }
}

void append_subgoal2packet(C2K_PACKETS *p,IMBUF *subgoal)
{   
    if((subgoal==(IMBUF *)NULL)){
	if((p->dist_subgoals==0))
	    strcat(p->packet,":atom []");
    } else {
	p->dist_subgoals++;
	strcat(p->packet,":");
	strcat(p->packet,subgoal->clause);	    
    }
}

void make_packets(C2K_PACKETS *top,HOSTDATA *data)
{
    int i;
    C2K_PACKETS *dm_buf;
    IMBUF *dm_imbuf;
    
    dm_buf = top;
    
    clear_packets(c2kpackets_top);

    for(i=0;dm_buf != (C2K_PACKETS *)NULL;dm_buf = dm_buf->next,i++){
        /* ƥ˺1Ĥ */
	dm_buf->rate = data[i].rate;
	dm_buf->rate_sum = 0;
	dm_buf->tid = data[i].tid;
	append_K2packet(dm_buf,data[i].k);
	append_answercost2packet(dm_buf);
	dm_imbuf=get_subgoal(imbuftop_sb);
	append_subgoal2packet(dm_buf,dm_imbuf);
    }
    
    while(subgoal_count!=0)
    /* ĤΥ֥ɥ٥졼˱ʬ */
    {
	dm_buf = top;

	for(i=0;dm_buf != (C2K_PACKETS *)NULL;dm_buf = dm_buf->next){
	    dm_buf->rate_sum += dm_buf->rate;
	    if(dm_buf->rate_sum >= 1.00){
		dm_imbuf=get_subgoal(imbuftop_sb);
		append_subgoal2packet(dm_buf,dm_imbuf);

		dm_buf->rate_sum = dm_buf->rate_sum - 1;
	    }
	}
    }

    dm_buf = top;
    if(ck_startup==OFF)
        fprintf(stderr,"distribute goals:  ");
    for(;dm_buf != (C2K_PACKETS *)NULL;dm_buf = dm_buf->next){
        if(ck_startup==OFF)
            fprintf(stderr,"%8d ",dm_buf->dist_subgoals);
	strcat(dm_buf->packet,";");	
    }
    if(ck_startup==OFF)
        fprintf(stderr,"\n");
}

void show_packets(C2K_PACKETS *top)
{
    C2K_PACKETS *dm_buf;

    dm_buf = top;
    
    for(;dm_buf != (C2K_PACKETS *)NULL;dm_buf = dm_buf->next)
	fprintf(stderr,"%.50s\n",dm_buf->packet);
}

