/* PARCAR/KP Parallel Abductive Reasoning System on KILC+PVM */
/* Copyright (C) 1997    Shohey Kato                         */

/* buf.c */
/* buffering candidate solution and subgoals for communication */
    
#include<stdio.h>
#include<stdlib.h>
#include"parcar.h"

int subgoal_count=0;
int answer_count=0;


IMBUF *imbuf,*imbuftop_ans,*imbuftop_sb;

void free_imbuf(IMBUF *bf)
{
    free(bf->clause);
    free(bf);
}

void add_answer(int cost,char *str)   
/* 򤽤ΥȽ˥Хåե˳Ǽ */
{
    IMBUF *dm_buf,*dm_buftop;

    answer_count++;
    dm_buf = (IMBUF *)malloc(sizeof(IMBUF));
    dm_buf->cost=cost;
    dm_buf->clause=str;
 
    if(imbuftop_ans != NULL){
        dm_buftop=imbuftop_ans;
        if(dm_buftop->cost > dm_buf->cost){
            dm_buf->next=dm_buftop;
            imbuftop_ans=dm_buf;
        }else{
            for(;(dm_buftop->cost < dm_buf->cost) &&
                    (dm_buftop->next != (IMBUF *)NULL)
                    ;dm_buftop=dm_buftop->next);
            dm_buf->next=dm_buftop->next;
            dm_buftop->next=dm_buf;
        }

    } else {
        imbuftop_ans = dm_buf;
        imbuftop_ans->next = NULL;
    }
}

IMBUF *get_answer(IMBUF *bf)
{
    if(bf==(IMBUF *)NULL)
        return((IMBUF *)NULL);

    imbuftop_ans=bf->next;
    answer_count--;
    return(bf);
}

void show_answer(IMBUF *bf)
{
    float old=0.0;
    
    fprintf(stderr,"\nThe refutation finished successfully.\n");
    fprintf(stderr,"explanation:\n");
    for(;bf!=(IMBUF *)NULL;bf=bf->next){
        old=print_terms(3,old,cut_sg_and_used(bf->clause));
    }
    
}

void add_subgoal(int cost,char *str)  
/* ֥򤽤ΥȽ˥Хåե˳Ǽ */
{
    IMBUF *dm_buf,*dm_buftop;
    subgoal_count++;

  
    dm_buf = (IMBUF *)malloc(sizeof(IMBUF));
    dm_buf->cost=cost;
    dm_buf->clause=str;
  
    if(imbuftop_sb != NULL){
        dm_buftop=imbuftop_sb;
        if(dm_buftop->cost > dm_buf->cost){
            dm_buf->next=dm_buftop;
            imbuftop_sb=dm_buf;
        }else{
            for(;(dm_buftop->cost < dm_buf->cost) &&
                    (dm_buftop->next != (IMBUF *)NULL)
                    ;dm_buftop=dm_buftop->next);
            
            dm_buf->next=dm_buftop->next;
            dm_buftop->next=dm_buf;
        }
    } else {
        imbuftop_sb = dm_buf;
        imbuftop_sb->next = NULL;
    }
}

IMBUF *get_subgoal(IMBUF *bf)
{
    if(bf==(IMBUF *)NULL)
        return((IMBUF *)NULL);

    imbuftop_sb=bf->next;
    subgoal_count--;
    return(bf);
}

void show_subgoal(IMBUF *bf)
{
    for(;bf!=(IMBUF *)NULL;bf=bf->next)
        fprintf(stderr,"show_sb cost: %d , clause %s\n",bf->cost,bf->clause);
}
