/* PARCAR/KP Parallel Abductive Reasoning System on KILC+PVM */
/* Copyright (C) 1997    Shohey Kato                         */

/* ans_ck.c */
/* Received packets from slave processors are transformed into candidate solution and subgoals. */ 
/* Checking is also done if any candidate solution is found. */

#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include"parcar.h"

int dist_count=0;
int check_phase=OFF;

char pack_buf[MAINBUFSIZE],bufln[64];
int ck_cost();

char *del_endmark(char *str)
/* packet κǸˤĤƤ";" */
{
    char *save;
    save = str;
    for(;*str!=';';str++);
    *str='\0';
    return(save);
}

void sprit_and_add_subgoal(char *str)
/* packet ʬ䤷,add_subgoalϤ */
{
    int i;
    char *dm_buf,buf[PACKETSIZE];

  
    while(*str!=';'){
        for(i=0;(*str!=':')&&(*str!=';');i++,str++)
            buf[i]=*str;
    
        buf[i++]='\0';
    
        dm_buf=(char *)malloc(strlen(buf)+1);
        strcpy(dm_buf,buf);
        add_subgoal(ck_cost(buf),dm_buf);
        if(*str!=';') 
            str++;
    }
}

void sprit_and_add_answer(char *str)
/* packet ʬ䤷,add_answerϤ */
{

    int i;
    char *dm_buf,buf[PACKETSIZE];

      while(*str!=';'){
	  for(i=0;(*str!=':')&&(*str!=';');i++,str++)
	      buf[i]=*str;
	  buf[i++]='\0';
	  dm_buf=(char *)malloc(strlen(buf)+1);
	  strcpy(dm_buf,buf);
	  add_answer(ck_cost(buf),dm_buf);
	      if(*str!=';')
		  str++;
      }
}


void add2buf(char *ans,char *sb)
{

  if(*ans!='\0')
      sprit_and_add_answer(ans);

  if(*sb!='\0')
      sprit_and_add_subgoal(sb);
}

char *ans_ck(char *str,HOSTDATA data)
/* packet -> loadave,ans,subgoal  dispatcher */
{
    int i;
    char timetag[LINEBUFSIZE],abf[MAINBUFSIZE],sbbf[MAINBUFSIZE];

    /*** load average data ***/
    for(i=0;*str!=':';str++,i++) timetag[i] = *str;
    str++;
    timetag[i]='\0';
    data.rev = atof(timetag);
  
    /*** answer and subgoal ***/
    if(*str=='a'){ /* receive 'atom []' */
        abf[0]='\0';
    
        for(;*str!=';';str++);	/* first endmark */
        str++;
        if(*str=='a'){ /* receive 'atom []' */
            sbbf[0]='\0';
        }else{
            strcpy(sbbf,str);
            abf[0]='\0'; 
        }
    }else{ /* exists candidacy for answer */
        for(i=0;*str!=';';str++,i++)	/* first endmark */
            abf[i]=*str;

        i++;     		
        abf[i]=';';
        i++;
        abf[i]='\0';	/* terminate answers */
      
        str++;

        if(*str=='a'){
            sbbf[0]='\0';
        }else{
            strcpy(sbbf,str);
        }
    }
    add2buf(abf,sbbf);
    return((char *)NULL);
}

int ck_cost(char *str)    
/* ɾ֤ͤͤ
   ɾͤ func 6 cls number 11111 ...  11111 ʬ */
{
    int i;
    char xx[10];

    for(i=0;i<4;str++)
        if(*str==' ') i++;
  
    for(i=0;*str!=' ';i++,str++) xx[i]=*str;
    xx[i++]='\0';

    return((int)atoi(xx));
}

char *cut_cost(char *str)
/* ɾͤʸ֤
   ɾͤ func 6 cls number 11111 ...  number 11111 ʬ */
{
    int i,j;

    for(i=0;i<3;str++)
        if(*str==' ') i++;
  
    for(i=0,j=-1;i<2;str++){ /* 2 = 5 - 3 */
        j++;
        bufln[j]=*str;
        if(*str==' ')
            i++;
    }
    bufln[j]='\0';

    return(bufln);
}

