#!/bin/csh
#
# 򥳥ѥ뤹뤿Υץȥե
# juman : JUMAN ƥΤǥ쥯ȥꡣʤȤ⡢
#	makeint/
#	makemat/
#	bin/
#	juman/
#	maketree/
#	 JUMAN ƥǥ쥯ȥ꡼¸ߤ뤳ȡ
#
# ܤμѤƥ
# % cmpldict.sh -C bsic
#
# IPAL Ѥƥ
# % cmpldict.sh -C ipal
#
# SIZN Ѥƥ
# % cmpldict.sh -C sizn
#
# CNST Ѥƥ
# % cmpldict.sh -C cnst
#
# IPAٱμѤƥ
# % cmpldict.sh -C lct1
# % cmpldict.sh -C lct2
#
# MORPHPATH : ܥѥå󥹥ȡ뤵Ƥѥ򼨤Ķѿ
# JUMANPATH: JUMANƥब󥹥ȡ뤵Ƥѥ򼨤Ķѿ
# JUMANVERSION: JUMANƥǤ򼨤Ķѿ
#
# ѥꤵƤ뤫
if (! $?MORPHPATH ) then
	echo "MORPHPATH not found"
	exit
endif
if (! $?JUMANPATH ) then
	echo "JUMANPATH not found"
	exit
endif
if (! $?JUMANVERSION ) then
	echo "JUMANVERSION not found"
	exit
endif
#####
# ο򸡺ʤˤ usage ɽ
if($#argv == 0) then
	echo "usage: $0 -C [MODE]"
	exit
endif
#####
#  -h(elp) ξˤ usage ξܺ٤ɽ
if(($#argv == 1) && (($argv[1] == "-h") || ($argv[1] == "-help"))) then
	echo "usage: $0 -C [MODE]"
	echo "   MODE = bsic | ipal | sizn | bnst | cnst | lct1 | lct2 | mydict"
	exit
endif
#####
# ޥɰ򸡺
while($#argv > 0)
	switch($argv[1])
	case -C:
		set MODE=$argv[2]
		breaksw
	default:
		echo "Illegal option found"
		echo "try again ... bye"
		exit
	endsw
	shift argv; shift argv
end
#####
# mode ɽ
echo "($MODE)"
echo ""
# JUMAN ⥸塼⡼ɤ˽äƵư
switch( $MODE )
#####
# BSIC #
case bsic:
	set DicDir=$MORPHPATH/"DICT/CLOSEWORD/DIC"
	set RCName="BSIC"
	breaksw
# IPAL #
case ipal:
	set DicDir=$MORPHPATH/"DICT/OPENWORD/IPAL/DIC"
	set RCName="IPAL"
	breaksw
# SIZN #
case sizn:
	set DicDir=$MORPHPATH/"DICT/OPENWORD/SIZN/DIC"
	set RCName="SIZEN"
	breaksw
# BNST #
case bnst:
	set DicDir=$MORPHPATH/"DICT/OPENWORD/BNST/DIC"
	set RCName="BNST"
	breaksw
# CNST # Υǥ쥯ȥ꡼ΤMISCβˤ
case cnst:
	set DicDir=$MORPHPATH/"MISC/CORPUS/CNST/DIC"
	set RCName="CNST"
	breaksw
# LCT1 # ̾Ω
case lct1:
	set DicDir=$MORPHPATH/"DICT/OPENWORD/LCT1/DIC"
	set RCName="LCT1"
	breaksw
# LCT2 # ̾
case lct2:
	set DicDir=$MORPHPATH/"DICT/OPENWORD/LCT2/DIC"
	set RCName="LCT2"
	breaksw
# MYDICT #
case mydict:
	set DicDir=$MORPHPATH/"DICT/MYDICT"
	set RCName="MYDICT"
	breaksw
#
default:
	echo "No such Directory name (or MODE)"
	echo "try again ... bye"
	exit
endsw
#####
#
echo "+----------------------------------------------+"
echo "| MAKING A PARSER OBJECT FOR JUMAN IN PROGRESS |"
echo "+----------------------------------------------+"
echo "(JUMAN-PATH : $JUMANPATH , Version : $JUMANVERSION)"
#
# JUMANRC
#
# MYDICT ξ .jumanrc ե򹹿ʤ
# ¾Υ⡼ɤѤ .jumanrc ե뤬Ѥ뤳Ȥ٤
if( $RCName != "MYDICT") then
	mv -f "$HOME"/.jumanrc "$HOME"/.jumanrc.save
	cp "$MORPHPATH"/DICT/RCFILES/jumanrc."$RCName" "$HOME"/.jumanrc
	echo "Moved jumanrc."$RCName" to home directory as the file (.jumanrc )"
endif
#
# "$DicDir"/*.int ե
#
"$JUMANPATH"/bin/makeint "$DicDir"/*.dic
#
# ǤȤ˽Ѥ
switch( $JUMANVERSION )
case 1.0:
# VERISON 1.0 λ maketree ˤ "$DicDir"  JUMANTREE.imis/main/mida/yomi,
# maketree.log ȥǥ쥯ȥ˺
	"$JUMANPATH"/bin/maketree "$DicDir"/*.int
# "$DicDir" ˤ JUMANTREE.main 򹹿
	if(! -e "$DicDir"/JUMANTREE.main) then
		\rm "$DicDir"/JUMANTREE.main
	endif
	mv -f JUMANTREE.* "$DicDir"
	mv -f maketree.log "$DicDir"
	echo "Moved the maketree.log to which the JUMANTREEs belong."
	echo "  ==>  "$DicDir"/maketree.log"
	echo ""
	breaksw
#####
case 2.0:
# VERISON 2.0 λ makehd ˤ RULE  JUMANTREE.imis/main/mida/yomi,
# makehd.log ȥǥ쥯ȥ˺
	"$JUMANPATH"/bin/makehd "$DicDir"/*.int
# "$DicDir" ˤ JUMANTREE.main Ϻʤ
	mv -f JUMANTREE.* "$DicDir"
	mv -f makehd.log "$DicDir"
	echo "Moved the makehd.log to which the JUMANTREEs belong."
	echo "  ==>  "$DicDir"/makehd.log"
	echo ""
	breaksw
	default:
endsw
#
# End of File
