#!/bin/csh
#
# ƥȷե JUMAN μե(*.dic)Ѵ
#
# ƥȷμǡΥեޥå
# 1              2        3    4        5		(6)
# Ҥ餬ʸФ Ф ɤ ʬ ʬ	(Ҥ餬Ͽ)
#                    θ Τ		(kana)
#                    θ *		(kana)
#
# Usage: text2dic.sh <ե̾>{ <ե̾>}*
#
# աե̾ϳĥҤʤ
#       *.txtեꤷ*.dicե()
#       *.dic ե *.dic.save եȤ¸
#       ǡե'#'ǻϤޤԤϥȤȤʤ
#       ǡե';'ǻϤޤԤJUMANեľܽ񤭹ޤ
#       6ܤ'kana'ꤹȡ֤Ҥ餬ʸФפϿѴ
#	եϤǥ쥯ȥ꡼ $MORPHPATH/DICT/CLOSEWORD/DIC
#
# ο򸡺ʤˤ usage ɽ
if($#argv == 0) then
   echo "Usage: $0 <FILE NAME>{ <FILE NAME>}*"
   exit
endif
#####
#  -h(elp) ξˤ usage ξܺ٤ɽ
if(($#argv == 1) && (($argv[1] == "-h") || ($argv[1] == "-help"))) then
   echo "Usage: $0 <FILE NAME>{ <FILE NAME>}*"
   echo ""
   echo "  <FILE NAME>ǻꤵƥȷJUMANѴ"
   echo ""
   exit
endif
#
# MORPHPATH : ܥѥå󥹥ȡ뤵Ƥѥ򼨤Ķѿ
#
# ѥꤵƤ뤫
if (! $?MORPHPATH ) then
   echo "MORPHPATH not found"
   exit
endif
#
# եΥåȤ
set files=""
while($#argv > 0)
   set files="$files"" "$argv[1]
   shift argv
end
#
pushd .
cd $MORPHPATH/DICT/CLOSEWORD
#
foreach file ( $files )
# --- foreach loop ---
set SOURCE=$file.txt
set TARGET="DIC/"$file.dic
# ե¸߸
if( -r $SOURCE ) then
   echo "$SOURCE --> $TARGET"
   mv -f $TARGET $TARGET.save
else
  echo "$SOURCE file not found"
  exit
endif
#
gawk 'BEGIN { now=0; outof=0; } \
/^#/ { next; } \
/^\;/ { print $0; next; } \
NF==4 { \
  printf("(%s\n",$4); \
  printf("  ((Ф %s)\n",$2); \
  printf("   (ɤ     %s))\n",$3); \
  print ")"; \
  ++now; \
  next; \
} \
NF==5 { \
  printf("(%s\n",$4); \
  printf(" (%s\n",$5); \
  printf("  ((Ф %s)\n",$2); \
  printf("   (ɤ     %s))\n",$3); \
  print "))"; \
  ++now; \
  next; \
} \
NF==6 && $6~/kana/ { \
  printf("(%s\n",$4); \
  printf(" (%s\n",$5); \
  printf("  ((Ф (%s) (%s))\n",$2,$3); \
  printf("   (ɤ     %s))\n",$3); \
  print "))"; \
  ++now; \
  next; \
} \
{ ++outof; print "; "$0 } \
END { printf( "; %d word(s) (%d)\n",now,outof) } ' $SOURCE > ! $TARGET
# --- end of foreach loop ---
end
#
popd
#
# End of File
