%  Shaky v1.0      Copyright (C) 1997, Masanori Ohmori (oomori@jaist.ac.jp) 
/* 桼󥿡ե:

 'situation-name'> query.

ƥҸ
 load : ץΥ
 exit : ץνλ
 list : ץɽ

shell :- 
*/
:- module(ui,[]).

/* Ƽ¹ */
shell :- initialize,shell([w]).
/* 
 1. ץץȽФ
 2. user1ʸɤ߹
 3. ɽѴ
 4. termɤȽ
 5. ᥤ
*/
shell(Sit) :- 
	io:printprompt(Sit),
	io:getline(Com), 
	tr:transfer_etoi(Com,S),
	goal_filter(S,S_new,Sit),
	shell(Sit,S_new).

/* error */
shell(Sit,error):- print('error!!'),nl,shell(Sit).
/* 'exit'shellλ */
shell(_,X) :-
	u:pred(X,exit),!,
	print('good by').
/* ƥҸμ¹ */
shell(Sit,X) :-
	u:pred(X,Xpred), sys:system_pred(Xpred),!,
	u:args(X,Xargs),
	Z=..[Xpred,Xargs],
	sys:Z,
	shell(Sit).
/*  */
shell(Sit,X) :-
	inf:solver(X,Output),
	sys:output(Output),
	shell(Sit).


/* goal_filter :- 뤿Υե륿
  term --> Τޤ
  rule --> error
  infon --> current situationղätermˤ
*/
/* ɽѴǤʤäerror */
goal_filter(error,error,_).
/* infonʤdefaultξĤ */
goal_filter([infon,X],[Sit,X],Sit).
/* 롼ʤerror */
goal_filter([rule,X],error,_).
/* ʤ餽Τޤ */
goal_filter([term,X],X,_).

/*  */
initialize:-
	db:newdb.
:- module(sys,[]).

/* Ҹ줬ƥҸ줫Ƚ */
system_pred(X):-
	system_predicate(Pred),
	user:member(X,Pred).
/* ƥҸΥꥹ */
system_predicate([load_data,load_sr_data,listing_sit,listing_all]).

/* load :- ǡɤ */
load_data([[file,File]]):-
	io:load_data(File).

/* load_sr_data :- ִطɤ */
load_sr_data([[file,File]]):-
	io:load_sr_data(File).

/* listing_all :- ǡɽ */
/* listing_sit(E) :- EݡȤǡɽ */
listing_sit([[sit,E]]):-
	listing_sit1(E).
listing_sit1(E):-
	db:get_data(support_map0,E,Infs),
	listing_sit2(Infs,Infs_ex),
	io:output_data(Infs_ex).
listing_sit2([],[]).
listing_sit2([Id|Infs],[Inf_ex|Infs_ex]):-
	db:get_data(infons,Id,Inf),
	tr:transfer_itoe([infon,Inf],Inf_ex),
	listing_sit2(Infs,Infs_ex).

output([]).
output([E|Output]):-
	print(E),
	output(Output).
	/* Transfer Module */
:- module(tr,[]).

/* transfer(In,Ex)
	:- ɽInȳɽEx */
transfer(In,Ex):-
	var(In),atom(Ex),
	transfer_etoi(Ex,In).
transfer(In,Ex):-
	atom(In),var(Ex),
	transfer_itoe(In,Ex).

/* transfer_etoi(Ex,In)
    :- ɽ(String)ɽѴ */
transfer_etoi(X,error):-
	remove_ctl(X,[9,10,32],[]).
transfer_etoi(Ex,In):-
	remove_ctl(Ex,[9,10,32],String),
	morpheme_analysis(String, Res, [:,-,=,<,'(',')',',','|','.','[',']']),!,
	parse(Res, Inn),
	v_replace(Inn, In).
/* transfer_itoe(In,Ex)
    :- ɽɽѴ */
transfer_itoe(In,Ex):-
	v_replace(Inn,In),
	parse(X,Inn),
	transfer_itoe1(X,XX),
	u:append(XX,Ex).

transfer_itoe1([],[]).	
transfer_itoe1([E|L],[S|R]):-
	name(E,S),
	transfer_itoe1(L,R).
/*
transfer_itoe([infon, Inf],Ex):-
	infon_itoe(Inf,Ex).
transfer_itoe([term, Term],Ex):-
	term_itoe(Term,Ex).
transfer_itoe([rule, Rule],Ex):-
	rule_itoe(Rule,Ex).

infon_itoe([Rel,Args,Pol],Ex):-
	pol_itoe(Pol,Pol_ex),
	atom_itoe(Rel,Rel_ex),
	args_itoe(Args, Args_ex),
	u:append([Pol_ex,[40],Args_ex,[41,46]],Ex).
pol_itoe(0,[45]).
pol_itoe(1,[]).
atom_itoe(Atom,Atom_ex):-
	atom(Atom),
	name(Atom,Atom_ex).

args_itoe([[Label,Val]],[Arg_ex]):-
	atom_itoe(Label,Label_ex),
	val_itoe(Val,Val_ex),
	u:append([Label_ex,[61],Val_ex],Arg_ex).
args_itoe([[Label,Val]|Args],[Arg_ex|Args_ex]):-
	atom_itoe(Label,Label_ex),
	val_itoe(Val,Val_ex),
	u:append([Label_ex,[61],Val_ex,[44]],Arg_ex),
	args_itoe(Args,Args_ex).
val_itoe(Inf,Val_ex):-
	infon_itoe(Inf,Val_ex).
val_itoe(Term,Val_ex):-
	term_itoe(Term,Val_ex).
val_itoe(Atom,Val_ex):-
	atom_itoe(Atom).
*/

/* String饳ȥ륳ɤ */
% usage : remove_ctl(Data, [10,46,32,9], New_data)
remove_ctl([],_,[]).
remove_ctl([A|X],Ctl,Y):-
	user:member(A,Ctl),
	remove_ctl(X,Ctl,Y).
remove_ctl([A|X],Ctl,[A|Y]):-
	remove_ctl(X,Ctl,Y).

/* ǲ
 usage : morpheme_analysis(String, Result, [:,-,=,<,'(',')',',',/])
*/
morpheme_analysis(Str,Result,Specials):-
	morpheme_analysis1(Str,Result,Specials,[]).
morpheme_analysis1([],[],_,_Tmp):-name('',_Tmp).
morpheme_analysis1([],[Tmp],_,_Tmp):-name(Tmp,_Tmp).
morpheme_analysis1([39|Str],[Atom|Res],Chars,[]):-
	morpheme_analysis2(Str,Str_rest,Atom_s),
	name(Atom,Atom_s),
	morpheme_analysis1(Str_rest,Res,Chars,[]).
morpheme_analysis1([39|Str],[Tmp,Atom|Res],Chars,Tmp):-
	morpheme_analysis2(Str,Str_rest,Atom_s),
	name(Atom,Atom_s),
	morpheme_analysis1(Str_rest,Res,Chars,[]).
morpheme_analysis2([39|Str],Str,[]).
morpheme_analysis2([X|Str],Rest,[X|Atom]):-
	morpheme_analysis2(Str,Rest,Atom).
morpheme_analysis1([_C|Str],[C|Res],Chars,[]):-
	name(C,[_C]),
	user:member(C,Chars),
	morpheme_analysis1(Str,Res,Chars,[]).
morpheme_analysis1([_C|Str],[A,C|Res],Chars,Tmp):-
	name(C,[_C]),
	user:member(C,Chars),
	name(A,Tmp),
	morpheme_analysis1(Str,Res,Chars,[]).
morpheme_analysis1([_C|Str],Res,Chars,Tmp):-
	user:append(Tmp,[_C],Tmp1),
	morpheme_analysis1(Str,Res,Chars,Tmp1).

/* ʸ
 parse(Src,Res) */
parse(Src,Res):-
	phrase(g:s(Res),Src).
parse(_,error).

/* ѿиִ */
/* voc_check(L,VL) :- LˤVLѿ(ʸǻϤޤatom)Ƥ */
voc_check(L,VL):-voc_check(L,VL,[]).
voc_check([],[],_).
voc_check([X|L],VVL,Tmp):-
	user:is_list(X),!,
	voc_check(X,Y,Tmp),
	user:append(Y,Tmp,Tmp1),
	user:append(Y,VL,VVL),
	voc_check(L,VL,Tmp1).
voc_check([X|L],[X|VL],Tmp):-
	X @< '[', X @>= 'A', user:non_member(X,Tmp), !,
	voc_check(L,VL,[X|Tmp]).
voc_check([X|L],VL,Tmp):-
	voc_check(L,VL,Tmp).

/* v_check(L,VL) :- LˤVLѿƤ */
v_check(L,VL):-v_check(L,VL,[]).
v_check([],[],_).
v_check([X|L],VVL,Tmp):-
	user:is_list(X),!,
	v_check(X,Y,Tmp),
	user:append(Y,Tmp,Tmp1),
	user:append(Y,VL,VVL),
	v_check(L,VL,Tmp1).
v_check([X|L],[X|VL],Tmp):-
	var(X), tr:non_member(X,Tmp), !,
	v_check(L,VL,[X|Tmp]).
v_check([X|L],VL,Tmp):-
	v_check(L,VL,Tmp).

/* v_replace(L,NL) :- LʸϤޤatomѿ֤ΤNL */
v_replace(L,NL):-
	var(NL),nonvar(L),!,
	ctov_replace(L,NL).
v_replace(L,NL):-
	nonvar(NL),var(L),!,
	vtoc_replace(NL,L).

ctov_replace(L,NL):-
	voc_check(L,VL),
	ctov_replace(L,VL,NL).
ctov_replace(L,[],L).
ctov_replace(L,[X|VL],L1):-
	u:replace(L,X,_,L2),
	ctov_replace(L2,VL,L1).

vtoc_replace(L,NL):-
	v_check(L,VL),
	vtoc_replace(L,VL,NL,65).
vtoc_replace(L,[],L,_).
vtoc_replace(L,[X|VL],L1,C):-
	name(B,[C]),
	u:replace(L,X,B,L2),
	CC is C+1,
	vtoc_replace(L2,VL,L1,CC).

non_member(_,[]).
non_member(X,[Y|L]):-
	X==Y,!,fail.
non_member(X,[_|L]):-
	non_member(X,L).:- module(g,[]).

s([rule, [ES,RULE]]) --> e_sit(ES),[':',':'],rule(RULE),['.'].
s([term, TERM]) --> term(TERM),['.'].
s([infon, INF]) --> infon(INF),['.'].
term([SIT,INF,0]) --> sit(SIT),[':'],infon(INF).
term([SIT,INF,1]) --> sit(SIT),[':','='],infon(INF).
term([[ES],INF,2]) --> e_sit(ES),[':','>'],infon(INF).
e_sit(ATOM) --> [ATOM],{a @=< ATOM, ATOM @< '{'}.
sit(VAR) --> var(VAR).
sit([ES]) --> e_sit(ES).
sit([ES|SIT]) --> e_sit(ES),[','],sit(SIT).
infon([REL,ARGS,0]) --> ['-'],rel(REL),['('],args(ARGS),[')'].
infon([REL,[],0]) --> ['-'],rel(REL).
infon([REL,ARGS,1]) --> rel(REL),['('],args(ARGS),[')'].
infon(VAR) --> var(VAR).
infon([REL,[],1]) --> rel(REL).
rel(ATOM) --> [ATOM], {a @=< ATOM, ATOM @< '{'}.
var(VAR) --> [VAR], {'A' @=< VAR, VAR @< '['}.
args([ARG]) --> arg_s(ARG).
args([ARG|ARGS]) --> arg_s(ARG),[','], args(ARGS).
arg_s([LVL,VAL]) --> label(LVL),['='],val(VAL).
label(ATOM) --> [ATOM], {a @=< ATOM, ATOM @< '{'}.
val(LIST) --> ['['],list(LIST),[']'].
val(ATOM) --> [ATOM], {a @=< ATOM, ATOM @< '{'}.
val(VAR) --> var(VAR).
val(TERM) --> term(TERM).
val(INF) --> infon(INF).
list([ATOM]) --> [ATOM].
list([ATOM|LIST]) --> [ATOM],[','],list(LIST), {a @=< ATOM, ATOM @< '{'}.
rule([HEAD,BODY,BC]) --> head(HEAD),['<','-'],body(BODY),['|'],bc(BC).
rule([HEAD,BODY,[]]) --> head(HEAD),['<','-'],body(BODY).
head(TERM) --> term(TERM).
body([TERM]) --> term(TERM).
body([TERM|BODY]) --> term(TERM),[','],body(BODY).
bc([INF]) --> infon(INF).
bc([INF|BC]) --> infon(INF),[','],bc(BC).
/* ǡϥ⥸塼 */
:- module(io,[]).

/* getn(Stream,N,Data)
 StreamNĤDataɤ߹ */
getn(_,0,[]).
getn(Stream,N,[C|List]):-
	get0(Stream,C),
	N1 is N-1,
	getn(Stream,N1,List).

/* getline(Stream,String):-
	Stream1sentenceɤ߹ */
getline(Stream,List):-
	get0(Stream,C),!,
	getline(Stream,List,C).
getline(_,[-1],-1).
getline(Stream,[46|List],46):-
	get0(Stream,C),!,
	getline1(Stream,List,C).
getline(Stream,[C|List],C):-
	getline(Stream,List).
getline1(_,[-1],-1).
getline1(_,[10],10).
getline1(Stream,[C|List],C):-
	getline(Stream,List).

/* getline(List) :- user_input1sentenceɤߤȤ */
getline(List):- getline(user,List).

/* promptɽ : "''> "*/
printprompt(Sit):-
	printprompt1(Sit),
	print('> ').
printprompt1([X]):-
	format("~a",X).
printprompt1([X|SL]):-
	format("~a,",X),
	printprompt1(SL).

/* ǡΥ */
load_data(File):-
	open(File, read, Stream),
	load_loop(Stream),
	close(Stream).
load_loop(Stream):-
	getline(Stream, Data),!,
	user:last(Data,Flag),
	load_loop1(Stream,Data,Flag).
load_loop1(_,_,-1).
load_loop1(Stream,Data,_):-
	tr:transfer_etoi(Data,In_data),
	db:store_data(In_data),
	load_loop(Stream).

/* output_data1(Ex) :- ɽɽ*/
output_data1(Ex):-
	name(X,Ex),
	print(X).
output_data([]).
output_data([Ex|List]):-
	output_data1(Ex),nl,
	output_data(List).
/* ܴطΥ */
load_sr_data(File):-
	open(File, read, Stream),
	load_sr_loop(Stream),
	close(Stream).
load_sr_loop(Stream):-
	getline(Stream, Data),!,
	user:last(Data,Flag),
	load_sr_loop1(Stream,Data,Flag).
load_sr_loop1(_,_,-1).
load_sr_loop1(Stream,Data,_):-
	tr:transfer_etoi(Data,In_data),
	db:store_sr_data(In_data),
	load_sr_loop(Stream).
/* ǡ١⥸塼 */
:- module(db,[]).

/* newdb :- ǡ١ν 
    as_list : Υꥹ
    support_map0,1,2 : ݡȥޥå 
        0 : non persistent
        1 : persistent
        2 : equal
*/
newdb :-
	bb_put(i_id,0),
	bb_put(r_id,0),
	newdb([links,infons,support_map0,support_map1,support_map2,
	rules,domain,s_link,sr,str_order]).
newdb([]).
newdb([DB|DBL]):-
	del_db(DB),
	X=..[DB,[]], 
	asserta(X),
	newdb(DBL).

/* ǡ١DB¸ߤʤä. ʤФʤˤ⤷ʤ. */
del_db(DB):-
	current_predicate(DB,_),
	abolish(DB,1).
del_db(DB).

/* Υ */
% s_link([[s1,[s2,s3]],[s2,[s4]],[s3,[s4]],[s4,[s5]]]).
% domain([s1,s2,s3,s4]).

/* ǡǡ١˥ȥ */
store_data([term, X]):-
	store_term(X).
store_data([rule, X]):-
	store_rule(X).
store_data([infon, X]):-
	store_term([[w],X,0]).

/* ִطǡ١˥ȥ */
store_sr_data([infon, [domain,[[dom,X]],1]]):-
	del_db(domain),
	asserta(domain(X)).
store_sr_data([infon, [link, [[from,X],[to,Y]],1]]):-
	update_slink(X,Y).
store_sr_data([infon, [str,[[order,X]],1]]):-
	str_order(Z),
	del_db(str_order),
	asserta(str_order(X)).
store_sr_data([infon, INF]):-
	store_term([[w],INF,0]).

/* update_slink(X,Y) :- 
    XY˥󥯤ĥƤ뤳Ȥ򥹥ȥ */
update_slink(X,Y):-
	s_link(L),
	update_slink(L,X,Y,LL),
	del_db(s_link),
	asserta(s_link(LL)).
update_slink([],X,Y,[[X,[Y]]]).
update_slink([[X,Lx]|L],X,Y,[[X,Lx]|L]):-
	user:member(Y,Lx).
update_slink([[X,Lx]|L],X,Y,[[X,[Y|Lx]]|L]).
update_slink([E|L],X,Y,[E|LL]):-
	update_slink(L,X,Y,LL).

/* ζ */
stronger(X,Y):-
	str_order(Str),
	user:nth(Nx,Str,X),
	user:nth(Ny,Str,Y),
	Nx < Ny.

/* store_rule(X) :- 롼ǡ١˲ä */
store_rule([E,Rule]):-
	rules(Rules),
	new_id(r_id,Id),
	del_db(rules),
	asserta(rules([[Id,Rule]|Rules])),
	store_sr(E,Id).
store_sr(E,Id):-
	sr(SM),
	store_sr(SM,E,Id,SM_new),
	del_db(sr),
	asserta(sr(SM_new)).
store_sr([],E,Id,[[E,[Id]]]).
store_sr([[E,X]|SM],E,Id,[[E,[Id|X]]|SM]).
store_sr([X|SM],E,Id,[X|SM_new]):-
	store_sr(SM,E,Id,SM_new).

/* store_term(X) :- ǡ١˲ä */
store_term([Sit,Inf,St]):-
	store_infon(Inf,Id),
	store_sm(Sit,Id,St).

/* store_infon(Inf,I_id) :- infoninfons list˲ä, id */
store_infon(Inf,I_id):-
	infons(Infs),
	check_member(Inf,Infs,Id),
	store_infon1(Inf,Infs,Id,I_id,New_infs),
	del_db(infons),
	asserta(infons(New_infs)).
store_infon1(Inf,Infs,-1,I_id,[[I_id,Inf]|Infs]):-
	new_id(i_id,I_id).
store_infon1(_,Infs,Id,Id,Infs).

/* store_sm(Sit,Id,Stype) :- Sitid=IdΥե
   ݡȴطStypeǤ뤳Ȥǡ١˲ä */
store_sm(Sit,Id,0):-
	support_map0(SM),
	store_sm0(SM,Sit,Id,SM_new),
	del_db(support_map0),
	asserta(support_map0(SM_new)).
store_sm0([],[],_,[]).
store_sm0([],Sit,Id,SM_new):-
	store_sm01(Sit,Id,SM_new).
store_sm01([],_,[]).
store_sm01([E|Sit],Id,[[E,[Id]]|SM_new]):-
	store_sm01(Sit,Id,SM_new).
store_sm0([E|SM],Sit,Id,[E_new|SM_new]):-
	store_sm0_sub(E,Sit,Id,E_new,Sit_new),
	store_sm0(SM,Sit_new,Id,SM_new).
store_sm0([E|SM],Sit,Id,[E|SM_new]):-
	store_sm0(SM,Sit,Id,SM_new).
store_sm0_sub([S,Infons],Sit,Id,[S,[Id|Infons]],Sit_new):-
	user:member(S,Sit),
	user:non_member(Id,Infons),
	user:delete(Sit,S,Sit_new).
store_sm0_sub([S,Infons],Sit,Id,[S,Infons],Sit_new):-
	user:member(S,Sit),
	user:delete(Sit,S,Sit_new).

/* ǡ١ΤμФƿid֤ */
new_id(Type,Id):-
	bb_get(Type,Id),
	Id_next is Id + 1,
	bb_put(Type,Id_next).

/* infonsǡ١νʣ򤱤 */
check_member(Inf,[],-1).
check_member(Inf,[[Id,Inf]|_],Id).
check_member(Inf,[[_,X]|As],Id):-
	check_member(Inf,As,Id).

/* support(E,Inf,Type) :- 
    EϥTypeǥեInf򥵥ݡȤ */
support(E,Inf,0):-
	support0(E,Inf).
support(E,Inf,1):-
	support1(E,Inf).
support(E,Inf,2):-
	support2(E,Inf).

/* support0(E,Inf) :- EեInf򥵥ݡȤƤ */
support0(E,Inf):-
	atom(E),
	get_data(support_map0,E,Infs),!,
	user:member(Id,Infs),
	get_data(infons,Id,Inf).

/* get_data(Map_name,Key,Result)
	:- ޥåMap_nameKey򥭡ˤͤ */
get_data(Map_name,Key,Val):-
	Pred=..[Map_name,Contents],
	Pred,!,
	u:assoc(Key,Contents,Val).

/* rs(E) :- Ereasoning situationǤ */
rs(E) :-
	str_order(X),
	user:member(E,X).

/* rule(Id,Rule) :- Ruleϥ롼idIdΥ롼Ǥ */
rule(Id,Rule):-
	get_data(rules,Id,Rule).

/* link(S1,S2) :- S1S2ܤƤ */
link(S1,S2):-
	get_data(s_link,S1,SL),
	user:member(S2,SL).
link(S,nil).

/* get_domain([First,Last,Nes],Dom):- , , ɬܥꥹȤõϰϤ */
get_domain([First,Last,Nes],Dom):-
	get_domain_f(First,Rf),
	get_domain_l(Last,Rl),
	u:intersection([Rf,Rl],Dom),
	u:subset(Nes,Dom).

get_domain_f(nil,All):-
	domain(All).
get_domain_f(First,Rf):-
	get_domain_f1([First],Rf).
get_domain_f1([X|L],[X|Res]):-
	get_data(s_link,X,S),
	u:union([S,L],Tmp),
	get_domain_f1(Tmp,Res).
get_domain_f1(R,R).

get_domain_l(nil,All):-
	domain(All).
get_domain_l(Last,Rl):-
	get_domain_l1([Last],Rl).
get_domain_l1([X|L],[X|Res]):-
	setof(Y,link(Y,X),S),
	u:union([S,L],Tmp),
	get_domain_l1(Tmp,Res).
get_domain_l1(R,R).
/* ⥸塼 */

/* solve(Query,Answer):-
	QueryФyes, noѿΥХɤ֤ */
% solve(Goal)
solver([Sit,Inf,St],Out):-
	var(Sit),
	db:domain(All_s),
	solve([[Sit,Inf,St]],[[Sit,[nil,nil,[],All_s]]],Out_raw),!,
	output(Out_raw,Out).
solver([Sit,Inf,St],Out):-
	ground(Sit),
	user:nth(1,Sit,First),user:last(Sit,Last),
	solve([[Sit,Inf,St]],[[Sit,[First,Last,Sit,Sit]]],Out_raw),!,
	output(Out_raw,Out).

get_range(X,[First,Last,X,X]):-
	ground(X),
	user:nth(1,X,First),user:last(X,Last).

/* solve(Goals,In,Out):- ʣGoalsФƤξ */
solve([],_,[]):-!.
solve([G|Goal],In,Out):-
	[Sit,Inf,St]=G,
	get_in1(Sit,In,In_g),
	solve_s(G,In_g,Out_g),
	solve(Goal,In,Out_goal),
	merge_sl(Out_g,Out_goal,Out).

/* solve_s(Goal,In,Out):- 1ĤGoalФƤξ */
solve_s([Sit,Inf,0],[Sit,[F,L,N,R]],[Sit,[F,L,N,Res]]):-
	solve_e(R,Inf,Res),!,
	Res\==[],
	u:subset(N,Res).
solve_s([Sit,Inf,0],In,Out):-
	solve_r([Sit,Inf,0],In,Out,S).
/*
solve_s([Sit,Inf,1],In,Out):-
	solve_r([Sit,Inf,0],In,Out,S).
solve_s([Sit,Inf,1],[Sit,[F,L,N,R]],[Sit,[F,L,N,Res]]):-
	solve_e(R,Inf,Res),
	u:subset(N,Res).
solve_s([Sit,Inf,2],In,Out):-
	solve_r([Sit,Inf,0],In,Out,S).
solve_s([Sit,Inf,2],[Sit,[F,L,N,R]],[Sit,[F,L,N,Res]]):-
	solve_e(R,Inf,Res),
	u:subset(N,Res).
*/
/* solve_e(Range,Inf,RR) :- 
  եInfΩäƤ뤫RangeĴ٤ */
solve_e([],_,[]):-!.
solve_e([E|R],Inf,[E|Res]):-
	solve_e1(E,Inf),
	solve_e(R,Inf,Res).
solve_e([E|R],Inf,Res):-
	solve_e(R,Inf,Res).
solve_e1(E,Inf):-
	db:support0(E,Inf),
	u:dual(Inf,Inf_dual),
	\+db:support0(E,Inf_dual).
solve_e1(E,Inf):-
	solve_r([[E],Inf,0],[[E],[E,E,[E],[E]]],_,S),
	u:dual(Inf,Inf_dual),
	db:support0(E,Inf_dual),!,fail.
solve_e1(E,Inf):-
	solve_r([[E],Inf,0],[[E],[E,E,[E],[E]]],_,S),
	u:dual(Inf,Inf_dual),
	solve_r([[E],Inf_dual,0],[[E],[E,E,[E],[E]]],_,S_dual),!,
	db:stronger(S,S_dual).
solve_e1(E,Inf):-
	solve_r([[E],Inf,0],[[E],[E,E,[E],[E]]],_,S).

/* solve_r(Goal,In,Out):- 롼뤫Goal褹 */
solve_r(Goal,In,Out,E):-
	db:rs(E),
	db:get_data(sr,E,Ids),
	user:member(Id,Ids),
	db:rule(Id,[Head,Body,BC]),
	unify(Goal,Head),
	sv(Body,VL_body),
	cs_in(In,VL_body,BC,In_body),
	solve(Body,In_body,Out_raw),
	cs_out(Out_raw,BC,Out),
	disp(Head,Body,Out),!.


disp(Head,Body,Out):-!,
	sv([Head],[]),
	tr:transfer_itoe([term,Head],Hex),
	name(X,Hex),
	format("~k<-\n",[X]),
	disp1(Body,Out).
disp(Head,Body,Out):-
	sv([Head],[Vhead]),
	get_in1(Vhead,Out,X),
	[_,[_,_,N,N]]=X,
	user:substitute(Vhead,Head,N,H),
	tr:transfer_itoe([term,H],Hex),
	name(X,Hex),
	format("~k<-\n",[X]),
	disp1(Body,Out).
disp1([],_).
disp1([B|Body],Out):-
	sv([B],[]),
	tr:transfer_itoe([term,B],Bex),
	name(X,Bex),
	format("   ~k\n",[X]),
	disp1(Body,Out).
disp1([B|Body],Out):-
	sv([B],[Vb]),
	get_in1(Vb,Out,X),
	[_,[_,_,N,N]]=X,
	user:substitute(Vb,B,N,BB),
	tr:transfer_itoe([term,BB],Bex),
	name(Y,Bex),
	format("   ~k\n",[Y]),
	disp1(Body,Out).

bind([],_).
bind([E|VL],Out):-
	get_in1(E,Out,X),
	[_,[_,_,N,N]]=X,
	E=N,
	bind(VL,Out).
bind([_|VL],Out):-
	bind(VL,Out).

cs_out(In,[],In).
cs_out(In,[[Rel,Args,_]|BC],Out):-
	C=..[Rel,Args,In,Res],
	cs_out:C,
	merge_sll(In,Res,Inn),
	cs_out(Inn,BC,Out).


/*
cs_out(Out_raw,Out).
*/

get_sit(Range,[First|S]):-
	user:member(First,Range),
	get_sit1(Range,First,S).
get_sit1(Range,E,[Next|S]):-
	db:link(E,Next),user:member(Next,Range),
	get_sit1(Range,Next,S).
get_sit1(Range,E,[]):-
	db:link(E,nil).

first([],[]).
first([E|Range],[E|FL]):-
	\+db:link(_,E),
	first(Range,FL).
first([E|Range],FL):-
	first(Range,FL).

/* cs_in(In,VL_body,BC,In_body):-
    InꥹȤѿVL_bodyطʾBCIn_body */
cs_in(In,VL_body,BC,In_body):-!,
	cs_in(In,BC,R),
	sv(R,RV),
	u:sabun(VL_body,RV,V),
	vl_add(V,R,In_body).
cs_in(In,[],[In]):-!.
cs_in(In,[[Rel,Args,_]|BC],R):-
	C=..[Rel,Args,Res],
	cs:C,!,
	merge_sl(In,Res,Inn),
	cs_in1(Inn,BC,R).
cs_in1(Inn,[],Inn).
cs_in1(Inn,[[Rel,Args,_]|BC],R):-
	C=..[Rel,Args,Res],
	cs:C,!,
	merge_sll(Inn,Res,Inn1),
	cs_in1(Inn,BC,R).
vl_add([],R,R):-!.
vl_add([E|V],R,[[E,[nil,nil,[],X]]|In]):-
	db:get_domain([nil,nil,[]],X),
	vl_add(V,R,In).

/* 󥸽Υޡ */
merge_sll([],Res,Res).
merge_sll([E|S],Res,Inn1):-
	merge_sl(E,Res,Res1),
	merge_sll(S,Res1,Inn1).
merge_sl(S,[],[S]).
merge_sl([Sit,Range],[[S,Ra]|SL],[[Sit,Res]|SL]):-
	Sit==S,merge_range(Range,Ra,Res).
merge_sl(S,[E|SL],[E|R]):-
	merge_sl(S,SL,R).

/* 󥸤Υޡ */
merge_range([F1,L1,N1,R1],[F2,L2,N2,R2],[F3,L3,N3,R3]):-
	merge_range_f(F1,F2,F3),
	merge_range_l(L1,L2,L3),
	merge_range_n(N1,N2,N3),
	merge_range_r(R1,R2,R3),
	u:subset(N3,R3).
merge_range_f(nil,F2,F3):-
	F3=F2.
merge_range_f(F1,nil,F3):-
	F3=F1.
merge_range_l(nil,L2,L3):-
	L3=L2.
merge_range_l(L1,nil,L3):-
	L3=L1.
merge_range_n(N1,N2,N3):-
	u:union([N1,N2],N3).
merge_range_r(R1,R2,R3):-
	u:intersection([R1,R2],R3).

/* sv(LL,VL):- LLKeyȤʤѿνVL */
sv([],[]).
sv([[S|_]|L],[S|VL]):-
	var(S),
	sv(L,VL).
sv([[S|_]|L],VL):-
	nonvar(S),
	sv(L,VL).
/* get_in(Sit,SL,S,L):- SitΥSȻĤL֤ */
get_in1(Sit,[[S,Range]|L],[S,Range]):-
	Sit == S.
get_in1(Sit,[[S,Range]|L],In):-
	Sit \== S,
	get_in1(Sit,L,In).
/*
get_in(Sit,[[S,Range]|L],[S,Range],L):-
	Sit == S.
get_in(Sit,[X|VL],In,[X|L]):-
	get_in(Sit,VL,In,L).
*/

/* output(Out_raw,Out) :- Υ󥸤θ֤ */
output([],[]).
output([E|Out_raw],[S|Out]):-
	situation(E,S),
	output(Out_raw,Out).
output([E|Out_raw],Out):-
	output(Out_raw,Out).

situation([Sit,[F,L,N,R]],_):-
	ground(Sit),!,fail.
situation([Sit,[F,L,N,R]],[Sit,S]):-
	get_sit(R,S),
	firstp(F,S),
	lastp(L,S),
	u:subset(N,S).
firstp(nil,S).
firstp(F,[F|S]).
lastp(nil,S).
lastp(L,S):-
	user:last(L,S).
/* ˥ե󡦥⥸塼 */
unify([S1,I1,St1],[S2,I2,St2]):-
	St1==St2,
	var(S2),S2=S1,
	unify_inf(I1,I2).
unify([S1,I1,St1],[S2,I2,St2]):-
	St1==St2,
	ground(S1),ground(S2),
	S1==S2,
	unify_inf(I1,I2).
unify_val(V1,V2):-
	atom(V1),atom(V2),V1==V2.
unify_val(V1,V2):-
	var(V2),V2=V1.
unify_val(V1,V2):-
	var(V1),V1=V2.
unify_val([S1,I1,P1],[S2,I2,P2]):-
	P1==P2,
	var(S2),S2=S1,
	unify_inf(I1,I2).
unify_inf(X,Y):-
	var(X),ground(Y),X=Y.
unify_inf(X,Y):-
	var(Y),ground(X),Y=X.
unify_inf([R1,A1,P1],[R2,A2,P2]):-
	P1==P2,atom(R1),atom(R2),R1==R2,
	unify_args(A1,A2).
unify_args([],[]):-!.
unify_args(_,[]):-!.
unify_args([],_):-!.
unify_args(Args_s,Args_t):-
        u:assoc(Key,Args_s,Val_s),
        u:assoc(Key,Args_t,Val_t),
        S=[Key,Val_s],T=[Key,Val_t],
        u:delete(Args_s,S,Res_s),u:delete(Args_t,T,Res_t),
        unify_val(Val_s,Val_t),
        unify_args(Res_s,Res_t).
/*
unify([S1,T1],[S2,T2]):-
	sit_unify(S1,S2),
	term_unify(T1,T2).

sit_unify(S1,S2):-
	var(S1),S1=S2.
sit_unify(S1,S2):-
	atom(S1),var(S2),S2=S1.
sit_unify(S1,S2):-
	atom(S1),atom(S2),S1==S2.

term_unify(T1,T2):-
	var(T2),T2=T1.
term_unify(T1,T2):-
	var(T1),T1=T2.
term_unify(T1,T2):-
	compound(T1),compound(T2),term_unify1(T1,T2).

term_unify1([R2,P1,Args1],[R2,P2,Args2]):-
	P1 \== P2, !, fail.
term_unify1([R,P,Args1],[R,P,Args2]):-
	unify_args(Args1,Args2).

unify_args([],[]):-!.
unify_args(_,[]):-!.
unify_args([],_):-!.
unify_args(Args_s,Args_t):-
        assoc(Key,Args_s,Val_s),
        assoc(Key,Args_t,Val_t),
        S=[Key,Val_s],T=[Key,Val_t],
        delete(Args_s,S,Res_s),delete(Args_t,T,Res_t),
        unify(Val_s,Val_t),
        unify_args(Res_s,Res_t).
*//* ѽҸ */
:- module(u,[]).

/* replace(L1,X,Y,L2) :- L1XY˴ΤL2 */
replace([],_,_,[]).
replace([E|L1],X,Y,[Y|L2]):-
	E==X,
	replace(L1,X,Y,L2).
replace([E1|L1],X,Y,[E2|L2]):-
	user:is_list(E1),
	replace(E1,X,Y,E2),
	replace(L1,X,Y,L2).
replace([E1|L1],X,Y,[E1|L2]):-
	replace(L1,X,Y,L2).

/* 
 assoc(+Key,+Alist,-Value) :- AlistKeyбͤValueǤ 
 argument˻Ȥ
*/
assoc(_,[],_):-!,fail.
assoc(Key,[[Key,Value]|Alist],Value).
assoc(Key,[X|Alist],Value):-
        assoc(Key,Alist,Value).

% assoc_wide(Key_list,Alist,Value_list) :- assocγĥ
assoc_wide([],_,[]).
assoc_wide([V|VL],SLb,[Sv|SL]):-
	assoc_wide1(V,SLb,Sv),
	assoc_wide(VL,SLb,SL).
assoc_wide1(_,[],_):- !,fail.
assoc_wide1(V,[X|SLb],Sv):-
	X=[W,Sv], W==V.
assoc_wide1(V,[X|SLb],Sv):-
	assoc_wide1(V,SLb,Sv).

/* delete1(L1,X,L2) :- L1XĤΤL2 */
delete1([],_,[]):-!.
delete1([X|Xs],X,Y):-delete1_s1(Xs,X,Y).
delete1([X|Xs],Z,[X|Y]):-delete1(Xs,Z,Y).
delete1_s1(Xs,_,Xs).

/* delete(+L1,+X,-L2) :- L1X򤹤٤ƽΤL2Ǥ */
delete([],_,[]):-!.
delete([X|L1],X,L2):-delete(L1,X,L2).
delete([Z|L1],X,[Z|L2]):-Z \== X,delete(L1,X,L2).

% sabun(X,Y,X-Y)
sabun([],_,[]):-!.
sabun([X1|X],Y,Z):-
	member(X1,Y),!,
	sabun(X,Y,Z).
sabun([X1|X],Y,[X1|Z]):-!,
	sabun(X,Y,Z).

% get_sl(Var_list,Sit_list,Sub_sit_list)
get_sl(Var_list,Sit_list,Sub_sit_list):-
	assoc_wide(Var_list,Sit_list,Sub_sit_list).

/* pred(Inrep, Pred):-
	फҸФ */
pred([_,[Pred|_]|_],Pred).
/* args(Inrep, Args):-
	argumentफФ */
args([_,[_,Args|_]|_],Args).

/* capital(X) :- Xκǽ餬ʸʤ yes */
capital(X):-
	'A' @=< X,
	X @< 'a'.
/* append(LList,List) :- ꥹȤΥꥹȤĤʤ */
append([],[]).
append([E|LL],L1):-
	user:append(E,L2,L1),
	append(LL,L2).

/* sitp(+Sit):- SitϾǤ. */
sitp([X,Y]):-
	db:link(X,Y).
sitp([X,Y|Sit]):-
	db:link(X,Y),
	sit([Y|Sit]).

intersection([X|L],Res):-
	intersection([X|L],Res,X).
intersection([],R,R).
intersection([X|L],Res,Tmp):-
	intersection1(X,Tmp,Tmp1),
	intersection(L,Res,Tmp1).
intersection1([],_,[]).
intersection1([E|X],Tmp,[E|Tmp1]):-
	user:member(E,Tmp),
	intersection1(X,Tmp,Tmp1).
intersection1([_|X],Tmp,Tmp1):-
	intersection1(X,Tmp,Tmp1).

union(L,Res):-
	union(L,Res,[]).
union([],R,R).
union([X|L],Res,Tmp):-
	union1(X,Tmp,Tmp1),
	union(L,Res,Tmp1).
union1([],Tmp,Tmp).
union1([E|X],Tmp,[E|Tmp1]):-
	user:non_member(E,Tmp),
	union1(X,Tmp,Tmp1).
union1([E|X],Tmp,Tmp1):-
	union1(X,Tmp,Tmp1).

subset([],_).
subset([X|L1],L2):-
	user:member(X,L2),
	subset(L1,L2).

member(E0,[]):-!,fail.
member(E0,[E1|L]):-
	E0==E1.
member(E0,[E1|L]):-
	member(E0,L).

dual([Rel,Args,0],[Rel,Args,1]).
dual([Rel,Args,1],[Rel,Args,0]).

meet(S1,S2):-
	user:last(S1,L),
	user:nth(1,S2,F),
	db:link(L,F).
/* å⥸塼 */
:- module(cs,[]).

/* time(Args,Res):-ִطRes֤ */

time([[pre,S1],[post,S2]],Res):-
	time(S1,S2,Res).
time(S1,S2,[[S1,[nil,L,[],X]]]):-
	var(S1),ground(S2),
	user:nth(1,S2,F),
	db:link(L,F),
	db:get_domain([nil,L,[]],X).
time(S1,S2,[[S2,[F,nil,[],X]]]):-
	ground(S1),var(S2),
	user:last(S1,L),
	db:link(L,F),
	db:get_domain([F,nil,[]],X).

time([[pre,S1],[post,S2],[event,E]],Res):-
	time(S1,S2,E,Res).
time(S1,S2,E,[[S2,[F2,nil,[],X2]],[E,[EE,EE,[EE],[EE]]]]):-
	ground(S1),var(S2),var(E),
	user:last(S1,L1),
	db:link(L1,F2),
	db:get_domain([F2,nil,[]],X2),
	db:support0(w,[time,[[pre,L1],[post,F2],[event,EE]],1]).
time(S1,S2,E,[[S1,[nil,L1,[L1],X1]],[E,[EE,EE,[EE],[EE]]]]):-
	ground(S2),var(S1),var(E),
	user:nth(1,S2,F2),
	db:link(L1,F2),
	db:get_domain([nil,L1,[L1]],X1),
	db:support0(w,[time,[[pre,L1],[post,F2],[event,EE]],1]).
time(S1,S2,E,[[S2,[F2,nil,[],X2]],[S1,[nil,L1,[],X1]]]):-
	ground(E),var(S1),var(S2),
	db:support0(w,[time,[[pre,L1],[post,F2],[event,E]],1]),
	db:get_domain([nil,L1,[]],X1),
	db:get_domain([F2,nil,[]],X2).
time(S1,S2,E,[[S1,[nil,nil,[],All_s]],[S2,[nil,nil,[],All_s]],[E,[nil,nil,[],All_s]]]):-
	var(S1),var(S2),var(E),
	db:domain(All_s).

subset([[sub,S],[super,T]],Res):-
	subset(S,T,Res).
subset(S,T,[[T,[F,nil,[F],Tr]]]):-
	ground(S),var(T),
	user:last(L,S),
	db:link(L,F),
	db:get_domain([F,nil,[F]],Tr).
subset(S,T,[[S,[nil,L,[L],Sr]]]):-
	ground(T),var(S),
	user:nth(1,F,T),
	db:link(L,F),
	db:get_domain([nil,L,[L]],Sr).
subset(S,T,[[S,[nil,nil,[],All_s]],[T,[nil,nil,[],All_s]]]):-
	var(T),var(S),
	db:domain(All_s).

union([[s1,S1],[s2,S2],[s3,S3]],Res):-
	union(S1,S2,S3,Res).
union(S1,S2,S3,[[S2,[S2f,nil,[S2f],S2r]],[S3,[S1f,nil,S3n,S3r]]]):-
	ground(S1),var(S2),var(S3),
	user:nth(1,S1f,S1),
	user:last(S1l,S1),
	db:link(S1l,S2f),
	db:get_domain([S2f,nil,[S2f]],S2r),
	user:append(S1,S2f,S3n),
	db:get_domain([S1f,nil,S3n],S3r).
union(S1,S2,S3,[[S1,[nil,S1l,[S1l],S1r]],[S3,[nil,S2l,[S1l|S2],S3r]]]):-
	var(S1),ground(S2),var(S3),
	user:nth(1,S2f,S2),
	user:last(S2l,S2),
	db:link(S1l,S2f),
	db:get_domain([nil,S1l,[S1l]],S1r),
	db:get_domain([nil,S2l,[S1l|S2]],S3r).
union(S1,S2,S3,[S1,[nil,nil,[],All]],[S2,[nil,nil,[],All]],[S3,[nil,nil,[],All]]):-
	var(S1),var(S2),var(S3),
	db:domain(All).

meet([[pre,S1],[post,S2]],Res):-
	meet(S1,S2,Res).
meet(S1,S2,[[S1,[nil,L,[],X]]]):-
	var(S1),ground(S2),
	user:nth(1,S2,F),
	db:link(L,F),
	db:get_domain([nil,L,[]],X).
meet(S1,S2,[[S2,[F,nil,[],X]]]):-
	ground(S1),var(S2),
	user:last(S1,L),
	db:link(L,F),
	db:get_domain([F,nil,[]],X).
meet(S1,S2,[[S1,[nil,nil,[],All]],[S2,[nil,nil,[],All]]]):-
	var(S1),var(S2),
	db:domain(All).:- module(cs_out,[]).

meet([[pre,S1],[post,S2]],In,[[S1,C1r],[S2,C2r]]):-
	inf:get_in1(S1,In,In_1),
	inf:get_in1(S2,In,In_2),!,
	inf:output([In_1,In_2],[[S1,C1],[S2,C2]]),
	u:meet(C1,C2),
	inf:get_range(C1,C1r),
	inf:get_range(C2,C2r).

union([[s1,S1],[s2,S2],[s3,S3]],In,[[S1,C1r],[S2,C2r],[S3,C3r]]):-
	get_in1(S1,In_1,In),
	get_in1(S2,In_2,In),
	get_in1(S3,In_3,In),!,
	inf:output([In_1,In_2,In_3],[[S1,C1],[S2,C2],[S3,C3]]),
	u:union(C1,C2,C3),
	inf:get_range(C1,C1r),
	inf:get_range(C2,C2r),
	inf:get_range(C3,C3r).

subset([[sub,S1],[super,S2]],In,[[S1,C1r],[S2,C2r]]):-
	inf:get_in1(S1,In,In_1),
	inf:get_in1(S2,In,In_2),!,
	inf:output([In_1,In_2],[[S1,C1],[S2,C2]]),
	u:subset(C1,C2),
	inf:get_range(C1,C1r),
	inf:get_range(C2,C2r).
