%  Shaky v1.0      Copyright (C) 1997, Masanori Ohmori (oomori@jaist.ac.jp) 
/* ط⥸塼 */
:- module(rel,[]).

/*
[ִطcheck]
 overlap, meet, union, preceed, subset
*/

% overlap(X,Y)
overlap(X,Y):-
	member(W,X),
	member(W,Y).

% meet(X,Y)
% meet(t1,t2).
% meet(t2,t3).
% meet(t3,t4).

meet(X,[First|Y]):-
	last(X,Last),
	meet(Last,First).

% union(X,Y,Z)
union(X,Y,_):-
	\+meet(X,Y),
	\+overlap(X,Y),!,fail.
union(X,Y,Z):-
	preceed(X,Y),
	append(X,Y,XY),!,
	remove_duplicates(XY,Z).
union(X,Y,Z):-
	append(Y,X,XY),!,
	remove_duplicates(XY,Z).

% preceed(X,Y)
preceed([Fx|X],[Fy|Y]):-
	preceed(Fx,Fy).
preceed(Fx,Fy):-
	meet(Fx,Fy).
preceed(Fx,Fy):-
	meet(Fx,W),
	preceed(W,Fy).

% subset(X,Y)
subset([],_).
subset([X1|X],Y):-
	subset1(X1,Y),
	subset(X,Y).
subset1(_,[]):-!,fail.
subset1(X1,[X1|Y]).
subset1(X1,[Y1|Y]):-
	subset1(X1,Y).

% get_se(Sit,Start,End)
get_se(Sit,Start,End):-
	get_s(Sit,Sit,Start),
	get_e(Sit,Sit,End).
get_s([],_,[]).
get_s([X|S],Sit,Start):-
	link(Y,X),
	member(Y,Sit),
	get_s(S,Sit,Start).
get_s([X|S],Sit,[X|Start]):-
	link(Y,X),
	\+member(Y,Sit),
	get_s(S,Sit,Start).
get_s([X|S],Sit,[X|Start]):-
	\+link(Y,X),
	get_s(S,Sit,Start).

get_e([],_,[]).
get_e([X|S],Sit,End):-
	link(X,Y),
	member(Y,Sit),
	get_e(S,Sit,End).
get_e([X|S],Sit,[X|End]):-
	link(X,Y),
	\+member(Y,Sit),
	get_e(S,Sit,End).
get_e([X|S],Sit,[X|End]):-
	\+link(Y,X),
	get_e(S,Sit,End).

% situationp(Sit)
