%	grammar.pl, Shaky v1.0
%	Copyright (C) 1997, Masanori Ohmori (oomori@jaist.ac.jp)
%
%       A grammar for translating

:- module(g,[]).

s([rule, [ES,RULE]]) --> e_sit(ES),[':',':'],rule(RULE),['.'].
s([term, TERM]) --> term(TERM),['.'].
s([infon, INF]) --> infon(INF),['.'].
term([SIT,INF,0]) --> sit(SIT),[':'],infon(INF).
term([SIT,INF,1]) --> sit(SIT),[':','='],infon(INF).
term([[ES],INF,2]) --> e_sit(ES),[':','>'],infon(INF).
e_sit(ATOM) --> [ATOM],{a @=< ATOM, ATOM @< '{'}.
sit(VAR) --> var(VAR).
sit([ES]) --> e_sit(ES).
sit([ES|SIT]) --> e_sit(ES),[','],sit(SIT).
infon([REL,ARGS,0]) --> ['-'],rel(REL),['('],args(ARGS),[')'].
infon([REL,[],0]) --> ['-'],rel(REL).
infon([REL,ARGS,1]) --> rel(REL),['('],args(ARGS),[')'].
infon(VAR) --> var(VAR).
infon([REL,[],1]) --> rel(REL).
rel(ATOM) --> [ATOM], {a @=< ATOM, ATOM @< '{'}.
var(VAR) --> [VAR], {'A' @=< VAR, VAR @< '['}.
args([ARG]) --> arg_s(ARG).
args([ARG|ARGS]) --> arg_s(ARG),[','], args(ARGS).
arg_s([LVL,VAL]) --> label(LVL),['='],val(VAL).
label(ATOM) --> [ATOM], {a @=< ATOM, ATOM @< '{'}.
val(LIST) --> ['['],list(LIST),[']'].
val(ATOM) --> [ATOM], {a @=< ATOM, ATOM @=< '~~'}.
val(VAR) --> var(VAR).
val(TERM) --> term(TERM).
val(INF) --> infon(INF).
list([ATOM]) --> [ATOM].
list([ATOM|LIST]) --> [ATOM],[','],list(LIST), {a @=< ATOM, ATOM @< '{'}.
rule([HEAD,BODY,BC]) --> head(HEAD),['<','-'],body(BODY),['|'],bc(BC).
rule([HEAD,BODY,[]]) --> head(HEAD),['<','-'],body(BODY).
head(TERM) --> term(TERM).
body([TERM]) --> term(TERM).
body([TERM|BODY]) --> term(TERM),[','],body(BODY).
bc([INF]) --> infon(INF).
bc([INF|BC]) --> infon(INF),[','],bc(BC).
