%	cs_out.pl, Shaky v1.0
%	Copyright (C) 1997, Masanori Ohmori (oomori@jaist.ac.jp)
%
%       Constraint Solver

:- module(cs_out,[]).

meet([[pre,S1],[post,S2]],In,[[S1,C1r],[S2,C2r]]):-
	inf:get_in1(S1,In,In_1),
	inf:get_in1(S2,In,In_2),!,
	inf:output([In_1,In_2],[[S1,C1],[S2,C2]]),
	u:meet(C1,C2),
	inf:get_range(C1,C1r),
	inf:get_range(C2,C2r).

union([[s1,S1],[s2,S2],[s3,S3]],In,[[S1,C1r],[S2,C2r],[S3,C3r]]):-
	get_in1(S1,In_1,In),
	get_in1(S2,In_2,In),
	get_in1(S3,In_3,In),!,
	inf:output([In_1,In_2,In_3],[[S1,C1],[S2,C2],[S3,C3]]),
	u:union(C1,C2,C3),
	inf:get_range(C1,C1r),
	inf:get_range(C2,C2r),
	inf:get_range(C3,C3r).

subset([[sub,S1],[super,S2]],In,[[S1,C1r],[S2,C2r]]):-
	inf:get_in1(S1,In,In_1),
	inf:get_in1(S2,In,In_2),!,
	inf:output([In_1,In_2],[[S1,C1],[S2,C2]]),
	u:subset(C1,C2),
	inf:get_range(C1,C1r),
	inf:get_range(C2,C2r).
