%	cs.pl, Shaky v1.0
%	Copyright (C) 1997, Masanori Ohmori (oomori@jaist.ac.jp)
%
%       Constraint Solver

/* å⥸塼 */
:- module(cs,[]).

/* time(Args,Res):-ִطRes֤ */

time([[pre,S1],[post,S2]],Res):-
	time(S1,S2,Res).
time(S1,S2,[[S1,[nil,L,[],X]]]):-
	var(S1),ground(S2),
	user:nth(1,S2,F),
	db:link(L,F),
	db:get_domain([nil,L,[]],X).
time(S1,S2,[[S2,[F,nil,[],X]]]):-
	ground(S1),var(S2),
	user:last(S1,L),
	db:link(L,F),
	db:get_domain([F,nil,[]],X).

time([[pre,S1],[post,S2],[event,E]],Res):-
	time(S1,S2,E,Res).
time(S1,S2,E,[[S2,[F2,nil,[],X2]],[E,[EE,EE,[EE],[EE]]]]):-
	ground(S1),var(S2),var(E),
	user:last(S1,L1),
	db:link(L1,F2),
	db:get_domain([F2,nil,[]],X2),
	db:support0(w,[time,[[pre,L1],[post,F2],[event,EE]],1]).
time(S1,S2,E,[[S1,[nil,L1,[L1],X1]],[E,[EE,EE,[EE],[EE]]]]):-
	ground(S2),var(S1),var(E),
	user:nth(1,S2,F2),
	db:link(L1,F2),
	db:get_domain([nil,L1,[L1]],X1),
	db:support0(w,[time,[[pre,L1],[post,F2],[event,EE]],1]).
time(S1,S2,E,[[S2,[F2,nil,[],X2]],[S1,[nil,L1,[],X1]]]):-
	ground(E),var(S1),var(S2),
	db:support0(w,[time,[[pre,L1],[post,F2],[event,E]],1]),
	db:get_domain([nil,L1,[]],X1),
	db:get_domain([F2,nil,[]],X2).
time(S1,S2,E,[[S1,[nil,nil,[],All_s]],[S2,[nil,nil,[],All_s]],[E,[nil,nil,[],All_s]]]):-
	var(S1),var(S2),var(E),
	db:domain(All_s).

subset([[sub,S],[super,T]],Res):-
	subset(S,T,Res).
subset(S,T,[[T,[F,nil,[F],Tr]]]):-
	ground(S),var(T),
	user:last(L,S),
	db:link(L,F),
	db:get_domain([F,nil,[F]],Tr).
subset(S,T,[[S,[nil,L,[L],Sr]]]):-
	ground(T),var(S),
	user:nth(1,F,T),
	db:link(L,F),
	db:get_domain([nil,L,[L]],Sr).
subset(S,T,[[S,[nil,nil,[],All_s]],[T,[nil,nil,[],All_s]]]):-
	var(T),var(S),
	db:domain(All_s).

union([[s1,S1],[s2,S2],[s3,S3]],Res):-
	union(S1,S2,S3,Res).
union(S1,S2,S3,[[S2,[S2f,nil,[S2f],S2r]],[S3,[S1f,nil,S3n,S3r]]]):-
	ground(S1),var(S2),var(S3),
	user:nth(1,S1f,S1),
	user:last(S1l,S1),
	db:link(S1l,S2f),
	db:get_domain([S2f,nil,[S2f]],S2r),
	user:append(S1,S2f,S3n),
	db:get_domain([S1f,nil,S3n],S3r).
union(S1,S2,S3,[[S1,[nil,S1l,[S1l],S1r]],[S3,[nil,S2l,[S1l|S2],S3r]]]):-
	var(S1),ground(S2),var(S3),
	user:nth(1,S2f,S2),
	user:last(S2l,S2),
	db:link(S1l,S2f),
	db:get_domain([nil,S1l,[S1l]],S1r),
	db:get_domain([nil,S2l,[S1l|S2]],S3r).
union(S1,S2,S3,[S1,[nil,nil,[],All]],[S2,[nil,nil,[],All]],[S3,[nil,nil,[],All]]):-
	var(S1),var(S2),var(S3),
	db:domain(All).

meet([[pre,S1],[post,S2]],Res):-
	meet(S1,S2,Res).
meet(S1,S2,[[S1,[nil,L,[],X]]]):-
	var(S1),ground(S2),
	user:nth(1,S2,F),
	db:link(L,F),
	db:get_domain([nil,L,[]],X).
meet(S1,S2,[[S2,[F,nil,[],X]]]):-
	ground(S1),var(S2),
	user:last(S1,L),
	db:link(L,F),
	db:get_domain([F,nil,[]],X).
meet(S1,S2,[[S1,[nil,nil,[],All]],[S2,[nil,nil,[],All]]]):-
	var(S1),var(S2),
	db:domain(All).