%  Shaky v1.0      Copyright (C) 1997, Masanori Ohmori (oomori@jaist.ac.jp) 
/* Constraint Solver Module */
:- module(cs,[]).

/*
[ô]

 constraint_solver(Condition, Situation list, New situation list)
    : νͿä
  Condition = Υꥹ
  Situation list = [ѿ s.elementν]Υꥹ
  New Situation list = ø֤

 cs_{subset, union, etc.}(Old,New)
    : Oldξ֤äNew֤
  cs_subset([X,Y],[New-x,New-y])
    : XYsubsetǤ. ŪˤYѲʤXYsubsetˤ
      褦˽̤
  cs_union([X,Y,Z],New)
    : ZXYunionǤ. 
*/

/* cs(Cond,Slist,New_slist):-
	νSlistCond褦New_slist֤ */
% condition(Cond,SLb,SL)
condition([],SL,SL).
condition([[Rel,Args]|Cond],SLb,SL):-
	C=..[Rel,Args], name(F,SF),
	name(NF,[99,115,95|SF]),
	get_sl(Args,SLb,SL_sub),
	cs:C
	CS=..[NF,SL_sub,New_sl],
	CS,
	u:replace(SLb,Args,New_sl,New_slb),!,
	condition(Cond,New_slb,SL).

/* Constraint Solver For each relation */
% subset(XY,New_xy)
subset([[sub=X,ent=Y],[New_x,Y]):-
	subset(X,Y,New_x).
subset([],_,[]).
subset([X1|X],Y,[X1|New_x]):-
	member(X1,Y),
	subset(X,Y,New_x).
subset([X1|X],Y,New_x):-
	subset(X,Y,New_x).

% union([X,Y,Z],[New_x,New_y,New_z])
union([s1=X,s2=Y,r=Z],[New_x,New_y,New_z]):-
	union(X,Y,Z,New_x,New_y,New_z).
union(X,Y,Z,X,Y,Z):-
	union(X,Y,Z),!.
union(X,Y,Z,Nex_x,New_y,New_z):-
	union(X,Y,W),
	union(X,Y,Z,W,Nex_x,New_y,New_z).
union(X,Y,Z,W,X,Y,W):-
	subset(W,Z),!.
union(X,Y,Z,W,New_x,New_y,Z):-
	sabun(W,Z,I),
	sabun(X,I,New_x),
	sabun(Y,I,New_y),!.

