/*
Copyright (C) 1997 TAKAHASHI Shin
*/

/* Sphere class */

/* #include <stdio.h>*/

#include "Sphere.h"

void Sphere::draw(float time)
{
   switch(transType.path){
      default:
	   vars[VAR_X] = (ends[VAR_X][1]-ends[VAR_X][0])*time + ends[VAR_X][0];
	   vars[VAR_Y] = (ends[VAR_Y][1]-ends[VAR_Y][0])*time + ends[VAR_Y][0];
	   vars[VAR_Z] = (ends[VAR_Z][1]-ends[VAR_Z][0])*time + ends[VAR_Z][0];
      case CREATION:
      case DELETION:
	   vars[VAR_R] = (ends[VAR_R][1]-ends[VAR_R][0])*time + ends[VAR_R][0];
   }

   glPushMatrix();

   glTranslatef(vars[VAR_X], vars[VAR_Y], vars[VAR_Z]);
   glMaterialfv(GL_FRONT, GL_AMBIENT, ambient);
   glMaterialfv(GL_FRONT, GL_DIFFUSE, diffuse);
   glMaterialfv(GL_FRONT, GL_SPECULAR, specular);
   glMaterialfv(GL_FRONT, GL_SHININESS, &shininess);
   glMaterialfv(GL_FRONT, GL_EMISSION, emission);
   //auxSolidSphere(vars[VAR_R]);
   auxWireSphere(vars[VAR_R]);

   glPopMatrix();

   cx = vars[VAR_X];
   cy = vars[VAR_Y];
   cz = vars[VAR_Z];

   return;
}

