/*
Copyright (C) 1997 TAKAHASHI Shin
*/

/* Shape class */

#ifndef _myShape_h_
#define _myShape_h_

#include "glos.h"
#include <GL/gl.h>

#ifdef MESA
#include "glaux.h"
#else
/*#include "libaux/aux.h"*/
#include <GL/glu.h>
#include <GL/glaux.h>
#endif

#include "TransitionType.h"
#include "VarType.h"
#include "MaterialType.h"

class Shape {
protected:
	int			name;
	int			numberOfPaths;
	int			nanbanme;
	Transition		transType;

	GLfloat	vars[7];
	GLfloat	ends[7][2];

	GLfloat ambient[4];
	GLfloat diffuse[4];
	GLfloat specular[4];
	GLfloat emission[4];
	GLfloat shininess;
	GLfloat transparency;

public:
	int	loc;

	GLfloat	cx;
	GLfloat	cy;
	GLfloat	cz;

	GLfloat viaList[16][3];

	GLfloat	color[4];

	Shape(void);

	virtual void draw(float time);

	void setVariable(int type, int val);
	void setTransition(int var, int val1, int val2);
	void setName(int name);
	void setPathType(Transition type);
	void setNumberOfPaths(int num);
	void setMaterial(MaterialType type, GLfloat v1, GLfloat v2, GLfloat v3);
};

#endif 
