/*
Copyright (C) 1997 TAKAHASHI Shin
*/

/* Shape class */

#include "Shape.h"

#include <stdio.h>
#include <stdlib.h>


Shape::Shape(void)
{
	numberOfPaths = 1;

	vars[VAR_R] = 1.0;
	vars[VAR_W] = 1.0;
	vars[VAR_D] = 1.0;
	vars[VAR_H] = 1.0;

	vars[VAR_X] = 0.0;
	vars[VAR_Y] = 0.0;
	vars[VAR_Z] = 0.0;

	transType.path = UNDEFINED;

	ambient[0]=0.2;
	ambient[1]=0.2;
	ambient[2]=0.2;
	ambient[3]=1.0;
	diffuse[0]=0.8;
	diffuse[1]=0.8;
	diffuse[2]=0.8;
	diffuse[3]=1.0;
	specular[0]=0.0;
	specular[1]=0.0;
	specular[2]=0.0;
	specular[3]=1.0;
	emission[0]=0.2;
	emission[1]=0.2;
	emission[2]=0.2;
	emission[3]=1.0;
	shininess = 0.0;
	transparency = 1.0;
}

void Shape::setName(int id)
{
	name = id;

	return;
}

void Shape::setVariable(int type, int val)
{
	//printf("%d = %d\n", type, val);
	vars[type] = (GLfloat)val;

	/*
	if(transType.path == UNDEFINED){
	  puts("Internal Error: 'setVariable' is called before 'setPathType'");
	  exit(1);
	}*/

	if(transType.path == CREATION){
	   ends[type][0] = 0.0;
	   ends[type][1] = (GLfloat)val;
	}else if(transType.path == DELETION){
	   ends[type][0] = (GLfloat)val;
	   ends[type][1] = 0.0;
	}

	return;
}

void Shape::setTransition(int type, int val1, int val2)
{
	ends[type][0] = val1;
	ends[type][1] = val2;

	return;
}

void Shape::draw(float)
{
	return;
}

void Shape::setPathType(Transition type)
{
   transType = type;
}

void Shape::setNumberOfPaths(int num)
{
   numberOfPaths = num;
   nanbanme = 1;
}


void Shape::setMaterial(MaterialType type, float v1, float v2, float v3)
{
   switch(type){
     default: break;
     case AMBIENT:
	ambient[0] = v1;
	ambient[1] = v2;
	ambient[2] = v3;
        break;
     case DIFFUSE:
	diffuse[0] = v1;
	diffuse[1] = v2;
	diffuse[2] = v3;
        break;
     case SPECULAR:
	specular[0] = v1;
	specular[1] = v2;
	specular[2] = v3;
        break;
     case EMISSIVE:
	emission[0] = v1;
	emission[1] = v2;
	emission[2] = v3;
        break;
     case SHININESS:
	shininess = v1;
        break;
     case TRANSPARENCY:
	transparency = 1.0 - v1;
	ambient[3] = transparency;
	diffuse[3] = transparency;
	specular[3] = transparency;
	emission[3] = transparency;
        break;
   }

   return;
}

