/*
Copyright (C) 1997 TAKAHASHI Shin
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
/*#include <unistd.h>*/

#include "glos.h"
#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glaux.h>
/*#include <GL/glx.h>*/
#include <math.h>

#define	BUFSIZE 1023
#define TRUE  1
#define FALSE 0

static char	buf[BUFSIZE+1];	/* line buffer */
static char	command[128];
static char	mode[256];
static float	globaltime;
static FILE 	*fp;
static GLuint	TheDisplayList;

#include "Box.h"
#include "Line.h"
#include "Sphere.h"
#include "Cylinder.h"

#include "ShapeTable.h"
#include "VsrObjects.h"
#include "TransitionType.h"


ShapeObject	object_table[TABLESIZE];


int	step;
int	DEBUG;

static void analyze_mode(int loc, char *mode)
{
   char 	*ptr;
   float	v1, v2, v3;
   int		i;

   ptr = mode;
   while(TRUE){
      switch(*ptr){
	 case 'a' : // ambient
		ptr = strchr(ptr, ' '); ptr++;
		sscanf(ptr, "%f %f %f", &v1, &v2, &v3);
		(object_table[loc].object)->setMaterial(AMBIENT, v1, v2, v3);
		for(i=0;i<3;i++){ 
			ptr = strchr(ptr, ' ');
			ptr++;
		}
		break;
	 case 'd' : // diffuse
		ptr = strchr(ptr, ' '); ptr++;
		sscanf(ptr, "%f %f %f", &v1, &v2, &v3);
		(object_table[loc].object)->setMaterial(DIFFUSE, v1, v2, v3);
		for(i=0;i<3;i++){ 
			ptr = strchr(ptr, ' ');
			ptr++;
		}
		break;
	 case 's' : 
		switch(*(ptr+1)){
		   case 'p' : // specular
			ptr = strchr(ptr, ' '); ptr++;
			sscanf(ptr, "%f %f %f", &v1, &v2, &v3);
			(object_table[loc].object)->
				setMaterial(SPECULAR, v1, v2, v3);
			for(i=0;i<3;i++){ 
				ptr = strchr(ptr, ' ');
				ptr++;
			}
			break;
		   case 'h' : // shininess
			ptr = strchr(ptr, ' '); ptr++;
			sscanf(ptr, "%f", &v1);
			(object_table[loc].object)-> 
				setMaterial(SHININESS, v1, 0.0, 0.0);
			ptr = strchr(ptr, ' '); ptr++;
			break;
		    default : return;
		} 
		break;
	 case 'e' : // emissive
		ptr = strchr(ptr, ' '); ptr++;
		sscanf(ptr, "%f %f %f", &v1, &v2, &v3);
		(object_table[loc].object)->setMaterial(EMISSIVE, v1, v2, v3);
		for(i=0;i<3;i++){ 
			ptr = strchr(ptr, ' ');
			ptr++;
		}
		break;
	 case 't' : // transparency
		ptr = strchr(ptr, ' '); ptr++;
		sscanf(ptr, "%f", &v1);
		(object_table[loc].object)->
			setMaterial(TRANSPARENCY, v1, 0.0, 0.0);
		ptr = strchr(ptr, ' '); ptr++;
		break;
	 case 'E' : // End
	 default  : 
		return;
      }
   }
}

/* OK */
int search_object(int name)
{
   int hash_value, loc;

   hash_value = name & TABLEMASK;

   loc = hash_value;
   while((object_table[loc].empty)||(object_table[loc].name!=name)){
	if(object_table[loc].name==name) break;
	loc = (loc + 1)&TABLEMASK;
	if(loc == hash_value){
		fprintf(stderr,"cannot find %s!\n", name);
		exit(1);
	}
   }
   return loc;
}

/* OK */
static Shape *graphical_object(int Obj, int name)
{
   switch(Obj){
      case SPHERE:{
		   Sphere *obj = new Sphere;
		   obj->setName(name);
		   return obj;
		}
      case LINE:{
		   Line *obj = new Line;
		   obj->setName(name);
		   return obj;
		}	  
      case BOX:{
		   Box *obj = new Box;
		   obj->setName(name);
		   return obj;
		}
      case CYLINDER:{
		   Cylinder *obj = new Cylinder;
		   obj->setName(name);
		   return obj;
		}
      default:
	fprintf(stderr,"unknown object type!\n");
	exit(1);
	return (Shape *)0; /* this will never be called */
   }
}

/* OK */
static void create_object(void)
{
   int type, hash_value, loc, name;
   char *ptr;
   Transition	tp;

   sscanf(buf, "%s %d %d", command, &type, &name);

   hash_value = name & TABLEMASK;
   loc = hash_value;
   while(!(object_table[loc].empty)){
	loc = (loc + 1)&TABLEMASK;
	if(loc == hash_value){
		fprintf(stderr,"cannot find space!\n");
		exit(1);
	}
   }
   object_table[loc].object = graphical_object(type, name);
   object_table[loc].name   = name;
   object_table[loc].type   = type;
   object_table[loc].empty  = FALSE; /* not empty */
 
   tp.path = CREATION;
   (object_table[loc].object)->setPathType(tp);

   ptr = &(buf[9]);
   ptr = strchr(ptr, ' '); ptr++;

   analyze_mode(loc, ptr);

   object_table[loc].object->loc = loc;

}


/* OK */
static void set_line(void)
{
   int	lobj, end1, end2;
   int  name1, name2, name3;

   sscanf(buf, "%s %d %d %d", command, &name1, &name2, &name3);

   lobj = search_object(name1);
   end1 = search_object(name2);
   end2 = search_object(name3);

   ((Line *)(object_table[lobj].object))->
	setupConnection(object_table[end1].object, object_table[end2].object);
}

/* OK */
static void set_transition(void)
{
   int val1, val2;
   int loc;
   int name, var_name;

   sscanf(buf, "%s %d %d %d %d", command, &name, &var_name, &val1, &val2);

   loc = search_object(name);

   (object_table[loc].object)->setTransition(var_name, val1, val2);
}

/* OK */
static void delete_object(void)
{
   int type, loc, name;
   Transition	tp;

   sscanf(buf, "%s %d %d %s", command, &type, &name, mode);

   loc = search_object(name);

   tp.path = DELETION;
   (object_table[loc].object)->setPathType(tp);

   object_table[loc].deleted = TRUE;
}

/* OK */
static void set_variable(void)
{
   int type, val, loc, name, var_name;

   sscanf(buf, "%s %d %d %d %d", command, &type, &name, &var_name, &val);

   loc = search_object(name);

   (object_table[loc].object)->setVariable(var_name, val);
}

/* OK */
static void set_mode(void)
{
   int loc, name;
   char *ptr;

   sscanf(buf, "%s %d", command, &name);

   loc = search_object(name);

   ptr = &(buf[6]);
   ptr = strchr(ptr, ' '); ptr++;

   analyze_mode(loc, ptr); /* modes "?????" HERE STARTS MODES */
}

/* mada
static void set_text(void)
{
   int loc, name;
   char aString[128];

   sscanf(buf, "%s %d %s %s", command, &name, aString, mode);

   loc = search_object(name);

   aString[strlen(aString)-1] = (char)NULL;

   ((Word *)object_table[loc].object)->setString(&(aString[1]), mode);
}
*/

/* OK */
static void set_path(void)
{
   int 		type, name, j;
   char 	*ptr;
   Shape	*shp; 
   Transition	tp;

   sscanf(buf, "%s %d %d", command, &name, &type);

   ptr = buf;
   for(j=0;j<3;j++){ 
	ptr = strchr(ptr, ' ');
	ptr++;
   }

   shp = object_table[search_object(name)].object;

   tp.path = type;

   if(type == CIRCUITOUS){
	int v1x, v1y, v1z, v2x, v2y, v2z;

        sscanf(ptr, "%d %d %d %d %d %d", &v1x, &v1y, &v1z, &v2x, &v2y, &v2z);
	tp.v1[0] = (GLfloat)v1x;
	tp.v1[1] = (GLfloat)v1y;
	tp.v1[2] = (GLfloat)v1z;
	tp.v2[0] = (GLfloat)v2x;
	tp.v2[1] = (GLfloat)v2y;
	tp.v2[2] = (GLfloat)v2z;
	shp->setPathType(tp);
   }else if(type == MULTIPATH){
	int num, x, y, z, i;

	shp->setPathType(tp);

	sscanf(ptr, "%d", &num); 
	shp->setNumberOfPaths(num);
	ptr = strchr(ptr, ' '); ptr++;

	//printf("# of path = %d\n", num);

	for(i = 0; i < (num-1); i++){
		//puts(ptr);
		sscanf(ptr, "%d %d %d", &x, &y, &z);
		shp->viaList[i][0] = (GLfloat)x;
		shp->viaList[i][1] = (GLfloat)x;
		shp->viaList[i][2] = (GLfloat)x;
		//printf("%d %d %d\n",x,y,z);
		for(j=0;j<3;j++){ 
			ptr = strchr(ptr, ' ');
			ptr++;
		}
	}
   }else{
	   shp->setPathType(tp);
   }
}

/*
static void end_of_state(void)
{
}
*/

static void clear_objects(void)
{
   int i;

   for(i = 0; i < TABLESIZE; i++)
      if(!(object_table[i].empty)){
         delete object_table[i].object;
	 object_table[i].empty = TRUE;
	 object_table[i].deleted = FALSE;
      }
}

static void removeDeletedObjects(void)
{
   int i;
   Transition	tp;

   tp.path = STRAIGHT;

   for(i = 0; i < TABLESIZE; i++){
      if(object_table[i].empty) continue;
      if(object_table[i].deleted){
         delete object_table[i].object;
	 object_table[i].empty = TRUE;
	 object_table[i].deleted = FALSE;
      }

      // Set to Default Path Type
      (object_table[i].object)->setPathType(tp);
   }
}

void makeObjectsDisplayList(void)
{
   int i;

   //glNewList(TheDisplayList, GL_COMPILE);

     /* draw objects other than lines */
     for(i = 0; i < TABLESIZE; i++){
        if(object_table[i].empty) continue;
        //if(object_table[i].type == LINE) continue;
        (object_table[i].object)->draw(globaltime);
     }
     /* draw lines 
     for(i = 0; i < TABLESIZE; i++){
        if(object_table[i].empty) continue;
        if(object_table[i].type != LINE) continue;
        (object_table[i].object)->draw(globaltime);
     }*/

   //glEndList();
}

void CALLBACK advanceTime(void)
{
  void CALLBACK readAnimData(void);
  void CALLBACK display(void);

  globaltime = globaltime + 0.1;
  if(globaltime > 1.0){
	auxIdleFunc(0);
	removeDeletedObjects();
	auxIdleFunc(readAnimData);
  }
  //makeObjectsDisplayList();
  display();
}

void CALLBACK readAnimData(void)
{

   while(TRUE){
     while(!feof(fp)){
	/* read from stdin */
	fgets(buf, BUFSIZE, fp);
	//puts(buf);
	if((buf[0] == 0)||(buf[0] == '\n')) continue;

	/* select command */
	switch(buf[0]){
	  case 'c' :
		switch(buf[1]){
		  case 'r' :			/* create */
			create_object(); 
			break;
		  case 'o' :			/* connect */
			set_line(); 
			break;
		  case 'h' :			/* change */
			set_transition(); 
			break;
		  default :
			fprintf(stderr,"ERROR!!!<<%s>>\n",buf);
			break;
		}
		break;
	  case 'd' :				/* delete */
		delete_object();
		break;
	  case 's' :				/* set */
		set_variable();
		break;
	  case 'm' :				/* modes */
		set_mode();
		break;
	  case 'e' :				/* end_of_state */
		/*end_of_state();*/
		globaltime = 0.0;
		auxIdleFunc(advanceTime);
		puts("end_of_state!");
		return;
	  case 't' :				/* modes */
		//set_text();
		break;
	  case 'p' :				/* path */
		set_path();
		break;
	  default:
		fprintf(stderr,"ERROR!!!<<%s>>\n",buf);
		break;
	}
     }
     if (step == 3) break;
     clear_objects();
     rewind(fp);
     fprintf(stderr,"da capo!\n");
   }
   return;
}

void CALLBACK display(void)
{
   glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

   makeObjectsDisplayList();
   //glCallList(TheDisplayList);

   glFlush();
   /*glXSwapBuffers(auxXDisplay(), auxXWindow());*/
   auxSwapBuffers();
}

void CALLBACK myReshape(int w, int h)
{
    glMatrixMode (GL_PROJECTION);       /*  prepare for and then  */ 
    glLoadIdentity ();  /*  define the projection  */
    gluPerspective(90.0, (GLfloat)w/(GLfloat)h, 1.0, 500.0);
    glMatrixMode (GL_MODELVIEW);        /*  back to modelview matrix    */
    glViewport (0, 0, w, h);    /*  define the viewport */
}

GLfloat eye[3];
GLfloat center[3];
GLfloat up[3];

float length(float x, float y, float z)
{
    return sqrt(x*x+y*y+z*z);
}

void CALLBACK down_CB()
{
    GLfloat newv[3], left[3], p, l;
    int i;

    printf("down!\n");
    for(i=0;i<3;i++)
      newv[i] = (center[i]-eye[i])-5.0*up[i];
    left[0] = up[1]*newv[2]-up[2]*newv[1];
    left[1] = up[2]*newv[0]-up[0]*newv[2];
    left[2] = up[0]*newv[1]-up[1]*newv[0];
    up[0] = left[1]*newv[2]-left[2]*newv[1];
    up[1] = left[2]*newv[0]-left[0]*newv[2];
    up[2] = left[0]*newv[1]-left[1]*newv[0];
    l = length(up[0], up[1], up[2]);
    for(i=0;i<3;i++)
      up[i] = -up[i]/l;
    p = length(center[0]-eye[0], center[1]-eye[1], center[2]-eye[2])
       /length(newv[0], newv[1], newv[2]);
    for(i=0;i<3;i++)
      center[i] = eye[i]+newv[i]/p;
    glLoadIdentity();
    gluLookAt(eye[0], eye[1], eye[2], center[0], center[1], center[2],
    		up[0], up[1], up[2]);

}

void CALLBACK up_CB()
{
    GLfloat newv[3], left[3], p, l;
    int i;

    printf("up!\n");
    for(i=0;i<3;i++)
      newv[i] = (center[i]-eye[i])+5.0*up[i];
    left[0] = up[1]*newv[2]-up[2]*newv[1];
    left[1] = up[2]*newv[0]-up[0]*newv[2];
    left[2] = up[0]*newv[1]-up[1]*newv[0];
    up[0] = left[1]*newv[2]-left[2]*newv[1];
    up[1] = left[2]*newv[0]-left[0]*newv[2];
    up[2] = left[0]*newv[1]-left[1]*newv[0];
    l = length(up[0], up[1], up[2]);
    for(i=0;i<3;i++)
      up[i] = -up[i]/l;
    p = length(center[0]-eye[0], center[1]-eye[1], center[2]-eye[2])
       /length(newv[0], newv[1], newv[2]);
    for(i=0;i<3;i++)
      center[i] = eye[i]+newv[i]/p;
    glLoadIdentity();
    gluLookAt(eye[0], eye[1], eye[2], center[0], center[1], center[2],
    		up[0], up[1], up[2]);

}

void CALLBACK left_CB()
{
    GLfloat newv[3], left[3], p;
    int i;
    printf("left!\n");
    for(i=0;i<3;i++)
      newv[i] = center[i]-eye[i];
    left[0] = up[1]*newv[2]-up[2]*newv[1];
    left[1] = up[2]*newv[0]-up[0]*newv[2];
    left[2] = up[0]*newv[1]-up[1]*newv[0];
    p = length(left[0], left[1], left[2]);
    for(i=0;i<3;i++) 
      center[i] += 5.0*left[i]/p;
    glLoadIdentity();
    gluLookAt(eye[0], eye[1], eye[2], center[0], center[1], center[2],
    		up[0], up[1], up[2]);
}

void CALLBACK right_CB()
{
    GLfloat newv[3], left[3], p;
    int i;
    printf("right!\n");
    for(i=0;i<3;i++)
      newv[i] = center[i]-eye[i];
    left[0] = up[1]*newv[2]-up[2]*newv[1];
    left[1] = up[2]*newv[0]-up[0]*newv[2];
    left[2] = up[0]*newv[1]-up[1]*newv[0];
    p = length(left[0], left[1], left[2]);
    for(i=0;i<3;i++) 
      center[i] -= 5.0*left[i]/p;
    glLoadIdentity();
    gluLookAt(eye[0], eye[1], eye[2], center[0], center[1], center[2],
    		up[0], up[1], up[2]);
}

void CALLBACK forward_CB()
{
    GLfloat newv[3], l;
    int i;
    printf("forward!\n");
    for(i=0;i<3;i++)
      newv[i] = center[i]-eye[i];
    l = length(newv[0], newv[1], newv[2]);
    for(i=0;i<3;i++){
      center[i] += 5.0*newv[i]/l;
      eye[i] += 5.0*newv[i]/l;
    }
    glLoadIdentity();
    gluLookAt(eye[0], eye[1], eye[2], center[0], center[1], center[2],
    		up[0], up[1], up[2]);
}

void CALLBACK back_CB()
{
    GLfloat newv[3], l;
    int i;
    printf("back!\n");
    for(i=0;i<3;i++)
      newv[i] = center[i]-eye[i];
    l = length(newv[0], newv[1], newv[2]);
    for(i=0;i<3;i++){
      center[i] -= newv[i]/l;
      eye[i] -= newv[i]/l;
    }
    glLoadIdentity();
    gluLookAt(eye[0], eye[1], eye[2], center[0], center[1], center[2],
    		up[0], up[1], up[2]);
}


void main(int argc, char *argv[])
{
   int	i, distance;

   /* Initialize object_table */
   for(i = 0; i < TABLESIZE; i++){
	object_table[i].empty = TRUE;
	object_table[i].deleted = FALSE;
   }

   /* open a file */
   if(argc > 1){
      if((fp = fopen(argv[1], "r"))==NULL){
	perror("cannot open!");
	exit(1);
      }
   }else{
      fp = stdin;
   }

   /* see the setup flag */
   if(argc > 2)
     if(strcmp("-step", argv[2]) == 0) step = 1;
   if(argc > 2)
     if(strcmp("-debug", argv[2]) == 0){ step = 2; DEBUG = 1; }
   if(argc > 2)
     if(strcmp("-once", argv[2]) == 0){ step = 3; }

   globaltime = 0.0;

   auxInitDisplayMode (AUX_DOUBLE | AUX_RGBA | AUX_DEPTH);
   auxInitPosition (0, 0, 500, 500);
   auxInitWindow (argv[0]);



   glEnable(GL_DEPTH_TEST);
   glDepthFunc(GL_LESS);

   GLfloat ambient[] = { 0.5, 0.5, 0.5, 1.0 };
   GLfloat diffuse[] = { 1.0, 1.0, 1.0, 1.0 };
   GLfloat specular[] = { 1.0, 1.0, 1.0, 1.0 };
   GLfloat position[] = { 170.0, 80.0, 200.0, 0.0 };
   GLfloat lmodel_ambient[] = { 0.4, 0.4, 0.4, 1.0 };
   GLfloat local_view[] = { 0.0 };

   glLightfv(GL_LIGHT0, GL_AMBIENT, ambient);
   glLightfv(GL_LIGHT0, GL_DIFFUSE, diffuse);
   glLightfv(GL_LIGHT0, GL_POSITION, position);
   glLightModelfv(GL_LIGHT_MODEL_AMBIENT, lmodel_ambient);
   glLightModelfv(GL_LIGHT_MODEL_LOCAL_VIEWER, local_view);

   glEnable(GL_LIGHTING);
   glEnable(GL_LIGHT0);


   auxReshapeFunc(myReshape);

   auxKeyFunc(AUX_DOWN, down_CB);
   auxKeyFunc(AUX_UP, up_CB);
   auxKeyFunc(AUX_LEFT, left_CB);
   auxKeyFunc(AUX_RIGHT, right_CB);
   auxKeyFunc(AUX_a, forward_CB);
   auxKeyFunc(AUX_z, back_CB);

   TheDisplayList = glGenLists(1);

   auxIdleFunc(readAnimData);

   distance = 500;

   eye[0] = 170.0;
   eye[1] = 80.0;
   eye[2] = 200.0;
   center[0] = 100.0;
   center[1] = 100.0;
   center[2] = 100.0;
   up[0] = 0.0;
   up[1] = -1.0;
   up[2] = 0.0;


   gluLookAt(170.0, 80.0, 200.0, 100.0, 100.0, 100.0, 0.0, -1.0, 0.0);

   auxMainLoop(display);

}
