/*
Copyright (C) 1997 TAKAHASHI Shin
*/

/* Line class */

#include "Line.h"

void Line::draw(float time)
{
   glPushMatrix();

   glMaterialfv(GL_FRONT, GL_AMBIENT, ambient);
   glMaterialfv(GL_FRONT, GL_DIFFUSE, diffuse);
   glMaterialfv(GL_FRONT, GL_SPECULAR, specular);
   glMaterialfv(GL_FRONT, GL_SHININESS, &shininess);
   glMaterialfv(GL_FRONT, GL_EMISSION, emission);
   glBegin(GL_LINES);
   glVertex3f(end1->cx, end1->cy, end1->cz);
   glVertex3f(end2->cx, end2->cy, end2->cz);
   glEnd();

   glPopMatrix();

   return;
}

void Line::setupConnection(Shape *e1, Shape *e2)
{
   end1 = e1;
   end2 = e2;

   return;
}

