/*
Copyright (C) 1997 TAKAHASHI Shin
*/

/* Cylinder class */

#include <stdio.h>

#include "Cylinder.h"

void Cylinder::draw(float time)
{
   vars[VAR_R] = (ends[VAR_R][1] - ends[VAR_R][0]) * time + ends[VAR_R][0];
   vars[VAR_H] = (ends[VAR_H][1] - ends[VAR_H][0]) * time + ends[VAR_H][0];
   vars[VAR_X] = (ends[VAR_X][1] - ends[VAR_X][0]) * time + ends[VAR_X][0];
   vars[VAR_Y] = (ends[VAR_Y][1] - ends[VAR_Y][0]) * time + ends[VAR_Y][0];
   vars[VAR_Z] = (ends[VAR_Z][1] - ends[VAR_Z][0]) * time + ends[VAR_Z][0];

   glPushMatrix();

   glTranslatef(vars[VAR_X], vars[VAR_Y], vars[VAR_Z]);
   glMaterialfv(GL_FRONT, GL_AMBIENT, ambient);
   glMaterialfv(GL_FRONT, GL_DIFFUSE, diffuse);
   glMaterialfv(GL_FRONT, GL_SPECULAR, specular);
   glMaterialfv(GL_FRONT, GL_SHININESS, &shininess);
   glMaterialfv(GL_FRONT, GL_EMISSION, emission);
   auxSolidCylinder(vars[VAR_R], vars[VAR_H]);

   glPopMatrix();

   cx = vars[VAR_X];
   cy = vars[VAR_Y];
   cz = vars[VAR_Z] + vars[VAR_R] / 2.0;

   return;
}
