/*
Copyright (C) 1997 TAKAHASHI Shin
*/

/* Box class */

/*#include <stdio.h>*/

#include "Box.h"

void Box::draw(float time)
{
   switch(transType.path){
      default:
	   vars[VAR_X] = (ends[VAR_X][1]-ends[VAR_X][0])*time + ends[VAR_X][0];
	   vars[VAR_Y] = (ends[VAR_Y][1]-ends[VAR_Y][0])*time + ends[VAR_Y][0];
	   vars[VAR_Z] = (ends[VAR_Z][1]-ends[VAR_Z][0])*time + ends[VAR_Z][0];
      case CREATION:
      case DELETION:
	   vars[VAR_W] = (ends[VAR_W][1]-ends[VAR_W][0])*time + ends[VAR_W][0];
	   vars[VAR_H] = (ends[VAR_H][1]-ends[VAR_H][0])*time + ends[VAR_H][0];
	   vars[VAR_D] = (ends[VAR_D][1]-ends[VAR_D][0])*time + ends[VAR_D][0];
   }

   glPushMatrix();

  /*
        glEnable (GL_BLEND);
        glDepthMask (GL_FALSE);
        glBlendFunc (GL_SRC_ALPHA, GL_ONE);
  */

   glTranslatef(vars[VAR_X], vars[VAR_Y], vars[VAR_Z]);
   glMaterialfv(GL_FRONT, GL_AMBIENT, ambient);
   glMaterialfv(GL_FRONT, GL_DIFFUSE, diffuse);
   glMaterialfv(GL_FRONT, GL_SPECULAR, specular);
   glMaterialfv(GL_FRONT, GL_SHININESS, &shininess);
   glMaterialfv(GL_FRONT, GL_EMISSION, emission);
   //auxSolidBox(vars[VAR_W], vars[VAR_H], vars[VAR_D]);
   auxSolidBox(vars[VAR_W], vars[VAR_H], vars[VAR_D]);

   /*
        glDepthMask (GL_TRUE);
        glDisable (GL_BLEND);
   */

   glPopMatrix();

   /*
   cx = vars[VAR_X] + vars[VAR_W] / 2.0;
   cy = vars[VAR_Y] + vars[VAR_H] / 2.0;
   cz = vars[VAR_Z] + vars[VAR_D] / 2.0;
   */
   cx = vars[VAR_X];
   cy = vars[VAR_Y];
   cz = vars[VAR_Z];

   return;
}
