/*
Copyright (C) 1997 $B9b66(B $B?-(B (TAKAHASHI Shin)
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

/*#include <GL/glaux.h>*/
#include <Inventor/Xt/SoXt.h>
#include <Inventor/engines/SoElapsedTime.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoCoordinate3.h>
#include <Inventor/actions/SoWriteAction.h>

#include "Shape.h"
#include "Cylinder.h"
#include "Word.h"

#define	BUFSIZE 1023
#define TRUE  1
#define FALSE 0

static char	buf[BUFSIZE+1];	/* line buffer */
static char	command[128];
static char	mode[256];

#include "ShapeTable.h"

ShapeObject	object_table[TABLESIZE];

FILE *fp; // read logs from this file pointer

int	step;
int	Animating;
int	First;

extern Shape *graphical_object(int Obj, int name);
extern void setupGlobalCounter(void);
extern void setupRootNode(void);
extern void setTransitionType(Shape *, int);
extern void initializeWindow(void);
extern void displayViewer(void);

extern int DEBUG;
extern SoElapsedTime *globalCounter;
extern SoSeparator *root;
extern SoSFTime *global_time;
extern SoCoordinate3 *global_time_proxy;

static void analyze_mode(int loc, char *mode)
{
   char 	*ptr;
   float	v1, v2, v3;
   int		i;

   ptr = mode;
   while(TRUE){
      switch(*ptr){
	 case 'a' : // ambient
		ptr = strchr(ptr, ' '); ptr++;
		sscanf(ptr, "%f %f %f", &v1, &v2, &v3);
		(object_table[loc].object)->setMaterial(AMBIENT, v1, v2, v3);
		for(i=0;i<3;i++){ 
			ptr = strchr(ptr, ' ');
			ptr++;
		}
		break;
	 case 'd' : // diffuse
		ptr = strchr(ptr, ' '); ptr++;
		sscanf(ptr, "%f %f %f", &v1, &v2, &v3);
		(object_table[loc].object)->setMaterial(DIFFUSE, v1, v2, v3);
		for(i=0;i<3;i++){ 
			ptr = strchr(ptr, ' ');
			ptr++;
		}
		break;
	 case 's' : 
		switch(*(ptr+1)){
		   case 'p' : // specular
			ptr = strchr(ptr, ' '); ptr++;
			sscanf(ptr, "%f %f %f", &v1, &v2, &v3);
			(object_table[loc].object)->
				setMaterial(SPECULAR, v1, v2, v3);
			for(i=0;i<3;i++){
				ptr = strchr(ptr, ' ');
				ptr++;
			}
			break;
		   case 'h' : // shininess
			ptr = strchr(ptr, ' '); ptr++;
			sscanf(ptr, "%f", &v1);
			(object_table[loc].object)->
				setMaterial(SHININESS, v1, 0.0, 0.0);
			ptr = strchr(ptr, ' '); ptr++;
			break;
		    default : return;
		} 
		break;
	 case 'e' : // emissive
		ptr = strchr(ptr, ' '); ptr++;
		sscanf(ptr, "%f %f %f", &v1, &v2, &v3);
		(object_table[loc].object)->setMaterial(EMISSIVE, v1, v2, v3);
		for(i=0;i<3;i++){ 
			ptr = strchr(ptr, ' ');
			ptr++;
		}
		break;
	 case 't' : // transparency
		ptr = strchr(ptr, ' '); ptr++;
		sscanf(ptr, "%f", &v1);
		(object_table[loc].object)->
			setMaterial(TRANSPARENCY,v1,0.0,0.0);
		ptr = strchr(ptr, ' '); ptr++;
		break;
	 case 'E' : // End
	 default  : 
		return;
      }
   }
}

int search_object(int name)
{
   int hash_value, loc;

   hash_value = name & TABLEMASK;

   loc = hash_value;
   while((object_table[loc].empty)||(object_table[loc].name!=name)){
	if(object_table[loc].name==name) break;
	loc = (loc + 1)&TABLEMASK;
	if(loc == hash_value){
		fprintf(stderr,"cannot find %s!\n", name);
		exit(1);
	}
   }
   return loc;
}

static void create_object(void)
{
   int type, hash_value, loc, name;
   char *ptr;

   sscanf(buf, "%s %d %d", command, &type, &name);

   hash_value = name & TABLEMASK;
   loc = hash_value;
   while(!(object_table[loc].empty)){
	loc = (loc + 1)&TABLEMASK;
	if(loc == hash_value){
		fprintf(stderr,"cannot find space!\n");
		exit(1);
	}
   }
   object_table[loc].object = graphical_object(type, name);
   root->addChild((object_table[loc].object)->node);

   object_table[loc].name = name;
   object_table[loc].empty   = FALSE; /* not empty */

   setTransitionType(object_table[loc].object, 4);	/* 0:creation */

   ptr = &(buf[9]);
   ptr = strchr(ptr, ' '); ptr++;

   analyze_mode(loc, ptr);

   object_table[loc].object->loc = loc;

}

static void set_line(void)
{
   int	lobj, end1, end2;
   int  name1, name2, name3;

   sscanf(buf, "%s %d %d %d", command, &name1, &name2, &name3);

   lobj = search_object(name1);
   end1 = search_object(name2);
   end2 = search_object(name3);

   ((Cylinder *)(object_table[lobj].object))->
		setupConnection(object_table[end1].object,
				object_table[end2].object);
}

static void set_transition(void)
{
   int val1, val2;
   int loc;
   int name, var_name;

   sscanf(buf, "%s %d %d %d %d", command, &name, &var_name, &val1, &val2);

   loc = search_object(name);

   (object_table[loc].object)->setTransition(var_name, val1, val2);
}

void set_long_action(void)
{
   int val1, val2;
   int loc;
   int name1, name2, var_name1, var_name2;
   int id_num1, id_num2;
   float time2;
   long pos;

   sscanf(buf, "%s %d %d %d %d", command, &id_num1, &name1, &var_name1, &val1);
   puts(buf);putchar('\n');

   pos = ftell(fp); // to memorize current file pointer
   while(!feof(fp)){
        fgets(buf, BUFSIZE, fp);
        if((buf[0] == 0)||(buf[0] == '\n')) continue;
        if(!strncmp(buf, "time", 4)){
           sscanf(buf, "%s %f", command, &time2);
        }else if(!strncmp(buf, "stop", 4)){
           sscanf(buf, "%s %d %d %d %d", command, &id_num2, &name2, 
                                        &var_name2, &val2);
           puts(buf);
           if((id_num1 == id_num2)&&(var_name1 == var_name2)){
	   // found stop event!
                loc = search_object(name1);
                (object_table[loc].object)->
                   setLongTransition(var_name1,
				     //global_time->getValue().getValue(),
				     global_time_proxy->point[0][0],
				     val1,
				     time2,
				     val2);
                fseek(fp, pos, SEEK_SET); //set pos as before
                return;
           }
        }
   }
   /* Oh, cannot find stop event */
   fprintf(stderr,"cannot find a stop event! %s\n", name1);
   exit(1);
}



static void delete_object(void)
{
   int type, loc, name;

   sscanf(buf, "%s %d %d %s", command, &type, &name, mode);

   loc = search_object(name);

   setTransitionType(object_table[loc].object, 5);	/* 5:delete */
   (object_table[loc].object)->deleteAfterTransition();
}

static void set_variable(void)
{
   int type, val, loc, name, var_name;

   sscanf(buf, "%s %d %d %d %d", command, &type, &name, &var_name, &val);

   loc = search_object(name);

   (object_table[loc].object)->setVariable(var_name, val);
}

static void set_mode(void)
{
   int loc, name;
   char *ptr;

   sscanf(buf, "%s %d", command, &name);

   loc = search_object(name);

   ptr = &(buf[6]);
   ptr = strchr(ptr, ' '); ptr++;

   analyze_mode(loc, ptr); /* modes "?????" HERE STARTS MODES */
}

static void set_text(void)
{
   int loc, name;
   char aString[128];

   sscanf(buf, "%s %d %s %s", command, &name, aString, mode);

   loc = search_object(name);

   aString[strlen(aString)-1] = (char)NULL;

   ((Word *)object_table[loc].object)->setString(&(aString[1]), mode);
}

static void set_path(void)
{
   int 		type, name, j;
   char 	*ptr;
   Shape	*shp; 
   Transition	tp;

   sscanf(buf, "%s %d %d", command, &name, &type);

   ptr = buf;
   for(j=0;j<3;j++){ 
	ptr = strchr(ptr, ' ');
	ptr++;
   }

   shp = object_table[search_object(name)].object;

   if(type == 1){
	int v1x, v1y, v1z, v2x, v2y, v2z;

        sscanf(ptr, "%d %d %d %d %d %d", &v1x, &v1y, &v1z, &v2x, &v2y, &v2z);
	tp.v1 = SbVec3f((float)v1x, (float)v1y, (float)v1z);
	tp.v2 = SbVec3f((float)v2x, (float)v2y, (float)v2z);
	tp.path = circuitous;
	shp->setPathType(tp);
   }else if(type == 6){
	int num, x, y, z, i;

	tp.path = multipath;
	shp->setPathType(tp);

	sscanf(ptr, "%d", &num); 
	shp->setNumberOfPaths(num);
	ptr = strchr(ptr, ' '); ptr++;

	//printf("# of path = %d\n", num);

	for(i = 0; i < (num-1); i++){
		//puts(ptr);
		sscanf(ptr, "%d %d %d", &x, &y, &z);
		shp->viaList->set1Value(i, (float)x, (float)y, (float)z);
		//printf("%d %d %d\n",x,y,z);
		for(j=0;j<3;j++){ 
			ptr = strchr(ptr, ' ');
			ptr++;
		}
	}
	shp->path->E = (*(shp->viaList))[0];
   }else{
	   setTransitionType(shp, type);
   }
}

static void clear_objects(void)
{
   int i;

   for(i = 0; i < TABLESIZE; i++)
      if(!(object_table[i].empty)){
	     delete object_table[i].object;
		 object_table[i].empty = TRUE;
      }
}

float next_event_time;	//read from log file

static void proceed_until_time(void)
{
  extern SoXtExaminerViewer	*myViewer;

  sscanf(buf, "%s %f", command, &next_event_time);
  //printf("next time = %f\n", next_event_time);

//  if(First&&(aTripViewerView!=NULL)){
  if(First){
      myViewer->viewAll();
      First = FALSE;
      Animating = FALSE;
  } else {
      Animating = TRUE;
  }
   // debug
    if(DEBUG){
	SoWriteAction *foo = new SoWriteAction;
	foo->apply(root);
    }

  // start animation
  globalCounter->on.setValue(TRUE);

  return;
}


static Boolean readAnimData(XtPointer client_data)
{
   extern SoFieldSensor *timer_sensor;

   //puts("readAnimData!!");

   //float f = global_time->getValue().getValue();
   //float f = global_time_proxy->point[0][0];

   /*
   SoSFTime *timeOut =
        (SoSFTime *)(timer_sensor->getAttachedField());

   f = timeOut->getValue().getValue();
   */

   if (Animating) return False;

   glFlush();

   while(TRUE){
     while(!feof(fp)){
	/* read from stdin */
	fgets(buf, BUFSIZE, fp);
	//puts(buf);
	if((buf[0] == 0)||(buf[0] == '\n')) continue;

	/* select command */
	switch(buf[0]){
	  case 'c' :
		switch(buf[1]){
		  case 'r' :			/* create */
			create_object(); 
			break;
		  case 'o' :			/* connect */
			set_line(); 
			break;
		  case 'h' :			/* change */
			set_transition(); 
			break;
		  default :
			fprintf(stderr,"ERROR!!!<<%s>>\n",buf);
			break;
		}
		break;
	  case 'd' :				/* delete */
		delete_object();
		break;
	  case 's' :				/* set */
                switch(buf[1]){
                  case 'e' :
                        set_variable();
                        break;
                  case 't' : /* start and stop */
                        if(!strncmp(buf,"start",5)) set_long_action();
                        break;
                  default :
                        fprintf(stderr,"ERROR!!!<<%s>>\n",buf);
                        break;
                }
		break;
	  case 'm' :				/* modes */
		set_mode();
		break;
	  case 'e' :				/* end_of_state */
		//end_of_state();
		break;
	  case 't' :				/* modes */
                switch(buf[1]){
                  case 'e' :
                     set_text();
                     break;
                  case 'i' :    /* time */
                     proceed_until_time();
                     return False;
                     //break;
                }
                break;
	  case 'p' :				/* path */
		set_path();
		break;
	  default:
		fprintf(stderr,"ERROR!!!<<%s>>\n",buf);
		break;
	}
     }
     if (step == 3) break;
     clear_objects();
     rewind(fp);
     fprintf(stderr,"da capo!\n");
     globalCounter->reset.touch();
     globalCounter->on.setValue(FALSE);
   }
   return TRUE;
}

void timer_handler(void *object, SoSensor *sensor)
{
   /*
   fprintf(stderr, "I'm timer handler!! The time is %f\n", 
	global_time_proxy->point[0][0]);
   */

   if(!Animating){
        readAnimData((XtPointer)fp);
   }else{
	/*
	SoMFFloat *timeOut = 
		(SoMFFloat *)(((SoFieldSensor *)sensor)->getAttachedField());
        if((*timeOut)[0] >= next_event_time){
	*/
        if(global_time_proxy->point[0][0] >= next_event_time){
           Animating = FALSE;
	   globalCounter->on.setValue(FALSE);
	   readAnimData((XtPointer)fp);
        }
   }
   return;
}

void main(int argc, char *argv[])
{
   int	i;

   /* Initialize object_table */
   for(i = 0; i < TABLESIZE; i++){
	object_table[i].empty = TRUE;
   }

   /* open a file */
   if(argc > 1){
      if((fp = fopen(argv[1], "r"))==NULL){
	perror("cannot open!");
	exit(1);
      }
   }else{
      fp = stdin;
   }

   // see the setup flag 
   if(argc > 2)
     if(strcmp("-step", argv[2]) == 0) step = 1;
   if(argc > 2)
     if(strcmp("-debug", argv[2]) == 0){ step = 2; DEBUG = 1; }
   if(argc > 2)
     if(strcmp("-once", argv[2]) == 0){ step = 3; }
   //

   initializeWindow();
   
   setupGlobalCounter();
   setupRootNode();

   Animating = FALSE;
   First = TRUE;

   XtAppAddWorkProc(SoXt::getAppContext(), 
	     (XtWorkProc)readAnimData, 
	     (XtPointer)fp);


   displayViewer();

   XtAppMainLoop(SoXt::getAppContext());
}
